<?php
/*
 * Copyright 2003-2004 Jamin W. Collins <jcollins@asgardsrealm.net>
 * Copyright 2001-2003 Tony Collins
 *
 * This file is part of Media Mate
 * 
 * Media Mate is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Media Mate is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Media Mate; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 */

// This script shows user details.
require_once('header.php');

?>

<!-- Some necessary crap to set the page up. -->
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
   <head>
      <link rel="stylesheet" type="text/css" 
         href="themes/<?php echo $global_prefs['theme'];?>.css">
      <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
      <title><?php echo $global_text['userdetails'];?></title>
   </head>
   <body>
      <!-- Center the background canvas on the page -->
      <div align="center">
         <div id="pageborder">

            <a href="index.php">
               <div id="title">
               </div>
            </a>

            <br>

<?php
// User Details Section
if ( ($_SESSION['level'] > '0') && (is_numeric($_GET['id'])) ) {
   $id = $_GET['id'];

   $sql = "SELECT * FROM global_users WHERE user_id = ?";
   $result = $mm->dbExec($sql, array($id));
   list($user_id, $admin_level, $user_name, $user_password, $real_name, 
      $address_1, $address_2, $email_address, $user_phone, $jabber_id) 
      = $mm->dbFetchRow($result);
?>

            <p class="subheading">

<?php 
   echo "{$global_text['userdetailsfor']} - $real_name <i>($user_name)</i>";
?>
            </p>
            
<?php
   // If user is level 2 or higher, show admin box
   if ($_SESSION['level'] == '3') {
?>

            <table class="admin">
               <tr>
                  <td>
                     <form action="edit.php" method="get">
                        <input type="hidden" name="id" 
                           value="<?php echo "$user_id";?>">
                        <input type="image" src="gfx/edit.png" width="32" 
                           height="32" border="0" 
                           alt="<?php echo $global_text['editusersdetails'];?>" 
                           title="<?php echo $global_text['editusersdetails'];?>">
                     </form>
                  </td>
                  <td>
                     <form action="delete.php" method="post"
                        onSubmit="
                        if(confirm('<?php echo $global_text['deleteuserconfirm'];?>')) {
                           return true
                        } else {
                           return false 
                        }
                     ">
                        <input type="hidden" name="id" 
                           value="<?php echo "$user_id";?>">
                        <input type="image" src="gfx/delete.png" width="32" 
                           height="32" border="0" 
                           alt="<?php echo $global_text['deletethisuser'];?>" 
                           title="<?php echo $global_text['deletethisuser'];?>">
                     </form>
                  </td>
               </tr>
            </table>
            <br>

<?php
   }; // End of admin box
?>
            <table class="main">
               <tr>
                  <td align="right" valign="top">
                     <p class="mainlabel">

<?php 
   echo $global_text['address'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td>
                     <p class="maintext">

<?php 
   echo "$address_1";
?>

                     </p>
                  </td>
               </tr>
               <tr>
                  <td></td>
                  <td>
                     <p class="maintext">

<?php 
   echo "$address_2";
?>

                     </p>
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="mainlabel">

<?php 
   echo $global_text['email'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td>
                     <p class="maintext">

<?php
   // If there's a mail server installed, create a link to the mail form
   if ($global_prefs['mta'] == "on") {
      echo "<a href=\"javascript:void(0)\" ";
      echo "onClick=\"window.open('mail.php?email_address=$email_address',";
      echo "'Email_User', 'width=500,height=350,toobar=0,scrollbars=1,";
      echo "location=0,statusbar=0,menubar=0,resizable=1'); return false\">";
      echo "$email_address</a>";
   } else {
      echo "<a href=\"mailto:$email_address\" ";
      echo "title=\"{$global_text['emailthisuser']}\">$email_address</a>";
   };
?>

                     </p>
                  </td>
               </tr>
               <tr>
                  <td align="right">
                     <p class="mainlabel">

<?php 
   echo $global_text['telephone'], "&nbsp;&nbsp;\n";
?>

                     </p>
                  </td>
                  <td>
                     <p class="maintext">

<?php 
   echo "$user_phone";
?>

                     </p>
                     </td>
                  </tr>
                  <tr>
                     <td align="right">
                        <p class="mainlabel">

<?php 
   echo $global_text['jabberid'], "&nbsp;&nbsp;\n";
?>

                        </p>
                     </td>
                     <td align="left">

<?php 
   if (($global_prefs['j_server'] != "") AND ($global_prefs['j_port'] != "") 
      AND ($global_prefs['j_username'] != "") AND ($global_prefs['j_password'] 
      != "") AND ($global_prefs['online'] == "on")) {

         echo "<p class=\"maintext\"><a href=\"javascript:void(0)\" ";
         echo "onClick=\"window.open('jabber_im.php?jid=$jabber_id',";
         echo "'Jabber_IM', 'width=500,height=350,toobar=0,scrollbars=1,";
         echo "location=0,statusbar=0,menubar=0,resizable=1'); return false\">";
         echo "$jabber_id</a>&nbsp;&nbsp;</p>";
                     
   } else {
         echo "<p class=\"maintext\">$jabber_id</p>";
   };
?>
                     </td>
                  </tr>
               </table>

<?php
   // Let's check if this User has borrowed anything from the installed modules
   // and show links to history if they have.
   // First, a quick check to see if they have in fact borrowed anything
   $sql = "SELECT * FROM global_history WHERE borrower_uid = ?";
   $result = $mm->dbExec($sql, array($id));

   if ($mm->dbCountRows($result)) {
      echo "<p class=\"subheading\">{$global_text['borrowinghistory']}</p>";
      echo "<table class=\"admin\"><tr><td align=\"center\">";
      // If they have borrowed something, we want to see which modules
      // they've borrowed from, and show links.
      if ($dir = @opendir("modules/")) {
         while (($module_name = readdir($dir)) !== false) {
            if ($module_name != "." && $module_name != ".." 
               && file_exists("modules/$module_name/summary.php")) {
                  $sql = "SELECT * FROM global_history WHERE media_type = ?";
                  $gethistory = $mm->dbExec($sql, array($module_name));
                  if ($mm->dbCountRows($gethistory)) {
                     echo "<a href=\"index.php?module=$module_name&";
                     echo "do=userhistory&id=$id\">$module_name</a><br>";
                  };
            };
         };
      };
      echo "</td></tr></table>";

   }; 
};
?>

               <br/><br/>
               <a class="returnlink" href="index.php">

<?php 
echo $global_text['returntofront'];
?>

               </a>



            </div>
         <!-- End of centering the canvas on the page -->
         </div>
      </div>
   </body>
</html>
