/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.beobachter;

import java.awt.Component;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.io.History;
import mediathek.io.starter.Starts;

public class DownloadCellRenderer extends DefaultTableCellRenderer {

    private Daten daten;
    private boolean aboMalen;
    private boolean startMalen;
    private boolean gesehen = false;
    private int startQuelle = -1;
    private History history = null;

    public DownloadCellRenderer(Daten d, boolean sstartMalen, boolean aaboMalen, int sstartQuelle, boolean ggesehen) {
        daten = d;
        history = daten.history;
        startMalen = sstartMalen;
        aboMalen = aaboMalen;
        startQuelle = sstartQuelle;
        gesehen = ggesehen;
    }

    public DownloadCellRenderer(Daten d, boolean sstartMalen, boolean aaboMalen) {
        daten = d;
        history = daten.history;
        startMalen = sstartMalen;
        aboMalen = aaboMalen;
    }

    @Override
    public Component getTableCellRendererComponent(
            JTable table,
            Object value,
            boolean isSelected,
            boolean hasFocus,
            int row,
            int column) {
        try {
            setBackground(null);
            setForeground(null);
            setFont(null);
            super.getTableCellRendererComponent(
                    table, value, isSelected, hasFocus, row, column);
            int r = table.convertRowIndexToModel(row);
            String url = table.getModel().getValueAt(r, Konstanten.FILM_URL_NR).toString();
            if (startMalen) {
                Starts s = daten.starterClass.getStart(table.getModel().getValueAt(r, Konstanten.FILM_URL_NR).toString());
                if (s != null) {
                    if (startQuelle == -1 || startQuelle == s.quelle) {
                        switch (s.status) {
                            case Starts.STATUS_INIT:
                                if (isSelected) {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_WAIT_SEL);
                                } else {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_WAIT);
                                }
                                break;
                            case Starts.STATUS_RUN:
                                if (isSelected) {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_RUN_SEL);
                                } else {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_RUN);
                                }
                                break;
                            case Starts.STATUS_FERTIG:
                                if (isSelected) {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_FERTIG_SEL);
                                } else {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_FERTIG);
                                }
                                break;
                            case Starts.STATUS_ERR:
                                if (isSelected) {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_ERR_SEL);
                                } else {
                                    setBackground(Konstanten.DOWNLOAD_FARBE_ERR);
                                }
                                break;
                        }
                    }
                }
            }
            if (aboMalen) {
                DatenAbo datenAbo = daten.listeAbo.getEinmalAbo(url);
                if (datenAbo != null /*enmal-Abo wenn schon gelöscht*/) {
                    setForeground(Konstanten.DOWNLOAD_FARBE_ABO_EINMAL);
                    setFont(new java.awt.Font("Dialog", 3, 12));
                }
            }
            if (gesehen) {
                if (history.contains(table.getModel().getValueAt(r, Konstanten.FILM_URL_NR).toString())) {
                    setBackground(Konstanten.DOWNLOAD_FARBE_GESEHEN);
//                    setFont(new java.awt.Font("Dialog", 0, 12));
                }
            }
        } catch (Exception ex) {
            daten.fehler.fehlerMeldung(ex, "DownloadCellRenderer.getTabeleCellRendererComponent: Kann eigentlich nicht sein!");
        }
        return this;
    }
}
