/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 * 
 * @author
 */
public class MediathekWdr extends MediathekReader implements Runnable {

    private final int MAX_COUNT = 5;

    /**
     * 
     * @param ddaten
     * @param dde
     */
    public MediathekWdr(Daten ddaten) {
        super(ddaten);
        text = "WDR (bis ca. 300 MB, bis 1200 Filme)";
        sender = Konstanten.SENDER_WDR;
    }

    //===================================
    // public
    //===================================
//    @Override
//    void themaLaden() {
//        new Thread(new SenderThemaLaden()).start();
//
//    }
    @Override
    public synchronized void addToList() {
        //Theman suchen
        listeThemen.clear();
        addToList__("http://www.wdr.de/mediathek/html/regional/index.xml");
        if (!stop) {
            if (listeThemen.size() > 0) {
                notifyStart(listeThemen.size());
                for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME_KLEIN; ++t) {
                    new Thread(new SenderThemaLaden()).start();
                }
            }
        }
    }

    //===================================
    // private
    //===================================
    private void addToList__(String ADRESSE) {
        //Theman suchen
        final String MUSTER_URL = "<a href=\"";
        final String START = "<h2>Sendungen A-Z</h2>";
        final String ENDE = "<h2>Themen</h2>";
        StringBuffer strSeite = new StringBuffer();
        strSeite = getUrlIo.getUri_Iso(sender, ADRESSE, strSeite, "");
        int pos = 0;
        int pos1 = 0;
        int pos2 = 0;
        String url = "";
        String thema = "";
        int ende = strSeite.indexOf(ENDE);
        int start = strSeite.indexOf(START);
        if (start != -1 && ende != -1) {
            pos = start;
            while (!stop && (pos = strSeite.indexOf(MUSTER_URL, pos)) != -1) {
                if (pos > ende) {
                    //Themenbereich zu Ende
                    break;
                }
                url = "";
                thema = "";
                pos += MUSTER_URL.length();
                pos1 = pos;
                pos2 = strSeite.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                    url = strSeite.substring(pos1, pos2);
                    pos1 = strSeite.indexOf("\">", pos);
                    pos2 = strSeite.indexOf("<", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        thema = strSeite.substring(pos1 + 2, pos2).trim();
                        if (nurAboLaden()) {
                            //nur Abos laden
                            if (!daten.listeAbo.aboExists(sender, thema)) {
                                continue;
                            }
                        }
                    }
                    if (url.equals("")) {
                        daten.fehler.fehlerMeldung("Fehler!", "MediathekWdr.addToList: keine URL");
                    } else {
                        url = url.replace("&amp;", "&");
                        String[] add = new String[]{"http://www.wdr.de" + url + "&rankingcount=20", thema};
                        if (!istInListe(listeThemen, url, 0)) {
                            listeThemen.add(add);
                        }
                    }
                }
            }
        } else {
            daten.fehler.systemMeldung("WDR: nix gefunden!!");
        }
    }

    private class SenderThemaLaden implements Runnable {

        GetUrl getUrl = new GetUrl(daten, -1, Konstanten.WARTEN_BASIS_URL_LANG);
        private StringBuffer strSeite1 = new StringBuffer();
        private StringBuffer strSeite2 = new StringBuffer();

        @Override
        public void run() {
            addThread();
            String[] link;
            while (!stop && (link = getListeThemen()) != null) {
                themenSeitenSuchen(link[0] /*url*/, link[1] /*Thema*/);
                notifyProgress(link[0]);
            }
            threadUndFertig();
        }

        private void themenSeitenSuchen(String strUrlFeed, String thema) {
            //<div class="wsDisplayP"><strong>Video:</strong> http://www.wdr.de/mediathek/html/regional/
            //              2009/02/14/a40-komplett.xml;jsessionid=F203466678603049365CEB7FD61F087C.mediathek4</div>
            // diathek4" title="Zum Video 'Von Wundern und Bunkern'">

            //oder Audio:
            //    <div class="wsDisplayP"><strong>Audio:</strong> http://www.wdr.de/mediathek/html/regional/2009/01/
            //        30/cosmo-konsum.xml;jsessionid=A5A9CDE4FCA9E3339AFC9137656767CA.mediathek4</div>
            // title="Zum Audio 'Kauflaune ungetrübt'">Kauflaune u


            //<li class="wsVor">
            // <a href="?rankingtype=sendung&amp;rankingvisible=newest&amp;rankingvalue=A40&amp;rankingcount=5&amp;rankingpage=1">

            final String NEUESEITE_1 = "<li class=\"wsVor\">";
            final String NEUESEITE_2 = "<a href=\"?";

            final String MUSTER_URL = "<div class=\"wsDisplayP\"><strong>Video:</strong>";
            final String TITEL = "title=\"Zum Video '";
            int seitenCount = 0;
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            boolean neueSeite = false;
            String url = "";
            String titel = "";
            boolean first = true;
            do {
                neueSeite = false;
                pos = 0;
                pos1 = 0;
                pos2 = 0;
                strSeite1 = getUrl.getUri_Iso(sender, strUrlFeed, strSeite1, "");
                ++seitenCount;
                notifyProgress("*" + strUrlFeed);
                while (!stop && (pos = strSeite1.indexOf(MUSTER_URL, pos)) != -1) {
                    url = "";
                    titel = "";
                    pos += MUSTER_URL.length();
                    pos1 = pos;
                    pos2 = strSeite1.indexOf(";", pos);
                    if (pos1 != -1 && pos2 != -1 && pos1 != pos2) {
                        url = strSeite1.substring(pos1, pos2).trim();
                        if (!url.equals("")) {
                            pos1 = strSeite1.indexOf(TITEL, pos);
                            if (pos1 != -1) {
                                pos1 += TITEL.length();
                                pos2 = strSeite1.indexOf("'", pos1);
                                if (pos2 != -1 && pos1 < pos2) {
                                    titel = strSeite1.substring(pos1, pos2);
                                    //weiter gehts
                                    addFilme2(strUrlFeed, thema, titel, url, first);
                                    first = false;
                                }
                            }
                        } else {
                            daten.fehler.fehlerMeldung("Fehler!", "keine Url WdrThemaLaden.themenSeitenSuchen 1" + sender + thema);
                        }
                    } else {
                        daten.fehler.fehlerMeldung("Fehler!", "keine Url WdrThemaLaden.themenSeitenSuchen 2" + sender + thema);
                    }
                }
                if (daten.allesLaden) {
//                    String str = strSeite1.toString();
                    pos = -1;
                    if ((pos = strSeite1.indexOf(NEUESEITE_1)) != -1) {
                        if ((pos = strSeite1.indexOf(NEUESEITE_2, pos)) != -1) {
                            pos += NEUESEITE_2.length();
                            pos1 = pos;
                            pos2 = strSeite1.indexOf("\"", pos);
                            if (pos2 != -1 && pos1 < pos2) {
                                strUrlFeed = "http://www.wdr.de/mediathek/html/regional/ergebnisse/sendung.xml?" + strSeite1.substring(pos1, pos2);
                                strUrlFeed = strUrlFeed.replace("&amp;", "&");
                                if (!strUrlFeed.equals("")) {
                                    if (seitenCount < MAX_COUNT) {
                                        neueSeite = true;
                                    }
                                }
                            }
                        }
                    }
                }
            } while (!stop && neueSeite);
        }

        private void addFilme2(String strUrlFeed, String thema, String titel, String urlFilm, boolean alt) {
            // ;dslSrc=rtmp://gffstream.fcod.llnwd.net/a792/e1/media/video/2009/02/14/20090214_a40_komplett_big.flv&amp;isdnSrc=rtm
            // <p class="wsArticleAutor">Ein Beitrag von Heinke Schröder, 24.11.2010	</p>
            final String MUSTER_URL = "dslSrc=";
            final String MUSTER_DATUM = "<p class=\"wsArticleAutor\">";
            notifyProgress("*" + urlFilm);
            strSeite2 = getUrl.getUri_Iso(sender, urlFilm, strSeite2, "");
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            String url = "";
            String datum = "";
            //url suchen
            if ((pos = strSeite2.indexOf(MUSTER_DATUM)) != -1) {
                pos += MUSTER_DATUM.length();
                pos1 = pos;
                if ((pos2 = strSeite2.indexOf("<", pos)) != -1) {
                    if (pos1 < pos2) {
                        datum = strSeite2.substring(pos1, pos2).trim();
                        if (datum.length() > 10) {
                            datum = datum.substring(datum.length() - 10);
                        }
                    }
                }
            }
            pos = 0;
            pos1 = 0;
            pos2 = 0;
            if ((pos = strSeite2.indexOf(MUSTER_URL)) != -1) {
                pos += MUSTER_URL.length();
                pos1 = pos;
                if ((pos2 = strSeite2.indexOf("&", pos)) != -1) {
                    if (pos1 < pos2) {
                        url = strSeite2.substring(pos1, pos2);
                        if (!url.equals("")) {
                            // DatenFilm(Daten ddaten, String ssender, String tthema, String urlThema, String ttitel, String uurl, String uurlorg, String zziel) {
                            DatenFilm film = new DatenFilm(daten, sender, thema, strUrlFeed, titel, url, datum, ""/*zeit*/);
                            daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(film);
                        } else {
                            daten.fehler.fehlerMeldung("Fehler!", "keine Url WdrThemaLaden.addFilme2-1" + sender + thema);
                        }
                    }
                }
            } else {
                daten.fehler.fehlerMeldung("Fehler!", "keine Url WdrThemaLaden.addFilme2-2" + sender + thema);
            }
        }
    }
}
