/*
 *    Copyright (C) 2008
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package mediathek.filme.sender;

import mediathek.Konstanten;
import mediathek.daten.Daten;
import mediathek.filme.DatenFilm;
import mediathek.io.GetUrl;

/**
 * 
 * @author
 */
public class MediathekZdf extends MediathekReader implements Runnable {

    private StringBuffer seite = new StringBuffer();
    private final int ANZAHL_ZDF = 500;

    /**
     * 
     * @param ddaten
     */
    public MediathekZdf(Daten ddaten) {
        super(ddaten);
        sender = Konstanten.SENDER_ZDF;
        text = "ZDF  (bis ca. 130 MB, bis 10.000 Filme)";
    }

//    public static String leitungAendern(Daten daten, DatenFilm film) {
//        return leitungAendern__(daten, film.arr[Konstanten.FILM_URL_ORG_NR], film.arr[Konstanten.FILM_URL_HD_NR]);
//    }
//
//    public static String leitungAendern__(Daten daten, String urlOrg, String urlHd) {
//        String url;
//        if (daten.system[Konstanten.SYSTEM_LEITUNG_NR].equals(Konstanten.LEITUNG_HD)) {
//            if (!urlHd.equals("")) {
//                url = urlHd;
//            } else {
//                url = urlOrg;
//            }
//        } else if (daten.system[Konstanten.SYSTEM_LEITUNG_NR].equals(Konstanten.LEITUNG_DSL1000)) {
//            url = urlOrg.replace("/veryhigh/", "/300/");
//        } else {
//            url = urlOrg;
//        }
//        return url;
//    }
    /**
     * 
     */
    @Override
    public void addToList() {
        listeThemen.clear();
        addToList_kurz();
        if (daten.allesLaden) {
            addToList_lang();
        }
        if (!stop && listeThemen.size() > 0) {
            notifyStart(listeThemen.size());
//                if (!daten.allesLaden) {
//                    //nur die RSS auswerten
//                    for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME; ++t) {
//                        new Thread(new ZdfThemaLadenSchnell()).start();
//                    }
//                } else {
//                }
            //alles auswerten
            for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME; ++t) {
                new Thread(new ZdfThemaLaden()).start();
            }
        }
    }

    private void addToList_lang() {
        // Live-Stream eintragen
//        daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten,
//                Konstanten.SENDER_ZDF, "Live", "", "ZDF-Livestream",
//                "http://wstreaming.zdf.de/encoder/livestream2_vh.asx", ""/*datum*/, ""/*zeit*/));
        //Liste von http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-a-bis-z/saz0 bis sat8 holen
        final String MUSTER_URL = "<p><b><a href=\"/ZDFmediathek/kanaluebersicht/aktuellste/";
        String addr = "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-a-bis-z/saz";
        for (int i = 0; i <= 8; ++i) {
            seite = getUrlIo.getUri_Utf(sender, addr + String.valueOf(i), seite, "");
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            int pos3 = 0;
            String url = "";
            String urlorg = "";
            String thema = "";
            while ((pos = seite.indexOf(MUSTER_URL, pos)) != -1) {
                pos += MUSTER_URL.length();
                pos1 = pos;
                pos2 = seite.indexOf("?", pos);
                pos3 = seite.indexOf("\"", pos);
                if (pos1 != -1 && pos2 != -1 && pos3 != -1 && pos2 < pos3) {
                    //pos2 > pos3 dann hat der Link kein ?
                    url = seite.substring(pos1, pos2);
                }
                pos1 = seite.indexOf("\">", pos);
                pos2 = seite.indexOf("<", pos);
                if (pos1 != -1 && pos2 != -1) {
                    thema = seite.substring(pos1 + 2, pos2);
                    if (nurAboLaden()) {
                        //nur Abos laden
                        if (!daten.listeAbo.aboExists(sender, thema)) {
                            continue;
                        }
                    }
                }
                if (url.equals("")) {
                    daten.fehler.fehlerMeldung("Fehler!", "MediathekZdf.addToList: keine URL");
                } else {
                    url = "http://www.zdf.de/ZDFmediathek/kanaluebersicht/aktuellste/" + url;
                    urlorg = url;
                    url += "?teaserListIndex=" + ANZAHL_ZDF;
                    addThemenliste(urlorg, url, thema);
                }
            }
        }
//        if (!stop) {
//            if (listeThemen.size() > 0) {
//                notifyStart(listeThemen.size());
//                if (!daten.allesLaden) {
//                    //nur die RSS auswerten
//                    for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME; ++t) {
//                        new Thread(new ZdfThemaLadenSchnell()).start();
//                    }
//                } else {
//                    //alles auswerten
//                    for (int t = 0; t < Konstanten.MAX_THREAD_LADEN_FILME; ++t) {
//                        new Thread(new ZdfThemaLaden()).start();
//                    }
//                }
//            }
//        }
    }

    private void addToList_kurz() {
        // Live-Stream eintragen
        daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten,
                Konstanten.SENDER_ZDF, "Live", "", "ZDF-Livestream",
                "http://wstreaming.zdf.de/encoder/livestream2_vh.asx", ""/*datum*/, ""/*zeit*/));
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day0", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day0", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day1", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day1", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day2", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day2", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day3", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day3", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day4", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day4", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day5", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day5", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day6", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day6", "");
        addThemenliste("http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day7", "http://www.zdf.de/ZDFmediathek/hauptnavigation/sendung-verpasst/day7", "");
    }

    private synchronized void addThemenliste(String urlorg, String url, String thema) {
        String[] add = new String[]{urlorg, url, thema};
        if (!istInListe(listeThemen, url, 0)) {
            listeThemen.add(add);
        }

    }

    private class ZdfThemaLaden implements Runnable {

        GetUrl getUrl = new GetUrl(daten);
        private StringBuffer seite1 = new StringBuffer();
        private StringBuffer seite2 = new StringBuffer();
//        private GetUrl getUrl = new GetUrl(daten);

        @Override
        public void run() {
            String link[];
            addThread();
            while (!stop && (link = getListeThemen()) != null) {
                seite1.setLength(0);
                addFilme(link[2]/*Thema*/, link[1]/*url*/, link[0]/*urlorg*/);
                notifyProgress(link[0]);
            }
            threadUndFertig();
        }

        private void addFilme(String thema, String urlThema, String urlorg) {
            final String MUSTER_URL_1 = "<p><b><a href=\"/ZDFmediathek/beitrag/video/";
            String titel = "";
            String url = "";
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            int pos3 = 0;
            int anz = 0;
            try {
                //seite1 = getUrl.getUri(urlThema + "?bc=saz", seite1);
                seite1 = getUrl.getUri_Utf(sender, urlThema, seite1, "Thema: " + thema);
                while (!stop && (pos = seite1.indexOf(MUSTER_URL_1, pos)) != -1) {
                    ++anz;
                    pos += MUSTER_URL_1.length();
                    pos1 = pos;
                    pos2 = seite1.indexOf("?", pos);
                    pos3 = seite1.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1 && pos3 != -1 && pos2 < pos3) {
                        //pos2 > pos3 dann hat der Link kein ?
                        url = seite1.substring(pos1, pos2);
                    } else {
                        url = seite1.substring(pos1, pos3);
                    }
//                    String test = seite1.substring(pos1, pos2);
//                    String test2 = seite1.toString();
                    pos1 = seite1.indexOf("\">", pos);
                    pos2 = seite1.indexOf("<", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        titel = seite1.substring(pos1 + 2, pos2);
                    }
                    if (url.equals("")) {
                        daten.fehler.systemMeldung("MediathekZdf.addToList: keine URL");
                    } else {
                        url = "http://www.zdf.de/ZDFmediathek/beitrag/video/" + url;
                        filmHolen(thema, titel, urlorg, url, anz < 30 ? false : true);
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "MediathekZdf.addToList");
            }
        }

        private void filmHolen(String thema, String titel, String urlThema, String urlFilm, boolean alt) {
            final String MUSTER_URL_1 = "<li>DSL 2000 <a href=\"http://wstreaming.zdf.de/zdf/veryhigh/";
            final String MUSTER_URL_2 = "<li>DSL 2000 <a href=\"http://wgeostreaming.zdf.de/zdf/veryhigh/";
            final String MUSTER_TITEL_1 = "<title>";
            final String MUSTER_TITEL_2 = "</title>";
            final String MUSTER_DATUM_1 = "<p class=\"datum\">";
            final String MUSTER_DATUM_2 = "</p>";
            String muster = "";
            String url = "";
            //String urlHd = "";
            String datum = "";
            int pos = 0;
            int pos1 = 0;
            int pos2 = 0;
            try {
                notifyProgress("*" + urlFilm);
                seite2 = getUrl.getUri_Utf(sender, urlFilm, seite2, "urlThema: " + urlThema);
                if (titel.equals("")) {
                    //<title>Neu im Kino - &quot;Fair Game&quot; - ZDFneo - ZDFmediathek - ZDF Mediathek</title>
                    //<title>Trinkwasser aus dem Eisberg - Abenteuer Wissen - ZDFmediathek - ZDF Mediathek</title>
                    //<p class="datum">Abenteuer Wissen, 24.11.2010</p>

                    pos1 = seite2.indexOf(MUSTER_TITEL_1, 0) + MUSTER_TITEL_1.length();
                    pos2 = seite2.indexOf(MUSTER_TITEL_2, MUSTER_TITEL_1.length());
                    if (pos1 != -1 && pos2 != -1) {
                        titel = seite2.substring(pos1, pos2);
                        titel.replace("", " - ZDFmediathek - ZDF Mediathek");
                        if (titel.contains("-")) {
                            titel = titel.substring(titel.lastIndexOf("-"));
                        }
                    }
                }
                pos = 0;
                pos1 = 0;
                pos2 = 0;
                if ((pos1 = seite2.indexOf(MUSTER_DATUM_1, 0)) != -1) {
                    if ((pos2 = seite2.indexOf(MUSTER_DATUM_2, pos1)) != -1) {
                        pos1 += MUSTER_DATUM_1.length();
                        datum = seite2.substring(pos1, pos2);
                        if (datum.contains(",")) {
                            if (thema.equals("")) {
                                thema = datum.substring(0, datum.lastIndexOf(","));
                            }
                            datum = datum.substring(datum.lastIndexOf(",") + 1).trim();
                        }
                    }
                }
                pos = 0;
                pos1 = 0;
                pos2 = 0;
                if (seite2.indexOf(MUSTER_URL_1) != -1) {
                    muster = MUSTER_URL_1;
                } else {
                    muster = MUSTER_URL_2;
                }
                if (!stop && (pos = seite2.indexOf(muster, pos)) != -1) {
                    pos += muster.length();
                    pos1 = pos;
                    pos2 = seite2.indexOf("\"", pos);
                    if (pos1 != -1 && pos2 != -1) {
                        url = seite2.substring(pos1, pos2);
                    }
                    if (url.equals("")) {
                        daten.fehler.systemMeldung("MediathekZdf.filmHolen-1: keine URL");
                    } else {
                        url = "http://wstreaming.zdf.de/zdf/veryhigh/" + url;
                        if (!url.endsWith("asx")) {
                            daten.fehler.systemMeldung("MediathekZdf.filmHolen-2: keine URL");
                        } else {
//                            if (thema.equals("Terra X")) { //bisher einziges Thema
//                                if (Funktionen.urlExists(url.replace("/veryhigh/", "/hd/"))) {
//                                    urlHd = url.replace("/veryhigh/", "/hd/");
//                                }
//                            }
                            //DatenFilm(ddaten, ssender, tthema, urlThema, ttitel, uurl, uurlorg, zziel)
//                            daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten, Konstanten.SENDER_ZDF,
//                                    thema, urlThema, titel,
//                                    leitungAendern__(daten, url, urlHd), url/*urlOrg*/, ""/*urlRtmp*/, urlHd, alt));
                            daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten, Konstanten.SENDER_ZDF,
                                    thema, urlThema, titel, url, url/*urlOrg*/, ""/*urlRtmp*/, datum, ""/*zeit*/, alt));
                        }
                    }
                }
            } catch (Exception ex) {
                daten.fehler.fehlerMeldung(ex, "MediathekZdf.filmHolen");
            }
        }

        private synchronized String[] getListeThemen() {
            return listeThemen.pollFirst();
        }
    }
//
//    private class ZdfThemaLadenSchnell implements Runnable {
//
//        GetUrl getUrl = new GetUrl(daten);
//        private StringBuffer seite = new StringBuffer();
////        private GetUrl getUrl = new GetUrl(daten);
//
//        @Override
//        public void run() {
//            String link[]; //String[]{urlorg, url, thema};
//            ++threads;
//            notifyThread();
//            //Link bauen: http://www.zdf.de/ZDFmediathek/rss/382?view=rss
//            while (!stop && (link = getListeThemen()) != null) {
//                String urlThema = link[0].substring(link[0].lastIndexOf("/") + 1);
//                urlThema = "http://www.zdf.de/ZDFmediathek/rss/" + urlThema + "?view=rss";
//                notifyProgress(urlThema);
//                seite.setLength(0);
//                addFilme(link[2], urlThema);
//            }
//            --threads;
//            notifyThread();
//            notifyFertig();
//        }
//
//        void addFilme(String thema, String strUrlFeed) {
//            //Liste von http://www.3sat.de/mediathek/rss/mediathek.xml holen
//            final String MUSTER_ITEM_1 = "<item>";
//            final String MUSTER_ITEM_2 = "</item>";
//            final String MUSTER_TITEL_1 = "<title>";
//            final String MUSTER_TITEL_2 = "</title>";
//            final String MUSTER_URL_1 = "<media:content url=\"";
//            final String MUSTER_URL_2 = "\">";
//            int pos = 0;
//            int posEnd = 0;
//            int pos1 = 0;
//            int pos2 = 0;
//            String titel = "";
//            String url = "";
//            String urlorg = "";
//            String urlHd = "";
//            try {
//                notifyProgress("*" + strUrlFeed);
//                seite = getUrl.getUri_Utf(sender, strUrlFeed, seite, "Thema: " + thema);
//                pos = seite.indexOf(MUSTER_ITEM_1, pos); //start der Einträge
//                if (pos != -1) {
//                    do {
//                        url = "";
//                        posEnd = seite.indexOf(MUSTER_ITEM_2, pos);
//                        pos += MUSTER_ITEM_1.length();
//                        pos1 = seite.indexOf(MUSTER_TITEL_1, pos) + MUSTER_TITEL_1.length();
//                        pos2 = seite.indexOf(MUSTER_TITEL_2, pos + MUSTER_TITEL_1.length());
//                        if (pos1 != -1 && pos2 != -1 && pos1 < posEnd && pos2 < posEnd) {
//                            titel = seite.substring(pos1, pos2);
//                            pos = pos2;
//                        }
//                        pos1 = seite.indexOf(MUSTER_URL_1, pos) + MUSTER_URL_1.length();
//                        pos2 = seite.indexOf(MUSTER_URL_2, pos + MUSTER_URL_1.length());
//                        if (pos1 != -1 && pos2 != -1 && pos1 < posEnd && pos2 < posEnd) {
//                            url = seite.substring(pos1, pos2);
//                            pos = pos2; //erst den zweiten Eintrag nehmen
//                            if (url.endsWith("mov")) {
//                                url = "";
//                                pos1 = seite.indexOf(MUSTER_URL_1, pos) + MUSTER_URL_1.length();
//                                pos2 = seite.indexOf(MUSTER_URL_2, pos + MUSTER_URL_1.length());
//                                if (pos1 != -1 && pos2 != -1 && pos1 < posEnd && pos2 < posEnd) {
//                                    url = seite.substring(pos1, pos2);
//                                    pos = pos2;
//                                }
//                            }
//                        }
//                        if (url.equals("")) {
////                            new Fehler(daten).fehlermeldung("Fehler!", "MediathekZdf.addToList: keine URL");
////                            daten.fehler.systemMeldung("MediathekZdf.addToList: keine URL");
//                        } else {
//                            if (!url.endsWith("asx")) {
//                                daten.fehler.fehlerMeldung("Fehler!", "MediathekZdf.addToList: keine URL");
//                            } else {
//                                urlorg = new String(url);
//                                if (thema.equals("Terra X")) { //bisher einziges Thema
//                                    if (Funktionen.urlExists(urlorg.replace("/veryhigh/", "/hd/"))) {
//                                        urlHd = urlorg.replace("/veryhigh/", "/hd/");
//                                    }
//
//                                }
////                                daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten,
////                                        Konstanten.SENDER_ZDF, thema, strUrlFeed, titel,
////                                        leitungAendern__(daten, urlorg, urlHd), urlorg/*urlOrg*/, ""/*urlRtmp*/, urlHd));
//                                daten.filmeLaden.listeFilmeSchattenliste.addSenderRtmp(new DatenFilm(daten,
//                                        Konstanten.SENDER_ZDF, thema, strUrlFeed, titel,
//                                        urlorg, urlorg/*urlOrg*/, ""/*urlRtmp*/, urlHd));
//                            }
//                        }
//                    } while (!stop && (pos = seite.indexOf(MUSTER_ITEM_1, pos)) != -1);
//                }
//            } catch (Exception ex) {
//                daten.fehler.fehlerMeldung(ex, "MediathekZdf.addToList");
//            }
//        }
//    }
}
