/*
 *    Copyright (C) 2010
 *
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package mediathek.wiz;

import mediathek.daten.Daten;
import mediathek.daten.ListePgruppe;
import mediathek.wiz.panel.WizDataButton;
import mediathek.wiz.panel.WizPanelButtonStart;
import mediathek.wiz.panel.WizPanelButtonNeu;
import mediathek.wiz.panel.WizPanelButtonAendern;
import mediathek.wiz.panel.WizPanelButtonLoeschen;
import mediathek.wiz.wizard.Wizard;

public class WizButtonAnlegen {

    private Daten daten;

    public WizButtonAnlegen(Daten ddaten) {
        daten = ddaten;
        //public Wizard(java.awt.Frame parent, boolean modal, String ttitel) {
        ListePgruppe liste = daten.listePgruppeButton.getCopyOfMe();
        WizDataButton wizDataButton = new WizDataButton(liste);
        Wizard wiz = new Wizard(null, true, "Button ändern", wizDataButton);
        wiz.addPanel(new WizPanelButtonStart(wizDataButton));
        wiz.addPanel(new WizPanelButtonNeu(wizDataButton));
        wiz.addPanel(new WizPanelButtonAendern(wizDataButton));
        wiz.addPanel(new WizPanelButtonLoeschen(wizDataButton));
        wiz.start("WizPanelButtonStart");
        if (wiz.ok) {
            daten.listePgruppeButton = liste;
        }
    }

}
