module All where
import Data.String.HT
import Logger
import Control.Exception
import ImperativeState
import UrlAnalyse hiding (url)
import Load
import Compiler
import GetImages
import MakeChess
import Join
import TouchJPEG
import Control.Monad.State hiding (join)
import Tools
import Data.ByteString hiding (take,reverse,dropWhile,takeWhile,drop,map,concat,elem,zip,intercalate)
import System.Directory
import System.IO.Temp
import WikiHelper
import System.Info
import System.Process hiding (cwd)
import Static
import Data.List.Split
import MagicStrings
import Codec.Binary.UTF8.String
import Data.Map hiding (map)
import Data.List.HT (dropWhileRev)
import Data.ByteString.UTF8 (toString)
import Data.List
import Data.Maybe
import Data.Char
deleteImages::ImperativeMonad ()
deleteImages=return ()

getExtension:: String->String
getExtension s = normalizeExtension2 (map toLower (reverse . (takeWhile (/='.')) .reverse $ s))

getConvert:: String
getConvert= if os == "linux" then convert else getPathPrefix++convert
  where convert="convert "

makeTitle :: CompileResult -> FullWikiUrl -> [Char]
makeTitle result fu = theTitle
  where
    theTitle=if (Compiler.title result)=="" then pub++tit else pub++ (Compiler.title result)
    fun:: [String]->String->String
    fun (y:_) x= case splitOn y x of 
                    (z:_)->z
                    _ -> []
    fun [] x = x
    pub = "\\publishers{" ++ (concat (map  chartrans (UrlAnalyse.hostname fu))) ++ "}\n"
    tit= "\\title{" ++ ((concat (map (chartrans) ((fun ["/Print version","/Complete Wikibook","/All Chapters","/Print Version","/print version","/Printable version"] ((lemma fu)))))))++ "}\n"

getPathPrefix:: String
getPathPrefix= if os == "linux" then "" else "..\\lib\\"

-- shutil.copy(newfilename[:-4] + '-0.png', newfilename)

runFileMods::String->String->Integer->[Integer]->Integer->String->IO ()
runFileMods filenamebase extension theResolution gals imageNumber pathname =
                                     case extension of 
                                       ('s':'v':'g':_)-> do _<-system (getPathPrefix ++ "rsvg-convert -o " ++ pngfilename ++ " -a -w 1250 " ++ filename)
                                                            postprocpng pngfilename
                                                            _<-system(getPathPrefix ++ "rsvg-convert --format=pdf -o " ++ (filenamebase++"."++"pdf") ++ " -a -w 1250 " ++ filename)
                                                            return ()
                                       ('g':'i':'f':_)-> do stdfun
                                                            b<-doesFileExist firstpngfilename
                                                            if b then copyFile firstpngfilename newfilename else return ()
                                                            postprocpng newfilename
                                       ('t':'i':'f':_)-> do stdfun
                                                            postprocpng newfilename
                                       ('j':'p':'g':_)-> postprocjpg filename
                                       ('p':'n':'g':_)-> postprocpng filename
                                       _ -> return ()
  where 
    firstpngfilename= (reverse.(drop 4). reverse $ newfilename)++"-0.png"
    newfilename=filenamebase++"."++(normalizeExtension extension)
    filename=filenamebase++"."++extension
    stdfun = do _<-system (getConvert ++ "\"" ++ filename ++ "\" \"" ++ newfilename ++ "\"")
                return ()
    postprocpng fn = do _<-background fn
                        dither fn
                        return ()
    postprocjpg fn = do _<-system (getConvert ++ "-verbose " ++ fn ++ " " ++ fn)
                        dither fn
                        return ()
    background fn = system(getConvert ++ fn ++ 
                        " -background white -flatten " ++ fn)
    pngfilename =filenamebase++"."++"png"
    dither::String->IO ()
    dither fn = do _<-system (getConvert ++ "-verbose " ++ 
                      fn ++ " -format '%w'  " ++ pathname ++ "nullfile.bmp" ++ 
                      " > "++pathname++"dump2 2> "++pathname++"dump")
                   dump<-Tools.readFile (pathname ++ "dump")
                   case reverse (Prelude.filter (\x->(trim x)/="") (splitOn "\n" dump))  of 
                     (x:_)-> case splitOn " " x of 
                               (_:_:y:_)-> case splitOn "x" y of
                                           (z:_) -> case reads z of 
                                                 [(ii, _)] -> do runDither fn (if imageNumber `elem` gals then galleryWidth else imageWidth) ii
                                                 _ -> return ()
                                           _ -> return ()
                               _ -> return ()
                     _ -> return ()
    runDither::String->Integer->Integer->IO ()
    runDither fn newSize oldSize = if newSize < oldSize then system(getConvert ++ fn ++ " -resize " ++ (show newSize) ++ " " ++ fn)>> return() else return ()
    textWidth=10.5
    galleryImageWidth=5.0
    centimetersPerInch::Double
    centimetersPerInch = 2.54
    galleryWidth::Integer 
    galleryWidth= round ((fromIntegral theResolution) *galleryImageWidth / centimetersPerInch )
    imageWidth::Integer
    imageWidth= round ((fromIntegral theResolution) * textWidth / centimetersPerInch)

writeFiles:: String->[Maybe (String,ByteString,[String])]->Integer->[Integer]->IO ()
writeFiles pathname theImages theResolution gals = mapM_ go (Prelude.zip ([1..]::[Integer]) theImages)
  where
    go (i,Just (n,d,_))= do let filenamebase=(pathname++(show i))
                            let filename=filenamebase ++"."++(getExtension n)
                            Data.ByteString.writeFile filename d
                            runFileMods filenamebase (getExtension n) theResolution gals i pathname 
    go _ = return ()


makeBabel :: [Char] -> String
makeBabel x =case Data.Map.lookup xx m of
               Just v -> decode . unpack $ v
               _ -> case Data.Map.lookup "en" m of
                      Just w -> decode . unpack $  w
                      _ -> ""
  where m=fromList babelFiles
        xx=case splitOn "." x of
             (z:_)->z
             _ -> "en"

data LatexConfig = LatexConfig {figures::[Maybe (String,ByteString,[String])],title::String,fullConfig::FullConfig,content::String,hostname::String,theResult::CompileResult, onlyTables::Bool}

runLaTeX::LatexConfig->ImperativeMonad ByteString
runLaTeX config= liftIO (withSystemTempDirectory "MediaWiki2LaTeX" (runLaTeXCallback config))

runLaTeXCallback:: LatexConfig->FilePath -> IO ByteString
runLaTeXCallback config pathname = 
                                    do extract pathname
                                       Tools.writeFile (pathname++"/document/main/main.tex") (content config)
                                       Tools.writeFile (pathname++"/document/headers/svg.tex") (if vector (fullConfig config) then "\\newcommand{\\SVGExtension}{pdf}" else "\\newcommand{\\SVGExtension}{png}")
                                       Tools.writeFile (pathname++"/document/headers/title.tex") (All.title config)
                                       Tools.writeFile (pathname++"/document/headers/babel.tex") (makeBabel (All.hostname config))
                                       Tools.writeFile (pathname++"/document/headers/paper.tex") ("\\KOMAoption{paper}{"++(paper (fullConfig config))++"}")
                                       if (onlyTables config) then return () else All.writeFiles (pathname++"/document/images/") (figures config) (resolution (fullConfig config)) (galleryNumbers (theResult config)) 
                                       cwd<-getCurrentDirectory
                                       setCurrentDirectory (pathname++"/document/main")

                                       case (ImperativeState.copy  (fullConfig config)) of 
                                               Just x-> do _<-system("cp -r ../../document/* "++x)
                                                           return ()
                                               _ -> return ()
                                       _<-forM ((if onlyTables config then [1] else [1,2,3])::[Integer]) (\_->system "xelatex --interaction=nonstopmode main.tex")
                                       result<-if (onlyTables config) 
                                         then
                                           do _<-system("pdftotext main.pdf main.txt")
                                              te<-Control.Exception.catch  (Tools.readFile("main.txt")) catchFun
                                              case splitOn "\n" te of
                                                (x:_)->return (pack(encode (strip "pt\r" x)))
                                                _->return (pack(encode ""))
                                         else
                                           Data.ByteString.readFile "main.pdf"  
                                       setCurrentDirectory cwd 
                                       return result                
 

catchFun::IOException ->IO String
catchFun _= return ""

strip ::  Eq a=>[a] -> [a] -> [a]
strip l = dropWhileRev isBad . dropWhile isBad
 where 
  isBad x= x `elem` l 

latexPostamble::String 
latexPostamble = "\n\\end{longtable}\n\\pagebreak"

imgContrib::Maybe (String, ByteString, [String])->ImperativeMonad (String,Maybe String)
imgContrib (Just (_,_,x)) = do img<-getContributors x
                               return (intercalate ", " (keys (fst img)), snd img)

imgContrib _ = return ("",Nothing)

makeImgList :: [Maybe (String, ByteString, [String])]->ImperativeMonad String
makeImgList imgs = do contrib<-mapM imgContrib imgs 
                      let z=concat (map go (zip (zip ([1.. ]::[Integer]) contrib) imgs))
                      return ((toString latexPreamble)++z++(latexPostamble))
  where
    go (((i,(con,lic)),Just (_,_,(_:u:_))))="\\href{"++(replace2(replace2(concat (map chartransforlink u)) "//" "/" ) "http:/" "http://")++"}{"++(show i)++"}& "++con++"&"++(fromMaybe "" lic)++"\\\\ \\hline \n"
    go (((i,(_,_)),_)) = (show i)++"&&\\\\ \\hline \n"

all::FullConfig->ImperativeMonad ()
all cfg = 
                                          do st<-get
                                             templates <- case runMode cfg of
                                                           UserTemplateFile filename -> liftIO (Tools.readFile filename)  
                                                           _ -> return userTemplates
                                             let url = replace2 (if (take 8 (inputUrl cfg))=="https://"  then "http://"++(drop 8(inputUrl cfg)) else if (take 7 (inputUrl cfg))=="http://"  then (inputUrl cfg) else "http://"++(inputUrl cfg)) "_" " "
                                             purl<-parseUrl url
                                             put st{fullUrl= purl}
                                             minInit
                                             text<-load (runMode cfg)
                                             result<-compile (runMode cfg) text templates []
                                             deleteImages
                                             theImages<-getImages (images  result) (wikiUrl purl) 
                                             touchJPEG
                                             joined<-join (font cfg) (body result) ""
                                             makeChess
                                             let theConfig=LatexConfig{content=joined,figures=theImages, All.title=(makeTitle result purl),fullConfig=cfg,All.hostname= (UrlAnalyse.hostname purl),theResult=result,onlyTables=True}
                                             tabs<-mapM (\x->mapM (\y->runLaTeX theConfig {content=(toString (if (font cfg) then latexUnicodeTableHeader else latexTableHeader))++y++(toString latexTableFooter)}) x) (tablelist result)
                                             newResult<-compile (runMode cfg) text templates tabs
                                             contrib<-makeContributors
                                             pp<-makeImgList theImages
                                             newContent<-join (font cfg) (body newResult) (contrib++pp)
                                             pdf<-runLaTeX theConfig {onlyTables=False,theResult=newResult,content=newContent }
                                             liftIO (Data.ByteString.writeFile (outputFilename cfg) pdf)



