/* This file is autogenerated from gtksourcelanguagemanager.c */
#line 1 "/home/muntyan/projects/moo/moo/mooedit/gtksourceview/upstream/gtksourcelanguagemanager.c"
/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8; coding: utf-8 -*-
 *  gtksourcelanguagemanager.c
 *
 *  Copyright (C) 2003 - Paolo Maggi <paolo.maggi@polito.it>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>
#include "mooutils/mooi18n.h"
#include "gtksourcelanguage-private-mangled.h"
#include "gtksourcelanguage-mangled.h"
#include "gtksourceview-utils-mangled.h"

#define RNG_SCHEMA_FILE		"language2.rng"
#define LANGUAGE_DIR		"language-specs"
#define LANG_FILE_SUFFIX	".lang"

enum {
	PROP_0,
	PROP_SEARCH_PATH
};

struct _MooGtkSourceLanguageManagerPrivate
{
	GHashTable	*language_ids;
	GSList 		*available_languages;
	char	       **lang_dirs;
	char		*rng_file;
};

G_DEFINE_TYPE (MooGtkSourceLanguageManager, _moo_gtk_source_language_manager, G_TYPE_OBJECT)


static void
_moo_gtk_source_language_manager_set_property (GObject 	*object,
					  guint 	 prop_id,
					  const GValue *value,
					  GParamSpec	*pspec)
{
	MooGtkSourceLanguageManager *lm;

	lm = GTK_SOURCE_LANGUAGE_MANAGER (object);

	switch (prop_id)
	{
		case PROP_SEARCH_PATH:
			_moo_gtk_source_language_manager_set_search_path (lm, g_value_get_boxed (value));
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
_moo_gtk_source_language_manager_get_property (GObject 	*object,
					  guint 	 prop_id,
					  GValue 	*value,
					  GParamSpec	*pspec)
{
	MooGtkSourceLanguageManager *lm;

	lm = GTK_SOURCE_LANGUAGE_MANAGER (object);

	switch (prop_id)
	{
		case PROP_SEARCH_PATH:
			g_value_set_boxed (value, _moo_gtk_source_language_manager_get_search_path (lm));
			break;

		default:
			G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
			break;
	}
}

static void
_moo_gtk_source_language_manager_finalize (GObject *object)
{
	MooGtkSourceLanguageManager *lm;

	lm = GTK_SOURCE_LANGUAGE_MANAGER (object);

	if (lm->priv->language_ids)
		g_hash_table_destroy (lm->priv->language_ids);

	g_slist_foreach (lm->priv->available_languages, (GFunc) g_object_unref, NULL);
	g_slist_free (lm->priv->available_languages);
	g_strfreev (lm->priv->lang_dirs);
	g_free (lm->priv->rng_file);

	G_OBJECT_CLASS (_moo_gtk_source_language_manager_parent_class)->finalize (object);
}

static void
_moo_gtk_source_language_manager_class_init (MooGtkSourceLanguageManagerClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	object_class->finalize	= _moo_gtk_source_language_manager_finalize;

	object_class->set_property = _moo_gtk_source_language_manager_set_property;
	object_class->get_property = _moo_gtk_source_language_manager_get_property;

	g_object_class_install_property (object_class,
					 PROP_SEARCH_PATH,
					 g_param_spec_boxed ("search-path",
						 	     _("Language specification directories"),
							     _("List of directories where the "
							       "language specification files (.lang) "
							       "are located"),
							     G_TYPE_STRV,
							     G_PARAM_READWRITE));

	g_type_class_add_private (object_class, sizeof(MooGtkSourceLanguageManagerPrivate));
}

static void
_moo_gtk_source_language_manager_init (MooGtkSourceLanguageManager *lm)
{
	lm->priv = G_TYPE_INSTANCE_GET_PRIVATE (lm, GTK_TYPE_SOURCE_LANGUAGE_MANAGER,
						MooGtkSourceLanguageManagerPrivate);
	lm->priv->language_ids = NULL;
	lm->priv->available_languages = NULL;
	lm->priv->lang_dirs = NULL;
	lm->priv->rng_file = NULL;
}

/**
 * _moo_gtk_source_language_manager_new:
 *
 * Creates a new language manager. If you do not need more than one language
 * manager or a private language manager instance then use
 * _moo_gtk_source_language_manager_get_default() instead.
 *
 * Returns: a #MooGtkSourceLanguageManager.
 **/
MooGtkSourceLanguageManager *
_moo_gtk_source_language_manager_new (void)
{
	return g_object_new (GTK_TYPE_SOURCE_LANGUAGE_MANAGER, NULL);
}

/**
 * _moo_gtk_source_language_manager_get_default:
 *
 * Returns the default #MooGtkSourceLanguageManager instance.
 *
 * Returns: a #MooGtkSourceLanguageManager. Return value is owned
 * by MooGtkSourceView library and must not be unref'ed.
 **/
MooGtkSourceLanguageManager *
_moo_gtk_source_language_manager_get_default (void)
{
	static MooGtkSourceLanguageManager *instance;

	if (instance == NULL)
	{
		instance = _moo_gtk_source_language_manager_new ();
		g_object_add_weak_pointer (G_OBJECT (instance),
					   (gpointer*) &instance);
	}

	return instance;
}

/**
 * _moo_gtk_source_language_manager_set_search_path:
 * @lm: a #MooGtkSourceLanguageManager.
 * @dirs: a %NULL-terminated array of strings or %NULL.
 *
 * Sets a list of language files directories for the given language manager.
 * @dirs == %NULL resets directories list to default.
 **/
void
_moo_gtk_source_language_manager_set_search_path (MooGtkSourceLanguageManager *lm,
					     gchar                   **dirs)
{
	char **tmp;

	g_return_if_fail (GTK_IS_SOURCE_LANGUAGE_MANAGER (lm));
	/* FIXME: so what do we do? rescan, refresh? */
	g_return_if_fail (lm->priv->available_languages == NULL);

	tmp = lm->priv->lang_dirs;
	lm->priv->lang_dirs = g_strdupv (dirs);
	g_strfreev (tmp);

	g_object_notify (G_OBJECT (lm), "search-path");
}

/**
 * _moo_gtk_source_language_manager_get_search_path:
 * @lm: a #MooGtkSourceLanguageManager.
 *
 * Gets a list of language files directories for the given language manager.
 *
 * Returns: %NULL-terminated array containg a list of language files directories.
 * It is owned by @lm and must not be modified or freed.
 **/
gchar **
_moo_gtk_source_language_manager_get_search_path (MooGtkSourceLanguageManager *lm)
{
	g_return_val_if_fail (GTK_IS_SOURCE_LANGUAGE_MANAGER (lm), NULL);

	if (lm->priv->lang_dirs == NULL)
		lm->priv->lang_dirs = _moo_gtk_source_view_get_default_dirs (LANGUAGE_DIR, TRUE);

	return lm->priv->lang_dirs;
}

/**
 * _moo_gtk_source_language_manager_get_rng_file:
 * @lm: a #MooGtkSourceLanguageManager.
 *
 * Returns location of the RNG schema file for lang files version 2.
 *
 * Returns: path to RNG file. It belongs to %lm and must not be freed or modified.
 **/
const char *
_moo_gtk_source_language_manager_get_rng_file (MooGtkSourceLanguageManager *lm)
{
	g_return_val_if_fail (GTK_IS_SOURCE_LANGUAGE_MANAGER (lm), NULL);

	if (lm->priv->rng_file == NULL)
	{
		gchar **dirs;

		for (dirs = _moo_gtk_source_language_manager_get_search_path (lm);
		     dirs != NULL && *dirs != NULL;
		     ++dirs)
		{
			gchar *file;

			file = g_build_filename (*dirs, RNG_SCHEMA_FILE, NULL);
			if (g_file_test (file, G_FILE_TEST_EXISTS))
			{
				lm->priv->rng_file = file;
				break;
			}

			g_free (file);
		}
	}

	return lm->priv->rng_file;
}

static void
prepend_lang (G_GNUC_UNUSED gchar      *id,
	      MooGtkSourceLanguage        *lang,
	      MooGtkSourceLanguageManager *lm)
{
	lm->priv->available_languages =
		g_slist_prepend (lm->priv->available_languages, g_object_ref (lang));
}

static void
ensure_languages (MooGtkSourceLanguageManager *lm)
{
	GSList *filenames, *l;

	if (lm->priv->language_ids != NULL)
		return;

	lm->priv->language_ids = g_hash_table_new_full (g_str_hash, g_str_equal,
							g_free, g_object_unref);

	filenames = _moo_gtk_source_view_get_file_list (_moo_gtk_source_language_manager_get_search_path (lm),
						    LANG_FILE_SUFFIX);

	for (l = filenames; l != NULL; l = l->next)
	{
		MooGtkSourceLanguage *lang;
		gchar *filename;

		filename = l->data;

		lang = _moo_gtk_source_language_new_from_file (filename, lm);

		if (lang == NULL)
		{
			g_warning ("Error reading language specification file '%s'", filename);
			continue;
		}

		if (g_hash_table_lookup (lm->priv->language_ids, lang->priv->id) == NULL)
		{
			g_hash_table_insert (lm->priv->language_ids,
					     g_strdup (lang->priv->id),
					     lang);
		}
		else
		{
			g_object_unref (lang);
		}
	}

	g_hash_table_foreach (lm->priv->language_ids, (GHFunc) prepend_lang, lm);

	g_slist_foreach (filenames, (GFunc) g_free, NULL);
	g_slist_free (filenames);
}

/**
 * _moo_gtk_source_language_manager_get_available_languages:
 * @lm: a #MooGtkSourceLanguageManager.
 *
 * Gets a list of available languages for the given language manager.
 *
 * Returns: a list of #MooGtkSourceLanguage. Return value is owned by @lm and should
 * not be modified or freed.
 **/
const GSList *
_moo_gtk_source_language_manager_get_available_languages (MooGtkSourceLanguageManager *lm)
{
	g_return_val_if_fail (GTK_IS_SOURCE_LANGUAGE_MANAGER (lm), NULL);
	ensure_languages (lm);
	return lm->priv->available_languages;
}

/**
 * _moo_gtk_source_language_manager_get_language_by_id:
 * @lm: a #MooGtkSourceLanguageManager.
 * @id: a language id.
 *
 * Gets the #MooGtkSourceLanguage identified by the given @id in the language
 * manager.
 *
 * Returns: a #MooGtkSourceLanguage, or %NULL if there is no language
 * identified by the given @id. Return value is owned by @lm and should not
 * be freed.
 **/
MooGtkSourceLanguage *
_moo_gtk_source_language_manager_get_language_by_id (MooGtkSourceLanguageManager *lm,
						const gchar              *id)
{
	g_return_val_if_fail (id != NULL, NULL);
	ensure_languages (lm);
	return g_hash_table_lookup (lm->priv->language_ids, id);
}

