/* This file is autogenerated from gtksourcelanguage-private.h */
#line 1 "/home/muntyan/projects/moo/moo/mooedit/gtksourceview/upstream/gtksourcelanguage-private.h"
/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8; coding: utf-8 -*-
 *  gtksourcelanguage-private.h
 *
 *  Copyright (C) 2003 - Paolo Maggi <paolo.maggi@polito.it>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GTK_SOURCE_LANGUAGE_PRIVATE_H__
#define __GTK_SOURCE_LANGUAGE_PRIVATE_H__

#include <glib.h>
#include "gtksourcecontextengine-mangled.h"
#include "gtksourcelanguagemanager-mangled.h"

G_BEGIN_DECLS

#define GTK_SOURCE_LANGUAGE_VERSION_1_0  100
#define GTK_SOURCE_LANGUAGE_VERSION_2_0  200

typedef struct _MooGtkSourceStyleInfo MooGtkSourceStyleInfo;

struct _MooGtkSourceStyleInfo
{
	gchar *name;
	gchar *map_to;
};

struct _MooGtkSourceLanguagePrivate
{
	gchar                    *lang_file_name;
	gchar                    *translation_domain;

	gchar                    *id;
	gchar                    *name;
	gchar                    *section;

	/* Maps ids to MooGtkSourceStyleInfo objects */
	/* Names of styles defined in other lang files are not stored */
	GHashTable               *styles;
	gboolean		  styles_loaded;

	gint                      version;
	gboolean                  hidden;

	GHashTable               *properties;

	MooGtkSourceLanguageManager *language_manager;

	MooGtkSourceContextData     *ctx_data;
};

MooGtkSourceLanguage 	 *_moo_gtk_source_language_new_from_file 		(const gchar		   *filename,
									 MooGtkSourceLanguageManager  *lm);

MooGtkSourceLanguageManager *_moo_gtk_source_language_get_language_manager 	(MooGtkSourceLanguage        *language);

const gchar		 *_moo_gtk_source_language_manager_get_rng_file	(MooGtkSourceLanguageManager *lm);

gchar       		 *_moo_gtk_source_language_translate_string 	(MooGtkSourceLanguage        *language,
									 const gchar              *string);

void 			  _moo_gtk_source_language_define_language_styles	(MooGtkSourceLanguage        *language);

gboolean 		  _moo_gtk_source_language_file_parse_version1 	(MooGtkSourceLanguage        *language,
									 MooGtkSourceContextData     *ctx_data);

gboolean 		  _moo_gtk_source_language_file_parse_version2	(MooGtkSourceLanguage        *language,
									 MooGtkSourceContextData     *ctx_data);

MooGtkSourceEngine 	 *_moo_gtk_source_language_create_engine		(MooGtkSourceLanguage	  *language);

/* Utility functions for MooGtkSourceStyleInfo */
MooGtkSourceStyleInfo 	 *_moo_gtk_source_style_info_new 			(const gchar		  *name,
									 const gchar              *map_to);
MooGtkSourceStyleInfo 	 *_moo_gtk_source_style_info_copy			(MooGtkSourceStyleInfo       *info);
void			  _moo_gtk_source_style_info_free			(MooGtkSourceStyleInfo       *info);

G_END_DECLS

#endif  /* __GTK_SOURCE_LANGUAGE_PRIVATE_H__ */

