#ifndef MDFN_FILE_H
#define MDFN_FILE_H
typedef struct {
	uint8 *data;
	int64 size;
	int64 location;
	void *mmap;
	char *ext;
} MDFNFILE;

MDFNFILE *MDFN_fopen(const char *path, const char *ipsfn, char *mode, char *ext);
int MDFN_fclose(MDFNFILE*);
uint64 MDFN_fread(void *ptr, size_t size, size_t nmemb, MDFNFILE*);
uint64 MDFN_fwrite(void *ptr, size_t size, size_t nmemb, MDFNFILE*);
int MDFN_fseek(MDFNFILE*, int64 offset, int whence);
uint64 MDFN_ftell(MDFNFILE*);
void MDFN_rewind(MDFNFILE*);
int MDFN_read32le(uint32 *Bufo, MDFNFILE*);
int MDFN_read16le(uint16 *Bufo, MDFNFILE*);
int MDFN_fgetc(MDFNFILE*);
uint64 MDFN_fgetsize(MDFNFILE*);
int MDFN_fisarchive(MDFNFILE*);
char *MDFN_fgets(char *s, int size, MDFNFILE *);
#endif
