/* Mednafen - Multi-system Emulator
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#if 0
// HAVE_FCNTL
//defined(HAVE_FCNTL) && defined(HAVE_FCNTL_H)

#include "main.h"
#include <trio/trio.h>
#include <ctype.h>
#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>

// Code for the stdio emulator interface.
static char *InputBuffer;
static size_t InputBufferLen;
static off_t InputBufferOffset;

unsigned int hex_nibble_to_val(char nibble)
{
 unsigned int ret = 0;
 nibble = tolower(nibble);

 if(nibble >= '0' && nibble <= '9')
  ret = nibble - '0';
 else
  ret = nibble - 'a';

 return(ret);
}

void unescape_string(char *string)
{
 char *src = string;
 bool inescape = 0;
 uint8 hoval = 0;
 int inhex = 0;
 int inoctal = 0;

 while(*src)
 {
  if(*src == '\\')
  {
   inescape = TRUE;
   inhex = 0;
   inoctal = 0;
  }
  else if(inhex)
  {
   if(inhex == 1) 
   {
    hoval = hex_nibble_to_val(*src) << 4;
    inhex++;
   }
   else if(inhex == 2)
   {
    hoval |= hex_nibble_to_val(*src);
    *string = hoval;
    string++;
    hoval = 0;
    inhex = 0;
   }
  }
  else if(inoctal)
  {
   if(inoctal == 1)
   {
    hoval = (*src - '0') * 8 * 8;
   }
   else if(inoctal == 2)
   {
    hoval += (*src - '0') * 8;
   }
   else
   {
    hoval += *src - '0';
    *string = hoval;
    string++;
    hoval = 0;
    inoctal = 0;
   }
  }
  else if(inescape)
  {
   switch(*src)
   {
    case 'a': *string = 7; string++; break;
    case 'b': *string = 8; string++; break;
    case 'f': *string = 12; string++; break;
    case 'n': *string = 10; string++; break;
    case 'r': *string = 13; string++; break;
    case 't': *string = 9; string++; break;
    case 'v': *string = 11; string++; break;

    case '\\': *string = '\\'; string++; break;
    case '?': *string = '?'; string++; break;
    case '\'': *string = '\''; string++; break;
    case '"': *string = '"'; string++; break;

    case 'o': inoctal = 1; break;
    case 'x': inhex = 1; break;
    

    default: *string = *src; string++; break;
   }
   inescape = 0;
  }
  else
  {
   *string = *src;
   string++;
  }
  src++;
 }
 *string = 0;
}

static void ParseSTDIOCommand(char *buf)
{
 char *arguments[8];
 int which_argument = 0;
 size_t blen = strlen(buf);
 bool InQuote = 0;
 char *InBegin = NULL;
 char last_char = 0;

 memset(arguments, 0, sizeof(arguments));

 for(size_t x = 0; x <= blen; x++)
 {
  if((buf[x] == ' ' || buf[x] == 0) && last_char != '\\' && !InQuote && InBegin)
  {
   buf[x] = 0;

   unescape_string(InBegin);
   arguments[which_argument] = InBegin;
   which_argument++;
   if(which_argument == 8)
   {
    break;
   }
   InBegin = NULL;
  }
  else if(buf[x] != ' ' && buf[x] != '\t' && buf[x] != '"' && last_char != '\\' && !InQuote && !InBegin)
  {
   InBegin = &buf[x];
  }
  else if(buf[x] == '"' && last_char != '\\')
  {
   if(InBegin)
   {
    buf[x] = 0;
    unescape_string(InBegin);
    arguments[which_argument] = InBegin;
    which_argument++;
    if(which_argument == 8)
    {
     break;
    }
    InQuote = 0;
    InBegin = NULL;
   }
   else
   {
    InQuote = TRUE;
    InBegin = &buf[x + 1];
   }
  }
  last_char = buf[x];
 }

 int numargs = which_argument; // numargs count includes the command.  Misleading, yes!
 bool success = 0;
 bool suppress_success = 0;

 if(numargs)
 {
  if(!strcasecmp(arguments[0], "exit"))
  {
   MainRequestExit();
   suppress_success = TRUE;
  }
  else if(!strcasecmp(arguments[0], "sync_video"))
  {
   success = MT_FromRemote_VideoSync();
  }
  else if(!strcasecmp(arguments[0], "sync_sound"))
  {
   success = MT_FromRemote_SoundSync();
  }
  else if(!strcasecmp(arguments[0], "get_setting"))
  {
   if(numargs == 2)
   {
    std::string sval;

    LockGameMutex(TRUE);

    sval = MDFN_GetSettingS(arguments[1]);
    success = TRUE;

    LockGameMutex(FALSE);
   }
   else
    puts("Invalid number of arguments");
  }
  else if(!strcasecmp(arguments[0], "set_setting"))
  {
   if(numargs == 3)
   {
    LockGameMutex(TRUE);
    success = MDFNI_SetSetting(arguments[1], arguments[2]);
    LockGameMutex(FALSE);
   }
   else
    puts("Invalid number of arguments");
  }
  else
  {
   puts("Unknown command!");
  }
 }

 if(!suppress_success)
 {
  if(success)
   puts("*SUCCESS");
  else
   puts("*FAILURE");
 }
 //printf("%s %s %s %s %s %s\n", arguments[0], arguments[1], arguments[2], arguments[3], arguments[4], arguments[5]);
}

// Called from the main thread.
void CheckForSTDIOMessages(void)
{
 char inval;

 while(read(fileno(stdin), &inval, 1) == 1)
 {
  if(InputBufferOffset == InputBufferLen)
  {
   InputBufferLen += 256;
   InputBuffer = (char*)realloc(InputBuffer, InputBufferLen);
  }

  if(inval == '\n')
  {
   InputBuffer[InputBufferOffset] = 0;

   for(size_t x = 0; x < InputBufferOffset; x++)
    if(InputBuffer[x] == '\r')
     InputBuffer[x] = 0;

   ParseSTDIOCommand(InputBuffer);
   InputBufferOffset = 0;
  }
  else
   InputBuffer[InputBufferOffset++] = inval;

 }
}

bool InitSTDIOInterface(void)
{
 if(fcntl(fileno(stdin), F_SETFL, O_NONBLOCK | O_RDONLY))
 {
  puts("fcntl error");
  return(0);
 }

 InputBuffer = NULL;
 InputBufferLen = 0; 
 InputBufferOffset = 0;
 
 return(TRUE);
}

#else

void CheckForSTDIOMessages(void)
{

}

bool InitSTDIOInterface(void)
{
 return(0);
}

#endif
