#ifndef __PCFX_SCSICD_H
#define __PCFX_SCSICD_H

#include <blip/Blip_Buffer.h>

void SCSICD_Power(void);
void SCSICD_SetDB(uint8 data);
uint8 SCSICD_GetDB(void);

// These SCSICD_Set* functions are kind of misnomers, at least in comparison to the SCSICD_Get* functions...
// They will set/clear the bits corresponding to the KING's side of the bus.
void SCSICD_SetACK(bool set);
void SCSICD_SetMSG(bool set);
void SCSICD_SetREQ(bool set);
void SCSICD_SetSEL(bool set);
void SCSICD_SetRST(bool set);
void SCSICD_SetBSY(bool set);
void SCSICD_SetCD(bool set);
void SCSICD_SetIO(bool set);
void SCSICD_SetATN(bool set);

// These SCSICD_Get* functions return the current status of the SCSI bus(not necessarily equal to the status of internal registers on any particular chip driving these signals high or low)
bool SCSICD_GetBSY(void);
bool SCSICD_GetACK(void);
bool SCSICD_GetRST(void);
bool SCSICD_GetMSG(void);
bool SCSICD_GetSEL(void);
bool SCSICD_GetCD(void);
bool SCSICD_GetREQ(void);
bool SCSICD_GetIO(void);
bool SCSICD_GetATN(void);

uint32 SCSICD_Run(uint32);
void SCSICD_ResetTS(void);

enum
{
 SCSICD_PCE = 1,
 SCSICD_PCFX
};

enum
{
 SCSICD_IRQ_DATA_TRANSFER_DONE = 1,
 SCSICD_IRQ_DATA_TRANSFER_READY
};

void SCSICD_GetCDDAValues(int16 &left, int16 &right);

void SCSICD_Init(int type, int CDDATimeDiv, Blip_Buffer *leftbuf, Blip_Buffer *rightbuf, uint32 TransferRate, uint32 SystemClock, void (*IRQFunc)(int), void (*SSCFunc)(uint8));
void SCSICD_SetCDDAVolume(double left, double right);
bool SCSICD_StealByte(uint8 &stolen);
int SCSICD_StateAction(StateMem *sm, int load, int data_only, const char *sname);

bool SCSICD_IsInserted(void);
bool SCSICD_EjectVirtual(void);
bool SCSICD_InsertVirtual(void);

#endif
