/*
 * system_glade.h
 * 
 * Copyright 2013-2015 AmatCoder
 * 
 * This file is part of system.
 * 
 * Mednaffe is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Mednaffe is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Mednaffe; if not, see <http://www.gnu.org/licenses/>.
 * 
 */
 
#ifndef SYSTEM_GLADE_H
#define SYSTEM_GLADE_H

static const char *system_glade =
"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
"<interface>\n"
"<requires lib=\"gtk+\" version=\"2.18\"/>\n"
"<!-- interface-naming-policy project-wide -->\n"
"<object class=\"GtkVBox\" id=\"-gb\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Emulated GB type:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-gb.system_type\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">auto - Auto\n"
"Automatic detection based on headers.\n"
"\n"
"dmg - DMG\n"
"Original GameBoy Monochrome.\n"
"\n"
"cgb - CGB\n"
"GameBoy Color.\n"
"\n"
"This option is not fully implemented in regards to handling of DMG games.\n"
"\n"
"agb - AGB\n"
"GameBoy Advance.\n"
"\n"
"This option is not fully implemented in regards to handling of DMG games.</property>\n"
"<property name=\"model\">gbstore</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-gb.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label64\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-gba\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-gba.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label63\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to optional GBA BIOS ROM image:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-gba.bios\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button1\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-gba.bios\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Bios&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-gg\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-gg.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-lynx\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-lynx.lowpass\">\n"
"<property name=\"label\" translatable=\"yes\">Enable sound output lowpass filter</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label65\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-md\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">13</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Emulate the specified region:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-md.region\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">game - Match game's header.\n"
"Emulate the region that the game indicates it expects to run in via data in the header(or in an internal database for a few games that may have bad header data).\n"
"\n"
"overseas_ntsc - Overseas(non-Japan), NTSC\n"
"Region used in North America.\n"
"\n"
"overseas_pal - Overseas(non-Japan), PAL\n"
"Region used in Europe.\n"
"\n"
"domestic_ntsc - Domestic(Japan), NTSC\n"
"Region used in Japan.\n"
"\n"
"domestic_pal - Domestic(Japan), PAL\n"
"Probably an invalid region, but available for testing purposes anyway.</property>\n"
"<property name=\"model\">mdstore1</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb2\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Region reported to the game:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-md.reported_region\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">same - Match the region emulated.\n"
"\n"
"game - Match game's header.\n"
"This option, in conjunction with the \"region\" setting, can be used to run all games at NTSC speeds, or all games at PAL speeds.\n"
"\n"
"overseas_ntsc - Overseas(non-Japan), NTSC\n"
"Region used in North America.\n"
"\n"
"overseas_pal - Overseas(non-Japan), PAL\n"
"Region used in Europe.\n"
"\n"
"domestic_ntsc - Domestic(Japan), NTSC\n"
"Region used in Japan.\n"
"\n"
"domestic_pal - Domestic(Japan), PAL\n"
"Probably an invalid region, but available for testing purposes anyway.</property>\n"
"<property name=\"model\">mdstore2</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb3\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-md.correct_aspect\">\n"
"<property name=\"label\" translatable=\"yes\">Correct the aspect ratio</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label69\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame26\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment27\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-md.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label41\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-nes\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.pal\">\n"
"<property name=\"label\" translatable=\"yes\">Enable PAL (50Hz) NES emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.fnscan\">\n"
"<property name=\"label\" translatable=\"yes\">Scan filename for (U),(J),(E),etc. strings to en/dis-able PAL emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"This option may break NES network play when enabled IF the players are using ROM images with different filenames.</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.nofs\">\n"
"<property name=\"label\" translatable=\"yes\">Disable four-score emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.gg\">\n"
"<property name=\"label\" translatable=\"yes\">Enable Game Genie emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"bottom_padding\">6</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox15\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.correct_aspect\">\n"
"<property name=\"label\" translatable=\"yes\">Correct the aspect ratio</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.clipsides\">\n"
"<property name=\"label\" translatable=\"yes\">Clip left+right 8 pixel columns</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.no8lim\">\n"
"<property name=\"label\" translatable=\"yes\">Remove 8-sprites-per-scanline hardware limit</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"Enabling this option will cause graphical glitches in some games, including \"Solstice\".</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">4</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.slendp\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjnes6</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.slstartp\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjnes5</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.slend\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjnes4</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.slstart\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjnes3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label48\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">First displayed scanline in NTSC mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label49\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Last displayed scanline in NTSC mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label50\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">First displayed scanline in PAL mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label51\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Last displayed scanline in PAL mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label68\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.n106bs\">\n"
"<property name=\"label\" translatable=\"yes\">Enable less-accurate, but better sounding, Namco 106 sound emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-nes.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox41\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label47\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Sound quality:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-nes.soundq\">\n"
"<property name=\"width_request\">212</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Higher values correspond to better SNR and better preservation of higher frequencies(\"brightness\"), at the cost of increased computational complexity and a negligible(&lt;0.5ms) increase in latency.</property>\n"
"<property name=\"adjustment\">adjnes1</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox46\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label52\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Output rate tolerance:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-nes.sound_rate_error\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Lower values correspond to better matching of the output rate of the resampler to the actual desired output rate, at the expense of increased RAM usage and poorer CPU cache utilization. \n"
"\n"
"DO NOT INCREASE THIS VALUE, OR SOUND WILL LIKELY BE OFF-KEY AND THE WRONG TEMPO, AMONG OTHER PROBLEMS.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjnes2</property>\n"
"<property name=\"digits\">6</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label61\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label46\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to Game Genie ROM image:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox40\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-nes.ggrom\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button8\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-nes.ggrom\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label62\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Bios&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-ngp\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Language games should display text in:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-ngp.language\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">ngpstore</property>\n"
"<property name=\"active\">1</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb1\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame27\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment28\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-ngp.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label45\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpce2\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">235</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-pce\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">9</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox3\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.arcadecard\">\n"
"<property name=\"label\" translatable=\"yes\">Enable Arcade Card emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Leaving this option enabled is recommended, unless you want to see special warning screens on ACD games, or you prefer the non-enhanced modes of ACD-enhanced SCD games. \n"
"\n"
"Additionally, you may want to disable it you you wish to use state rewinding with a SCD ACD-enhanced game on a slow CPU, as the extra 2MiB of RAM the Arcade Card offers is difficult to compress in real-time.</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.forcesgx\">\n"
"<property name=\"label\" translatable=\"yes\">Force SuperGrafx emulation</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Enabling this option is not necessary to run unrecognized PCE ROM images in SuperGrafx mode, and enabling it is discouraged; ROM images with a file extension of \".sgx\" will automatically enable SuperGrafx emulation.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.disable_bram_cd\">\n"
"<property name=\"label\" translatable=\"yes\">Disable BRAM(saved game memory) for CD games</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">It is intended for viewing CD games error screens that may be different from simple BRAM full and uninitialized BRAM error screens, though it can cause the game to crash outright.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.disable_bram_hucard\">\n"
"<property name=\"label\" translatable=\"yes\">Disable BRAM(saved game memory) for HuCard games</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">It is intended for changing the behavior (passwords vs save games) of some HuCard games.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">29</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label40\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Select PSG revision:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-pce.psgrevision\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"HES playback will always use the \"huc6280a\" revision if this setting is set to \"match\", since HES playback is always done with SuperGrafx emulation enabled.\n"
"\n"
"huc6280 - HuC6280\n"
"HuC6280 as found in the original PC Engine.\n"
"\n"
"huc6280a - HuC6280A\n"
"HuC6280A as found in the SuperGrafx and CoreGrafx I. Provides proper channel amplitude centering, but may cause clicking in a few games designed with the original HuC6280's sound characteristics in mind.\n"
"\n"
"enhanced - Enhanced\n"
"Emulator-only pseudo-revision, designed to reduce clicking and audio artifacts in games designed for either real revision.\n"
"\n"
"match - Match emulation mode.\n"
"Selects \"huc6280\" for non-SuperGrafx mode, and \"huc6280a\" for SuperGrafx(full) mode.</property>\n"
"<property name=\"model\">pcestore</property>\n"
"<property name=\"active\">3</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb11\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">3</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.nospritelimit\">\n"
"<property name=\"label\" translatable=\"yes\">Remove 16-sprites-per-scanline hardware limit</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">WARNING: \n"
"Enabling this option may cause undesirable graphics glitching on some games(such as \"Bloody Wolf\").</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.h_overscan\">\n"
"<property name=\"label\" translatable=\"yes\">Show horizontal overscan area</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox59\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label67\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">First rendered scanline:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-pce.slstart\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpce1</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox60\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">13</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label70\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Last rendered scanline:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-pce.slend\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpce2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label75\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">4</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.adpcmextraprec\">\n"
"<property name=\"label\" translatable=\"yes\">Output the full 12-bit ADPCM predictor</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Enabling this option causes the MSM5205 ADPCM predictor to be outputted with full precision of 12-bits, rather than only outputting 10-bits of precision(as an actual MSM5205 does). Enable this option to reduce whining noise during ADPCM playback.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">3</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">8</property>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-pce.adpcmvolume\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjpce3</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-pce.cddavolume\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjpce</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-pce.cdpsgvolume\">\n"
"<property name=\"width_request\">300</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjpc2</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label36\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">ADPCM volume:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label42\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">CD-DA volume:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label76\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">PSG volume when playing a CD game:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label112\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Sound quality:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-pce.resamp_quality\">\n"
"<property name=\"width_request\">268</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Higher values correspond to better SNR and better preservation of higher frequencies(\"brightness\"), at the cost of increased computational complexity and a negligible increase in latency.</property>\n"
"<property name=\"adjustment\">adjpce_resamp_quality</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label113\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Output rate tolerance:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-pce.resamp_rate_error\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Lower values correspond to better matching of the output rate of the resampler to the actual desired output rate, at the expense of increased RAM usage and poorer CPU cache utilization.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpce_resamp_error</property>\n"
"<property name=\"digits\">7</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label79\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment25\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label83\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to the CD BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox76\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-pce.cdbios\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">8</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button13\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-pce.cdbios\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox34\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label84\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to the GE CD BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox78\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-pce.gecdbios\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">8</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button14\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label85\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Bios&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-psx\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-psx.region_autodetect\">\n"
"<property name=\"label\" translatable=\"yes\">Attempt to auto-detect region of game</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">1</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label24\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Default region to use:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-psx.region_default\">\n"
"<property name=\"width_request\">75</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Used if region autodetection fails or is disabled.\n"
"\n"
"jp - Japan\n"
"\n"
"na - North America\n"
"\n"
"eu - Europe</property>\n"
"<property name=\"model\">psxstore</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb5\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame54\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment56\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox29\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">4</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-psx.slstart\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpsx_slstart</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-psx.slend\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpsx_slend</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-psx.slstartp\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpsx_slstartp</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-psx.slendp\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpsx_slendp</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label114\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">First displayed scanline in NTSC mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label115\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Last displayed scanline in NTSC mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label116\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">First displayed scanline in PAL mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label117\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Last displayed scanline in PAL mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label118\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment34\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-psx.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label37\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">SPU output resampler quality:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-psx.spu.resamp_quality\">\n"
"<property name=\"width_request\">275</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">0 is lowest quality and CPU usage, 10 is highest quality and CPU usage. \n"
"\n"
"The resampler that this setting refers to is used for converting from 44.1KHz to the sampling rate of the host audio device Mednafen is using. \n"
"\n"
"Changing Mednafen's output rate, via the \"sound.rate\" setting, to \"44100\" will bypass the resampler, which will decrease CPU usage by Mednafen, and can increase or decrease audio quality, depending on various operating system and hardware factors.</property>\n"
"<property name=\"adjustment\">adjpsx</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label74\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame34\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment35\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox30\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label86\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to the Europe SCPH-5502 ROM BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox65\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-psx.bios_eu\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button10\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-psx.bios_eu\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox31\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label87\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to the Japan SCPH-5500 ROM BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox68\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-psx.bios_jp\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button11\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-psx.bios_jp\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label90\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to the North America SCPH-5501 ROM BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox70\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-psx.bios_na\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button12\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-psx.bios_na\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label91\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Bios&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-sms\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox7\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox17\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label23\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">System territory/region:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-sms.territory\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">domestic - Domestic (Japanese)\n"
"\n"
"export - Export (World)</property>\n"
"<property name=\"model\">smstore</property>\n"
"<property name=\"active\">1</property>\n"
"<signal name=\"changed\" handler=\"cbvideodrv_changed_cb\" object=\"-sms.fm\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb4\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-sms.fm\">\n"
"<property name=\"label\" translatable=\"yes\">Enable FM sound emulation when playing domestic/Japan-region games</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-sms.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label35\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-snes\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment12\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-snes.correct_aspect\">\n"
"<property name=\"label\" translatable=\"yes\">Correct the aspect ratio</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Note that regardless of this setting's value, \"512\" and \"256\" width modes will be scaled to the same dimensions for display.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label18\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0.47999998927116394</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame35\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment36\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-snes.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0.47999998927116394</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-vb\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame36\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment37\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox49\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">48</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label55\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">CPU emulation mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-vb.cpu_emulation\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">fast - Fast Mode\n"
"Fast mode trades timing accuracy, cache emulation, and executing from hardware registers and RAM not intended for code use for performance.\n"
"\n"
"accurate - Accurate Mode\n"
"Increased timing accuracy, though not perfect, along with cache emulation, at the cost of decreased performance. \n"
"Additionally, even the pipeline isn't correctly and fully emulated in this mode.</property>\n"
"<property name=\"model\">vbstore3</property>\n"
"<property name=\"active\">0</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb14\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label82\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0.47999998927116394</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment13\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox28\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-vb.3dreverse\">\n"
"<property name=\"label\" translatable=\"yes\">Reverse left/right 3D views</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-vb.instant_display_hack\">\n"
"<property name=\"label\" translatable=\"yes\">Display latency reduction hack</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Reduces latency in games by displaying the framebuffer 20ms earlier. \n"
"This hack has some potential of causing graphical glitches, so it is disabled by default.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-vb.allow_draw_skip\">\n"
"<property name=\"label\" translatable=\"yes\">Allow draw skipping</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">If \"Display latency reduction hack\" is enabled, and this setting is enabled, then frame-skipping the drawing to the emulated framebuffer will be allowed. \n"
"\n"
"THIS WILL CAUSE GRAPHICAL GLITCHES, AND THEORETICALLY(but unlikely) GAME CRASHES, ESPECIALLY WITH DIRECT FRAMEBUFFER DRAWING GAMES.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-vb.disable_parallax\">\n"
"<property name=\"label\" translatable=\"yes\">Disable parallax for BG and OBJ rendering</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox51\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">6</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label57\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Number of pixels to separate L/R views by:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-vb.sidebyside.separation\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">This setting refers to pixels before \"Scaling factor (fullscreen)\" is taken into consideration. \n"
"For example, a value of \"100\" here will result in a separation of 300 screen pixels if \"Scaling factor (fullscreen)\" is set to \"3\".</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjvb2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox50\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label56\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Line Interlaced prescale:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-vb.liprescale\">\n"
"<property name=\"width_request\">170</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"adjustment\">adjvb1</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox47\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">128</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label53\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">3D mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-vb.3dmode\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">anaglyph - Anaglyph\n"
"Used in conjunction with classic dual-lens-color glasses.\n"
"\n"
"cscope - CyberScope\n"
"Intended for use with the CyberScope 3D device.\n"
"\n"
"sidebyside - Side-by-Side\n"
"The left-eye image is displayed on the left, and the right-eye image is displayed on the right.\n"
"\n"
"vli - Vertical Line Interlaced\n"
"Vertical lines alternate between left view and right view.\n"
"\n"
"hli - Horizontal Line Interlaced\n"
"Horizontal lines alternate between left view and right view.</property>\n"
"<property name=\"model\">vbstore1</property>\n"
"<property name=\"active\">0</property>\n"
"<signal name=\"changed\" handler=\"on_vbmode2_changed\" object=\"nonanabox\" swapped=\"no\"/>\n"
"<signal name=\"changed\" handler=\"cbvideodrv_changed_cb\" object=\"colorbox\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb12\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0.47999998927116394</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame38\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment39\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-vb.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0.47999998927116394</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame39\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment40\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox11\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"colorbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"anapresetbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">36</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label54\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Anaglyph preset colors:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-vb.anaglyph.preset\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">vbstore2</property>\n"
"<property name=\"active\">1</property>\n"
"<signal name=\"changed\" handler=\"cbvideodrv_changed_cb\" object=\"anacolorbox\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb13\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"anacolorbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label58\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Anaglyph maximum-brightness color for...</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox4\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">24</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label26\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">left view:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-vb.anaglyph.lcolor\">\n"
"<property name=\"width_request\">100</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<signal name=\"changed\" handler=\"on_entry_color_changed\" object=\"cbvbdefault1\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkColorButton\" id=\"cbvbdefault1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<signal name=\"color-set\" handler=\"on_cbvbdefault_color_set\" object=\"-vb.anaglyph.lcolor\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox8\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label28\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">right view:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-vb.anaglyph.rcolor\">\n"
"<property name=\"width_request\">100</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<signal name=\"changed\" handler=\"on_entry_color_changed\" object=\"cbvbdefault2\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkColorButton\" id=\"cbvbdefault2\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<signal name=\"color-set\" handler=\"on_cbvbdefault_color_set\" object=\"-vb.anaglyph.rcolor\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"nonanabox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"sensitive\">False</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label59\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Default maximum-brightness color to use in non-anaglyph 3D modes:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment44\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">150</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox52\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-vb.default_color\">\n"
"<property name=\"width_request\">100</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<signal name=\"changed\" handler=\"on_entry_color_changed\" object=\"cbvbdefault\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkColorButton\" id=\"cbvbdefault\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<signal name=\"color-set\" handler=\"on_cbvbdefault_color_set\" object=\"-vb.default_color\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label16\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0.47999998927116394</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Colors&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-wswan\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment14\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox21\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label27\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Language games should display text in:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-wswan.language\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">wsstore1</property>\n"
"<property name=\"active\">1</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb6\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame42\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment43\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-wswan.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label25\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame41\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment42\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkTable\" id=\"table1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"n_rows\">6</property>\n"
"<property name=\"n_columns\">2</property>\n"
"<property name=\"column_spacing\">16</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-wswan.name\">\n"
"<property name=\"width_request\">100</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-wswan.bday\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjws1</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-wswan.bmonth\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjws2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-wswan.byear\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjws3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-wswan.sex\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">wsstore2</property>\n"
"<property name=\"active\">1</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb19\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">4</property>\n"
"<property name=\"bottom_attach\">5</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-wswan.blood\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"model\">wsstore3</property>\n"
"<property name=\"active\">2</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb20\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"left_attach\">1</property>\n"
"<property name=\"right_attach\">2</property>\n"
"<property name=\"top_attach\">5</property>\n"
"<property name=\"bottom_attach\">6</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label96\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Name:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label97\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Birth Day:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">1</property>\n"
"<property name=\"bottom_attach\">2</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label98\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Birth Month:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">2</property>\n"
"<property name=\"bottom_attach\">3</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label99\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Birth Year:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">3</property>\n"
"<property name=\"bottom_attach\">4</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label100\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Sex:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">4</property>\n"
"<property name=\"bottom_attach\">5</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label101\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">1</property>\n"
"<property name=\"label\" translatable=\"yes\">Blood Type:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"top_attach\">5</property>\n"
"<property name=\"bottom_attach\">6</property>\n"
"<property name=\"x_options\">GTK_FILL</property>\n"
"<property name=\"y_options\">GTK_FILL</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label102\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Data&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnes1\">\n"
"<property name=\"lower\">-2</property>\n"
"<property name=\"upper\">3</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnes2\">\n"
"<property name=\"lower\">9.9999999999999995e-07</property>\n"
"<property name=\"upper\">0.01</property>\n"
"<property name=\"value\">4.0000000000000003e-05</property>\n"
"<property name=\"step_increment\">9.9999999999999995e-07</property>\n"
"<property name=\"page_increment\">1.0000000000000001e-05</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnes3\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">8</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnes4\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">231</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnes5\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjnes6\">\n"
"<property name=\"upper\">287</property>\n"
"<property name=\"value\">287</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpc2\">\n"
"<property name=\"upper\">200</property>\n"
"<property name=\"value\">100</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpce\">\n"
"<property name=\"upper\">200</property>\n"
"<property name=\"value\">100</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpce1\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">4</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpce3\">\n"
"<property name=\"upper\">200</property>\n"
"<property name=\"value\">100</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpce_resamp_error\">\n"
"<property name=\"lower\">9.9999999999999995e-08</property>\n"
"<property name=\"upper\">3.4999999999999997e-05</property>\n"
"<property name=\"value\">8.9999999999999996e-07</property>\n"
"<property name=\"step_increment\">9.9999999999999995e-08</property>\n"
"<property name=\"page_increment\">9.9999999999999995e-07</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpce_resamp_quality\">\n"
"<property name=\"upper\">5</property>\n"
"<property name=\"value\">3</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpcfx1\">\n"
"<property name=\"lower\">2</property>\n"
"<property name=\"upper\">10</property>\n"
"<property name=\"value\">2</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpcfx2\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">4</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpcfx3\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">235</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpcfx_resamp_error\">\n"
"<property name=\"lower\">9.9999999999999995e-08</property>\n"
"<property name=\"upper\">3.4999999999999997e-05</property>\n"
"<property name=\"value\">8.9999999999999996e-07</property>\n"
"<property name=\"step_increment\">9.9999999999999995e-08</property>\n"
"<property name=\"page_increment\">9.9999999999999995e-07</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpcfx_resamp_quality\">\n"
"<property name=\"upper\">5</property>\n"
"<property name=\"value\">3</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"-pcfx\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">8</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment6\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox5\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox30\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">18</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label38\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">CPU emulation mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-pcfx.cpu_emulation\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">fast - Fast Mode\n"
"Fast mode trades timing accuracy, cache emulation, and executing from hardware registers and RAM not intended for code use for performance.\n"
"\n"
"accurate - Accurate Mode\n"
"Increased timing accuracy, though not perfect, along with cache emulation, at the cost of decreased performance. Additionally, even the pipeline isn't correctly and fully emulated in this mode.\n"
"\n"
"auto - Auto Mode\n"
"Selects \"fast\" or \"accurate\" automatically based on an internal database. If the CD image is not recognized, defaults to \"fast\".</property>\n"
"<property name=\"model\">pcfxstore1</property>\n"
"<property name=\"active\">2</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb9\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox27\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Emulated CD-ROM speed:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-pcfx.cdspeed\">\n"
"<property name=\"width_request\">268</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Setting the value higher than 2, the default, will decrease loading times in most games by some degree.</property>\n"
"<property name=\"adjustment\">adjpcfx1</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.disable_bram\">\n"
"<property name=\"label\" translatable=\"yes\">Disable internal and external BRAM</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">It is intended for viewing games error screens that may be different from simple BRAM full and uninitialized BRAM error screens, though it can cause the game to crash outright.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Emulation&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame28\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment29\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox19\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.nospritelimit\">\n"
"<property name=\"label\" translatable=\"yes\">Remove 16-sprites-per-scanline hardware limit</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.rainbow.chromaip\">\n"
"<property name=\"label\" translatable=\"yes\">Enable bilinear interpolation on the chroma channel of RAINBOW YUV output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">This is an enhancement-related setting.\n"
"Enabling it may cause graphical glitches with some games.</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox36\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label72\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Emulated width for 7.16MHz dot-clock mode:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkComboBox\" id=\"-pcfx.high_dotclock_width\">\n"
"<property name=\"width_request\">150</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Lower values are faster, but will cause some degree of pixel distortion.\n"
"\n"
"256 - 256 pixels\n"
"This value will cause heavy pixel distortion.\n"
"\n"
"341 - 341 pixels\n"
"This value will cause moderate pixel distortion.\n"
"\n"
"1024 - 1024 pixels\n"
"This value will cause no pixel distortion as long as interpolation is enabled on the video output device and the resolution is sufficiently high, but it will use a lot of CPU time.</property>\n"
"<property name=\"model\">pcfxstore2</property>\n"
"<property name=\"active\">2</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertextgb16\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox33\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label66\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">First rendered scanline:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-pcfx.slstart\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpcfx2</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox35\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label71\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Last rendered scanline:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-pcfx.slend\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpcfx3</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label77\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Video&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame29\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment30\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox20\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.adpcm.emulate_buggy_codec\">\n"
"<property name=\"label\" translatable=\"yes\">Hack that emulates the codec a buggy ADPCM encoder used for some games</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.adpcm.suppress_channel_reset_clicks\">\n"
"<property name=\"label\" translatable=\"yes\">Hack to suppress clicks caused by forced channel resets</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.forcemono\">\n"
"<property name=\"label\" translatable=\"yes\">Force monophonic sound output</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox9\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label39\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Sound quality:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHScale\" id=\"-pcfx.resamp_quality\">\n"
"<property name=\"width_request\">268</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Higher values correspond to better SNR and better preservation of higher frequencies(\"brightness\"), at the cost of increased computational complexity and a negligible increase in latency.</property>\n"
"<property name=\"adjustment\">adjpcfx_resamp_quality</property>\n"
"<property name=\"round_digits\">0</property>\n"
"<property name=\"digits\">0</property>\n"
"<property name=\"value_pos\">left</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox10\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">12</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label111\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Output rate tolerance:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkSpinButton\" id=\"-pcfx.resamp_rate_error\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Lower values correspond to better matching of the output rate of the resampler to the actual desired output rate, at the expense of increased RAM usage and poorer CPU cache utilization.</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"<property name=\"adjustment\">adjpcfx_resamp_error</property>\n"
"<property name=\"digits\">7</property>\n"
"<property name=\"numeric\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label81\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Sound&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame31\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment32\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">12</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox22\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label80\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"xalign\">0</property>\n"
"<property name=\"label\" translatable=\"yes\">Path to the ROM BIOS:</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkHBox\" id=\"hbox62\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkEntry\" id=\"-pcfx.bios\">\n"
"<property name=\"width_request\">400</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"editable\">False</property>\n"
"<property name=\"invisible_char\">•</property>\n"
"<property name=\"invisible_char_set\">True</property>\n"
"<property name=\"primary_icon_activatable\">False</property>\n"
"<property name=\"secondary_icon_activatable\">False</property>\n"
"<property name=\"primary_icon_sensitive\">True</property>\n"
"<property name=\"secondary_icon_sensitive\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">12</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button2\">\n"
"<property name=\"label\">gtk-open</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"on_button_entry_clicked\" object=\"-pcfx.bios\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label89\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">&lt;b&gt;Bios&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpsx\">\n"
"<property name=\"upper\">10</property>\n"
"<property name=\"value\">5</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpsx_slend\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"value\">239</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpsx_slendp\">\n"
"<property name=\"upper\">287</property>\n"
"<property name=\"value\">287</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpsx_slstart\">\n"
"<property name=\"upper\">239</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjpsx_slstartp\">\n"
"<property name=\"upper\">287</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjvb1\">\n"
"<property name=\"lower\">1</property>\n"
"<property name=\"upper\">10</property>\n"
"<property name=\"value\">2</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjvb2\">\n"
"<property name=\"upper\">1024</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjws1\">\n"
"<property name=\"lower\">1</property>\n"
"<property name=\"upper\">31</property>\n"
"<property name=\"value\">23</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjws2\">\n"
"<property name=\"lower\">1</property>\n"
"<property name=\"upper\">12</property>\n"
"<property name=\"value\">6</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">1</property>\n"
"</object>\n"
"<object class=\"GtkAdjustment\" id=\"adjws3\">\n"
"<property name=\"upper\">9999</property>\n"
"<property name=\"value\">1989</property>\n"
"<property name=\"step_increment\">1</property>\n"
"<property name=\"page_increment\">10</property>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"gb\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"gba\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Shoulder Left</col>\n"
"<col id=\"1\">gamepad.shoulder_l</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Shoulder Right</col>\n"
"<col id=\"1\">gamepad.shoulder_r</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"gbainputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"gbinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"gbstore\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">auto</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">dmg</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">cgb</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">agb</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"gg\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button 1</col>\n"
"<col id=\"1\">gamepad.button1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button 2</col>\n"
"<col id=\"1\">gamepad.button2</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"gginputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkDialog\" id=\"inputdialog\">\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"border_width\">5</property>\n"
"<property name=\"modal\">True</property>\n"
"<property name=\"window_position\">center-on-parent</property>\n"
"<property name=\"destroy_with_parent\">True</property>\n"
"<property name=\"type_hint\">dialog</property>\n"
"<signal name=\"delete-event\" handler=\"close_input\" swapped=\"no\"/>\n"
"<child internal-child=\"vbox\">\n"
"<object class=\"GtkVBox\" id=\"dialog-vbox1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"spacing\">2</property>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame52\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<property name=\"shadow_type\">none</property>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment54\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"top_padding\">6</property>\n"
"<child>\n"
"<object class=\"GtkLabel\" id=\"label109\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Double click on the key column item to configure an action.</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label\">\n"
"<object class=\"GtkLabel\" id=\"label108\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\">&lt;b&gt;Controller Setup&lt;/b&gt;</property>\n"
"<property name=\"use_markup\">True</property>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"padding\">6</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkAlignment\" id=\"alignment55\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"left_padding\">24</property>\n"
"<property name=\"right_padding\">24</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox40\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkNotebook\" id=\"notebook1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"show_border\">False</property>\n"
"<signal name=\"switch-page\" handler=\"switch_page\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox42\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label60\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 1</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox44\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label44\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 2</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">1</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox41\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox43\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label73\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 3</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">2</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox45\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label78\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 4</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">3</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox46\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">4</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label92\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 5</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">4</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox47\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">5</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label93\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 6</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">5</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox48\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">6</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label95\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 7</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">6</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkVBox\" id=\"vbox49\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">7</property>\n"
"</packing>\n"
"</child>\n"
"<child type=\"tab\">\n"
"<object class=\"GtkLabel\" id=\"label110\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label\" translatable=\"yes\">Port 8</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"position\">7</property>\n"
"<property name=\"tab_fill\">False</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkFrame\" id=\"frame53\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"label_xalign\">0</property>\n"
"<child>\n"
"<object class=\"GtkTreeView\" id=\"treeview_input\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<property name=\"headers_clickable\">False</property>\n"
"<property name=\"enable_search\">False</property>\n"
"<property name=\"search_column\">0</property>\n"
"<signal name=\"button-press-event\" handler=\"on_treeview_input_button_press_event\" swapped=\"no\"/>\n"
"<child>\n"
"<object class=\"GtkTreeViewColumn\" id=\"treeviewcolumn4\">\n"
"<property name=\"resizable\">True</property>\n"
"<property name=\"min_width\">192</property>\n"
"<property name=\"title\" translatable=\"yes\">Action/Button</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellrenderertext10\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">0</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkTreeViewColumn\" id=\"treeviewcolumn5\">\n"
"<property name=\"resizable\">True</property>\n"
"<property name=\"min_width\">128</property>\n"
"<property name=\"title\" translatable=\"yes\">Key</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"cellkey\">\n"
"<signal name=\"editing-started\" handler=\"key_setting\" swapped=\"no\"/>\n"
"</object>\n"
"<attributes>\n"
"<attribute name=\"text\">2</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child>\n"
"<object class=\"GtkTreeViewColumn\" id=\"treeviewcolumn1\">\n"
"<property name=\"resizable\">True</property>\n"
"<property name=\"min_width\">256</property>\n"
"<property name=\"title\" translatable=\"yes\">Device</property>\n"
"<child>\n"
"<object class=\"GtkCellRendererText\" id=\"celldevice\"/>\n"
"<attributes>\n"
"<attribute name=\"text\">3</attribute>\n"
"</attributes>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<child type=\"label_item\">\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">1</property>\n"
"</packing>\n"
"</child>\n"
"<child internal-child=\"action_area\">\n"
"<object class=\"GtkHButtonBox\" id=\"dialog-action_area1\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkButton\" id=\"button4\">\n"
"<property name=\"label\">gtk-close</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">True</property>\n"
"<property name=\"use_stock\">True</property>\n"
"<signal name=\"clicked\" handler=\"cancel_input\" swapped=\"no\"/>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">False</property>\n"
"<property name=\"fill\">False</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">2</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</child>\n"
"<action-widgets>\n"
"<action-widget response=\"0\">button4</action-widget>\n"
"</action-widgets>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"lynx\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Pause</col>\n"
"<col id=\"1\">gamepad.pause</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Option 1</col>\n"
"<col id=\"1\">gamepad.option_1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Option 2</col>\n"
"<col id=\"1\">gamepad.option_2</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"lynxinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-lynx.rotateinput\">\n"
"<property name=\"label\" translatable=\"yes\">Virtually rotate D-pad along with screen</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"md\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button C</col>\n"
"<col id=\"1\">gamepad.c</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"mdinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"mdstore1\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">game</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">overseas_ntsc</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">overseas_pal</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">domestic_ntsc</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">domestic_pal</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"mdstore2\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">same</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">game</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">overseas_ntsc</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">overseas_pal</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">domestic_ntsc</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">domestic_pal</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"nes\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"nesinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"ngp\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Option</col>\n"
"<col id=\"1\">gamepad.option</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"ngpinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"ngpstore\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">japanese</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">english</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"pce\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button I</col>\n"
"<col id=\"1\">gamepad.i</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button II</col>\n"
"<col id=\"1\">gamepad.ii</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Run</col>\n"
"<col id=\"1\">gamepad.run</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"pceinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pce.disable_softreset\">\n"
"<property name=\"label\" translatable=\"yes\">When RUN+SEL are pressed simultaneously, disable both buttons temporarily</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"pcestore\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">huc6280</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">huc6280a</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">enhanced</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">match</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"pcfx\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button I</col>\n"
"<col id=\"1\">gamepad.i</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button II</col>\n"
"<col id=\"1\">gamepad.ii</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button III</col>\n"
"<col id=\"1\">gamepad.iii</col>\n"
"<col id=\"2\" translatable=\"yes\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button IV</col>\n"
"<col id=\"1\">gamepad.iv</col>\n"
"<col id=\"2\" translatable=\"yes\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button V</col>\n"
"<col id=\"1\">gamepad.v</col>\n"
"<col id=\"2\" translatable=\"yes\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button VI</col>\n"
"<col id=\"1\">gamepad.vi</col>\n"
"<col id=\"2\" translatable=\"yes\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Run</col>\n"
"<col id=\"1\">gamepad.run</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Mode 1</col>\n"
"<col id=\"1\">gamepad.mode1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Mode 2</col>\n"
"<col id=\"1\">gamepad.mode2</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"pcfxinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-pcfx.disable_softreset\">\n"
"<property name=\"label\" translatable=\"yes\">When RUN+SEL are pressed simultaneously, disable both buttons temporarily</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"pcfxstore1\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">fast</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">accurate</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">auto</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"pcfxstore2\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">256</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">341</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">1024</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"psx\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Triangle</col>\n"
"<col id=\"1\">gamepad.triangle</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Cross</col>\n"
"<col id=\"1\">gamepad.cross</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Square</col>\n"
"<col id=\"1\">gamepad.square</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Circle</col>\n"
"<col id=\"1\">gamepad.circle</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">L1</col>\n"
"<col id=\"1\">gamepad.l1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">L2</col>\n"
"<col id=\"1\">gamepad.l2</col>\n"
"<col id=\"2\" translatable=\"yes\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">R1</col>\n"
"<col id=\"1\">gamepad.r1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">R2</col>\n"
"<col id=\"1\">gamepad.r2</col>\n"
"<col id=\"2\" translatable=\"yes\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"psxinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"psxstore\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">jp</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">na</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">eu</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"sms\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Fire 1 / Start</col>\n"
"<col id=\"1\">gamepad.fire1</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Fire 2</col>\n"
"<col id=\"1\">gamepad.fire2</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Pause</col>\n"
"<col id=\"1\">gamepad.pause</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"smsinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"smstore\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">domestic</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">export</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"snes\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up</col>\n"
"<col id=\"1\">gamepad.up</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down</col>\n"
"<col id=\"1\">gamepad.down</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left</col>\n"
"<col id=\"1\">gamepad.left</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right</col>\n"
"<col id=\"1\">gamepad.right</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button X</col>\n"
"<col id=\"1\">gamepad.x</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button Y</col>\n"
"<col id=\"1\">gamepad.y</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Shoulder Left</col>\n"
"<col id=\"1\">gamepad.l</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Shoulder Right</col>\n"
"<col id=\"1\">gamepad.r</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"snesinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<placeholder/>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"vb\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up (Left D-Pad)</col>\n"
"<col id=\"1\">gamepad.up-l</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down (Left D-Pad)</col>\n"
"<col id=\"1\">gamepad.down-l</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left (Left D-Pad)</col>\n"
"<col id=\"1\">gamepad.left-l</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right (Left D-Pad)</col>\n"
"<col id=\"1\">gamepad.right-l</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up (Right D-Pad)</col>\n"
"<col id=\"1\">gamepad.up-r</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down (Right D-Pad)</col>\n"
"<col id=\"1\">gamepad.down-r</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left (Right D-Pad)</col>\n"
"<col id=\"1\">gamepad.left-r</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right (Right D-Pad)</col>\n"
"<col id=\"1\">gamepad.right-r</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Select</col>\n"
"<col id=\"1\">gamepad.select</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left-Back</col>\n"
"<col id=\"1\">gamepad.lt</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right-Back</col>\n"
"<col id=\"1\">gamepad.rt</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"vbinputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-vb.input.instant_read_hack\">\n"
"<property name=\"label\" translatable=\"yes\">Input latency reduction hack</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"has_tooltip\">True</property>\n"
"<property name=\"tooltip_text\" translatable=\"yes\">Reduces latency in some games by 20ms by returning the current pad state, rather than latched state, on serial port data reads. \n"
"This hack may cause some homebrew software to malfunction, but it should be relatively safe for commercial official games.</property>\n"
"<property name=\"active\">True</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"vbstore1\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">anaglyph</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">cscope</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">sidebyside</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">vli</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">hli</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"vbstore2\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">disabled</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">red_blue</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">red_cyan</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">red_electriccyan</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">red_green</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">green_magenta</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">yellow_blue</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"vbstore3\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">fast</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">accurate</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"wsstore1\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">japanese</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">english</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"wsstore2\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">M</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">F</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"wsstore3\">\n"
"<columns>\n"
"<!-- column-name gchararray1 -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\">A</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">B</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">O</col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\">AB</col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkListStore\" id=\"wswan\">\n"
"<columns>\n"
"<!-- column-name key_label -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key_command -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name key -->\n"
"<column type=\"gchararray\"/>\n"
"<!-- column-name device -->\n"
"<column type=\"gchararray\"/>\n"
"</columns>\n"
"<data>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up (X Cursors)</col>\n"
"<col id=\"1\">gamepad.up-x</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down (X Cursors)</col>\n"
"<col id=\"1\">gamepad.down-x</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left (X Cursors)</col>\n"
"<col id=\"1\">gamepad.left-x</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right (X Cursors)</col>\n"
"<col id=\"1\">gamepad.right-x</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Up (Y Cursors)</col>\n"
"<col id=\"1\">gamepad.up-y</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Down (Y Cursors)</col>\n"
"<col id=\"1\">gamepad.down-y</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Left (Y Cursors)</col>\n"
"<col id=\"1\">gamepad.left-y</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Right (Y Cursors)</col>\n"
"<col id=\"1\">gamepad.right-y</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button A</col>\n"
"<col id=\"1\">gamepad.a</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Button B</col>\n"
"<col id=\"1\">gamepad.b</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"<row>\n"
"<col id=\"0\" translatable=\"yes\">Start</col>\n"
"<col id=\"1\">gamepad.start</col>\n"
"<col id=\"2\"> </col>\n"
"<col id=\"3\" translatable=\"yes\"> </col>\n"
"</row>\n"
"</data>\n"
"</object>\n"
"<object class=\"GtkVBox\" id=\"wswaninputbox\">\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">False</property>\n"
"<child>\n"
"<object class=\"GtkCheckButton\" id=\"-wswan.rotateinput\">\n"
"<property name=\"label\" translatable=\"yes\">Virtually rotate D-pads along with screen</property>\n"
"<property name=\"visible\">True</property>\n"
"<property name=\"can_focus\">True</property>\n"
"<property name=\"receives_default\">False</property>\n"
"<property name=\"draw_indicator\">True</property>\n"
"</object>\n"
"<packing>\n"
"<property name=\"expand\">True</property>\n"
"<property name=\"fill\">True</property>\n"
"<property name=\"position\">0</property>\n"
"</packing>\n"
"</child>\n"
"</object>\n"
"</interface>\n"
;

#endif /* SYSTEM_GLADE_H */
