import os, sys
from distutils.core import setup, Extension

#module = Extension('pyqt_memaid.ann._memaid_core',
module = Extension('pyqt_memaid.ann._memaid_core',
                    sources = ['pyqt_memaid/ann/memaid.c',
                               'pyqt_memaid/ann/ann.c',
                               'pyqt_memaid/ann/memaid_core_wrap.c'])

pixmap_path = os.path.join(sys.exec_prefix, "lib", "python"+sys.version[:3],
                           "site-packages","pyqt_memaid", "pixmaps")

util_path = os.path.join(sys.exec_prefix, "lib", "python"+sys.version[:3],
                         "site-packages","pyqt_memaid", "util")

doc_path = os.path.join(sys.exec_prefix, "lib", "python"+sys.version[:3],
                        "site-packages","pyqt_memaid", "docs")

setup (name = "pyqt_memaid",
       author="Peter Bienstman",
       author_email="Peter.Bienstman@UGent.be",
       ext_modules = [module],
       packages = ["pyqt_memaid", "pyqt_memaid.ann"],
       data_files = [(pixmap_path,
                      ["pyqt_memaid/pixmaps/edit.png",
                       "pyqt_memaid/pixmaps/editclear.png",
                       "pyqt_memaid/pixmaps/fileopen.png",
                       "pyqt_memaid/pixmaps/exit.png",
                       "pyqt_memaid/pixmaps/filesave.png",
                       "pyqt_memaid/pixmaps/contents.png",
                       "pyqt_memaid/pixmaps/fileexport.png",
                       "pyqt_memaid/pixmaps/filesaveas.png",
                       "pyqt_memaid/pixmaps/edit.png",
                       "pyqt_memaid/pixmaps/fileimport.png",
                       "pyqt_memaid/pixmaps/edit_add.png",
                       "pyqt_memaid/pixmaps/filenew.png",
                       "pyqt_memaid/pixmaps/configure.png"]),
                     (util_path, ["util/convert.py"]),
                     (doc_path, ["pyqt_memaid/docs/pyqt_memaid.html"])],
       scripts = ['pyqt_memaid/pyqt_memaid'],
       )
