##############################################################################
#
# Widget to edit single item <Peter.Bienstman@ugent.be>
#
##############################################################################

from qt import *
from memaid_core import *
from edit_item_frm import *
from font_util import *

    
##############################################################################
#
# EditItemDlg
#
##############################################################################

class EditItemDlg(EditItemFrm):

    ##########################################################################
    #
    # __init__
    #
    ##########################################################################
    
    def __init__(self, item, parent=None, name=None, modal=0, fl=0):
        
        EditItemFrm.__init__(self,parent,name,modal,fl)

        self.item = item

        self.categories.insertItem(self.item.cat.name)
        for cat in get_categories():
            if cat.name != self.item.cat.name:
                self.categories.insertItem(cat.name)

        self.question.setText(self.item.q)
        self.answer.setText(self.item.a)
        
        self.connect(self.ok_button, SIGNAL("clicked()"), self.apply)

        self.question.setFocus()

        if get_config("font") != None:
            font = listToFont(get_config("font"))
            self.question.setFont(font)
            self.answer.setFont(font)
            self.categories.setFont(font)
            
        self.question.setTabChangesFocus(1)
        self.answer.setTabChangesFocus(1)

        

    ##########################################################################
    #
    # apply
    #
    ##########################################################################
    
    def apply(self):

        new_cat_name = unicode(self.categories.currentText())

        if new_cat_name != self.item.cat.name:
            self.item.change_category(new_cat_name)   
        
        self.item.q  = unicode(self.question.text())
        self.item.a  = unicode(self.answer.text())

        self.accept()
