// Copyright (c) 2009, Jens Peter Secher <jpsecher@gmail.com>
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

class RegExpUtil
{	
	//
	// Create an escaped string that can be used in regular-expression
	// construction so that it matches the literal string.  The place argument
	// decides whether an initial ^ and a final $ should be escaped.
	//
	public static function escape( literal : String, ?place : RegExpPlace )
	: String
	{
		if( place == null ) place = RegExpPlace.Middle;
		var escaped = new StringBuf();
		for( i in 0...literal.length )
		{
			var backslash = false;
			switch( literal.charAt( i ) )
			{
				case ".", "*", "+", "?", "[", "]", "(", ")", "\\":
					backslash = true;
				case "^":
					if
					(
						i == 0 &&
						(
							place == RegExpPlace.Initial ||
							place == RegExpPlace.Whole
						)
					)
					{
						backslash = true;
					}
				case "$":
					if
					(
						i == literal.length-1 &&
						(
							place == RegExpPlace.Final ||
							place == RegExpPlace.Whole
						)
					)
					{
						backslash = true;
					}
			}
			if( backslash ) escaped.add( "\\" );
			escaped.addSub( literal, i, 1 );
		}
		return escaped.toString();
	}
}


