/****************************************************************************
* MeshLab                                                           o o     *
* A versatile mesh processing toolbox                             o     o   *
*                                                                _   O  _   *
* Copyright(C) 2005                                                \/)\/    *
* Visual Computing Lab                                            /\/|      *
* ISTI - Italian National Research Council                           |      *
*                                                                    \      *
* All rights reserved.                                                      *
*                                                                           *
* This program is free software; you can redistribute it and/or modify      *   
* it under the terms of the GNU General Public License as published by      *
* the Free Software Foundation; either version 2 of the License, or         *
* (at your option) any later version.                                       *
*                                                                           *
* This program is distributed in the hope that it will be useful,           *
* but WITHOUT ANY WARRANTY; without even the implied warranty of            *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
* GNU General Public License (http://www.gnu.org/licenses/gpl.txt)          *
* for more details.                                                         *
*                                                                           *
****************************************************************************/

#ifndef FILTER_MEASURE_H
#define FILTER_MEASURE_H

#include <QObject>

#include <common/interfaces.h>

class FilterMeasurePlugin : public QObject, public MeshFilterInterface
{
	Q_OBJECT
	Q_INTERFACES(MeshFilterInterface)

public:
	enum { 
	FP_MEASURE_GEOM, 
	FP_MEASURE_TOPO,
	FP_MEASURE_TOPO_QUAD,
	FP_MEASURE_GAUSSCURV,
  FP_MEASURE_VERTEX_QUALITY_DISTRIBUTION,
  FP_MEASURE_VERTEX_QUALITY_HISTOGRAM,
  FP_MEASURE_FACE_QUALITY_DISTRIBUTION,
  FP_MEASURE_FACE_QUALITY_HISTOGRAM
  };

	FilterMeasurePlugin();
	
	virtual QString filterName(FilterIDType filter) const;
	virtual QString filterInfo(FilterIDType filter) const;
	virtual FilterClass getClass(QAction *);
	virtual void initParameterSet(QAction *,MeshDocument &/*m*/, RichParameterSet & /*parent*/);
	virtual bool applyFilter(QAction *filter, MeshDocument &m, RichParameterSet & /*parent*/, vcg::CallBackPos * cb) ;
	virtual QTreeWidgetItem *tagDump(TagBase * /*tag*/, MeshDocument &/*md*/, MeshModel *mm=0);
};

class MeasureTopoTag: public TagBase
{

public:
	int edges;
	int boundaryEdges;
	int connectComp;
	bool manifoldness;
	int genus;
	int holes;
	int edgeManifNum;
	int vertManifNum;
	int faceEdgeManif;
	int faceVertManif;

	MeasureTopoTag(MeshDocument &parent, MeshModel *mm, QString name);
};

#endif
