/*
mime.h - MessageWall MIME handling declarations
Copyright (C) 2002 Ian Gulliver

This program is free software; you can redistribute it and/or modify
it under the terms of version 2 of the GNU General Public License as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef _MIME_H
#define _MIME_H

#include "messagewall.h"
#include "rfc822.h"

struct mime_part_t {
	struct firestring_estr_t content_type;
	struct firestring_estr_t content_transfer_encoding;
	struct firestring_estr_t boundary;
	struct firestring_estr_t filename;
	struct rfc822_message_t message;
	int multipart;
	int attachment;
	int parent;
	int depth;
	int visible;
};

void mime_startup();

int mime_parse(int client, int depth, int *part, int parent, struct firestring_estr_t *message, struct messagewall_profile_t *profile);
int mime_base64(struct firestring_estr_t *chunk, struct firestring_estr_t *destination);
int mime_qp(struct firestring_estr_t *chunk);
int mime_build_message(int client, int backend, int *part);

int mime_checks(int client, int ourpart, struct firestring_estr_t *body);

#endif
