/***************************************************************************
 *   Copyright (C) 2005 by Florian Roth   *
 *   florian@synatic.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "metascrollview.h"

#include <kdebug.h>
#include <qsize.h>
#include <math.h>


 
MetaScrollView::MetaScrollView(MetabarWidget *metabar, QWidget *parent, const char *name) : QScrollView(parent, name)
{
  metabarWidget = metabar;
  
  setResizePolicy(QScrollView::AutoOneFit);
  setHScrollBarMode(QScrollView::AlwaysOff);
  
  addChild(metabarWidget);
}

MetaScrollView::~MetaScrollView()
{
}

void MetaScrollView::resizeEvent(QResizeEvent *e)
{
  metabarWidget->setFixedWidth(e->size().width());
  QScrollView::resizeEvent(e);
}

void MetaScrollView::viewportResizeEvent(QResizeEvent *e)
{
  metabarWidget->setFixedWidth(e->size().width());
  QScrollView::viewportResizeEvent(e);
}

