#!/usr/bin/perl -w
#
# makedoc.pl
# A script to construct the documentation for the theme packages
# This should be called *after* extracting the themes as it also moves any
# documentation from them.
#
# TODO: 
#  watch file
# 

use warnings;
use strict;
use debian::themedata; 
use FileHandle;

my $DOCDIR = "debian/metacity-themes/usr/share/doc/metacity-themes";
my $THEMEDIR = "debian/metacity-themes/usr/share/themes";


&makedirs();
&makeinstalleddoc();
&makerejectnotice();
&makecopyright();
&makesubstvars();
print "\nDone";

sub makedirs(){
	`mkdir debian/metacity-themes/usr`
		unless -e 'debian/metacity-themes/usr';
	`mkdir debian/metacity-themes/usr/share/`
		unless -e 'debian/metacity-themes/usr/share/';
	`mkdir debian/metacity-themes/usr/share/doc`
		unless -e 'debian/metacity-themes/usr/share/doc';
	`mkdir debian/metacity-themes/usr/share/doc/metacity-themes`
		unless -e 'debian/metacity-themes/usr/share/doc/metacity-themes';
}

sub makeinstalleddoc(){
	print "\nGenerating documentation for each theme...\n";
	# Creates documentation for the themes which were installed.
	foreach my $theme (@themedata::installed){
		unless (-e "$DOCDIR/$theme->{name}"){
			if (mkdir "$DOCDIR/$theme->{name}"){
				print "$theme->{name}: created doc directory, $DOCDIR/$theme->{name}.\n";
			}else{
				die "Error creating theme doc directory, $DOCDIR/$theme->{name}\: $!\n";
			}
		}
		open README, ">$DOCDIR/$theme->{name}/README.Debian"
			or die "Unable to open copyright file for writing, 
				>$DOCDIR/$theme->{name}/README.Debian\: $!";
		print README 'This theme is part of the metacity-themes package. If any '
				.'documentation was found with the upstream code, it will have been '
				."copied to this directory.\n\n"
				.'For instuctions on changing the current theme, please refer '
				."to the metacity documentation.\n\n"
				."Theme name: $theme->{name}\n"
				."$theme->{description}\n"
				."Downloaded from: $theme->{source}\n"
				."Version: $theme->{version}\n"
				."Upstream Author: $theme->{author}\n"
				."License: $theme->{license}\n";				
				
		close README
			or warn "Error closing $DOCDIR/$theme->{name}/README.Debian\: $!\n";
		print "$theme->{name}: written README.Debian file.\n";
		
		# Now examine the output directories
		foreach ("$THEMEDIR/$theme->{name}", "$THEMEDIR/$theme->{name}/metacity-1"){
			my $dir = $_;
			opendir DIR, $dir or die "Unable to open theme dir, $dir\: $!\n";
			foreach ('copying', 'COPYING', 'license', 'LICENSE', 'License', 'Copying', 'Copyright', 'COPYRIGHT', 'copyright', 'INSTALL', 'install'){
				my $term = $_;
				rewinddir DIR;
				if ( grep {/$term/} readdir DIR ){
					print "$theme->{name}: removing redundant file $dir/$term\n";
					`rm $dir/$term`;
				}
			}
			foreach ('readme', 'README', 'TODO', 'todo', 'AUTHORS', 'ChangeLog', 'Changelog'){
				my $term = $_;
				rewinddir DIR;
				if (grep {/$term/} readdir DIR){
					print "$theme->{name}: moving documentation $dir/$term\n";
					`mv $dir/$term $DOCDIR/$theme->{name}/`;
				}
			}
			foreach ('.*\~', '.*bak', '.*BAK', '.*swp', '.*SWP', '\.xvpics'){
				my $term = $_;
				rewinddir DIR;
				if (my @list = grep {/$term/} readdir DIR){
					foreach my $file (@list){
						print "$theme->{name}: WARNING: Deleting backup file: $dir/$file\n";
						`rm -r $dir/$file`;
					}
				}
			}
			
			closedir DIR or warn "Error closing dir $dir\:$!\n";

		}
	}
}

sub makerejectnotice(){
	# Creates rejected.debian file explaining which files were rejected from the
	# collection
	print "\nGenerating rejected.Debian file...\n";
	open REJECT, ">$DOCDIR\/rejected\.Debian" 
		or die "unable to open reject file, >$DOCDIR\/rejected\.Debian\: $!\n";
	REJECT->format_name("wrapped");
	print REJECT 'This package contains quality themes for the metacity window ',
		'manager. We reject themes for a number of reasons, including not having ',
		'a suitable license; not implementing all areas of the metacity theme ',
		'definition; not being high quality. If you believe a theme should be ',
		'included in the collection which isn\'t listed below, please send a link.',

		"\nIf you think the below information is incorrect, please correct us.\n\n";
		
	foreach my $reject (@themedata::rejected){
		print REJECT "$reject->{name} found at $reject->{source}\n$reject->{reason}\n\n";
	}
	
	print REJECT "The following were rejected due to license issues\n" 
		if (@themedata::rejectedlicense);
	foreach my $reject (@themedata::rejectedlicense){
		print REJECT "$reject->{name} found at $reject->{source}\n\n";
	}
	close REJECT
		or warn "Error closing reject file\: $!\n";
}

sub makecopyright(){
	# creates a copyright file containing details of the copyright of every
	# theme.
	
	print "\nGenerating copyright file...\n";
	open COPYRIGHT, ">$DOCDIR\/copyright"
		or die "unable to open copyright file, $DOCDIR\/copyright\: $!";
		
	print COPYRIGHT "This package was debianized by Mark Howard ",
			"<mh\@tildemh.com> \non Sat, 07 Sept 2002 16:04:28 +0100\n\n";

	foreach my $theme (@themedata::installed){
		print COPYRIGHT
                    "Theme: $theme->{name}\n",
                    "Upstream Author: $theme->{author}\n",
                    "It was downloaded from \n $theme->{source}\n\n";
	}

        print COPYRIGHT "Copyright: \n\n";

	foreach my $theme (@themedata::installed){
            print COPYRIGHT
                "Theme $theme->{name}\n",
                "Copyright $theme->{date} $theme->{author}\n\n";
	}

        print COPYRIGHT "\n";

	print COPYRIGHT "On Debian systems, the full text of the GPL \ncan be found in /usr/share/common-licenses/GPL";
	
	close COPYRIGHT
		or warn "Error closing copyright file: $!";
}

sub makesubstvars(){
	print "\nGenerating substitution variables\n";
	open SUBSTVARS, ">debian/metacity-themes.substvars" 
		or die "unable to open substvars file, >debian/substvars\: $!\n";
	print SUBSTVARS "themelist=";
	foreach my $theme (@themedata::installed){
		print SUBSTVARS "\${Newline}    * $theme->{name}"
	}	
	print SUBSTVARS "\n";
	close SUBSTVARS or warn "error closing substvars filei\: $!";
	`cat debian/substvars`;
}
