/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include "MvQColourLine.h"

#include <QComboBox>
#include <QPainter>

#include "MvQPalette.h"
#include "MvQRequestPanelHelp.h"

#include "LineFactory.h"
#include "RequestPanel.h"

QList<QString> MvQColourLine::specialColourNames_;


/*void MvQColourComboBox::insertColor(int index, const QColor &color, const QString &name)
{
    QPixmap pix(12, 12);
    QPainter painter(&pix);
    if (color.isValid()) {
	painter.setPen(Qt::gray);
	painter.setBrush(QBrush(color));
	painter.drawRect(0, 0, 12, 12);
    }
    QIcon icon;
    icon.addPixmap(pix);

    // Prevent adding of colors after the color dialog item.
    if (colorDialogEnabled && index > colorCount()) index = colorCount() - 1;
    insertItem(index, icon, name, color);
}
 */

MvQColourLine::MvQColourLine(RequestPanel& owner,const Parameter& param) :
		   MvQRequestPanelLine(owner,param) 
{

	// populate our list of 'special' colour names
	if (specialColourNames_.empty())
	{
		specialColourNames_ << "AUTOMATIC" << "CONTOUR_LINE_COLOUR";
	}


	colCb_ = new QComboBox(parentWidget_);
	
	QFont font;
    	QFontMetrics fm(font);
    	int h=fm.height()+4;
   	int w=h*2;
	colCb_->setIconSize(QSize(w,h));
	   
	param_.scan(*this);
	
	//The AUTOMATIC colour needs to be handled separately
	bool hasAuto=false;
	for(int i=0; i < colCb_->count(); i++)
	{
		QString colourName(colCb_->itemData(i).toString());
		if(specialColourNames_.contains(colourName))
		{
		  	hasAuto=true;
			break;
		}
	}	

	if(hasAuto == false)
	{
		const vector<string>& def=param_.defaults(); 
		if(def.size() == 1)
		{
			QString defColour(QString::fromStdString(def.at(0)));
			if (specialColourNames_.contains(defColour))
			{
				addColour(Qt::white,defColour,defColour); 
			}
		}
	}
	
	owner_.addWidget(colCb_,row_,3);
	
	connect(colCb_,SIGNAL(currentIndexChanged(int)),
		this,SLOT(slotCurrentChanged(int)));
}

void MvQColourLine::next(const Parameter&, const char* first,const char* /*second*/)
{
	if(!specialColourNames_.contains(first))
	{
		addColour(MvQPalette::magics(first),QString::fromStdString(param_.beautifiedName(first)),QString(first));
	}
	else
	{
	  	addColour(Qt::white,first,first); 
	}	  
}

void MvQColourLine::addColour(QColor color,QString name, QString realName,bool setCurrent)
{
    if(!color.isValid()) 
      	return;
    
    for(int i=0; i < colCb_->count(); i++)
    {
      	if(name.compare(colCb_->itemText(i),Qt::CaseInsensitive) == 0) 
	{
	  	if(setCurrent)
		{
		  	colCb_->setCurrentIndex(i);
		}
		return;
	}	
    }
    
    
    bool realCol = (!specialColourNames_.contains(name));
    
    int w=colCb_->iconSize().width();
    int h=colCb_->iconSize().height();
 
    QIcon icon;
    if(realCol)
    {
    	QPixmap pixmap(w, h);
    	QPainter painter(&pixmap);
    	painter.setPen(Qt::black);
  	painter.setBrush(QBrush(color));
    	painter.drawRect(0, 0, w-1, h-1);
 
    	icon.addPixmap(pixmap);
    }
    
    if(colCb_->count() == 0)
      	colCb_->addItem(icon,name,realName);
    else
    {
      	int i=0;
    	while(i < colCb_->count() && colCb_->itemText(i) < name) 
		 i++;
	colCb_->insertItem(i,icon,name,realName);
	if(setCurrent)
	  	colCb_->setCurrentIndex(i);
    }	
}


void MvQColourLine::refresh(const vector<string>& values)
{
	if(values.size() > 0)
	{
		for(int i=0; i < colCb_->count(); i++)
		{
			if(colCb_->itemData(i).toString().toStdString() == values[0])
			{
			  	colCb_->setCurrentIndex(i);
				return;
			}	
		}
		
		QString name=QString::fromStdString(values[0]);
		//This sets the current index as well
		addColour(MvQPalette::magics(values[0]),name,name,true);		
	}
	
	//changed_ = false;
}

void MvQColourLine::slotCurrentChanged(int index)
{
	if(index >=0 && index < colCb_->count())
	{
	  	QString name=colCb_->itemData(index).toString();
		owner_.set(param_.name(),name.toStdString());
		if(!specialColourNames_.contains(name))
		{ 
			if(helper_ && helper_->widget())
			  	helper_->widget()->setEnabled(true);
			updateHelper();
		}
		else
		{
		  	if(helper_ && helper_->widget())
			  	helper_->widget()->setEnabled(false);
		}  
	}	
}

void MvQColourLine::slotHelperEdited(const vector<string>& vals)
{
	if(vals.size() == 0)
	  	return;

	QString name=QString::fromStdString(vals[0]);
	addColour(MvQPalette::magics(vals[0]),name,name,true);
}	

void MvQColourLine::updateHelper()
{
  	if(!helper_)
		return;
	
	int index=colCb_->currentIndex();
	
	vector<string> vals;	
	vals.push_back(colCb_->itemData(index).toString().toStdString());
	helper_->refresh(vals);
}  		

static LineMaker<MvQColourLine> maker1("colour");
