/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <QApplication>
#include <QDebug>
#include <QSplashScreen>

#include "MvQObstatScatterTool.h"

#include <iostream>
#include "Metview.h"
#include "MvQService.h"
#include "MvQKeyManager.h"
#include "MvQObstatScatterData.h"

string ftmp;

using namespace std;
 
// Globals
int          ac;
char       **av;

class Base : public MvQService 
{ 
protected:
	Base(char* a) : MvQService(a) {};
};

class MvObstatScatterTool : public Base 
{	
public:
	MvObstatScatterTool() : Base("OBSTAT_SCATTER") {};	
	void serve(MvRequest&,MvRequest&);
};

void MvObstatScatterTool::serve( MvRequest& in, MvRequest& out)
{
  	cout << "--------------MvObstatScatterTool::serve()--------------" << endl;
  	in.print();	
    	
	//Get grib file name	
	const char* tmpc = in("PATH");	

	//Set grib file name			
	string fdata(tmpc);

	//Set tmpfile name
	ftmp=marstmp();

	//GribMetaData grib;
	//try
	//{
	//	grib.init(fgrib,fgribdump);
	//}
	/*catch(MvOdbException e)
   	{
		stringstream sbuff("", ios_base::out);
		sbuff << e.what();	
		//marslog(LOG_EXIT|LOG_EROR,"%s\n",sbuff.str().c_str());
		setError(13,sbuff.str().c_str());
		return;		
	}	
	catch(exception e)
   	{
		stringstream sbuff("", ios_base::out);
		sbuff << e.what();		
		//marslog(LOG_EXIT|LOG_EROR,"%s\n",sbuff.str().c_str());
		setError(13,sbuff.str().c_str());	
		return;			
	}*/
	
  
	//Create the qt application
	QApplication app(ac, av); 
	
	//Create a splash screen
	/*QSplashScreen *splash=new QSplashScreen;
	splash->setFixedWidth(300);
	splash->setFixedHeight(300);
	splash->setPixmap(QPixmap("/tmp/PERFORCE/metview_4/src/GribBrowser_qt/splash.png"));

	splash->show();
	app.processEvents();

	Qt::Alignment topRight = Qt::AlignRight | Qt::AlignTop;
	
	splash->showMessage("Reading message list in Grib File",
			    topRight, Qt::white);
	app.processEvents();
	qDebug() << "splash";*/

	

	//Create the grib key manager and initialize it
	//MvQKeyManager *manager = new MvQKeyManager(MvQKeyManager::GribType);
	//manager->loadProfiles();

	//Create the grib metadata object and initialize it	
	MvQObstatScatterData *data = new MvQObstatScatterData;
	
	/*connect(data,SIGNAL(newItemLoaded(QString)),
		splash,SLOT(showMessage(QString)));*/


	data->setFileName(QString::fromStdString(fdata));

	//Create the grib browser and initialize it
	MvQObstatScatterTool *browser = new MvQObstatScatterTool;
	browser->init(data);
   	browser->show();
	
	//Listen to the mars event loop!
	setupSocketNotifier();
	
	//Remove splash screen
	//splash->finish(browser);
	//delete splash;

   	//Enter the app loop
 	app.exec();	
}		

int main( int argc, char **argv )
{
	ac = argc;
  	av = argv;
	
	MvApplication theApp( argc, argv );

    	MvObstatScatterTool scatter;	
	
    	theApp.run();	
}



