/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef REPROJECTSERVICE_H
#define REPROJECTSERVICE_H

#include <iostream>
#include <UserPoint.h>
#include <RasterData.h>
#include <GribDecoder.h>

using namespace std;
using namespace magics;


class ReprojectService {

public:

     ReprojectService() {}
     ReprojectService(string in,string out,double rx,double ry,double x1,double x2,double y1,double y2);

     bool execute();
     int gribit(RasterData& image, magics::GribDecoder& sourceGrib);

private:

    string gribIn_;
    string gribOut_;
    double resX_,resY_;        //resolution
    double x1_,x2_,y1_,y2_;    //geographical area
};

#endif
