/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQApplication_H
#define MvQApplication_H

#include <QtWidgets/QApplication>
#include <QWidget>

#include <MvRequest.h>
#include <MvProtocol.h>
#include <MvApplication.h>
#include <qsocketnotifier.h>

#include "MvQDragDrop.h"

using namespace std;

class QMainWindow;

class MvQApplication : public QApplication, public MvApplication
{
    Q_OBJECT

public:
    MvQApplication(int& ac, char** av, const char* name = NULL);
    virtual ~MvQApplication();
    void registerToDesktop(QMainWindow* win);
    static void writePidToFile(const MvRequest& r);

public slots:
    void slotDataReceived(int);
    void processDropRequest(MvRequest*);

protected:
    virtual void messageCallback(svcid* id, request* r);

private:
    // No copy allowed
    MvQApplication(const MvQApplication&);
    MvQApplication& operator=(const MvQApplication&) { return *this; }
    static void messageCallbackCore(svcid* id, request* r, void* obj);

    QSocketNotifier* sn_;
    QMainWindow* win_ {nullptr};
    char* desktopName_;
};

#endif
