/* -*- mode:C; indent-tabs-mode: nil; tab-width: 8; c-basic-offset: 8; c-set-style "K&R"; -*- */

/* 
 * This file is part of MIALMPICK - a software for landmark picking 
 * in 3D volume data sets
 *
 * Copyright (c) Leipzig, Madrid 1999-2013 Gert Wollny
 *
 * MIALMPICK is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MIALMPICK; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <globals.h>
#include "image3d.h"

#include <vistaio.h>

static VistaIOImage get_first_image(const char *file_name) 
{
	VistaIOImage res = NULL; 
	VistaIOAttrList list; 
	VistaIOAttrListPosn posn; 
	FILE *file;
	
	if ((file = fopen(file_name, "r")) == 0) {
		perror(file_name);
		return NULL; 
	}

	list = VistaIOReadFile(file,0);
	fclose(file);
	
	if (!list) 
		VistaIOError("%s is not vista file", file_name); 
	

	for (VistaIOFirstAttr(list, &posn); VistaIOAttrExists(&posn); VistaIONextAttr(&posn)) {
		// it this object an image?
		if (VistaIOGetAttrRepn(&posn) == VistaIOImageRepn) {
			VistaIOExtractAttr(list,VistaIOGetAttrName(&posn), 0, VistaIOImageRepn, &res, 0);
			break;
		}
	}
	VistaIODestroyAttrList(list);
	return res; 
}


MiaImage3d *load_vista_image(const char *filename)
{
	VistaIOImage img = NULL; 
	MiaImage3d *result = NULL; 
	
	img = get_first_image(filename);	
	if (!img)
		return NULL; 
	
	switch ( VistaIOPixelRepn(img) ) {
	case  VistaIOShortRepn: 
		result = mia_image3d_new_short(img->ncolumns, img->nrows, img->nbands, VistaIOPixelPtr(img,0,0,0));
		img->data = NULL; 
		break; 
	case VistaIOUByteRepn:
		result = mia_image3d_new_ubyte(img->ncolumns, img->nrows, img->nbands,  VistaIOPixelPtr(img,0,0,0));
		img->data = NULL; 
		break; 
	default:
		g_warning("Input type not supported");
	}
	VistaIODestroyImage(img);
	return result; 
}
