#ifndef NETWORK_H
#define NETWORK_H

#define LISTEN_LIST_NEW(x) { \
   if (x == NULL) \
      x = xmalloc(sizeof(struct LISTEN_LIST)); \
   else { \
      while (x->next != NULL) x = x->next; \
      x->next = xmalloc(sizeof(struct LISTEN_LIST)); \
      x = x->next; \
   } \
   x->port = -1; \
   x->ip = NULL; \
   x->next = NULL; \
   x->proxy = NULL; \
   x->proxytype = PROXY_DIRECT; \
};

#define LISTEN_LIST_INSERT(x, a, b, c, d) { \
   if (a != NULL && x->ip == NULL) \
      x->ip = xstrdup(a); \
   if (b != -1) \
      x->port = b; \
   if (c != NULL && x->proxy == NULL) \
      x->proxy = xstrdup(c); \
   if (d != NULL) { \
      if (!strcasecmp(d, "normal")) \
         x->proxytype = PROXY_NORMAL; \
      else if (!strcasecmp(d, "socks4")) \
         x->proxytype = PROXY_SOCKS4; \
      else \
         x->proxytype = PROXY_DIRECT; \
   } \
};

#endif				/* NETWORK_H */
