#ifndef PROTO_H
#define PROTO_H

#include "flags.h"
#include "../config.h"
#include "../tinyxml/tinyxml.h"

#ifdef HAVE_PCRE
#include <pcre.h>
#include <pcreposix.h>
#else
#include "../pcre/pcre.h"
#include "../pcre/pcreposix.h"
#endif /* HAVE_PCRE */

#ifdef HAVE_SSL
// XXX: I'll figure out which don't need to be included globally later
#include <openssl/ssl.h>
#include <openssl/rand.h>
#include <openssl/crypto.h>
#include <openssl/opensslconf.h>
#include <openssl/err.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/rsa.h>
#endif

#include <pthread.h>
#include <sys/resource.h>
#include <list>
#include <string>
#include <vector>
#include <map>

using std::vector;
using std::string;
using std::list;
using std::map;
using std::pair;

#ifdef HAVE_STDINT_H
#include <stdint.h>
#else
#include <types.h>
#endif /* HAVE_STDINT_H */

#ifdef HAVE_POLL
#include <sys/poll.h>
#endif

#include "compat.h"
#include "settings.h"
#include "section.h"
#include "types.h"
#include "macros.h"

#undef strncpy
#define strncpy(a,b,c) dont_use_strncpy()
#undef strncat
#define strncat(a,b,c) dont_use_strncat()

/* main.c */
void config();
int config_load(int, const string);
int config_save(const string &);
void config_xml_build();
int process_new(CONNECTION *);
int thread_create(void *, void *);
void process_entry(CONNECTION *);
void mainloop();
void show_help(char **);
int pid_check(char *);
void bypass_check(CONNECTION *);
void profiles_reset(CONNECTION *);
void rusage_update();
void fix_uid();
void fix_gid();

/* global.c */
void global_load(XML_LIST *xml_list);
XML_LIST *global_xml(XML_LIST *xml_list);
void global_general_insert(char *, char *, char *, char *, char *, char *, char *, char *, char *, char *);
void global_ftp_insert(char *, char *, char *, char *, char *);
void global_dnsbl_insert(char *, char *, char *);
void global_prefetch_insert(char *, char *, char *);

/* mem.c */
#ifdef _DEBUG_MEMORY
void *xrealloc_(void *, int, char*, int);
char *xstrdup_(const char *, char*, int);
char *xstrndup_(const char *, size_t, char*, int);
#else
void *xmalloc(int size);
void *xrealloc(void *, int);
void xfree(void *);
char *xstrdup(const char *);
char *xstrndup(const char *, size_t);
#endif
void out_of_memory();

/* xml.c */
TiXmlNode* section_select(TiXmlDocument *, const char*);

/* access.c */


/* header.c */
#ifdef _DEBUG_MEMORY
HEADER *header_new_(char*, int);
#else
HEADER *header_new();
#endif
HEADER *http_header_parse_request(char *);
HEADER *http_header_parse_response(char *);
HEADER *http_header_dup(HEADER *);
int header_length(char *, size_t);
void http_header_list_parse(HEADER *, char *);
void http_header_free(HEADER *);
char *header_extract(char *, int);
char *header_get(CONNECTION *, int, int);
void header_send(HEADER *, CONNECTION *, int, int);
void header_send_filebuf(Filebuf *, HEADER *, CONNECTION *, int, int);
struct url_command_t **url_command_parse(char *);
char *url_command_create(struct url_command_t **);
void url_command_free(struct url_command_t **);
char *url_command_add(CONNECTION *, char *);
struct url_command_t *url_command_find(struct url_command_t **, char *);
void xcache_header_update(CONNECTION *, int flags);
void via_header_update(CONNECTION *);
void conditional_header(HEADER *, CACHEMAP *);
int url_command_extract(CONNECTION *);

/* filebuf.c */
void zlib_error(int);

/* filter.c */


/* cookies.c */
void interface_cookies_show(CONNECTION *);

/* misc.c */
char *s_strncpy(char *, const char *, size_t);
char *s_strncat(char *, char *, size_t);
char *s_strcasestr(char *, char *);
size_t s_strnlen(const char *, size_t);
char *code_to_error(int);
char *error_to_template(int);
void hostent_free(HOSTENT *);
int isip(const char *);
void string_tolower(char *);
char *string_to_html(const char *, int);
char *url_encode(char *, size_t);
char *url_decode(char *, size_t);
char *string_to_xml(char *);
char **string_break(const char *, const char);
int range_check(char *, unsigned int);
void array_free(char **);
char *array_merge(char **, int);
int array_find(char **, char *);
int array_length(char **);
char **array_dup(char **);
char **array_add(char **, char *);
char **array_delete(char **, char *);
void stack_free(struct STACK_T *);
mode_t mode_parse(char *);
char *mode_create(mode_t);
struct sockaddr_in *ftpport_parse(char *);
char *ftpport_create(struct sockaddr_in *);
char *filesize(size_t);
time_t local_mktime(struct tm *);
time_t utc_time(time_t *);
char **cmdline_parse(const char *);
char *string_append(char *, char *);
char *path_to_url(char *);
int in_absolutetimerange(const struct tm &, const struct tm_partial &, const struct tm_partial &);
int in_alltimerange(const struct tm &, const struct tm_partial &, const struct tm_partial &);
char *month_name(int);
char *weekday_name(int);
URL *url_parse(const char *);
char *url_create(URL *);
void url_free(URL *);
int isempty(char *, size_t);
int urlcmp(URL *, URL *);
char *resolve_path(char *);
char *url_path_fix(char *);
void url_strip(char *);
int protocol_port(char *);
char *timeval_to_string(struct timeval *tv);

/* base64.c */
void to64frombits(unsigned char *, const unsigned char *, int);
int from64tobits(char *, const char *);

/* pool.c */
POOL *pool_init();
void pool_add(POOL *, Socket *, char *, char *, int, char *, char *);
Socket *pool_find(POOL *, char *, char *, int, char *, char *);
void pool_clean(POOL *, int);
void pool_clean_unlocked(POOL *, int);

/* regexp.c */
regex_t *reg_compile(const char *, int);
void reg_free(regex_t *);
int reg_exec(regex_t *, const char *);
regex_sub_t *reg_sub_compile(const char *, int);
regmatch_sub_t *reg_sub_exec(regex_sub_t *, char *);
char *reg_sub_parse(regmatch_sub_t *, const char *);
void reg_sub_match_free(regmatch_sub_t *);
void reg_sub_free(regex_sub_t *);
void reg_replace(Filebuf *, regex_sub_t *, const char *);
void string_replace(Filebuf *, char *, char *);

/* network.c */
void net_init();
CONNECTION *connection_new();
void connection_free(CONNECTION *);
int net_listen(int, const char *);
CONNECTION *net_accept(int);
void net_close(CONNECTION *);
void net_listen_closeall();
int net_connect(const char *, int, int);
int net_proxy(CONNECTION *, int);
int net_transfer(CONNECTION *, int, int);
int net_filebuf_read(Filebuf *, CONNECTION *, int, int);
int net_filebuf_send(Filebuf *, CONNECTION *, int);
int net_cache_send(CACHEMAP *, CONNECTION *, int, unsigned int);
int proxy_socks4(CONNECTION *);
HOSTENT *net_dns(const char *);

/* protocol.c */
int protocol_start(CONNECTION *);
int protocol_reconnect(CONNECTION *);
int protocol_http(CONNECTION *);
char *header_get_reconnect(CONNECTION *, int);
int proxy_authenticate(CONNECTION *);
int send_ntlm_response(CONNECTION *);
int send_basic_response(CONNECTION *);
void keepalive_check(CONNECTION *);
int buffer_check(CONNECTION *);
int transfer_limit_check(CONNECTION *);
int accepts_encoded_content(CONNECTION *);
void proxy_test(CONNECTION *);

/* proto_http.c */
unsigned int next_chunksize(CONNECTION *, int);
Filebuf *http_transfer_filebuf(CONNECTION *, int, unsigned int);
void http_transfer_discard(CONNECTION *, int);
void http_transfer(CONNECTION *, int);
int protocol_http_read_callback(void *, int, char *);

/* proto_ftp.c */
int protocol_ftp(CONNECTION *);
Socket *ftp_transfer_setup(CONNECTION *, char *, ...);
int ftp_transfer(CONNECTION *, int, Socket *, int);
Filebuf *ftp_transfer_filebuf(CONNECTION *, int, Socket *, int);
int ftp_code_wait(CONNECTION *, int, int);
int protocol_ftp_read_callback(void *, int, char *);

/* proto_connect.c */
int protocol_connect(CONNECTION *);
int proxy_connect(CONNECTION *);

/* dirlist.c */
struct dir_t *dir_list_parse(Filebuf *);
struct dir_t *dir_list_add(struct dir_t *, int, mode_t, char *, char *, size_t, struct tm, char *);
struct dir_t *dir_list_sort(struct dir_t *, int, int);
void dir_list_free(struct dir_t *);
struct dir_t *dir_list_filter(struct dir_t *, const char *);

/* template.c */
void template_parse(CONNECTION *, Filebuf *);

/* rewrite.c */


/* profiles.c */
int profile_find(const StringList&, const StringList&);

/* log.c */
void putlog(int, char *, ...);
void logbuffer_add(LOGBUFFER *, char *);
void logbuffer_clear(LOGBUFFER *);
void logbuffer_resize(LOGBUFFER *, int);

/* signal.c */
void signal_setup();

/* compat.c */
HOSTENT *p_gethostbyname(const char *);
int p_poll(struct pollfd *, int, int);
int p_setenv(const char *, const char *, int);
void p_clearenv();
void *p_mremap(void *, size_t, size_t, int);

/* external.c */
Filebuf *external_exec(CONNECTION *, const char *, Filebuf *, int);
char *external_getmime(Filebuf *);
char *env_header_format(char *, const char *);

/* mime.c */


/* hash.c */
unsigned int hash_key(int, const char *);
HASH_TABLE *hash_create(int);
struct HASH_LIST *hash_insert(HASH_TABLE *, const char *, void *);
void hash_purge(HASH_TABLE *, const char *);
struct HASH_LIST *hash_search(HASH_TABLE *, const char *);
void hash_destroy(HASH_TABLE *);
int hash_expire(HASH_TABLE *, unsigned int);

/* redirect.c */


/* forward.c */
void icp_thread();
int icp_packet_send(int fd, struct sockaddr_in *, struct icp_packet *);
int icp_packet_receive(int fd, struct sockaddr_in *, struct icp_packet *);
char *icp_opcode_name(int);

/* keywords.c */


/* cache.c */
struct cache_store *cache_load(struct cache_store *, XML_LIST *);
struct cache_store *stores_list_new(struct cache_store *);
void global_cache_insert(char *, char *, char *, char *, char *, char *, char *, char *, char *, char *, char *, char *, char *);
void stores_list_insert(struct cache_store *, char *, char *, char *, char *, char *);
struct cache_store *stores_list_delete(struct cache_store *);
void stores_list_free(struct cache_store *);
XML_LIST *cache_xml(struct cache_store *, XML_LIST *);

char *cache_header(CACHEMAP *);
Filebuf *cache_to_filebuf(CACHEMAP *, size_t);
int cacheable(HEADER *);
void unlink_list_add(char *);
void unlink_list_zap(char *);
void unlink_thread();

/* timers.c */
TIMERS *timers_init();
int timers_add(TIMERS *, int interval, int flags, void *callback, void *arg);
int timers_remove(TIMERS *, int tid);
void timers_check(TIMERS *);
struct TIMERS_LIST *timers_find(TIMERS *, int tid);
void timers_insert(TIMERS *, struct TIMERS_LIST *);


/* limits.c */


/* prefetch.c */
void prefetch_thread(PrefetchSection *);
int protocol_prefetch(URL *, HttpHeaderList *, unsigned int, int);
void prefetch_queue_free(struct PREFETCH_QUEUE *);
void prefetch_callback(HTMLSTREAM *hs, struct htmlstream_node *node, CONNECTION *connection);

/* hstream.c */
HTMLSTREAM *htmlstream_new();
void htmlstream_free(HTMLSTREAM *);
void htmlstream_tree_free(struct htmlstream_node *);
void htmlstream_tag_free(struct htmlstream_tag *);
void htmlstream_add(HTMLSTREAM *, char *, int);
struct htmlstream_tag *htmlstream_tag_parse(char *, int);
int htmlstream_callback_add(HTMLSTREAM *, const char *, void *, void *);

#ifdef HAVE_PAM
int auth_pam(char *, char *);
#endif /* HAVE_PAM */

/* interface.c */
int interface_check_referer(CONNECTION *);
void interface_stylesheet(CONNECTION *, Filebuf *);
void interface_handle_request(CONNECTION *);
void interface_page_connections(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_dnscache(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_headers(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_stats(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_save(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_load(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_log(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_cache(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_pool(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_config(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_prefetch(Filebuf *, CGIMap &, CONNECTION *);
void interface_page_global(Filebuf *, CGIMap &, CONNECTION *);
void interface_send_response(CONNECTION *, Filebuf *);
void score_show(CONNECTION *, int);
void cache_show(CONNECTION *);
void show_filebuf_diff(CONNECTION *, Filebuf *, Filebuf *);
void show_dirlist(CONNECTION *, struct dir_t *);
void show_headers(CONNECTION *);
void show_filebuf(CONNECTION *, Filebuf *);
void show_proxytest(CONNECTION *);
void show_htmltree(CONNECTION *);
void show_htmltree_node(Filebuf *, struct htmlstream_node *, int);
void show_profiles(CONNECTION *);

/* section.c */
unsigned int string_to_filesize(string);

/* stats.c */
char *stat_usertime();
char *stat_systime();
bool statm_load(struct statm_t *);
unsigned int stat_majflt();
unsigned int stat_minflt();
unsigned int stat_size();
unsigned int stat_resident();
unsigned int stat_share();

/* fetch.c */
HTTPRESPONSE *http_fetch(URL *);
void httpresponse_free(HTTPRESPONSE *);

/* sync.c */
void config_sync();
void sync_thread();

/* ssl.c */
#ifdef HAVE_SSL
void SSL_thread_setup();
void SSL_thread_cleanup();
void SSL_pthreads_locking_callback(int mode, int type, const char *file, int line);
unsigned long SSL_pthreads_thread_id(void);
#endif

#endif				/* PROTO_H */
