/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "proto.h"

extern TemplateSection *template_section;

AntivirusSection::AntivirusSection() :
	Section("antivirus", RWLOCK),
	enabled(field_vec[0].int_value),
	clamavhost(field_vec[1].string_value),
	clamavport(field_vec[2].int_value),
	dtempl(field_vec[3].string_value)
{
}

void AntivirusSection::update() {
	antivirus_list.clear();

        ItemList::iterator item;
        for (item = sub_vec[0].item_list.begin(); item != sub_vec[0].item_list.end(); item++)
                antivirus_list.push_back(Antivirus(*item));
}

const Antivirus *AntivirusSection::find(CONNECTION *connection) const 
{
	AntivirusList::const_iterator antivirus;

	for (antivirus = antivirus_list.begin(); antivirus != antivirus_list.end(); antivirus++) {
		if (!profile_find(connection->profiles, antivirus->profiles))
			continue;

		break;
	}

	return (antivirus != antivirus_list.end()) ? &*antivirus: NULL;
}

bool AntivirusSection::check_match(CONNECTION *connection) const
{
	const Antivirus *antivirus;

	read_lock();
	antivirus = find(connection);
	unlock();

	return (!!antivirus);
}

int AntivirusSection::check_and_block(CONNECTION *connection, Filebuf *filebuf) const
{
	int ret, port, sport;
	char buf[1024], **args;
	string blockedtempl, host;
	const Antivirus *antivirus;
	Socket *control = NULL, *stream = NULL;

	read_lock();
	antivirus = find(connection);
	if (antivirus == NULL) {
		unlock();

		return TRUE;
	}

	blockedtempl = (antivirus->templ != "") ? antivirus->templ : (dtempl != "") ? dtempl : "blocked";
	host = clamavhost;
	port = clamavport;

	unlock();

	control = xnew Socket();
	ret = control->Connect(host.c_str(), port);
	if (ret == -1) goto error;

	control->PutSock("STREAM\n");
	ret = control->GetLine(buf, sizeof(buf));
	if (ret == -1) goto error;

	ret = sscanf(buf, "PORT %d", &sport);
	if (ret != 1) goto error;

	stream = xnew Socket();
	ret = stream->Connect(host.c_str(), sport);
	if (ret == -1) goto error;

	stream->WriteFilebuf(filebuf);
	xdelete stream;
	stream = NULL;

	ret = control->GetLine(buf, sizeof(buf));
	if (ret == -1) goto error;

	args = string_break(buf, ' ');
	if (array_length(args) == 2)
		putlog(MMLOG_ANTIVIRUS, "no viruses found");
	else if (array_length(args) == 3) {
		putlog(MMLOG_ANTIVIRUS, "virus found: %s", args[1]);

		connection->variables["VIRUSNAME"] = args[1];

		template_section->send(blockedtempl.c_str(), connection, 404);

		xdelete control;
		array_free(args);

		return FALSE;
	} else {
		array_free(args);
		goto error;
	}

	array_free(args);
	xdelete control;

	return TRUE;

	error:

	putlog(MMLOG_ANTIVIRUS, "error checking file for viruses");

	xdelete control;
	xdelete stream;

	return TRUE;
}

Antivirus::Antivirus(const Item& item) :
	enabled(item.field_vec[0].int_value),
	comment(item.field_vec[1].string_value),
	profiles(item.field_vec[2].string_list_value),
	templ(item.field_vec[3].string_value)
{
}

