/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "proto.h"

extern GeneralSection *general_section;
extern TemplateSection *template_section;

KeywordSection::KeywordSection():
     Section("keywords", RWLOCK),
     enabled   (field_vec[0].int_value),
     threshold (field_vec[1].int_value),
     templ     (field_vec[2].string_value)
{
}

void KeywordSection::update()
{
	keyword_list.clear();

	ItemList::iterator item;
	for (item = sub_vec[0].item_list.begin(); item != sub_vec[0].item_list.end(); item++)
		keyword_list.push_back(Keyword(*item));
	
}


Keyword::Keyword(const Item& item):
     enabled  (item.field_vec[0].int_value),
     comment  (item.field_vec[1].string_value),
     profiles (item.field_vec[2].string_list_value),
     mime     (item.field_vec[3].string_value),
     size     (item.field_vec[4].int_value),
     keyword  (item.field_vec[5].string_value),
     score    (item.field_vec[6].int_value)
{
	me = (mime != "") ? reg_compile(mime.c_str(), REGFLAGS) : NULL;
	ke = (keyword != "") ? reg_compile(keyword.c_str(), REGFLAGS) : NULL;
}

Keyword::Keyword(const Keyword& k):
     enabled  (k.enabled),
     comment  (k.comment),
     profiles (k.profiles),
     mime     (k.mime),
     size     (k.size),
     keyword  (k.keyword),
     score    (k.score)
{
	me = (mime != "") ? reg_compile(mime.c_str(), REGFLAGS) : NULL;
	ke = (keyword != "") ? reg_compile(keyword.c_str(), REGFLAGS) : NULL;
}

Keyword::~Keyword()
{
	if (me != NULL)
		reg_free(me);
	if (ke != NULL)
		reg_free(ke);
}


bool KeywordSection::check_and_block(CONNECTION *connection, Filebuf *filebuf)
{
	int ret;

	ret = check(connection, filebuf, TRUE);

	if (ret) {
		read_lock();
		if (ret >= threshold) {
			/* page blocked due to keyword score exceeding threshold */
			putlog(MMLOG_KEYWORDS, "page above threshold with a score of %d", ret);

			template_section->send((templ != "") ? templ.c_str() : "blocked", connection, 200);

			unlock();

			return FALSE;
		}
	}

	unlock();

	return TRUE;
}

int KeywordSection::check(CONNECTION * connection, Filebuf * filebuf, int action)
{
	int ret, x = FALSE;
	unsigned int maxbuffer, tmp;

	if (connection->bypass & FEATURE_KEYWORDS)
		return FALSE;

	read_lock();

	if (this->enabled == FALSE) {
		unlock();

		return FALSE;
	}

	if (filebuf != NULL)
		filebuf->Add("", 1);

        maxbuffer = general_section->maxbuffer_get();

	KeywordList::const_iterator kl;
	for (kl = keyword_list.begin(); kl != keyword_list.end(); kl++) {
		if (kl->enabled == FALSE)
			continue;

		if (!profile_find(connection->profiles, kl->profiles))
			continue;

		if (kl->me != NULL && connection->rheader->content_type != NULL) {
			ret = reg_exec(kl->me, connection->rheader->content_type);
			if (ret)
				continue;
		} else if (kl->me != NULL) {
			ret = reg_exec(kl->me, "");
			if (ret)
				continue;
		}

                if (kl->size != 0) {
                    tmp = (kl->size == -1)? maxbuffer : kl->size;
                        
                    if (action == FALSE) {
                        if (connection->rheader->content_length > tmp)
                            continue;
                    } else {
                        if (!(connection->rheader->flags & HEADER_CL) || connection->rheader->content_length > tmp)
                            continue;
                    }
                }

		if (kl->ke != NULL && filebuf != NULL) {
			ret = reg_exec(kl->ke, filebuf->data);
			if (ret)
				continue;
		}

		if (action == FALSE) {
			/* just check if any entires apply to current page */
			x = TRUE;

			break;
		}

		x += kl->score;
	}

	if (filebuf != NULL)
		filebuf->Resize(filebuf->size - 1);

	unlock();

	return x;
}
