/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "proto.h"
#include <security/pam_appl.h>

struct auth_pam_userinfo {
	char *username, *password;
};

int auth_pam_talker(int num_msg, const struct pam_message **msg, struct pam_response **resp, void *appdata_ptr)
{
	int i;
	struct pam_response *response;
	struct auth_pam_userinfo *userinfo = (struct auth_pam_userinfo *) appdata_ptr;

	response = (pam_response*)xmalloc(num_msg * sizeof(struct pam_response));

	for (i = 0; i < num_msg; i++) {
		response[i].resp_retcode = 0;
		response[i].resp = xstrdup(userinfo->password);
	}

	*resp = response;

	return PAM_SUCCESS;
}

int auth_pam(char *username, char *password)
{
	int ret;
	struct auth_pam_userinfo userinfo;
	pam_handle_t *pamh;
	struct pam_conv pconv;

	userinfo.username = username;
	userinfo.password = password;

	pconv.conv = auth_pam_talker;
	pconv.appdata_ptr = &userinfo;

	ret = pam_start("mman", userinfo.username, &pconv, &pamh);
	if (ret != PAM_SUCCESS)
		return FALSE;

	ret = pam_authenticate(pamh, PAM_DISALLOW_NULL_AUTHTOK);
	if (ret != PAM_SUCCESS)
		goto finish;

	ret = pam_acct_mgmt(pamh, PAM_DISALLOW_NULL_AUTHTOK);

      finish:
	pam_end(pamh, PAM_SUCCESS);

	return (ret == PAM_SUCCESS) ? TRUE : FALSE;
}
