/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdio.h>
#include <string.h>
#include "proto.h"

extern GeneralSection *general_section;

RewriteSection::RewriteSection():
     Section("rewrite", RWLOCK),
     enabled  (field_vec[0].int_value)
{
}

void RewriteSection::update()
{
	rewrite_list.clear();

	ItemList::iterator item;
	for (item = sub_vec[0].item_list.begin(); item != sub_vec[0].item_list.end(); item++)
		rewrite_list.push_back(Rewrite(*item));
	
}


Rewrite::Rewrite(const Item& item):
     enabled  (item.field_vec[0].int_value),
     comment  (item.field_vec[1].string_value),
     profiles (item.field_vec[2].string_list_value),
     mime     (item.field_vec[3].string_value),
     size     (item.field_vec[4].int_value),
     pattern  (item.field_vec[5].string_value),
     replace  (item.field_vec[6].string_value),
     which    (item.field_vec[7].int_value)
{
	pe = (pattern != "") ? reg_sub_compile(pattern.c_str(), PCREFLAGS) : NULL;
	me = (mime != "") ? reg_compile(mime.c_str(), REGFLAGS) : NULL;
	
}

Rewrite::Rewrite(const Rewrite& r):
     enabled  (r.enabled),
     comment  (r.comment),
     profiles (r.profiles),
     mime     (r.mime),
     size     (r.size),
     pattern  (r.pattern),
     replace  (r.replace),
     which    (r.which)
{
	pe = (pattern != "") ? reg_sub_compile(pattern.c_str(), PCREFLAGS) : NULL;
	me = (mime != "") ? reg_compile(mime.c_str(), REGFLAGS) : NULL;
	
}

Rewrite::~Rewrite()
{
	if (pe != NULL)
		reg_sub_free(pe);
	if (me != NULL)
		reg_free(me);	
}

/*
remove areas of text matching patterns in REWRITE_LIST-type struct, and possibly
replace with something else
*/
int RewriteSection::rewrite_do(CONNECTION * connection, Filebuf * filebuf, int flags, int action)
{
	int x = FALSE, ret;
	unsigned int maxbuffer, tmp;

	if (connection->bypass & FEATURE_REWRITE)
		return FALSE;

	read_lock();

	if (this->enabled == FALSE) {
		unlock();

		return FALSE;
	}

        maxbuffer = general_section->maxbuffer_get();

	RewriteList::const_iterator rewrite;
	for (rewrite = rewrite_list.begin(); rewrite != rewrite_list.end(); rewrite++) {
		if (rewrite->enabled == FALSE)
			continue;

		if (!(rewrite->which & flags))
			continue;

		if (!profile_find(connection->profiles, rewrite->profiles))
			continue;

		if (connection->header != NULL) {
			if (flags == REWRITE_BODY && rewrite->me != NULL && connection->rheader->content_type != NULL) {
				ret = reg_exec(rewrite->me, connection->rheader->content_type);
				if (ret)
					continue;
			} else if (rewrite->me != NULL) {
				ret = reg_exec(rewrite->me, "");
				if (ret)
					continue;
			}

                        if (rewrite->size != 0) {
                            tmp = (rewrite->size == -1)? maxbuffer : rewrite->size;
                                
                            if (action == FALSE) {
                                if (connection->rheader->content_length > tmp)
                                    continue;
                            } else {
                                if (!(connection->rheader->flags & HEADER_CL) || connection->rheader->content_length > tmp)
                                    continue;
                            }
                        }
		}

		if (rewrite->pe != NULL) {
			x = TRUE;

			if (action == FALSE)
				break;

			reg_replace(filebuf, rewrite->pe, rewrite->replace.c_str());
		}
	}

	unlock();

	return x;
}
