/*
    MiddleMan filtering proxy server
    Copyright (C) 2002-2004  Jason McLaughlin
    Copyright (C) 2003  Riadh Elloumi

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "proto.h"

extern char pidfile[256];
extern GLOBAL *global;
extern CacheSection *cache_section;

#ifdef _DEBUG
/*
 * Clean global memory for malloc debugging
 */

void sighup()
{
	logbuffer_clear(global->logbuffer);
	pool_clean(global->pool, 1);
	cache_section->force_clean();

	pthread_mutex_lock(&global->dns_cache_lock);
	hash_destroy(global->dns_cache);
	pthread_mutex_unlock(&global->dns_cache_lock);
}
#endif

static void sigterm(int x)
{
	unlink(pidfile);
	exit(0);
}

/*
these signals need to be ignored for various reasons
*/
void signal_setup()
{
	struct sigaction sa;
	struct sigaction saterm;
#ifdef _DEBUG
	struct sigaction sahup;
#endif

	sa.sa_flags = SA_RESTART;
	sa.sa_handler = SIG_IGN;

	saterm.sa_flags = SA_RESTART;
	saterm.sa_handler = (void (*) (int))sigterm;

#ifdef _DEBUG
	sahup.sa_flags = SA_RESTART;
	sahup.sa_handler = (void (*) (int))sighup;

	sigaction(SIGHUP, &sahup, NULL);
#else
	sigaction(SIGHUP, &sa, NULL);
#endif

	sigaction(SIGTERM, &saterm, NULL);
	sigaction(SIGPIPE, &sa, NULL);
	sigaction(SIGALRM, &sa, NULL);
}
