#
# $Id: mindi.spec 936 2006-11-16 01:17:27Z bruno $
#
Summary:	Mindi creates emergency boot disks/CDs using your kernel, tools and modules
Name:		mindi
Version:	1.2.2
Release:	1.suse10.0
License:	GPL
Group:		Productivity/Archiving/Backup
Url:		http://www.mondorescue.org
Source:		ftp://ftp.mondorescue.org/src/%{name}-%{version}.tar.bz2
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(id -u -n)
ExcludeArch: ppc
Requires:	bzip2 >= 0.9, mkisofs, ncurses, binutils, gawk, dosfstools, mindi-busybox , syslinux

# Not on all systems
#Conflicts:	bonnie++

%description
Mindi takes your kernel, modules, tools and libraries, and puts them on N
bootable disks (or 1 bootable CD image). You may then boot from the disks/CD
and do system maintenance - e.g. format partitions, backup/restore data,
verify packages, etc.

%prep
%setup -n %name-%{version}

%build
%ifarch ia64
%{__make} -f Makefile.parted2fdisk clean
%{__make} -f Makefile.parted2fdisk
%endif

%install
%{__rm}  -rf $RPM_BUILD_ROOT
export DONT_RELINK=1

export HEAD=${RPM_BUILD_ROOT}
export PREFIX=%{_exec_prefix}
# Bug on x86_64 on _sysconfdir on rhel4 at least
%ifarch x86_64
export CONFDIR=/etc
%else
export CONFDIR=%{_sysconfdir}
%endif
export MANDIR=%{_mandir}
export DOCDIR=%{_docdir}
export LIBDIR=%{_libdir}
export RPMBUILDMINDI="true"

./install.sh

%clean
%{__rm} -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%config(noreplace) %{_sysconfdir}/mindi/deplist.txt 
%doc ChangeLog INSTALL COPYING README TODO README.ia64 README.pxe README.busybox svn.log
%{_mandir}/man8/*
%{_libdir}/mindi
%{_sbindir}/*

%changelog
* Mon Apr 16 2007 Bruno Cornec <bruno@mondorescue.org> 1.2.2-1.suse10.0
- Updated to 1.2.2
- Add support for new megaraid driver (HP NetServers with 2.6) (P.C.J.G.Brunier)
- Add support for adpahci (Proliant DL 140 G3 - SATA) (Abhijit Das/Bruno Cornec)
- Mindi log file is now added to mondoarchive log file to ease debug (Bruno Cornec)
- Suppress losetup usage in start-nfs (unreliable and doesn't work with QEMU (Bruno Cornec)
- Fix a bug where losetup is called with only one parameter (#140) (Bruno Cornec)
- Fix a bug on NFS in FC6 - fscache module needed (Bruno Cornec)
- Add build support for Mandriva 2007.1, RREL 5 and Debian 4.0 (Bruno Cornec)
- Fix a bug for FC6 where the boot disk size was again insufficient (Rene Ribaud/Bruno Cornec)
- On CentOS 4.4 mdrun isn't available anymore so init should use mdadm instead (Momtchil Momtchev/Bruno Cornec)
- Add support for raid456 driver (Mark Nienberg/Bruno Cornec)
- Add the DENY_MODS variable in mindi allowing to describes modules that you don't want to include as part of the restore boot environment (HP Open Call OCMP e.g; needs it) (Bruno Cornec)
- Add GetInitrdFilesystemToUse function to support initramfs type of initrd (SuSE 10.2/Debian 3.x/FC 6/...) (Andree Leidenfrost)
- Fix a bug for ia64 in kernel reference in elilo.conf (Andree Leidenfrost)
- Check that /boot/efi is mounted on ia64 (Andree Leidenfrost)
- Protect some rm -rf to avoid raw removals (Bruno Cornec)
- Better messages for analyze-my-lvm (Bruno Cornec)
- Add support for newer Qlogic drivers (qla2300 & 2400), mpt, dm and ohci (Josef Jetzinger/Bruno Cornec)
- Fix a bug in mindi for the FAILSAFE support (Scott Cummings)
- PATH fixed for init in restore (/usr/games added for petris) (Andree Leidenfrost)
- Fiw a bug where restore failing because no archive files are found when -G is used (Andree Leidenfrost)
- /media is now completely excluded as per StandardsCompliance (Bruno Cornec)

* Sat Dec 23 2006 Bruno Cornec <bruno@mondorescue.org> 1.2.1-1.suse10.0
- Updated to 1.2.1
- mindi now supports a configuration file (Bruno Cornec)
- Fix again support for LABEL on swap partitions (Bruno Cornec)
- mindi now prints mindi-busybox version (Bruno Cornec)
- mindi now supports gzip compression format (#113) (Bruno Cornec)
- Inline code of some useless functions for readability (Bruno Cornec)
- Add support for nvidia and ahci drivers (Bruno Cornec)
- Remove wrong full path name for cut (Matija Nalis/Bruno Cornec)
- UUID support (Bruno Cornec)
- Cleaner messages generated on screen (with defaults) and in logs (Bruno Cornec)
- First use of a configuration file with mindi to permit variable to be overwritten (Bruno Cornec)
- All temporary files are now under MINDI_TMP, unique dir under /tmp by default and not removed when called by mondo (Bruno Cornec)
- All generated files are now under CACHE_LOC, /var/cache/mindi by default (Bruno Cornec)
- Fix bug #100 where the temporary dir could be removed and be /home (Matija Nalis/Bruno Cornec)
- Should now work correctly under x86_64 distributions (Bruno Cornec)
- Fix a blocking bug in mindi where a " was misplaced (Bruno Cornec)
- New MindiExit function called everywhere (Bruno Cornec)
- TAG is now per package (Bruno Cornec)
- Add CentOS build support (Andy Wright/Bruno Cornec)
- Removal of grep -w|-x during restore as not supported by busybox fixes bug #101 (Alfred Chua/Bruno Cornec)
- init now reports the mindi version when executed (Bruno Cornec)

* Wed Oct 04 2006 Bruno Cornec <bruno@mondorescue.org> 1.2.0-1.suse10.0
- Updated to 1.2.0
- busybox is now a separate package and binaries are not provided anymore in mindi - Fix #37 (Bruno Cornec)
- deplist.txt adapted to use more busybox modules (Bruno Cornec)
- start-nfs now exports variables taken from PXE command line to mondo to override parameters during archiving - Fix bug #21 (Bruno Cornec)
- Fix for bug #71 mindi now works correctly on x86_64 (Brendan Bouffler/Bruno Cornec)
- ReadAllLink function added to mindi and 3 older functions suppressed + use of readlink where useful (Bruno Cornec)
- Other fixes for labelled swap support (Michael Shapiro/Bruno Cornec)
- Fix for bug #4 (B. Baumer)
- Fix PXE documentation (Brendan Bouffler)
- Attempt to fix bug #25 - bonding support (Michael Shapiro/Bruno Cornec)
- Write start and finish time to log - Fix bug #33 (Bruno Cornec)
- Fix for bug #46 (Klaus Ade Johnstad)

* Sat Aug 05 2006 Bruno Cornec <bruno@mondorescue.org> 1.0.9-1.suse10.0
- Updated to 1.0.9
- Fix for bug #22 RHEL4 + LVM + LABEL support (Bruno Cornec)
- Fix for bug #8 keyboard support incorrect (Bruno Cornec)
- New NFS/PXE support. start-nfs is now a fixed script. Allow more possibilities at restore time (Bruno Cornec)
- new global variables + Bug fixes for LVM (Bruno Cornec)
- SuSE RPMS now use bzip2 (Lars Rupp/Bruno Cornec)
- Fix a bug for filesystems with LABEL in fstab not mounted (Bruno Cornec)
- Qlogic 2300 and 2200 are now supported (Bruno Cornec)
- Use busybox 1.1.3 for net part (Bruno Cornec)
- Fix various screen corruption for 'Configure LVM' (Andree Leidenfrost)
- Fix Adaptec Zero-Channel RAID Cards support bug #6455 (Bruno Cornec)
- Fix a bug with redhat_label not initialized in the loop systematically
(Anthony P. Machon/Bruno Cornec)
- nfsmount option added to allow redeployment from another NFS server (Bruno Cornec)
- Replaced all occurrences of egrep with 'grep -E' and of fgrep with 'grep -F' (Andree Leidenfrost)
- Fix a bug in analyze-my-lvm for RHEL3 where vgdisplay prints an additional
field sometimes (#) (severine.lombardo_at_acoss.fr/Bruno Cornec)
- Deal properly with LVM tool lvmiopversion and with lvmcreate_initrd and pvdata - fixes [[debianBTS(351687)]] (Andree Leidenfrost)
- Handle the format /dev/mapper/<VG>-<LV> for LVM devices - fix for [[debianBTS(362926)]] (Andree Leidenfrost)

* Wed Jun 07 2006 Bruno Cornec <bruno@mondorescue.org> 1.0.8-3.suse10.0
- Updated to 1.0.8-3
- exec-shield removed for mindi (Bruno Cornec)
- Fix a bug for ia64 build in mindi where locallib was undefined (Bruno Cornec)
- Fix a bug for SuSE and Debian where $dfam was used in install.sh (Bruno Cornec)
- Make the init script mdadm-aware (Andree Leidenfrost)

* Fri Jun 02 2006 Bruno Cornec <bruno@mondorescue.org> 1.0.8-2.suse10.0
- Updated to 1.0.8-2
- Fix bugs in the swap+LABEL code found on rhel4 (Peter Naber/Bruno Cornec)
- PXE mode now supports change of NIC for redeployment (Bruno Cornec)

* Thu May 25 2006 Bruno Cornec <bruno@mondorescue.org> 1.0.8-1.suse10.0
- Updated to 1.0.8-1
- new build process (Bruno Cornec)
- Fix a bug when a disk less than 2.8 MB can be built, to include enough modules to support SCSI cds (Bruno Cornec)
- Fix a bug in .spec for RPM build (%attr now unused) (Bruno Cornec)
- Add support for LABEL on swap partitions (Michel Loiseleur + Julien Pinon)
- Attempt to fix bug 6827 (addition of a script for busybox udhcpc to support pxe/dhcp restore) (Bruno Cornec)
- support of dm and LVM v2 (Andree Leidenfrost)
- analyze-my-lvm is under $MINDI_LIB (Andree Leidenfrost)
- Fix a bug introduced by trying to avoid an error message when modprobe.d doesn't exist (Johannes Franken)
- Fix for Bug #6975 (/net is now excluded from kernel search location) (Bruno Cornec)
- Allow 5670 MB fllopy disks for lilo as well (Bruno Cornec)
- Add missing net modules (Klaus Ade Johnstad)

* Fri Mar 10 2006 Bruno Cornec <bruno@mondorescue.org> 1.0.7-1.suse10.0
- Updated to 1.0.7
- Fix issue for 2.6 kernels with VIA chipsets (Andree Leidenfrost)
- stop creating further size of floppy disks if the smaller one succeeds (Bruno Cornec)
- init revamped (removed unnecessary second general module loading phase, start NFS appropriately depending on PXE or simple NFS) (Andree Leidenfrost)
- Changed module 'nfsacl' to 'nfs_acl' (Andree Leidenfrost)
- Mindi/DiskSize is gone (Bruno Cornec)
- useless cat, sort|uniq commands removed (Bruno Cornec/Sébastien Aperghis-Tramoni)
- Doc cleanup (Andree Leidenfrost)
- Bug fix for chown in install.sh (JeffS)
- CHANGES renamed also in install.sh now (Bruno Cornec)
- rpmlint cleanups
- Get mindi to look for analyze-my-lvm in it's library directory MINDI_LIB (See also [[debianBTS(351446)]].)
- mindi only deletes freshly created 1440kb images in case of error (See also [[debianBTS(348966)]].) (Andree Leidenfrost)
- try standard grub-install in grub-MR restore script before trying anything fancy (Andree Leidenfrost)
- busybox mount should be called with -o ro for PXE (Make RHEL 3 works in PXE
with a 2.6 failsafe kernel now available) (Bruno Cornec)
- Fix mindi for 2.6 Failsafe support (Bruno Cornec)
- mindi now depends on grep >= 2.5 (for -m option) (Marco Puggelli/Bruno Cornec)
- Fix a bug in LVM context for RHEL4 in GetValueFromField (Rémi Bondoin/Bruno Cornec)
- New RPM Build environement (Bruno Cornec)
- mindi now supports x86_64 natively (Bruno Cornec)
- stop creating further size of floppy disks if the smaller one succeeds (Bruno Cornec)

* Fri Dec 23 2005 Bruno Cornec <bruno@mondorescue.org> 1.06-1.suse10.0
- Updated to 1.06
- mindi manpage added (Andree Leidenfrost)
- clean up remaining mount points, mindi.err at the end (Wolfgang Rosenauer)
- fix bugs for SuSE distro around tar, tr and find arguments order (Wolfgang Rosenauer)
- new busybox.net version used for better PXE support (Bruno Cornec)
- USB keyboard support (Bruno Cornec)
- -p should now work with ISO/PXE/NFS modes (Bruno Cornec)
- relocate what was under /usr/share to /usr/lib (FHS compliance) (Bruno Cornec/Andree Leidenfrost)
- manage non ambiguous delivery under /usr (packages) or /usr/local (tar ball) (Bruno Cornec)
- install script rewritten and used for RPM build, with new layout (Sébastien Aperghis-Tramoni/Bruno Cornec)
- use parted2fdisk everywhere (Bruno Cornec)
- use MONDO_LIB exported by mondoarchive instead of MONDO_HOME guessed (Bruno Cornec)
- RPM build for fedora core 4, sles9, redhat 7.3, rhel 3/4, mandriva 2006.0, mandrake 10.2/10.1 (Bruno Cornec/Gary Granger)
- VERSION/RELEASE Tag added (Bruno Cornec)
- VMPlayer support
- Code cleanup, small fixes, PXE/NFS code improvements (Wolfgang Rosenauer/Sébastien Aperghis-Tramoni/Bruno Cornec
- New switches for PXE mode (ping & ipconf, Cf README.pxe) (Sébastien Aperghis-Tramoni/Bruno Cornec)
- mindi-kernel added to SVN (Bruno Cornec)

* Sat Nov 19 2005 Bruno Cornec <bruno@mondorescue.org> 1.05-1.suse10.0
- Updated to 1.05
- Bug fix for ldd output incorrectly handled, leading to "grep not found" error (Andree Leidenfrost)
- NFS now works in interactive mode, and nolock problems are solve (Andree Leidenfrost)
- IA-64 support is now working for rhel 3 (Bruno Cornec)
- add MINDI_CONF to the mindi LOGFILE (Philippe De Muyter)
- Speed up fdisk'ing dev/ida raid devices (Philippe De Muyter)

* Tue May 03 2005 Bruno Cornec <bruno@mondorescue.org> 1.04-1.suse10.0
- Updated to 1.04
- support exec-shield
- added 'ide-generic' module to IDE modules in mindi to ensure that kernels with fully modularised IDE sub-system boot
- rewrote script 'wait-for-petris' to ensure that petris actually starts and can be restarted reliably
- fixed syntax error in mindi where a wrong delimiter is used in and sed call when processing file '/etc/issue.net'
- removed '#!/bin/bash' from file 'rootfs/etc/bashrc' (bashrc get sourced, not executed)
- removed executable flag from:
- 'rootfs/etc/ld.so.cache'
- 'rootfs/root/.profile'

* Wed Sep 29 2004 Bruno Cornec <bruno@mondorescue.org> 1.03-1.suse10.0
- Updated to 1.03
- better support of SLES 8

* Wed Jul 21 2004 Bruno Cornec <bruno@mondorescue.org> 1.02-1.suse10.0
- Updated to 1.02
- better kernel-level logging
- added ACL, xattr binaries to deplist.txt
- fixed obscure bug which occasionally stopped mindi from correctly finding and documenting all LVM2 LVM-on-RAID volumes 
1.01 (2004-06-21)
- added ide_tape and other modules to mindi's config detection
- unmount errant ramdisk ($mtpt) if fail to create boot floppy
- better support of ISO dirs at restore-time (Conor Daly)

* Fri Jun 18 2004 Bruno Cornec <bruno@mondorescue.org> 1.00-1.suse10.0
- Updated to 1.00
- first 1.0x release
- catch Ctrl-Alt-Del; trigger soft reset
- better support of SuSE 9.1
- added mdadm to deplist.txt
- better detection of multiple Mindis (Martin FÃ¼rstenau)
- don't complain if just a Mindi boot CD & not a platform for Mondo
- updated busybox to 1.0.0pre10
- removed uClibc
- add memtest support
- 2.6 kernel support
- removed Embleer files (Andree Leidenfrost)
- LVM v2 support for 2.6 (Takeru Komoriya)
- added kernel-only floppy support, to accommodate really big kernels
- updated+rebuilt busybox
- added star support
- mount /sys at boot-time
- better 64-bit and 2.6 kernel support
- better LVM, failsafe kernel support (Jim Richard)
- use LILO, not raw kernel, on 1.4MB boot floppy
- record names of unsaved modules for future reference
- enlarged ramdisk by 8MB

* Thu Mar 25 2004 Bruno Cornec <bruno@mondorescue.org> 0.95-1.suse10.0
- Updated to 0.95
- changed some '==' to '=' --- now more RH6-friendly
- allow absolute pathnames again in deplist
- disable multifunc cd thing
- better Gentoo support (Bill)
- better OnStream support
- better Slackware support (Laurenz)
- added partimagehack-static to deplist.txt
- recompiled Busybox - 10k smaller, better stack-handling
- fixed boot screen typo
- added support for 'auto' fs format
- better devfs support for Mandrake users
- better Debian+LVM support (Ralph Grewe)
- updated analyze-my-lvm to handle floating-point gigabyte -L values

* Wed Sep 24 2003 Bruno Cornec <bruno@mondorescue.org> 0.94-1.suse10.0
- Updated to 0.94
- altered rootfs's /dev entry to stop cvs from becoming confused
- tweaked MAX_COMPRESSED_SIZE
- added multi-function CD support to mindi and sbin/post-init
- re-mount root as rw just in case
- ask user to remove last data (floppy) disk if nec. (Tom Mortell)
- added support for 5th column in mountlist.txt for labels
- added symlinks.tgz
- suppress erroneous error messages re: failsafe kernel

* Wed Jun 04 2003 Bruno Cornec <bruno@mondorescue.org> 0.93-1.suse10.0
- Updated to 0.93
- added cciss.o to SCSI_MODS
- if format type is (e.g.) ext3,ext2 then use 1st entry
- re-enabled fsck*
- if cciss in use then enable it at boot-time
- added /dev/ataraid/* to boot disk via ataraid.tgz (Luc S.)
- better ISO support
- tweaked mindi to use 10-15% fewer floppies
- added RUN_AFTER_INITIAL_BOOT_PHASE var at start of Mindi, which user may use to force Mindi to run command before bootstrapping to aux data disks or CD - e.g. 'echo engage > /proc/scsi/something'
- allow for Debian & other Stiefkinder that use 'none', not 'swap' as the mountpoint of the swap partition
- removed afio dependency
- added RUN_AFTER_BOOT_PHASE_COMPLETE to let user specify a command to be run by Mindi after it boots but before it runs mondorestore
- re-worked install.sh and tarball not to use tgz's
- cleared up the boot msg
- updated busybox to 0.60.5; updated uClibc to 0.9.19
- add #!/bin/sh to start of insert-all-my-modules
- fixed obscure bug in install-additional-tools
- change grep -m1 to grep | head -n1, for Debian users
- moved lib.tar.bz2 and vmlinuz to mindi-kernel tarball/rpm

* Sun May 04 2003 Bruno Cornec <bruno@mondorescue.org> 0.92-1.suse10.0
- Updated to 0.92
- fixed LVM/RAID bugs (Brian Borgeson)
- if bad lilo, give more verbose error before quitting
- added mt and perl to deplist.txt
- insmod ide-cd, cdrom, isofs, just in case
- boot-time tmpfs ramdisk is now 40m (was 34m)
- cleaned up logs
- iso mode now calls Interactive
- make SizeOfPartition() more Debian-friendly (Andree Leidenfrost)
- clean up some calls to grep, esp. partition_mountpt=...
- corrected some bashisms, to suit Debian ped- er, users
- made first line refer to bash, not sh, to make sure the Debian people know Mindi requires bash, not hs
- changed grep -v "#" and grep -vx "#.*" to grep -vx " *#.*"
- disabled code which would make Mindi use sfdisk instead of fdisk if it looked as if Debian's fdisk would misbehave

* Fri Apr 04 2003 Bruno Cornec <bruno@mondorescue.org> 0.91-1.suse10.0
- Updated to 0.91
- updated ResolveSoftlinks() to work better with b0rkn Gentoo devfs /dev
- patched analyze-my-lvm (Benjamin Mampaey)
- detect built-in boot.b files in lilo
- return w/err, don't abort, if Matt Nelson's RH8 system is farked
- better at finding isolinux.bin
- better at analyzing dependencies when running on broken distributions
- try harder to boot from CD, even if tape fails
- added ADDITIONAL_BOOT_PARAMS to be sent to kernel
- better resolution of relative softlinks, leading to fewer duplicates on data disks and therefore fewer data disks
- detect Debian+devfs; use sfdisk instead of fdisk in that eventuality, to work around yet another of Debian's warts
- removed /lib/libuuid.* from rootfs.tgz
- fixed vi
- mindi now uses gawk --traditional (making gawk behave in a functionally identical way to awk) - PASS; great, so now Debian needs to fix its awk :)
- removed / from list of dirs accessed when trying to resolve deplist entry
- spinner bugfix; handle odd LABELs properly (Tom Mortell)

* Sun Dec 08 2002 Bruno Cornec <bruno@mondorescue.org> 0.90-1.suse10.0
- Updated to 0.90
- new stable branch
- EXTRA_SPACE=16384
- fixed deplist.txt

* Mon Dec 02 2002 Bruno Cornec <bruno@mondorescue.org> 0.72-1.suse10.0
- Updated to 0.72
- misc code clean-ups
- save boot device's boot sector
- detect and beware Compaq diagnostic partitions
- better handling of devfs V non-devfs kernels and boot devs
- trimmed to busybox 0.60.3 binary on boot disk
- mindi now resides in /usr/local/bin
- removed lilo from dependencies
- more Gentoo-friendly

* Sun Nov 17 2002 Bruno Cornec <bruno@mondorescue.org> 0.71-1.suse10.0
- Updated to 0.71
- if your kernel's builddate doesn't match any of the kernels in your /boot directory then fudge the issue & find the closest match (*grumble* Debian)
- scan tape & CD at start, to force inclusion of modules on boot device
- double EXTRA_SPACE if >7 disks
- slimmer, more lithesome logfile
- now accepts --findkernel
- line 1982 - dd count=24000 should be count=$ramdisksize (Andras Korn)
- better handling of non-Linux partitions on DevFS-enabled kernels
- fixed Debian/ramdisksize/bloat problem (Johannes Franken)
- fixed 2.4.20/fdisk eccentricity (Alistair Stevens)
- updated kernel to 2.4.18-mdk6
- generate mountlist in dev-abetical order ;)
- fixed minor bug in .spec file
- better at finding /boot/boot.b if your distro breaks the de facto standard
- fixed minor bug in MakeMountlist
- fixed install.sh
- cleaned up deplist.txt
- added rudimentary -v / -version flag
- line 1180 or so --- duplicate mindi.iso entires --- fixed
- added /bin/[ - a softlink to /bin/sh
- ListAllPartitions() - sanity fix (KP)
- fixed .spec bug
- better feedback
- added Markus's RAID patch
- ListAllPartitions() - include /mnt/win* (Hugo)

* Sun Sep 08 2002 Bruno Cornec <bruno@mondorescue.org> 0.70-1.suse10.0
- Updated to 0.70
- better logging by dependency-calculating code
- better handling of dependencies, specifically softlinks
- if called by mondo then use mondo's temp dir as our temp dir too
- changed gawk to $AWK in a few places, to allow for Debian
- added host* config files to deplist
- added tftp, ifconfig to busybox
- added RPC support to uClibc
- cleaned up creation of Mondo-Mindi configuration file
- fixed bug in TryToFindKernelPath which stopped it from handling multiple, same-version kernels gracefully
- cleaned up deplist.txt
- receive 'DIFFERENTIAL' variable from Mondo
- better Debian compatibility, esp. w/detection of ver# (Hector Alvarez)
- better devfs support; call fgrep in places instead of grep (Andrew Korn)
- fixed analyze-my-lvm (Ralph Gruwe)

* Sun Jul 14 2002 Bruno Cornec <bruno@mondorescue.org> 0.65-1.suse10.0
- Updated to 0.65-1
- moved 50K of stuff from rootfs.tgz to aux-tools.tgz
- added x11-tools.tgz option
- updated /dev/console and /dev/tty0 (Paul Stevens)
- cleaned up /mnt/groovy-stuff V /tmp/tmpfs code
- catch sigint, sighup, etc.
- fixed LILO-related message.txt mistake
- .spec file clean-up; automation; config file (Carl Wilhem Soderstrom)

* Sat Jul 13 2002 Bruno Cornec <bruno@mondorescue.org> 0.64-1.suse10.0
- Updated to 0.64-1
- fixed RH7.3 readonly bug
- improved nfs config file creation
- search more locations for isolinux.bin
- added isonuke option
- faster data disk creation
- better DevFS support (Hector Alvarez, DuckX)
- nfs-related fix (Hans Lie)
- abort if vfat filesystem present but mkfs.vfat missing
- removed softlink to pico
- allow Mondo to say no compression will be used
- added [ to ramdisk
- tar data disks with -b [block size] of 32k
- don't autoboot to 'RESTORE' screen - it's scary!
- let user choose lilo or syslinux as boot loader
- added syslinux support
- cleaned up message screens

* Tue Jun 04 2002 Bruno Cornec <bruno@mondorescue.org> 0.63-7.suse10.0
- Updated to 0.63-7
- improved logging

* Sun Jun 02 2002 Bruno Cornec <bruno@mondorescue.org> 0.63-6.suse10.0
- Updated to 0.63-6
- sped it up a bit
- fixed ISO creation bug

* Wed May 22 2002 Bruno Cornec <bruno@mondorescue.org> 0.63-5.suse10.0
- Updated to 0.63-5
- fixed RAID mountlist bug (Daniel Grandjean)
- better at German kbd support (Klaus Guntermann)
- no longer abort if MONDO_PATH cannot be discerned
- updated .spec file (Jesse Keating)

* Mon May 06 2002 Bruno Cornec <bruno@mondorescue.org> 0.63-4.suse10.0
- Updated to 0.63-4
- added less.bin to deplist.txt
- copy mondo-restore.cfg configuration file to /var/cache/mondo-archive
- increased EXTRA_SPACE to 16384
- fixed bug in -H (RESTORE) function

* Thu Apr 25 2002 Bruno Cornec <bruno@mondorescue.org> 0.63-2.suse10.0
- Updated to 0.63-2
- added mkdir -p to fix mountlist.txt-copying bug (Bruno Vidal)
- made sure mindi.iso (for tape users) copies kernel to [cd dir]/vmlinuz

* Tue Apr 23 2002 Bruno Cornec <bruno@mondorescue.org> 0.63-1.suse10.0
- Updated to 0.63
- minor cosmetic improvements
- improved homedir-locating code
- make sure the kernel is copied to [cd build dir]/vmlinuz

* Mon Apr 08 2002 Bruno Cornec <bruno@mondorescue.org> 0.62-1.suse10.0
- Updated to 0.62
- keep certain /dev directories compressed until boot-time, to allow Mindi to support larger kernels
- cleaned up logging a lot
- better detection of the kernel currently in use
- added /dev/nst* to ramdisk
- amend isolinux.cfg to specify the correct ramdisk size

* Sun Mar 31 2002 Bruno Cornec <bruno@mondorescue.org> 0.60-1.suse10.0
- Updated to 0.60
- bootable CD's now use ISOLINUX instead of LILO (Andy Glass)
- abort if isolinux not found
- abort if multiple copies of Mindi found lying around
- include mountlist.txt in ramdisk

* Thu Mar 21 2002 Bruno Cornec <bruno@mondorescue.org> 0.59-1.suse10.0
- Updated to 0.59
- change sbin/init's Die() function (Carl Wilhelm Soderstrom)
- improve friendliness of kernel-related warning msg (Andy Glass)
- added s/w switch re: making floppies (Carl Wilhelm Soderstrom)

* Sun Mar 10 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-r7.suse10.0
- Updated to 0.58-r7
- excluded two unused vars (Carl Soderstrom)

* Sun Mar 03 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-r6.suse10.0
- Updated to 0.58-r6
- reassemble large data/library files who have older 'mv' code which doesn't like to overwrite symlinks - affects older RH+Slack systems (Andrew Bulhak)
- call /usr/bin/logger, not 'logger', in LogIt()
- run chmod 755 which start-nfs` before running start-nfs

* Sun Feb 24 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-r5.suse10.0
- Updated to 0.58-r5
- pathname problem fixed (Fred Feirtag)
- patch to Debianize mindi a bit (Hï¿½tor Garcï¿½ ï¿½varez)
- removed mondo-manual.html
- moved /dev/{cciss,ida,rd} from rootfs.tgz to aux-tools.tgz
- cleaned up the refs to analyze-my-lvm a bit (Hugo)
- sped up disk-creation by 20-30%
- make sure mondo-restore.cfg is on data disk as well as boot disk
- added support for -C (cdstream) mode

* Mon Feb 18 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-r4.suse10.0
- Updated to 0.58-r4
- quash error if /opt not found
- use /tmp/groovy-stuff instead of /mnt/groovy-stuff for handling data disks and their contents, for tape users

* Sun Feb 17 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-r3.suse10.0
- Updated to 0.58-r3
- misc enhancements
- uses self-resizing ramdisk (tmpfs) for /tmp
- allows Mondo to exclude certain devices from mountlist
- incorporated .spec patch (Ian Kent)
- replaced &> /dev/null with > /dev/null 2> /dev/null
- added vi to busybox again

* Mon Feb 11 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-r2.suse10.0
- Updated to 0.58-r2
- fixed errant tar warning
- replaced libc5 with uClibc
- compiled busybox and open against uClibc
- moved minor scripts+tools from rootfs.tgz to aux-tools.tgz
- Mindi can now accommodate a kernel of up to 1290KB in size
- no longer insists on cdrecord being present

* Sun Feb 10 2002 Bruno Cornec <bruno@mondorescue.org> 0.58-1.suse10.0
- Updated to 0.58
- more pointed error messages
- fixed silly 'cp error (Markus Marquardt)
- use type C's embleer file for type B Windows partitions
- increased EXTRA_SPACE from 4096 to 8192
- cosmetic bugfixes
- nfs users boot into nfs options by default

* Tue Feb 05 2002 Bruno Cornec <bruno@mondorescue.org> 0.57-1.suse10.0
- Updated to 0.57
- abort if mounted partition is specified as an imagedev
- understand 'FAILSAFE' as kernel alternative
- added analyze-my-lvm to tools available thru PATH
- better discovery of locale and keymap file (Claude Mahï¿½
- compatible with 1.2x and the new 1.38+ stuff
- better 'bug-me' script (Troff)

* Fri Feb 01 2002 Bruno Cornec <bruno@mondorescue.org> 0.56-1.suse10.0
- Updated to 0.56
- compatible with Mondo v1.5x devel branch
- mindi's softlink now goes in /usr/sbin; was /usr/bin
- include nfs.o, nfsd.o, lockd.o and sunrpc.o on data disks if available
- patched .spec file to make it easier to change installdir (Ian Mortimer)
- updated README
- moved many global vars to start of script
- better at finding US kbd maps
- migrating to a single configuration file, /tmp/mondo-restore.cfg, for Mondo users; file is not in use yet but is there for future expansion

* Mon Jan 28 2002 Bruno Cornec <bruno@mondorescue.org> 0.55-1.suse10.0
- Updated to 0.55
- MINDI_HOME and MONDO_HOME defined at start of each source file, making it easier to relocate Mindi and Mondo if desired
- tries to mount /dev/hd[a-h] at boot-time, looking for CD-ROM; was hd[a-d]
- re-enabled the msg asking user to upgrade LILO if v21.6
- Lin/Win users are much, _much_ less likely to run out of disk space now when restoring from backups (Carlos Molina)
- patch from Andrej Borsenkow to help w/Mandrake 8.1
- disabled ramdisk free space checker (some distros don't like it)

* Fri Jan 25 2002 Bruno Cornec <bruno@mondorescue.org> 0.54-1.suse10.0
- Updated to 0.54
- don't abort if kernel is too big for 1.72MB floppy
- better handling of eccentric distros and their keybd layouts
- cosmetic fixes
- sprinkled comments liberally inside deplist.txt
- added gawk and awk to deplist
- lilo has been added to .spec file
- changed a couple of FatalError()'s to Die()'s
- better TurboLinux 7 / LVM compatibility

* Sun Jan 20 2002 Bruno Cornec <bruno@mondorescue.org> 0.53-1.suse10.0
- Updated to 0.53
- better support of non-Red Hat, non-Debian keyboard resource files
- cleaned up /sbin/init's output
- replaced libc5 mount with user's own 'mount'
- updated embleer.C.bz2
- missing /dev/hdb2 found & replaced (thanks, Troff)
- populated /dev/rd and /dev/ida on ramdisk (Michael Eisenberg)
- improved SizeOfPartition() function
- improved TryToFindKernelPath() function
- don't offer NFS users Nuke Mode
- finds and uses lilo.real if user is using Debian, a distro which installs a shell script where the lilo executable should go
- improved support for XFS users who opt to use failsafe kernel
- uses user's lsmod, depmod, insmod, etc.
- fixed freeze-up resulting from missing 'cat $mappath' command
- mount tmpfs at /tmp/tmpfs for mondo-restore's benefit
- try to create /dev/fd0u1722 if it is missing from /dev
- added .spec file to tarball

* Thu Jan 10 2002 Bruno Cornec <bruno@mondorescue.org> 0.52-2.suse10.0
- Updated to 0.52-2
- fixed a bug in the handling of non-English keyboard maps
- force failsafe kernel to provide reiserfs.o, xfs.o, jfs.o, ext2.o, ext3.o and loop.o at boot-time, just in case
- added /dev/sr[0-3] devices
- copy LAST_FILELIST_NUMBER to /tmp, for compatibility with Mondo v1.3x
- incorporates NFS-related settings, if supplied by Mondo v1.3x
- replace busybox's mount with standard libc5 mount ater restoring tools from floppies: NFS mounting requires full mount
- always make mindi.iso

* Sun Jan 06 2002 Bruno Cornec <bruno@mondorescue.org> 0.52-1.suse10.0
- Updated to 0.52-1
- ramdisk's size has been tweaked
- if script 'bootstrap' is found at boot-time then execute it
- use tty8 to show mondo's output log
- use tty7 to offer a game of Petris (if it exists on disk)
- be sure to use i386-only keymaps
- if LILO's "/tmp/dev.0" error occurs then abort & tell user to reboot
- /sbin and /usr/sbin added temporarily to PATH when Mindi runs
- if Mondo asks then force LILO to run in backward-compatible mode
- if Mondo's tmpdir has post-nuke.tgz in it then extract it and incorporate its files in the data disks
- losetup /dev/loop0 -d before calling LILO (Norm Crowfoot)
- if keyboard mapping dir (usu. /lib/kbd or /usr/lib/kbd) cannot be found then don't abort; simply tell the user the default keyboard mapping will be used
- added /dev/hd[a,b,c,d][17-24] to the rootfs tarball
- won't use LILO's optimizations when creating boot floppy; however, optimizations are used on CD unless --broken-bios in call to Mondo
- won't write data disks to start of tape; lets Mondo do that
- tweaked how Mindi moves all.tar.gz around, to make it more Mondo-friendly
- tweaked Mindi's disk-splitter
- user must unmount /dev/loop0 before calling Mindi: LILO insists...
- added NFS-related entries to deplist.txt
- if not called by Mondo then don't let user choose Interactive/Nuke/ whatever; just offer Expert

* Tue Dec 25 2001 Bruno Cornec <bruno@mondorescue.org> 0.51-1.suse10.0
- Updated to 0.51-1
- removed libm.* from rootfs.tgz
- replaced sh with busybox's ash
- upgraded busybox to 0.60-2; pared it down, too
- include tape-related modules on boot disk, if backing up to tape
- creates a tape-friendly tarball containing tools+modules
- reassembly of tools+libraries is more reliable now
- streamlined deplist.txt
- give user their localized keyboard layout at boot-time
- fix some cosmetic bugs

* Wed Dec 19 2001 Bruno Cornec <bruno@mondorescue.org> 0.50-4.suse10.0
- Updated to 0.50-4
- log Mindi's version# in the event of a fatal error
- make Mindi's boot-time output more esthetically pleasing
- if filesystem is type 'image', according to Mondo, then in filelist its partition type will be listed as the hexadecimal string (e.g.  'b', '83', etc.) and the partition mountpoint will be 'image'

* Sat Dec 15 2001 Bruno Cornec <bruno@mondorescue.org> 0.50-2.suse10.0
- Updated to 0.50-2
- support for newer features in Mondo v1.3x

* Fri Dec 14 2001 Bruno Cornec <bruno@mondorescue.org> 0.50-1.suse10.0
- Updated to 0.50-1
- correctly lists RAID constituent partitions in mountlist
- breaks compatibility with Mondo v1.2x
- if user's fstab has weird line(s) then ignore; don't abort
- working on CDROM_MODS, trying to make it work on Stewart Charnell's hardware setup
- cleaned up /sbin/init and /sbin/post-init a bit

* Sun Dec 09 2001 Bruno Cornec <bruno@mondorescue.org> 0.48-2.suse10.0
- Updated to 0.48-2
- when insmod'g modules from ramdisk's root dir, use 'ls /*.o*' (was 'ls /*.*') to find them
- if RAID controller(s) are detected then pause for 10s to let them intialize by themselves (some 3ware RAID controllers require this)
- cleaned up /sbin/init and /sbin/post-ini; the former now controls initialization of hardware, drivers, tools, etc. and the latter runs mondo-restore if it exists
- better detection of and compatibility with SCSI CD-ROM drives
- chopsize is now 64KB; was 128KB
- cleaned up mindi's logging

* Sat Dec 08 2001 Bruno Cornec <bruno@mondorescue.org> 0.48-1.suse10.0
- Updated to 0.48-1
- better logging of find-and-mount-cdrom's progress (to /tmp/mondo-restore.log)
- somehow, lilo was re-enabled in deplist.txt; DISABLED (again *g*)
- added 'linear' to the list of modules Mindi always backs up
- if called by Mondo then pass the name & device of the user's boot loader to the restore phase, by copying BOOTLOADER.* to the ramdisk
- if loading from floppies then try to mount CD-ROM a 2nd time after extracting files from data floppies, just in case user is a CD user who couldn't get their CD-ROM drive to work initially
- added fix to make sure /root/images/mindi is created (Charlie Root)
- aware of 'iso' boot mode, for future expansion

* Tue Dec 04 2001 Bruno Cornec <bruno@mondorescue.org> 0.47-1.suse10.0
- Updated to 0.47
- added /dev/cdrom/cdrom[1-4] to the devices automatically excluded from mountlist.txt
- added '-f-' to the end of most tar commands, to see if it fixes a bug in some obscure Debian distros
- added network-related dependencies to deplist.txt
- if called by Mondo then don't write floppy images to disks; let Mondo do that: less irritating for user
- if called by Mondo then do some clever tricks to add mondo-restore and its dependencies (mondo-restore is now a dynamic executable)
- finally gotten klogd to squelch echoing of kernel msgs to console

* Thu Nov 29 2001 Bruno Cornec <bruno@mondorescue.org> 0.46-1.suse10.0
- Updated to 0.46
- finally fixed that 'lib/modules/2.4.12-xfs not found' bug! :-D
- cosmetic changes and minor bugfixes
- excluded lilo.conf and lilo from deplist.txt; use user's copy instead
- if your fstab mentions a RAID partition but your raidtab doesn't then Mindi will terminate in a sane manner with a sane error message
- fixed a bug in bug-me (heh, how ironic)
- include and run (sys)klogd to try to pipe kernel msgs to logfile
- call hdparm to speed up access to CD-ROM drive

* Thu Nov 15 2001 Bruno Cornec <bruno@mondorescue.org> 0.45-1.suse10.0
- Updated to 0.45
- disabled fsck.* in deplist.txt
- include /etc/fstab in logfile
- removed lzop.* from aux-tools; should come from user's distro anyway
- tweaked data disk size and data disk formatting command
- make ISO bootable image (as well as floppies) when backing up to tape
- copy boot images (floppy + CD) from temp dir to /root/images/mindi after making them, just in case the user wants them later
- added md5sum to deplist.txt
- added pico->vi softlink to ramdisk
- in the ramdisk's /etc/bashrc, added /usr/local/bin and /usr/local/sbin to the PATH= command
- call insert-all-modules as background task; pause 3 seconds after calling it, before proceeding <--- /sbin/init
- call to devfs has been moved to before call to post-init
- added 'md5sum -> busybox' softlink
- Mindi now uses busybox's printf, md5sum, mount, umount, vi ...NB: I said, 'vi' :-) Now you have an editor again! :-)
- added lilo.real to deplist.txt, to allow for Debian's evil new distro
- added lzop to deplist.txt
- no longer including lzop in Mindi's tarball / RPM
- improved Mindi's error-reporting a little bit
- changed deplist.txt's /etc/* to just *
- restructured the calls in /sbin/post-init that reinitialize the LVM and RAID modules
- if mkfs.ext2 is not in PATH then abort
- Mindi uses a 'filename cache' to speed itself up at run-time (Jean-David Marrow)
- Red Hat 7.2 uses a weird /etc/issue.net; I've worked around it...
- tested with Linux-Mandrake 8.0 and Red Hat 7.2

* Sun Oct 28 2001 Bruno Cornec <bruno@mondorescue.org> 0.44-1.suse10.0
- Updated to 0.44
- at boot-time, activate LV's if they exist
- restructured deplist.txt a bit (cosmetic change)
- re-enabled fsck.* in deplist.txt
- analyze-my-lvm fails gracefully if you're not using LVM but inserted the module anyway

* Sun Oct 21 2001 Bruno Cornec <bruno@mondorescue.org> 0.43-1.suse10.0
- Updated to 0.43
- made Mindi work with Red Hat 6.2 and 2.2.19 kernel
- if mkisofs is not found, say so; don't just say, 'an error occurred while I was trying to make an ISO image'
- when formatting and writing floppies, if /dev/fd0's size is indeterminable then I'll use /dev/fd0H1440 instead 
- make sure xfs.o, jfs.o, reiserfs.o, ext2.o, ext3.o modules are backed up (if they exist) to boot disks
- fixed a silly bug that stopped Mindi from handling its own modules properly; only affects newbie users with broken kernels (i.e. the very people that Mindi's failsafe kernel was meant to help!)
- added lzop (Marcus Oberhumer's file compressor) to aux-tools.tgz
- added Bruno Cornec's "--cd-recovery" patch; if user uses the switch (i.e. '--cd-recovery yes') then the CD will boot to a screen that pauses until the user types RESTORE; then, it will enter Nuke Mode
- added Stephan Zegherd's "superformat" patch
- failsafe kernel is now 2.4.12 with XFS, JFS and lots of SCSI modules; the addition of XFS and extensive SCSI support will increase the size of Mindi's RPM / tarball significantly but I think it's worth it
- at boot-time, find out whether there are any RAID partitions; and if there are, whether they are 'started' yet; if not, run raidstart to start them at boot-time, before user can try to mount anything
- Mindi's failsafe kernel & modules are handled more elegantly now; if you have raid1.o, scsi.o, etc. loaded at backup-time then Mindi finds its corresponding modules in its tarball of failsafe modules and stores them so that at boot-time you can do SCSI, RAID, etc.
- removed gawk, printf from deplist.txt

* Wed Oct 10 2001 Bruno Cornec <bruno@mondorescue.org> 0.42-1.suse10.0
- Updated to 0.42
- make sure lvm-mod, raid0, raid1 and raid5 modules are backed up
- added 'you need a ramdisk' to FAQ
- changed the slice size from 20KB to 64KB; speeds up Mindi by 25% and doesn't have any negative side-effects (...that I can see)
- when searching for your current kernel version, do not examine a file if it does not exist (it sounds obvious, I know...)
- when asking user to send me a copy of their log file, point out that it may contain info which they do not want me to see but that they are SOL unless I can actually see their log file
- fixed a silly bug that would crop up when a Linux-Mandrake 8.1 user would use a devfs-enabled kernel and RAID partitions at the same time
- plays nicely with devfs-enabled kernels and distros
- data floppies are now 1.44MB each; boot floppy is still 1.72MB
- if binutils or libbinutils is not installed, abort
- fixed a bug which meant that some big files overwrote each other at backup-time and caused library-related problems are boot-time
- enabled comments ('#') in deplist.txt
- disabled fsck.* in deplist.txt; user may re-enable the line if s/he wants those tools available at boot-time
- tested successfully with the following distros - Linux-Mandrake 8.1 and its 2.4.8, devfs-enabled stock kernel - Red Hat 7.1 and its 2.4.2 stock kernel
- better at guessing the size of swap partition
- drop minix tools from deplist; user can restore them if s/he wants to use the minix filesystem
- don't backup _all_ cdrom modules (if backing up 'cdrom.o'); be selective! ...minor bug in ListKerneModulePaths has been fixed
- if the user has two glibc libraries - one in /lib and one in /lib/i686 - then Mindi will re-jig the softlinks so that only the version in /lib is backed up, to save space on the data disks
- major rewrite of the code that copies the tools and libraries from the data disks; prettier, faster and more stable (and did I mention how kind it is to your hard-working hands?)
- better handling of crazy libraries and softlinks thereto
- new boot-time script, 'bug-me', copies user's logs to a floppy and tells him/her to e-mail them to me if mondo-restore aborts
- ignore kernels named vmlinux (note the 'X'); traditionally, kernels are named vmlinuz (note the 'Z') or something similar
- no longer backup all modules to CD/tape; just backup the ones loaded at backup-time; this saves boot-time ramdisk space
- removed all references to LOOPDEVICE
- LVM is supported (experimental; watch this space...)
- included a tarball of 'sane' /dev/loop* nodes which will be extracted and added to the boot disk; this helps maintain Mindi's backward- compatibility with non-devfs kernels and distros
- when copying modules to boot or data disks, uncompress them first if they are gzipped (some distros come with compressed modules)
- no longer copies all loaded modules to the 2.88 MB El Torito bootable floppy image; instead, it copies FLOPPY_MODS to the 1.72 MB image, CDROM_MODS to the 2.88 MB image, and _all_ modules that were loaded at backup-time to the data disks - supports tape streamers, in conjunction with Mondo
- uses busybox's sync again; let's see if that breaks anything...
- if Mondo is backing up to tape streamer then write the tape's size to /tmp/TAPESIZE and the drive's device to /tmp/TAPEDEV-LIVES-HERE on the ramdisk
- floppy disk modules (ide-floppy.o and floppy.o) now are copied to the ramdisk, whether the user's kernel or the failsafe kernel is being used

* Fri Sep 28 2001 Bruno Cornec <bruno@mondorescue.org> 0.41-1.suse10.0
- Updated to 0.41
- excluded *.old from the 'boot.b' list when searching for boot.b
- updated Mindi's own failsafe kernel+modules to v2.4.10
- added umount to deplist again
- improved Mindi's support of modular kernels (esp. modular CD-ROM drive and floppy disk drives)
- don't accuse Linux 2.4.10 users of having a 'buggy kernel'
- restored the libc5 versions of sync and umount (dropped from deplist but also from busybox)
- fixed a lot of silly bugs related to incorporating Busybox in Mindi
- experimental LVM support
- added 'analyze-my-lvm' script to the tarball; Mindi uses it now
- able to recognize & record LVM mounts, adding them to the mountlist
- added the LVM executables (listed in the lvm-0.xx-i386.rpm) to deplist.txt; they won't be added unless you have them and you won't
 	  have them unless you're using LVM, so this is not 'bloat' IMO :)
- added date and sync to deplist again
- when working on LVM stuff, use 'echo y | pvcreate -ff' (was '..-f')
- amended format-...-kludge to allow for mountlists with >1 spaces between cols checked the fsck.reiserfs is in deplist.txt (yes it is)
- incorporated busybox 0.60-1; now, Mindi is faster at run-time and smaller at boot-time; you can fit a typical system onto 3 floppies; also, a kernel up to 1MB in size (approx.) can now be accommodated
- supports kernels that have MODULAR support for CD-ROM's or floppies
- Mindi copies only the loaded modules to the data disks but it copies _all_ modules to the CD, just in case
- thanks to busybox your floppy-based Mindi boot disk set should now be able to accommodate a kernel of up to 1MB in size
- boot into Expert Mode unless boot disk was generated by Mondo
- exclude all softlinks from list of 'eligible' kernels
- exclude kernels with 'vmlinux' in their names
- removed A LOT of files from deplist.txt's dependency list; they are listed in deplist.removed, in case you want to put them back :-)
- excludes libX11, libXext, libXi, libgtk, libgdk ALWAYS, whether you add them to deplist.txt or not; [cancel this by editing line 485]
- rewrote AddFileToDir() to make it more efficient (but slower...)
- strip chaff from binaries; strip comments from bash scripts; strip comments from /etc/termcap

* Sun Sep 16 2001 Bruno Cornec <bruno@mondorescue.org> 0.40-1.suse10.0
- Updated to 0.40
- if you use a softlink to your CD dev, e.g. /dev/cdrecorder->scd0, then Mindi should handle it properly now (i.e. not bomb out)
- if you have a large kernel & lots of modules loaded, Mindi will only copy as many modules to the ramdisk as will _fit_ on a ramdisk that will have to go alongside your kernel on a 2.88MB floppy disk
- if your kernel does not support loopfs, Mindi will say so & abort
- turned some warnings into fatal errors, to help the user to figure out exactly why Mindi won't work on their kernel
- changed mke2fs -N24 to -N32, to see if it helps braindead distros
- Mondo now tells Mindi whether or not to use its stock kernel
- gone back to the old 'insert-my-modules' for now; it's more reliable
- working on the 'insert-all-my-modules' script, to make it compatible with a wider range of insane distros and kernels
- dropped the '-c' option from LILO call - removed cdrecord, mkisofs, vi, route and diff from deplist.txt
- slowed down the 'split data between floppies' routine; made it try harder to squeeze more data onto each floppy
- excluding nvidia modules from the "insert-all-my-modules" script because it sometimes causes freeze-ups
- added code to copy your fstab, lilo.conf, etc. to a tarball which, in the event of an error, Mindi will ask the user to e-mail me

* Sat Sep 08 2001 Bruno Cornec <bruno@mondorescue.org> 0.39-1.suse10.0
- Updated to 0.39
- plays nicely with devfs, so long as your old /dev/hdX, /dev/sdX softlinks are still there :-)
- if your swap partition isn't mounted, Mindi will decide that it is 125MB; it used to abort but now it just warns & makes a good guess
- testing the failsafe kernel & associated scripts
- only use lilo's "-c" option if NOT a 2.88MB floppy disk image
- copes better with .o, .gz, etc. module suffixes
- better 'loaded modules / not loaded modules' feedback at boot-time
- semi-forces isofs and ide-cd (not isofs.o and ide-cd.o); the former will be more compatible with stock kernels - e.g. Red Hat, Mandrake; also added vfat, fat & a few other modules to the list of 'foced'.
- removed the '-c' switch from the call to LILO (some BIOSes don't like it very much)
- removed chaff from ramdisk's /etc/login.defs, saving approx 7K
- format the boot disks with -N 24 (was -N 64)
- do not insist on CD #1 (at boot-time) if there is no 'CD #' marker
- amend format-and-kludge-vfat; now, it will not abort if it cannot find its entry in mountlist; it doesn't need to find the entry anyway, except to check that the kludge works (which it does)
- if user chooses to use Mindi's failsafe 2.4.9 kernel, Mindi will load Mindi's versions of user's modules at boot-time
- make label-devices-as-necessary log its efforts
- added e2label and tune2fs to deplist.txt
- if you boot in Normal Mode, I'll call mondo-restore --interactive instead of just mondo-restore
- replaced K7-compatible 2.4.7 kernel with a 586-comp'ble 2.4.9 kernel
- improved the post-run clean-up
- force the copying/loading of isofs.o and ide-cd.o, which enhances Mindi's support for kernels that have modular CD-ROM support
- Interactive Mode offers to edit /tmp/mountlist.txt before running mondo-restore (good idea from F. Boon)
- /dev/hd[e-h]* have been added to the ramdisk
- disabled Cuckoo and Bootstrap Modes (they weren't doing anything anyway & were probably confusing some users)
- removed 'edit mountlist?' question (because mondo-restore takes care of that now, via a user-friendly mountlist editor)
- included a copy of mondo-manual.html
- only kludge /dev/hda1 or /dev/sda1 (if vfat, of course); otherwise, use regular mkfs.vfat
- use mkfs.dos if mkfs.vfat does not exist
- moved some scripts from rootfs.tgz to Mondo's restore-scripts.tgz

* Sat Aug 18 2001 Bruno Cornec <bruno@mondorescue.org> 0.38-1.suse10.0
- Updated to 0.38
- clarified the 'more than one kernel found' comment
- updated the README to emphasize that the scripts are deprecated
- when displaying mountlist on screen, make it easier to read
- changed most 'echo's to 'LogIt()'s; log most screen output to /var/log/mindi.log
- user can now use a stock 2.4.7 kernel (which comes with Mindi) if the user's distro's kernel isn't right for a boot disk

* Sat Aug 11 2001 Bruno Cornec <bruno@mondorescue.org> 0.37-1.suse10.0
- Updated to 0.37
- changed the "cannot boot from CD-ROM" message (more informative now)
- if an 'insmod'ed module cannot be found, warn but don't abort
- that whole loop-mount/extract tgz to ramdisk thing --- if it fails, abort, don't try to continue; also, ask if loopfs is supported by kernel (if not, that might explain the error)
- in addition to /lib/modules/uname -r`/modules, also search /root/oss/modules for kernel modules (Phillip Deackes)
- run syslog and klogd at restore-time, to pipe sys & knl messages to /tmp/mondo-restore.log
- default restore-time boot mode is now 'interactive (unless the disk is a 1.72MB, in which case default mode is still 'expert')
- if CDROM can't find itself (long story, re: El Torito) then the script will say, "Your kernel is b0rken." This will reduce the number of erroneous error reports that I receive from users
- working on implementing Cuckoo Mode again

* Fri Aug 03 2001 Bruno Cornec <bruno@mondorescue.org> 0.36-1.suse10.0
- Updated to 0.36
- testing it with LM8, RH71 and Slack8
- explicitily exluding /mnt/floppy and /floppy from mountlist.txt
- warn if afio not found (Mondo needs afio)
- optional --custom <temp dir> <out dir> switch added, to let the user specify where the temp dirs and created images will be stored
- changed /sbin/init to install modules _before_ trying to mount CD-ROM (David Granz)
- create a gawk->awk shortcut at restore-time if necessary
- specifically exclude /dev/fd0h1440 and /dev/fd0H1440 from mountlist
- removed silly "was CD inserted?" message

* Tue Jul 31 2001 Bruno Cornec <bruno@mondorescue.org> 0.35-1.suse10.0
- Updated to 0.35
- if LILO fails, it writes its errors to the screen
- use user's boot.b and LILO instead of Mindi's
- tarball/RPM no longer includes boot.b or lilo
- mke2fs' output will be echoed to screen, if an error occurs
- doubled the -N inode allocations and removed some of the -i inode fiddles, just in case they are making Red Hat 7.1 choke

* Wed Jul 25 2001 Bruno Cornec <bruno@mondorescue.org> 0.34-1.suse10.0
- Updated to 0.34
- includes patch to rid Mindi of its dependence on /dev/loop devices
 	  (Bill Davidsen)
- includes patch from 0ystein Skalsem, to fix a disk-formatting problem
- warns if kernel is 2.4.0-2.4.5; encourages user to upgrade

* Fri Jul 20 2001 Bruno Cornec <bruno@mondorescue.org> 0.33-1.suse10.0
- Updated to 0.33
- excludes all devices containing ':/' (i.e. NFS mountlists)
- the FORMAT/SYS replacement, "format-and-kludge-vfat" now writes its logfile to /tmp/format-and-kludge-vfat.log
- /etc/fstab now mounts floppies for read/write access by default
- format-and-kludge-vfat should only write to log once now
- added vi, top to deplist.txt
- updated the rootfs.tgz's README
- mountlist is written to screen as well as mountlist.txt
- tested with Linux 2.4.7; works fine
- changed 'mkfs' lines, to format the loop-mounted files instead of the device nodes which makes Mindi work better with kernels 2.4.6+
- Mindi can now handle kernels of up to 930K in size
- sped up the process of spreading data files across data disks by approx 20%

* Wed Jul 18 2001 Bruno Cornec <bruno@mondorescue.org> 0.32-1.suse10.0
- Updated to 0.32
- software RAID is now supported
- added the 'raidtools' binaries to deplist.txt
- add /etc/fstab and /etc/raidtab to deplist.txt
- added /dev/md* to the ramdisk's /dev directory
- modified MakeMountlist() to calculate correctly the sizes of RAID partitions, if they are present in /etc/fstab
- moved the 'LOOPDEVICE=...' code into the regular main() section
- install-additional-tools makes a softlink '/etc/raidtab' that points to /mnt/groovy-stuff/etc/raidtab; also, '/etc/fstab.orig' that points to /mnt/groovy-stuff/etc/fstab
- added line to 'install-additional-tools' that will delete the dummy modprobe before installing data from datadisk(s)
- mkdir -p $outdir at the beginning, just in case...

* Mon Jul 16 2001 Bruno Cornec <bruno@mondorescue.org> 0.31-1.suse10.0
- Updated to 0.31
- slightly better install.sh and README

* Sun Jul 15 2001 Bruno Cornec <bruno@mondorescue.org> 0.30-1.suse10.0
- Updated to 0.30
- added klogd and syslogd to deplist.txt
- can now cope with Red Hat's "LABEL=" entries in /etc/fstab
- should ignore NFS-mounted partitions now

* Sat Jul 14 2001 Bruno Cornec <bruno@mondorescue.org> 0.29-1.suse10.0
- Updated to 0.29
- stopped the 'modprobe' errors that used to occur at the beginning; they didn't mean anything but they did worry some novice users
- removed losetup from rootfs.tgz (wasn't doing anything useful)
- removed the 'txt-or-gui' stuff from Mindi (never used it anyway)
- added clear to deplist.txt
- moved rootfs.tgz's "mondo/" scripts to Mondo's "restore-scripts.tgz" tarball; tarball will be untarred and contents added to the data disks at run-time, if Mindi finds the tarball
- if user lacks fd0u1722 but has fd0h1722 then use the latter
- boot-up msg is more informative
- fixed obscure bug in find-and-mount-cdrom
- better at coping with hda1/2/3/4 (normal people use hda1/5/6/7 but if you really want to exhaust your primaries, well hey, your life)
- the 'outstring sucks!' message is now more informative

* Sat Jul 07 2001 Bruno Cornec <bruno@mondorescue.org> 0.28-1.suse10.0
- Updated to 0.28
- if AddFileToDir() is called with a file that does not exist, Mindi warns but does not abort
- should work with gzipped modules (which end in '.o.gz') and NVidia modules (which don't end in anything)
- should work with Red Hat's issue.net now
- misc. cosmetic changes to Mondo boot-time and restore-phase scripts, to make the visual output cleaner & more legible
- insist-on-cd retracts the CD tray after asking for next CD, in case the user did not close the drive before pressing <enter>
- if unable to create 1.72MB boot disk then warn but do not abort
- put creation date on the boot-up screen
- create data disks with tarballs up to 1700KB in size; tries harder to fill each data disk to the brim
- changed the call to make ext3 partitions; now, it uses a call to mkfs -t ext3 -j -Jsize=10 -q <device> (as requested by ext3 manual)
- tested w/ext3; works fine
- install-additional-tools doesn't call sync until after all softlinks have been finalized; that's to make sure we call the _right_ sync
- ramdisk is now (size of all files in data disks PLUS 8192) KB
- RPM and SRPM published
- mount CDROM at start of untar-me, just in case it wasn't mounted
- when restoring selectively, log the archives that have matches & the number of matches (inc. if zero)

* Thu Jul 05 2001 Bruno Cornec <bruno@mondorescue.org> 0.26-1.suse10.0
- Updated to 0.26
- has been tested with XFS, JFS, ReiserFS, ext2 and vfat
- compatible (but not tested) with ext3
- better at finding your kernel, even if you have several kernels of the same version (now checks the build date, too)
- better file-spreading algorithm; a little faster; much more reliable
- includes a copy of LILO, to make the boot disks properly
- tells you how big the tarballs are, when it assembles them
- compare-me uses 'insist-on-cd' instead of internal subroutine
- it looks as if Mindi can actually cope with 920K kernels now :)
- fixed some silly multi-CD bugs that would stop big files from being restored if they were spread across CD's

* Wed Jul 04 2001 Bruno Cornec <bruno@mondorescue.org> 0.25-1.suse10.0
- Updated to 0.25
- uses its own copy of lilo
- removed all "~" (backup copies) from rootfs.tgz
- updated the rootfs's README - stablilo-me, not hack-me
- improved the formatting of the lilo.conf as it is created
- replace all libc5 tools with libc6 (user's) tools at restore-time
- added diff to deplist.txt
- copy io.sys and msdos.sys (if found) to data disk(s) at run-time; softlinks them to /*.sys at boot-time
- fixed some vfat formatting-related issues w/Embleer (always tricky); the kludge's error-handling is better and its exit is more graceful
- say 'type nuke to restore automatically' in msg if Mondo called me
- backup all modules, not just the ones present/loaded at run-time; the loaded modules go on boot disk but ALL go on data disk
- reduced the max data per disk from 1700 to 1680, to suit ext2's needs
- DidMondoCallMe() replaces 'ps ax | grep | blah blah'
- includes user's /etc/termcap and /usr/bin/pico on disk(s)
- cosmetic changes to restore-time scripts (spaces, newlines, etc.)
- pipe kernel's msgs to /var/log/messages
- make sure /etc/lilo.conf is 600 (RW by root only)

* Tue Jul 03 2001 Bruno Cornec <bruno@mondorescue.org> 0.24-1.suse10.0
- Updated to 0.24
- can accommodate a kernel >900KB in size
- generates lilo.conf on-the-fly; no default/template file anymore
- copies io.sys and msdos.sys to the CD (if you have them)
- add the embleer tarballs to mindi-0.xx.tgz, so that users can format and make bootable msdos/Win9x partitions
- added printf and hdparm to deplist.txt
- incorporated Bruno Cornec's Mondo 0.991 scripts in Mindi
- separated README into README, INSTALL and TODO
- fixed silly {ramdisk}/sbin/InsistOnCD bug
- took out mke2fs and libext from rootfs.tgz
- rootfs.tgz's "/etc/bashrc" now includes /usr/share/mindi
- compare-mode uses IDE optimization to speed things up
- don't quibble over resizing partitions if <2MB difference
- fixed silly InsistOnCD bug

* Mon Jul 02 2001 Bruno Cornec <bruno@mondorescue.org> 0.23-1.suse10.0
- Updated to 0.23
- don't copy *.mdsg to boot floppy image
- fixed erroneous 'cannot make ISO image' error message
- can accommodate a kernel as large as 890K
- now uses lilo, not syslinux (lilo works better w/2.88MB boot images)
- creates & formats disk images on the fly (no more .img.gz templates)
- boot disks are formatted ext2, like the data disks
- creates 1.72MB and El Torito 2.88MB boot floppies/images
- if called by Mondo, doesn't list images or offer to copy to FDD/CDRw
- includes the distro's name and kernel version in LILO's message

* Sun Jul 01 2001 Bruno Cornec <bruno@mondorescue.org> 0.22-1.suse10.0
- Updated to 0.22
- don't add a ramdisk; use rootfs & that's it
- dependency-calculator runs approx. twice as fast as in v0.20
- tested with Linux Mandrake 8.0; works well, if you recompile kernel to include floppy disk support (which LM8's kernel does not)
- supports bigger kernels now, up to 900K in size
- deplist.txt may now include directories, not just files
- ignores kernel filenames that are hyperlinks
- uses awk instead of gawk; drop the awk/gawk-finding thing
- uses gzip, not bzip2; dropped bzip2, mv, ls to make rootfs smaller
- copies user's /dev/fd0* devices to boot disk
- calls Mindi's copy of syslinux, not user's copy
- use modules' paths, e.g. instead of just 'insmod fubar', use 'insmod /lib/modules/2.4.5-ac117/vfat/fubar.o'
- in boot.msg, XXXXX is part 1 of the 2nd line, YYYYY is part 2 of the 2nd line, and ZZZZZ is Mindi's version# (in the 1st line)

* Sat Jun 30 2001 Bruno Cornec <bruno@mondorescue.org> 0.21-1.suse10.0
- Updated to 0.21
- df, du, find, lsmod, rmmod have been removed from rootfs.tgz
- at boot-time, inserts kernel modules w/user's original parameters
- deletes the slices after recombining them & restoring the files
- includes the MINDI_VER version number in boot.msg
- if boot disk is too small, lists the files & which one is too big
- syslinux now waits 10 seconds before booting floppy
- 'insert-all-my-modules' is copied to rootfs, not to a data disk

