#############################################################################
# mined text editor make actions (make include file for make targets)
# Mouse library (optional, empty for most architectures)


#############################################################################
# make target parameters to be set before including this:
# (could be set to default with the ?= syntax but that doesn't work 
# in all versions of make)

# MOUSELIB ?= 
# SCREENOBJ ?= io.o keyboard.o
# KEYMAPSDEP ?= keymaps/_keymaps.h


#############################################################################
# components to be compiled

# Mined modules
OBJS	= keymaps.o keydefs.o charmaps.o handescr.o \
	output.o prompt.o compose.o mousemen.o \
	justify.o mined1.o mined2.o minedaux.o search.o \
	iswide.o iscombin.o isrtol.o locale.o encoding.o \
	$(CHARMAPS)


#############################################################################
# target properties, default target, auxiliary targets

# functional or abbreviated (non-file) targets:
.PHONY:	mkcharmaps mkkeymaps mnemodoc help man bin install localinstall optinstall homeinstall clean clear debianclean update all unidata vni viqr vtelex

# Default make target:
all:	$(MAKEMAPS) mined


#############################################################################
# Unicode data tables:

UnicodeData.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/UNIDATA/UnicodeData.txt

Scripts.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/UNIDATA/Scripts.txt

SpecialCasing.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/UNIDATA/SpecialCasing.txt

PropList.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/UNIDATA/PropList.txt

Blocks.txt:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/UNIDATA/Blocks.txt

Unihan.zip:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/UNIDATA/Unihan.zip

Unihan.txt:
	$(MAKE) Unihan.zip
	unzip -o Unihan.zip
	touch -r Unihan.txt Unihan.zip

UCD.html:
	echo Trying to retrieve Unicode data description via Internet
	wget -N http://unicode.org/Public/UNIDATA/UCD.html

BIG5.TXT:
	echo Trying to retrieve Unicode data file via Internet
	wget -N http://unicode.org/Public/MAPPINGS/OBSOLETE/EASTASIA/OTHER/BIG5.TXT

unidata:	UnicodeData.txt SpecialCasing.txt Scripts.txt Unihan.txt PropList.txt UCD.html
	rm -f casetabl.h casespec.h scripts.h categors.sed categors.h
	rm -f UniWITH
	echo not removing handescr.h because it takes so long to rebuild
	echo remove or rename manually to have it rebuilt
	# rm -f handescr.h
	#./mkcasetb
	#./mkcasesp
	#CC=$(CC) ./mkscript

cjk-b5.h:	mkbig5map # Unihan.txt BIG5.TXT
	./mkbig5map

# Vietnamese input methods:

UniWITH:	UnicodeData.txt
	sed -e "s,^\([^;]*\);\([^;]* LETTER [^;]* WITH [^;]*\);.*,U+\1	\2 AND," -e t -e d UnicodeData.txt | ./insutf8 > UniWITH

vni:	keymaps/VNI.h

categors.sed:	mkcategories # UCD.html
	./mkcategories -sed > categors.sed

categors.h:	mkcategories # UCD.html
	./mkcategories -h > categors.h

keymaps/VNI.h:	UniWITH vni.sev vni.sed vni.seh
	mkdir -p keymaps
	(sed -f vni.sev UniWITH ; cat UniWITH) | sed -f vni.sed | sed -f vni.seh > keymaps/VNI.h

viqr:	keymaps/VIQR.h

keymaps/VIQR.h:	keymaps/VNI.h
	mkdir -p keymaps
	sed -e "s,VNI,VIQR," keymaps/VNI.h | tr "6879125340" "^(+d\'\`.?~-" > keymaps/VIQR.h

vtelex:	keymaps/Vtelex.h

keymaps/Vtelex.h:	keymaps/VNI.h
	mkdir -p keymaps
	sed -e "s,VNI,Vtelex," -e "s,\([Aa]\)6,\1a," -e "s,\([Ee]\)6,\1e," -e "s,\([Oo]\)6,\1o," keymaps/VNI.h | tr "879125340" "wwdsfjrxz" > keymaps/Vtelex.h

# case conversion tables:

casetabl.h:	mkcasetb # UnicodeData.txt
	./mkcasetb

casespec.h:	mkcasesp # SpecialCasing.txt
	./mkcasesp

softdot.h:	mkdotted # PropList.txt
	./mkdotted > softdot.h

combin.h:	mkcombin # UnicodeData.txt
	CC=$(CC) ./mkcombin

# Unicode character information tables:
scripts.h:	mkscript categors.sed # Scripts.txt
	CC=$(CC) ./mkscript

colours.h:	colours.cfg # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Z][A-Za-z_]*\)[ 	,"]*\([0-9][0-9]*\)[	 ][	 ]*\([0-9][0-9]*\).*/	{"\1", \2, \3},/' -e t -e 's/^[ 	"]*\([A-Z][A-Za-z_]*\)[ 	,"]*\([0-9][0-9]*\).*/	{"\1", \2, -1},/' -e t -e d colours.cfg | sort > colours.h

# Unihan character description table:
handescr.h:	# Unihan.txt
	cd handescr; $(MAKE) descriptions.h
	ln handescr/descriptions.h handescr.h || cp handescr/descriptions.h handescr.h

# Keyboard mapping table configuration:
# source lines: Greek	keymap_GreekMonotonic	gr

# OBSOLETE: generate:	#include "Cangjie.h"
#keymaps.h:	keymaps.cfg keymaps0/*.h # mkinclud.mak
#	sed -e 's/^[ 	"]*\([A-Za-z][^ 	]*\)[ 	,"]*\([A-Za-z_][^ 	]*\).*\([^ 	][^ 	]\).*/#include "\2.h"/' -e t -e d keymaps.cfg > keymaps.h

# generate:	{keymap_GreekMonotonic, "gr"},
keymapsk.h:	keymaps.cfg # mkinclud.mak
	sed -e 's/^[ 	"]*\([A-Za-z0-9][^ 	]*\)[ 	,"]*\([A-Za-z0-9_][^ 	]*\).*\([^ 	][^ 	]\).*/	{keymap_\2, "\3"},/' -e t -e d keymaps.cfg > keymapsk.h

# generate:	{"Greek", select_keymap_entry, "gr"},
keymapsm.h:	keymaps.cfg # mkinclud.mak
	sed -e 's/^--* *\(.*\) */	{"\1", separator, ""},/' -e t -e 's/^[ 	"]*\([A-Za-z0-9][^ 	]*\)[ 	,"]*\([A-Za-z0-9_][^ 	]*\).*\([^ 	][^ 	]\).*/	{"\1", select_keymap_entry, "\3", keymapon},/' -e t -e d keymaps.cfg > keymapsm.h


#############################################################################
# generate tables for character encodings and keyboard mappings

# rules for non-GNU make:

# extract list of configured keyboard mappings from keymaps.cfg:
getKEYMAPS=`./mkkmlist`

# generate makefile to deal with variable list of dependencies,
# invoke it to generate cumulative keymaps file:
mkkeymaps:
	test -d keymaps || mkdir keymaps
	echo keymaps/_keymaps.h: keymaps.cfg $(getKEYMAPS) mkkmincl > keymaps/makefile
	echo "	./mkkmincl $(getKEYMAPS) > keymaps/_keymaps.h" >> keymaps/makefile
	$(MAKE) -f keymaps/makefile

# generate makefile to deal with variable list of targets,
# invoke it to generate and compile character mapping tables:
mkcharmaps:
	CC=$(CC) ./mkmakchr > charmaps/makefile
	CC=$(CC) $(MAKE) -f charmaps/makefile


# rules for GNU make:

# KEYMAPS is extracted list of configured keyboard mappings from keymaps.cfg:
keymaps/_keymaps.h:	keymaps.cfg $(KEYMAPS) mkkmincl
	test -d keymaps || mkdir keymaps
	./mkkmincl $(KEYMAPS) > keymaps/_keymaps.h

# define generic rule to generate and compile character mapping tables:
charmaps/%.o: charmaps/%.map mkchrtab charmaps.h
	CC=$(CC) ./mkchrtab $<


#############################################################################
# Character input support tables:
MNEMOS=mnemos.???	# mnemos.add, .gen, .rfc, .tex, .www
mnemos.h:	$(MNEMOS)
#	cat $(MNEMOS) > mnemos.h
	ls -1 $(MNEMOS) | sed -e 's,^,#include ",' -e 's,$$,",' > mnemos.h

# Documentation page for mnemonics (listing mined additional mnemos)
mnemodoc:	../doc/mnemodoc.html
../doc/mnemodoc.html:	mnemos.add ../doc/mined.html mkmnemodoc
	./mkmnemodoc
	./mnemos.check


#############################################################################
# Location of online help file:
HELPFILE=\"$(hlpdir)/mined.hlp\"
LHELPFILE=\"$(lhlpdir)/mined.hlp\"
DHELP=-DHELPFILE=$(HELPFILE) -DLHELPFILE=$(LHELPFILE)


#############################################################################
# Source compilation:
mined1.o:	mined1.c textbuf.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) $(DHELP) -c mined1.c
justify.o:	justify.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c justify.c
mined2.o:	mined2.c mined.h casespec.h casetabl.h softdot.h combin.h scripts.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c mined2.c
minedaux.o:	minedaux.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c minedaux.c
search.o:	search.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c search.c
mousemen.o:	mousemen.c mined.h keymapsm.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c mousemen.c
output.o:	output.c colours.h mined.h pc437.map
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c output.c
charmaps.o:	charmaps.c charmaps.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c charmaps.c
handescr.o:	handescr.c handescr.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c handescr.c
prompt.o:	prompt.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c prompt.c
compose.o:	compose.c mined.h mnemos.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c compose.c
io.o:	io.c io.h mined.h $(MOUSELIB) dosvideo.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c io.c
iocurses.o:	io.c io.h mined.h
	$(CC) $(CFLAGS) -DCURSES -DSETLOCALE $(PROTOFLAGS) -c io.c $(ICURSES) -o iocurses.o
keyboard.o:	keyboard.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c keyboard.c
keycurs.o:	keyboard.c mined.h
	$(CC) $(CFLAGS) -DCURSES $(PROTOFLAGS) -c keyboard.c $(ICURSES) -o keycurs.o
keymaps.o:	keymaps.c keymapsk.h $(KEYMAPSDEP)
	$(CC) $(CFLAGS) $(PROTOFLAGS) -Ikeymaps -c keymaps.c
keydefs.o:	keydefs.c mined.h
	$(CC) $(CFLAGS) $(PROTOFLAGS) -c keydefs.c
iswide.o:	iswide.c
	$(CC) $(CFLAGS) -c iswide.c
iscombin.o:	iscombin.c
	$(CC) $(CFLAGS) -c iscombin.c
isrtol.o:	isrtol.c
	$(CC) $(CFLAGS) -c isrtol.c
locale.o:	locale.c
	$(CC) $(CFLAGS) -c locale.c
encoding.o:	encoding.c
	$(CC) $(CFLAGS) -c encoding.c


#############################################################################
# Mined generation:
mined:	$(OBJS) $(SCREENOBJ)
	$(CC) $(OBJS) $(SCREENOBJ) $(SLIB) $(LINKOPTS) -o mined

curses:	minced

minced:	$(OBJS) iocurses.o keycurs.o
	$(CC) $(OBJS) iocurses.o keycurs.o -lncursesw $(LINKOPTS) -o minced


#############################################################################
# additional files, installation, cleanup

# Online help:
help:	../usrshare/mined.hlp

../usrshare/mined.hlp:	help/* mkhelp
	./mkhelp > ../usrshare/mined.hlp

# Manual page:
man:	../man/mined.1

../man/mined.1:	../doc/mined.html
	cd ../man; $(MAKE)

# Installation:
install:	mined help man ${INSTALLTARGET}
	strip mined
	mkdir -p $(bindir)
	$(INSTALL) mined $(bindir)
	mkdir -p $(hlpdir)
	$(INSTALL) ../usrshare/* $(hlpdir)
	mkdir -p $(mandir)/man1
	$(INSTALL) --mode=+r,u+w ../man/mined.1 $(mandir)/man1
	(ls $(mandir)/man1/*.gz && type gzip) > /dev/null 2>&1 && gzip -f $(mandir)/man1/mined.1

# Local installation:
localinstall:	mined help man ${INSTALLTARGET}
	strip mined
	mkdir -p $(lbindir)
	$(INSTALL) mined $(lbindir)
	mkdir -p $(lhlpdir)
	$(INSTALL) ../usrshare/* $(lhlpdir)
	mkdir -p $(lmandir)/man1
	$(INSTALL) --mode=+r,u+w ../man/mined.1 $(lmandir)/man1
	(ls $(lmandir)/man1/*.gz && type gzip) > /dev/null 2>&1 && gzip -f $(lmandir)/man1/mined.1

# /opt installation:
optinstall:	mined help man ${INSTALLTARGET}
	strip mined
	mkdir -p /opt/mined/bin
	$(INSTALL) mined /opt/mined/bin
	mkdir -p /opt/mined/share
	$(INSTALL) ../usrshare/* /opt/mined/share
	mkdir -p /opt/mined/man/man1
	$(INSTALL) --mode=+r,u+w ../man/mined.1 /opt/mined/man/man1
	(ls /opt/mined/man/man1/*.gz && type gzip) > /dev/null 2>&1 && gzip -f /opt/mined/man/man1/mined.1

# $HOME/opt installation:
homeinstall:	mined help man ${INSTALLTARGET}
	strip mined
	mkdir -p ${HOME}/opt/mined/bin
	$(INSTALL) mined ${HOME}/opt/mined/bin
	mkdir -p ${HOME}/opt/mined/share
	$(INSTALL) ../usrshare/* ${HOME}/opt/mined/share
	echo set MINEDHELPFILE=${HOME}/opt/mined/share/mined.hlp in your environment
	mkdir -p ${HOME}/opt/mined/man/man1
	$(INSTALL) --mode=+r,u+w ../man/mined.1 ${HOME}/opt/mined/man/man1

# Cleanup after compilation:
clear:
	rm -f *.o charmaps/*.o colours.h keymaps?.h keymaps/_keymaps.h core

debianclean:
	rm -f mined semantic.cache ../debian/semantic.cache

clean:	clear debianclean


#############################################################################
# development targets

# Tags file:
tags:	*.c *.h
	ctags -w *.c *.h

# Source update archive:
update:
	cd man; $(MAKE)
	zip -y mined-src-update *.h *.c makefile.* mk* doc/changes.html doc/mined.html man/mined.1 -x handescr.h

# Check function valid_cjk:
validcjk:	validcjk.c charmaps.c charmaps.h iscombin.o charmaps/*.o
	$(CC) -o validcjk validcjk.c iscombin.o charmaps/*.o

# Check correctness, consistency, uniqueness...
check:	validcjk
	./validcjk
	./mnemos.check


#############################################################################
# end
