/***************************************************************************\
	mined text editor main include file
\***************************************************************************/

#undef __

#ifdef __STDC__
#define DEFPROTO
#endif

#ifdef NOPROTO
#undef DEFPROTO
#endif

#ifdef DEFPROTO
#define _(x) x
#else
#define _(x) ()
#endif


/***************************************************************************\
	system environment configuration
\***************************************************************************/

/* MSDOS basic configuration */
#ifdef __MSDOS__

#undef unix	/* needed for djgcc? */
#define msdos
#define pc

# ifndef __TURBOC__
# define __GCC__

#  ifdef __strange__
#  undef msdos	/* in this queer case, a more specific distinction */
#  define unix	/* has to be made everywhere according to the 'pc' flag */
#  endif
# endif
#endif


/* character set definition for visual indications */
#ifdef pc
#define pc_charset
#ifdef __CYGWIN__	/* from some version mid 2000 */
#undef pc_charset
#endif
#endif


/* MSDOS includes and declarations */
#ifdef msdos
extern void delay ();
extern void exit ();

#include <string.h>
#include <io.h>		/* this is not "io.h" */
#  include <stdio.h>
#  undef putchar
#  include <fcntl.h>
#  define FUNcmd	'\000'

# ifdef __TURBOC__
/* With Turbo-C, compile with memory model >= Compact */
/* #define conio doesn't work with current combined positioning/output method */
extern far * getenv ();
extern far * getcwd ();
extern void setdisk ();
extern void sleep ();
# else
#define conio
# endif

#endif

#ifdef conio
#define dosmouse
#endif

#ifdef __TURBOC__
#define conio
#define dosmouse
#endif


/* VMS includes and declarations */
#ifdef vms
#  include <unixio.h>
#  include <file.h>	/* for the O_... attributes to open () */
#  include <unixlib.h>
#  undef putchar
#  undef FALSE
#  undef TRUE
#  define CURSES
#  define FUNcmd	'\000'
#endif


/* Unix and terminal I/O defines */
#ifdef TERMIO
#ifndef sysV
# define sysV
#endif
#endif

#ifdef sysV
#ifndef unix
# define unix
#endif
/* # define TERMIO ? */
#endif


/* Unix includes and defines */
#ifdef unix

/*#include <stdlib.h> */
#  include <stdio.h>
#  include <string.h>
/*#include <strings.h> ? */
#  include <fcntl.h>
#  include <unistd.h>
#  undef putchar
#  undef NULL
#  undef EOF
#  define FUNcmd	'\000'

#  ifdef sysV
   extern char * getcwd ();
#  else
   extern char * getwd ();
#  define getcwd(dirbuf, buflen)	getwd (dirbuf)
#  endif

extern void exit ();
extern char * getenv ();
/*extern int printf ();*/

/* already declared in <unistd.h>
#ifdef __STDC__
extern pid_t vfork ();
#else
#ifdef _CLASSIC_ID_TYPES
#define is_this_a_HP_special
extern int vfork();
#else
extern pid_t vfork ();
#endif
#endif
*/

#ifdef __CYGWIN__
extern int vfork();
#endif

#ifdef __GCC__
extern int wait ();
#else
extern pid_t wait ();
#endif

extern int select ();
extern unsigned int sleep ();

#ifdef use_usleep
extern unsigned int usleep ();
#endif

#endif /* unix */


/* PC-specific defines */
#ifdef __CYGWIN__
#define __pcgcc__
#endif
#ifdef __MSDOS__
#define __pcgcc__
#endif
#ifdef __pcgcc__
#define PROT int
#else
#define PROT unsigned int
#endif


/* CJK tables mode */
#ifndef msdos
#define use_cjk_tables
#define use_keymap_tables
#endif


/***************************************************************************\
	declaration of types and constants
\***************************************************************************/

#define arrlen(arr)	(sizeof (arr) / sizeof (* arr))

typedef unsigned char character;
/*typedef unsigned int character;*/

/* Screen size and display definitions. Coordinates start at 0, 0 */
#ifdef pc
#  define maxYMAX		64
#  define maxXMAX		132
#else
#  define maxYMAX		126	/* 73 */
#  define maxXMAX		279	/* 163 */
#endif

extern int YMAX;
extern int XMAX;
extern short MENU;
#define SCREENMAX	(YMAX - 1)	/* last line displayed (first is 0) */
#define XBREAK		(XMAX - scrollbar_width)	/* Shift line display at this column */
extern int scrollbar_width;
#define XBREAK_bottom	(XMAX - 1)
#define SHIFT_SIZE	(tab8 (XMAX / 4 + 1))	/* Number of chars to shift */
#define maxLINE_LEN	(maxXMAX + 1)	/* max screen line length */
#define screen_BUFL	((((maxXMAX * maxYMAX) >> 10) + 1) << 10)
					/* Size of I/O buffering */

#define MAX_CHARS	1024		/* max chars on one line of text */
		/* LINE_START must be rounded up to the lowest SHIFT_SIZE */
#define LINE_START	(((-MAX_CHARS - 1) / SHIFT_SIZE) * SHIFT_SIZE \
  				   - SHIFT_SIZE)
#define LINE_END	(MAX_CHARS * 8)	/* Must be larger than highest 
					x-coordinate for line; MAX_CHARS + 1
					is not sufficient due to TABs */

#define BLOCK_SIZE	1024

/* Return values of functions */
#define ERRORS		-1
#define NO_LINE		(ERRORS - 1)	/* Must be < 0 */
#define NUL_LINE	(ERRORS - 2)	/* Must be < 0 */
#define SPLIT_LINE	(ERRORS - 3)	/* Must be < 0 */
#define FINE	 	(ERRORS + 1)
#define NO_INPUT	(ERRORS + 2)

#define STD_IN		0		/* Input file # */
#define STD_OUT	 	1		/* Terminal output file # */
#define STD_ERR		2

#define REPORT	1		/* Report change of lines on # lines */

#ifndef pc
#ifndef O_BINARY
#define O_BINARY 0
#endif
#endif

/*
 * mouse button selection
 */
typedef enum {
	releasebutton,
	leftbutton,
	middlebutton,
	rightbutton,
	movebutton,
	wheelup,
	wheeldown
} mousebutton;

#define shift_button	4
#define meta_button	8
#define control_button	16

/*
 * Common enum type for all flags used in mined.
 */
typedef enum {
/* General flags */
  False,
  True,
  OFF,
  ON,

/* yank_status and other */
  NOT_VALID,
  VALID,

/* Expression flags */
  FORWARD,
  REVERSE,

/* Yank flags */
  SMALLER,
  BIGGER,
  SAME,
  NO_DELETE,
  DELETE,
  READ,
  WRITE,

/* smart quotes state */
  UNSURE,
  OPEN,
} FLAG;

/*
	line end definitions
 */
typedef unsigned char lineend_type;
#define lineend_NUL '\0'
#define lineend_NONE ' '
#define lineend_LF '\n'
#define lineend_CRLF '\r'
#define lineend_CR 'R'
#define lineend_LS 'L'	/* Unicode line separator 2028:   */
#define lineend_PS 'P'	/* Unicode paragraph separator 2029:   */

/*
 * The Line structure. Each line entry contains a pointer to the next line,
 * a pointer to the previous line, a pointer to the text and an unsigned char
 * telling at which offset of the line printing should start (usually 0).
 */
struct Line {
  struct Line * next;
  struct Line * prev;
  char * text;
  unsigned short shift_count;
  lineend_type return_type;
  char syntax_marker;	/* bitmask composed of values below */
};
#define syntax_none	0
#define syntax_HTML	1
#define syntax_JSP	2
#define syntax_comment	4

typedef struct Line LINE;

/* Dummy line indicator */
#define DUMMY		0x80
#define DUMMY_MASK	0x7F

/* Expression definitions */
#define NO_MATCH	0
#define MATCH		1
#define REG_ERROR	2

#define BEGIN_LINE	(2 * REG_ERROR)
#define END_LINE	(2 * BEGIN_LINE)

/*
 * For casting functions with int/void results
 */
typedef void (* voidfunc) ();
typedef unsigned long (* charfunc) ();
typedef int (* intfunc) ();

/*
 * The regex structure. Status can be any of 0, BEGIN_LINE or REG_ERROR. In
 * the last case, the result.err_mess field is assigned. Start_ptr and end_ptr
 * point to the match found. For more details see the documentation file.
 */
struct regex {
  union {
  	char * err_mess;
  	int * expression;
  } result;
  char status;
  LINE * start_line;
  char * start_ptr;
  LINE * end_line;
  char * end_ptr;
};

typedef struct regex REGEX;

/* NULL definitions */
#define NIL_PTR		((char *) 0)
#define NIL_LINE	((LINE *) 0)
#define NIL_REG		((REGEX *) 0)
#define NIL_INT		((int *) 0)


/***************************************************************************\
	declaration of system functions
\***************************************************************************/

#ifdef define_read_write	/* don't define to be compatible */
extern int write ();
extern int read ();
extern ssize_t write ();	/* but how do I find out if */
extern ssize_t read ();		/* ssize_t is defined on a system? */
#endif
extern int access ();
/*extern int open ();*/
extern int close ();
/*extern int creat ();*/
extern int chdir ();
extern int system ();
extern int isatty ();
#ifndef strcmp
extern int strcmp ();
#endif


/***************************************************************************\
	variable declarations
\***************************************************************************/

extern int total_lines;		/* Number of lines in file */
extern long total_chars;	/* Number of characters in file */
extern LINE * header;		/* Head of line list */
extern LINE * tail;		/* Last line in line list */
extern LINE * top_line;		/* First line of screen */
extern LINE * bot_line;		/* Last line of screen */
extern LINE * cur_line;		/* Current line in use */
extern char * cur_text;		/* Pointer to char on current line in use */
extern int last_y;		/* Last y of screen, usually SCREENMAX */
extern int line_number;		/* current line # determined by file_status */
extern int lines_per_page;	/* assumption for file_status */

extern int x, y;		/* x, y coordinates on screen */
extern FLAG modified;		/* Set when file is modified */
extern FLAG viewonly;		/* Set when view only mode is selected */
extern FLAG restricted;		/* Set when restricted mode is selected */
extern FLAG mined_keypad;	/* Apply mined keypad assignments */
extern FLAG mined_del_is_cut;	/* Del key cuts buffer */
extern FLAG quit;		/* Set when quit character is typed */
extern FLAG intr_char;		/* Set when intr character is typed */
extern FLAG winchg;		/* Set when the window size changes */
extern FLAG interrupted;	/* Set when a signal interrupts */
extern FLAG waitingforinput;	/* Set while waiting for the next command key */
extern FLAG isscreenmode;	/* Set when screen mode is on */
extern unsigned int out_count;	/* Index in output buffer */
extern char text_buffer [MAX_CHARS];	/* Buffer for modifying text */
extern int input_fd;		/* File descriptors for terminal dialog */
extern int output_fd;
extern PROT fprot;		/* To be used for file creatings */
extern PROT bufprot;		/* To be used for paste buffer file */

#ifdef unix
extern char * window_string_code;
extern char window_string [];	/* to set text in window headline and icon */
#endif

extern char yank_file [];	/* Temp. file for buffer */
extern char yankie_file [];	/* Temp. file for inter-window buffer */
extern char html_file [];	/* Temp. file for HTML embedding buffer */
extern char panic_file [];	/* file for panic-write-back */
extern FLAG yank_status;	/* Status of yank_file */
extern FLAG html_status;	/* Status of html_file */
extern FLAG redraw_pending;	/* was a redraw suppressed in find_y ? */
extern long chars_saved;	/* # of chars saved in paste buffer */
extern long bytes_saved;	/* # of bytes saved in paste buffer */
extern int lines_saved;	/* # of lines saved in paste buffer */

extern int hop_flag;		/* set to 2 by HOP key function */
extern int buffer_open_flag;	/* counter flag for the collective buffer */
extern int JUSlevel;		/* keep justified while typing? */
extern int JUSmode;		/* 1: paragraphs end at empty line */
extern FLAG autoindent;		/* auto indent on input of Enter? */
extern FLAG dim_HTML;		/* display HTML dimmed ? */
extern FLAG insert_mode;	/* insert or overwrite */
extern FLAG append_flag;	/* Set when buffer should be appended to */
extern character erase_char;	/* effective (configured) char for erase left */
extern char emulation;		/* 'w' for WordStar, 'e' for emacs */
extern FLAG emacs_buffer;	/* enable emacs buffer fct for ^K/^T */
extern FLAG paste_stay_left;	/* cursor stays before pasted region */
extern character control_prefix; /* ^V/^P/^Q character to prefix control chars */
extern character quit_char;	/* ^\/^G character to cancel command */
extern FLAG Turkish;		/* enable Turkish case toggle specials ? */
extern FLAG smart_quotes;	/* replace " with typographic quote ? */
extern FLAG utf8_screen;	/* screen driven in UTF-8 mode ? */
extern FLAG utf8_input;		/* keyboard input in UTF-8 mode ? */
extern FLAG cjk_term;		/* terminal in CJK mode ? */
extern FLAG gb18030_term;	/* does CJK terminal support GB18030 ? */
extern FLAG euc3_term;		/* does CJK terminal support EUC 3 byte ? */
extern FLAG euc4_term;		/* does CJK terminal support EUC 4 byte ? */
extern FLAG cjklow_term;	/* does CJK terminal support 81-9F range ? */
extern FLAG cjk_text;		/* text in CJK encoding ? */
extern FLAG utf8_text;		/* text in UTF-8 representation ? */
extern FLAG mapped_text;	/* text in 8 bit, non-Latin-1 representation ? */
extern FLAG utf8_lineends;	/* support UTF-8 LS and PS line ends ? */
extern FLAG poormansbidi;	/* poor man's bidirectional support ? */
extern FLAG disp_scrollbar;	/* shall scrollbar be displayed ? */
extern FLAG fine_scrollbar;	/* fine-grained UTF-8 scrollbar ? */
extern FLAG update_scrollbar_lazy;	/* partial scrollbar refresh as needed ? */
extern FLAG combining_mode;	/* UTF-8 combining character support ? */
extern int width_data_version;
extern FLAG utf_cjk_wide_padding; /* always display CJK on UTF double-width ? */
extern FLAG combining_screen;	/* UTF-8 combining character terminal ? */
extern FLAG bidi_screen;	/* UTF-8 bidi terminal ? */
extern FLAG display_block_graphics;	/* display control chars as graphics */
extern FLAG no_window_title;	/* suppress filename display in window title? */

extern long last_delta_readchar;	/* delay between last 2 characters */
extern long average_delta_readchar;	/* average delay between last characters */
extern FLAG loading;		/* Loading a file? Init True for error handling */
extern char file_name [];	/* name of file being edited */
extern char screen [];		/* I/O buffer for "writes" and "reads" */
extern FLAG wordnonblank;	/* handle all non-blank sequences as words */
extern FLAG proportional;	/* Enable support for proportional fonts? */
extern FLAG translate_output;	/* Transform output diacritics to strings */
extern char * transout;		/* Output transformation table */
extern char * dimansi;		/* special character dimming ANSI sequence */
extern char * ctrlansi;		/* control character display ANSI sequence */
extern char * uniansi;		/* Unicode character display ANSI sequence */
extern char * unimarkansi;	/* Unicode (lineend) marker display ANSI sequence */
extern char * combiningansi;	/* combining character display ANSI sequence */
extern char * menuansi;		/* menu line ANSI sequence */
extern char * HTMLansi;		/* HTML display ANSI sequence */
extern char * diagansi;		/* dialog (bottom status) line ANSI sequence */
extern char * scrollfgansi;	/* scrollbar foreground ANSI sequence */
extern char * scrollbgansi;	/* scrollbar background ANSI sequence */
extern int translen;		/* length of " */
extern FLAG controlQS;		/* must respect ^Q/^S handshake ? */
extern int display_delay;	/* delay between display lines */

extern char TABchar;		/* Char to be shown in place of tab chars */
extern char TABchar0;		/* Char to be shown at start of tab chars */
extern char TABchar2;		/* Char to be shown at end of tab chars */
extern char TABcharmid;		/* Char to be shown in middle of tab chars */
extern char SHIFT_BEG;		/* Char indicating that line continues left */
extern char RET_MARK;		/* Char indicating end of line */
extern char DOSRET_MARK;	/* Char indicating DOS end of line */
extern char PARA_MARK;		/* Char indicating end of paragraph */
extern char RET_BLANK;		/* Char to fill the end of line with */
extern char RET_BLANK2;		/* Char to fill last position of line with */
extern char * UTF_TAB;		/* Char to be shown in place of tab chars */
extern char * UTF_TAB0;		/* Char to be shown at start of tab chars */
extern char * UTF_TAB2;		/* Char to be shown at end of tab chars */
extern char * UTF_TABmid;	/* Char to be shown in middle of tab chars */
extern char * UTF_RET;		/* Char indicating end of line */
extern char * UTF_DOSRET;	/* Char indicating DOS end of line */
extern char * UTF_PARA;		/* Char indicating end of paragraph */
extern char * UTF_RETblank;	/* Char to fill the end of line with */
extern char * UTF_RETblank2;	/* Char to fill last position of line with */
extern char UNI_MARK;		/* char to be shown in place of Unicode char */
extern char TABdefault;		/* Char displayed instead of TABs */
extern char RETdefault;		/* Char displayed to indicate line-end */
extern char DOSRETdefault;	/* Char displayed to indicate DOS line-end */
extern char PARAdefault;	/* Char displayed to indicate end of paragraph */
extern FLAG paradisp;		/* Shall paragraph end be distinguished? */
extern char SHIFT_MARK;		/* Char indicating that line continues */
extern character ring;		/* Ring accent character */
#define UNI_ring (character) ''
#define UNI_acute (character) ''
#ifdef pc_charset
#define DOS_ring (character) 0xF8
#define DOS_acute (character) 0xEF
#endif

extern FLAG rpipe;		/* Set if file should be read from stdin */
extern FLAG stat_visible;	/* Set if status_line is visible */
extern FLAG top_line_scrolled;	/* was menu line scrolled away? */
extern FLAG always_disp_code;	/* Permanent char code display on status line? */
extern FLAG use_extracset;	/* Set if MINEDMARK enables graph. mark mode */
extern FLAG use_curses;		/* True if compiled with CURSES */

extern char * pc_charmap;	/* PC character set mapping */

extern voidfunc key_map [256];
extern voidfunc ws_key_map [32];
extern voidfunc emacs_key_map [32];
extern voidfunc pc_key_map [256];

extern FLAG page_scroll;	/* use scroll for page up/down */
extern FLAG page_stay;		/* stay at edge of page after page up/down */
extern FLAG cansuspendmyself;

/* terminal feature indications */
extern FLAG can_scroll_reverse;
extern FLAG can_add_line;
extern FLAG can_delete_line;
extern FLAG can_clear_eol;
extern FLAG can_alt_cset;


/***************************************************************************\
	declaration of mined functions
\***************************************************************************/

extern int find_y ();
extern int find_y_w_o_RD ();
extern int yankfile ();
extern long get_number ();
extern int get_hex_number ();
extern void display ();
extern void reset ();
extern void move_y ();
extern void move_to ();
extern void set_cursor_xy ();
extern void put_line ();
extern void move_address ();
extern void move_address_w_o_RD ();

extern int length_of _((char *));
extern int utf8_col_count _((char *));
extern int char_count _((char *));
extern int utf8_count _((char *));
extern int col_count _((char *));

extern int insert ();
extern void copy_string ();
extern int get_file ();
extern int get_line ();
extern void bad_write ();
extern void file_status ();
extern void calc_line_no ();
extern int find_x ();
extern void RDwin ();
extern void RD_window_title ();
extern void clear_window_title ();
extern void RD_y ();
extern void panicio ();
extern int panicwrite ();
extern void edit_nth_file ();
extern FLAG save_text_load_file ();

extern void checkout (), checkin ();

extern lineend_type extract_lineend_type _((char *, int));
extern lineend_type default_lineend;

extern unsigned long compose ();
extern unsigned long compose_mnemo ();
extern int idfchar ();
extern unsigned long grave ();
extern unsigned long circumflex ();
extern unsigned long acute ();
extern unsigned long diaeresis ();
extern unsigned long tilde ();
extern unsigned long angstrom ();
extern void insert_grave ();
extern void insert_circumflex ();
extern void insert_acute ();
extern void insert_diaeresis ();
extern void insert_tilde ();
extern void insert_angstrom ();

/* aux: */
extern void delete_yank_files ();
extern void catch_interrupt ();
extern char * scan_int _((char *, int *));

/* status line handling */
extern void rd_bottom_line ();
extern void redraw_prompt ();
extern void clear_lastline ();


/* keyboard input */
extern voidfunc keyproc;	/* function addressed by entered function key */
extern char keyshift;		/* shift state of entered function key */
/* shift state indications of escape sequences */
/*
ctrl	alt	shift	ESC code/ -1	keyshift code
0	0	0	0		000
0	0	1	2	1	001
0	1	0	3	2	010
0	1	1	4	3	011
1	0	0	5	4	100
1	0	1	6	5	101
1	1	0	7	6	110
1	1	1	8	7	111
*/
/* shift state masks (indications decremented by 1) */
#define ctrl_mask	0x4
#define alt_mask	0x2
#define shift_mask	0x1
#define ctrlshift_mask	(ctrl_mask | shift_mask)
#define altshift_mask	(alt_mask | shift_mask)
#define altctrl_mask	(alt_mask | ctrl_mask)
#define altctrlshift_mask	(alt_mask | ctrl_mask | shift_mask)


/*
 * Convert cnt to nearest tab position
 */
extern int tabsize;
#define tab(cnt)		(((cnt) + tabsize) & ~(tabsize - 1))
#define tab8(cnt)		(((cnt) + 8) & ~07)
#define is_tab(c)		((c) == '\t')
/*
 * Word definitions
 */
#define white_space(c)	((c) == ' ' || (c) == '\t')
#define alpha(c)	((c) != ' ' && (c) != '\t' && (c) != '\n')

/* Set cursor at coordinates x, y */
#define set_cursor(nx, ny)	move_cursor(nx, ny)


extern void reset_get_line ();
extern void show_get_l_errors ();
extern char * serror ();
extern char * serrorof ();
extern int geterrno ();

extern int get_idf ();

extern void set_modified ();

extern LINE * proceed ();
extern LINE * match ();
extern LINE * line_insert ();
extern char syntax_state ();
extern void update_text_state ();
extern char * num_out ();
extern character promptyn ();
extern FLAG display_scrollbar ();
extern void scrollbar_scroll_up _((int));
extern void scrollbar_scroll_down _((int));
extern FLAG checkoverwrite ();
extern void delete_file ();
extern char * unnull ();
extern void search_for ();
extern void search_expr ();
extern void search_corresponding ();
extern void viewonlyerr ();
extern void restrictederr ();

/* editing functions */
extern void yank_HTML ();
extern void paste_HTML ();
extern int delete_text ();

/* prompt line */
extern FLAG char_on_status_line; /* is output active on status line ? */
extern FLAG input_active;
extern int lpos;

/* output functions */
extern int iscontrol ();
extern character controlchar ();
extern void putcharacter ();
extern void putmark ();
extern void put_blanks ();
extern int flush_buffer ();

/* screen output functions */
#define putchar(c)	__putchar ((character) c)
extern void put_utfchar ();
extern int writeout ();
extern void putoutstring ();
extern void _put_unichar ();
extern int _put_cjkchar ();
/* insert cast needed for Turbo-C: */
#define put_unichar(c)	_put_unichar ((unsigned long) c)
#define put_cjkchar(c)	_put_cjkchar ((unsigned long) c)

/* character handling */
extern char * script ();

/* file output functions */
extern int writechar ();
extern int write_lineend ();

/* special stuff */
extern void panic ();
extern char * alloc ();
extern void free_space ();
extern LINE * alloc_header ();
extern void free_header ();

extern voidfunc command ();

/* character encoding handling */
extern unsigned long cjk ();
extern unsigned int lookup_cjk ();
extern void set_mapped_text ();
extern unsigned long max_cjk_value ();

/* charmaps exports */
extern void set_cjk_table ();
extern unsigned int map_char ();
extern unsigned long unmap_char ();
extern char cjk_encoding;
extern char * cjk_encoding_flag;

/* keyboard mapping menu handling */
#define allow_keymap ((utf8_input == True && (utf8_text == True || cjk_text == True || visciimode ())) || cjk_term == True)
extern char selection_space;
#define SPACE_NEXT	'n'
#define SPACE_NEXTROW	'r'
#define SPACE_SELECT	's'

/* menu handling */
extern void QUICKMEN (), openmenu (), openmenuat ();
extern int popup_menu ();
extern mousebutton mouse_button, mouse_lastbutton, mouse_prevbutton;
extern int mouse_shift;
extern int mouse_xpos, mouse_ypos, mouse_lastxpos, mouse_lastypos;
extern FLAG report_release;
extern void clean_menus ();
extern int is_menu_open ();
extern void displaymenuline ();
extern void redrawmenu ();
extern void displayflags ();
extern void toggleappend ();
extern void set_scripttag ();
extern FLAG flags_changed;	/* should flags menu area be redrawn? */
extern FLAG in_menu_border;

/* menu data structure */
typedef struct {
	char * itemname;
	voidfunc itemfu;
	char * hopitemname;
	char tag;
	} menuitemtype;

/* from mined2.c */
extern int quote_type;
extern void quote_type_down _((void));
extern void quote_type_up _((void));
extern void set_quote_type _((int));
extern void set_quote_style _((char *));
/* from mousemen.c */
extern int count_quote_types _((void));
extern char * quote_mark _((int, int));
extern int lookup_quotes _((char *));

/* The main editing functions */

extern void invoke_key_function _((unsigned long));

extern void QUICKMENU _((void)), FILEMENU _((void)), EDITMENU _((void));
extern void SEARCHMENU _((void)), EXTRAMENU _((void)), PARAMENU _((void));
extern void MOUSEescape _((void));
extern void MUP _((void)), MDN _((void)), MLF _((void)), MRT _((void)), MNW _((void)), MPW _((void));
extern void ctrl_MLF _((void)), ctrl_MRT _((void));
extern void BSEN _((void)), ESEN _((void)), SCORR _((void));
extern void SD _((void)), SU _((void)), PD _((void)), PU _((void)), BFILE _((void)), EFILE _((void));
extern void BLINE _((void)), ELINE _((void)), MPPARA _((void)), MNPARA _((void)), HIGH _((void)), LOW _((void));
extern void SNL _((void)), LIB _((void)), DPC _((void)), DCC _((void)), DLN _((void)), DNW _((void)), DPW _((void));
extern void DCC0 _((void)), DPC0 _((void));
extern void CTRLINS _((void)), DLINE _((void)), TOGINS _((void)), ctrlQ _((void)), ctrlK _((void)), ctrlO _((void));
extern void search_wrong_enc _((void));
extern void JUS _((void)), JUSclever _((void)), JUSandreturn _((void));
extern void QUED _((void)), WT _((void)), WTU _((void)), SAVEAS _((void)), SAVPOS _((void)), EDIT _((void)), NN _((void));
extern void RD _((void)), RDwin _((void)), I _((void));
extern void EXED _((void)), VIEW _((void)), GOTO _((void)), GOMA _((void)), HELP _((void));
extern void SFW _((void)), SRV _((void)), RS _((void)), LR _((void)), GR _((void)), REPL _((void));
extern void MARK _((void)), COPY _((void)), CUT _((void)), PASTE _((void)), PASTEstay _((void)), YANKRING _((void));
extern void WB _((void)), INSFILE _((void));
extern void HOMEkey _((void)), ENDkey _((void)), DELkey _((void)), smallHOMEkey _((void)), smallENDkey _((void));
extern void HOP _((void)), CANCEL _((void)), ESCAPE _((void)), FUNKEY _((void));
extern void EMAX _((void)), META _((void)), UNDO _((void));
extern void CHDI _((void)), PBUF _((void)), CMD _((void)), SH _((void)), SUSP _((void));
extern void LNCI _((void)), LNSW _((void));
extern void LOWCAP _((void)), LOWER _((void)), UPPER _((void)), CAPWORD _((void));
extern void Stag _((void));
extern void SIDFW _((void)), SIDRV _((void)), HTML _((void)), MARKER _((void)), GOMARKER _((void));
extern void EDITmode _((void)), VIEWmode _((void));
extern void NXTFILE _((void)), PRVFILE _((void)), NTHFILE _((void)), EXFILE _((void)), EXMINED _((void));
extern void ADJLM _((void)), ADJFLM _((void)), ADJNLM _((void)), ADJRM _((void)), ADJPAGELEN _((void));
extern void FS _((void)), FSTAT _((void)), HELPF _((void)), HELPS _((void)), HELPC _((void)), HELPA _((void));
extern void display_code _((void)), display_the_code _((void));
extern void toggletab _((void));
extern void changeuni _((void)), changehex _((void)), changeoct _((void)), changedec _((void));
extern void screensmaller _((void)), screenbigger _((void)), screenlesslines _((void)), screenmorelines _((void));

extern void toggleKEYMAP _((void)), setupKEYMAP _((void));

extern void Sdoublequote _((void)), Ssinglequote _((void));
extern void S _((character)), S0 _((character)), Scharacter _((unsigned long));

extern void goline _((int)), goproz _((int));

extern void SIDF _((FLAG));
extern void Pushmark _((void)), Popmark _((void));
extern void MARKn _((int)), GOMAn _((int)), Markn _((int));
extern void UML _((char)), REPT _((char)), BAD _((character));

/*
   Recognize multi-character prefix bytes (CJK)
 */
#define multichar(c)	((character) c >= 0x80 && (cjk_text == False || cjk_encoding != 'S' || (character) c < 0xA1 || (character) c > 0xDF))

extern int visciimode _((void));
extern int isviscii _((character));

extern char * charbegin _((char *, char *));
extern void advance_utf8_scr _((char * *, int *, char *));
extern void advance_utf8 _((char * *));
extern void advance_char_scr _((char * *, int *, char *));
extern void advance_char _((char * *));
extern void precede_char _((char * *, char *));
extern unsigned long charvalue _((character *));
extern unsigned long precedingchar _((char *, char *));
extern int UTF_len _((char));
extern int CJK_len _((character *));
extern int UTFseq_len _((char *));
extern int uniUTF _((unsigned long, character *));
extern int cjkencode _((unsigned long, character *));
extern void utf8_info _((char *, int *, unsigned long *));
extern int uniscrwidth _((unsigned long, char *, char *));
extern int iswide _((unsigned long));
extern int iscombining _((unsigned long));
extern int iscombined _((unsigned long, char *, char *));
extern int isjoined _((unsigned long, char *, char *));
extern unsigned long isolated_alef _((unsigned long));
extern int is_locale_utf8 _((void));
extern char * locale_terminal_encoding _((void));
extern char * locale_text_encoding _((void));

/*
 * String functions
 */
#define streq(s1, s2)		(strcmp (s1, s2) == 0)
#define strisprefix(s1, s2)	(strncmp (s2, s1, strlen (s1)) == 0)

/*
 * Empty output buffer
 */
#define clear_buffer()		(out_count = 0)

/*
 * Print line on terminal at offset 0 and clear tail of line
 */
#define line_print(scry, line)	put_line (scry, line, 0, True, False)

/*
 * Functions handling status_line. ON means in reverse video.
 */
extern int bottom_line ();
#define status_msg(str)		status_line (str, NIL_PTR)
#define status_line(str1, str2)		\
	(void) bottom_line (ON, (str1), (str2), NIL_PTR, False, "")
#define status_beg(str)			\
	(void) bottom_line (ON, (str), NIL_PTR, NIL_PTR, True, "")
#define error(str1, str2)		\
	(void) bottom_line (ON, (str1), (str2), NIL_PTR, False, "")
#define clear_status()			\
	(void) bottom_line (OFF, NIL_PTR, NIL_PTR, NIL_PTR, False, "")
#define get_string(str1, str2, fl, term_chars)	\
	bottom_line (ON, (str1), NIL_PTR, (str2), fl, term_chars)

/*
 * Print info about current file and buffer.
 */
#define fstatus(mess, bytes, chars)	\
	file_status ((mess), (bytes), file_name, total_lines, True, writable, modified, viewonly, (chars))

/*
 * Build formatted string.
 * If this definition is left out, a routine will be defined in mined1.c.
 */
#define build_string sprintf /**/

/*
 * Get real shift value.
 */
#define get_shift(cnt)		((cnt) & DUMMY_MASK)


/***************************************************************************\
	end
\***************************************************************************/
