# Soong to Makefile translator
#
# Copyright 2020 Andrej Shadura
#
# SPDX-License-Identifier: MIT
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

from .parser import soong
from .model import defaults, all_targets, all_modules, Module
from .utils import mergedefaults, print_vars
from .builders import flag_defaults, extra_targets
import os

def run():
    import sys
    global all_modules

    if len(sys.argv) > 1:
        bp = sys.argv[1]
    else:
        bp = "Android.bp"
    recipe = open(bp).read()

    if len(sys.argv) > 2:
        sys.stdout = open(sys.argv[2], 'w')

    flag_defaults()

    results = soong.parseString(recipe)
    all_modules.clear()
    all_modules += [r.arguments['name'] for r in results if isinstance(r, Module)]
    for r in results:
        r.run()

    print(f"build: {' '.join(all_targets)}")
    if all_targets:
        clean_targets = [f"clean-{target}" for target in all_targets]
        print(f"clean: {' '.join(clean_targets)}")
    else:
        print(f"clean:")
    extra_targets()
