//
// Copyright (C) 2008-2009 Jordi Mas i Hernandez, jmas@softcatala.org
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using Glade;
using Gtk;
using Mono.Unix;
using System.Collections;

namespace Mistelix.Dialogs
{
	// GTK.Dialog
	//
	// Catch the event OK from Glade to call OnOk 
	//
	public class GtkDialog
	{
		Glade.XML xml;
		Gtk.Dialog dialog;
		string dialog_name;

		public GtkDialog (string dialog_name)
		{
			this.dialog_name = dialog_name;
			xml = new Glade.XML (null, "mistelix.glade", dialog_name, "mistelix");
			xml.Autoconnect (this);
			Dialog.IconName = "mistelix";
			dialog = null;
		}

		public virtual ResponseType Run ()
		{
			ResponseType response = (ResponseType) Dialog.Run ();
			Destroy ();
			return response;
		}

		public ResponseType RunNoDestroy ()
		{
			ResponseType response = (ResponseType) Dialog.Run ();
			return response;
		}

		public Gtk.Dialog Dialog {
			get {
				if (dialog == null)
					dialog = (Gtk.Dialog) xml.GetWidget (dialog_name);
				
				return dialog;
			}
		}

		public virtual void Destroy ()
		{
			Dialog.Destroy ();
			FreeResources ();
		}

		// Free any resources allocated by this dialog box
		virtual public void FreeResources ()
		{
		}
	}
}
