/////////////////////////////////////////////////////////////////////////////
// Name:        ConsoleHelper.h
// Purpose:
// Author:      Stefan Langhammer
// Modified by:
// Created:     04.06.06
// Modified:    06.06.2006
// Copyright:   (c) Stefan Langhammer, Thomas Rogg
// Licence:     LGPL
/////////////////////////////////////////////////////////////////////////////

// -----------------------------------------------------------------------------
//	Console helper commands
// -----------------------------------------------------------------------------
bool bCloseApp = false;

#include <fstream>
#include <iostream>
using namespace std;

// -----------------------------------------------------------------------------
//	LoadSettings - load scratchlib calibration settings
// -----------------------------------------------------------------------------
bool LoadSettings(float &fCalibration)
{
    fstream f;
    f.open("ScratchlibExample.ini", ios::in);
	if (!f.is_open())
		return false;
	f>>fCalibration;
    f.close();
	return true;
}

// -----------------------------------------------------------------------------
//	StoreSettings - store scratchlib calibration settings
// -----------------------------------------------------------------------------
void StoreSettings(float fCalibration)
{
    fstream f;
    f.open("ScratchlibExample.ini", ios::out);
    f << fCalibration << endl;
    f.close();
}


#ifdef WIN32
	#include <iostream> 
	#include <windows.h> 

	// sets the cursor to position x,y
	void gotoxy(int x, int y) 
	{ 
		HANDLE hConsoleOutput; 
		COORD dwCursorPosition; 

		dwCursorPosition.X = x; 
		dwCursorPosition.Y = y; 
		hConsoleOutput = GetStdHandle(STD_OUTPUT_HANDLE); 
		SetConsoleCursorPosition(hConsoleOutput,dwCursorPosition);
	}
	// clears the screen
	void clearScreen()
	{
		system("cls");
	}
	// Close event return messages
	BOOL WINAPI ConsoleHandler(DWORD CEvent)
	{
		char mesg[128];

		switch(CEvent)
		{
		case CTRL_C_EVENT:
			bCloseApp = true;
			break;
		case CTRL_BREAK_EVENT:
			bCloseApp = true;
			break;
		case CTRL_CLOSE_EVENT:
			bCloseApp = true;
			break;
		case CTRL_LOGOFF_EVENT:
			bCloseApp = true;
			break;
		case CTRL_SHUTDOWN_EVENT:
			bCloseApp = true;
			break;
		}
		return TRUE;
	}

	// sets the close event handler
	void SetCloseHandler()
	{
		if (SetConsoleCtrlHandler(
		(PHANDLER_ROUTINE)ConsoleHandler,TRUE)==FALSE)
		{
			printf("Unable to install close handler!\n");
		}
	}

#else // Linux
	#include <stdlib.h>

	// sets the cursor to position x,y
	void gotoxy(int x, int y)
	{
		char buf[16];
		sprintf( buf, "\033[%d;%dH",x ,y );
		cout << buf;
	}

	// clears the screen
	void clearScreen()
	{
		system("clear");
	}

	// sets the close event handler
	void SetCloseHandler()
	{
		//TODO
	}
#endif
