#!/bin/sh
# Simple wrapper script used to start mkgmap-splitter in Debian
set -e

# Override to a specific one using $JAVACMD
ALTERNATIVE_JDK="`readlink -n -f /etc/alternatives/java`"

# Let's get the current architecture -- needed for multiarchified Java
ARCH="`dpkg --print-architecture`"

JAVA_CMDS="$JAVA_HOME/bin/java /usr/lib/jvm/java-7-openjdk-$ARCH/bin/java /usr/bin/java"

if [ -z "$JAVA_OPTS" -o $(echo "$JAVA_OPTS" | grep "\-Xmx" | wc -l) -eq 0 ]; then
   JAVA_OPTS="$JAVA_OPTS -Xmx2000m"
fi

for jcmd in $JAVA_CMDS; do
   if [ "z$ALTERNATIVE_JDK" = "z`readlink -n -f $jcmd`" ] && [ -z "${JAVACMD}" ]; then
      JAVACMD="$jcmd"
   fi
done

for jcmd in $JAVA_CMDS; do
   if [ -x "$jcmd" -a -z "${JAVACMD}" ]; then
      JAVACMD="$jcmd"
   fi
done

if [ "$JAVACMD" ]; then
   echo "Using $JAVACMD to execute mkgmap-splitter."
   exec $JAVACMD $JAVA_OPTS -jar /usr/share/mkgmap-splitter/splitter.jar "$@"
else
   echo "No valid JVM found to run mkgmap-splitter."
   exit 1
fi
