#!/usr/bin/python2.4
#
# Copyright 2006 Soeren Boll Overgaard <boll@fork.dk>
#
# This file is part of mlmmjadmd.
#
# mlmmjadmd is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# mlmmjadmd is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mlmmjadmd; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import mlmmjadm.conf;
import mlmmjadm.auth;
import logging;
import crypt;
import optparse;
import sys;

opts = optparse.OptionParser();
configuration = mlmmjadm.conf.Configuration();

opts.add_option("-f",
                "--fix-users-file",
                action="store_true",
                dest="fixUsersFile",
                help="Attempt to fix the specified users file, creating a new one if necessary. This option is incompatible with the -p and -u options.");
opts.add_option("-d",
                "--debug", 
                action="store_true", 
                dest="mlmmjAdmDebug",
                help="Enable debugging output");
opts.add_option("-u", 
                "--users-file", 
                dest="mlmmjAdmUsers",
                help="Specify the path to mlmmjadms users file");
                
opts.add_option("-n",
                "--username",
                dest="username",
                help="Username of the user to add");
opts.add_option("-p",
                "--password",
                dest="password",
                help="Password of the user to add");
                
(options, args) = opts.parse_args();

logging.basicConfig(level=logging.DEBUG,
                    format='%(asctime)s %(name)-12s %(levelname)-8s %(message)s',
                    datefmt='%m-%d %H:%M:%S',
                    filemode='w');

if options.mlmmjAdmDebug:
    logging.debug("Setting debug to "+str(options.mlmmjAdmDebug));
    configuration.setDebug(options.mlmmjAdmDebug);
if not configuration.getDebug():
    logging.disable(logging.DEBUG);
if options.mlmmjAdmUsers:
    logging.debug("Setting users file to: "+options.mlmmjAdmUsers);
    configuration.setUsersFile(options.mlmmjAdmUsers);
if options.fixUsersFile:
    logging.info("Determining if  "+configuration.getUsersFile()+" is valid.");
    authenticator = mlmmjadm.auth.Authenticator();
    if not authenticator.usersFileOk():
        logging.warn("Users file appears broken or missing. Trying to fix it.");
        if authenticator.fixUsersFile():
            logging.info("Successfully fixed users file");
            sys.exit(0);
        else:
            logging.fatal("Unable to fix users file");
            sys.exit(1);
    else:
        logging.info("Config file appears to be OK");
        sys.exit(0);
if not options.username or not options.password:
    logging.fatal("A username and a password must be supplied");
    sys.exit(1);
    
authenticator = mlmmjadm.auth.Authenticator();
if not authenticator.usersFileOk():
    logging.fatal("There was a problem with the configuration file. Please consult the messages above (if any).");
    sys.exit(1);
if authenticator.addUser(options.username, options.password):
    logging.info("Successfully added user "+options.username);
else:
    logging.fatal("Unable to add user "+options.username);