#!/usr/bin/python2.4
#
# Copyright 2006 Soeren Boll Overgaard <boll@fork.dk>
#
# This file is part of mlmmjadmd.
#
# mlmmjadmd is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# mlmmjadmd is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with mlmmjadmd; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

from ConfigParser import SafeConfigParser;
import mlmmjadm.conf;
import sys;

configuration = mlmmjadm.conf.Configuration();
section = "Conf";
parser = SafeConfigParser();
parser.add_section(section);

# Grab a copy of the current configuration, so we 
# can make sensible default suggestions
mlmmjBinPrefix = configuration.getMlmmjBinPrefix();
mlmmjListBase = configuration.getListBase();
mlmmjAdmUsersFile = configuration.getUsersFile();
mlmmjAdmBindAddress = configuration.getBindAddress();
mlmmjAdmBindPort = str(configuration.getBindPort());
mlmmjAdmLogFile = configuration.getLogFile();
mlmmjAdmPidFile = configuration.getPidFile();
mlmmjAdmConfigFile = configuration.getConfigFile();
mlmmjAdmUser = configuration.getUser();
mlmmjAdmGroup = configuration.getGroup();
mlmmjListTextsDir = configuration.getMlmmjListTextsDir();


def prompt(text, default="None"):
    if not default: default = "";
    sys.stdout.write(text+" ["+default+"]: ");

def readLine():
    tmp = None;
    try:
        tmp = sys.stdin.readline().strip();
    except KeyboardInterrupt, e:
        print "Caught keyboard interrrupt. Exiting.";
        sys.exit(0);
    if not tmp:
        return None;
    if len(tmp)<=1: 
        return None;
    return tmp;
    
def setConfigValue(name, value):
    global parser;
    global section;
    if not value: return;
    parser.set(section, name, value);


prompt("Please enter the TCP port to bind to", mlmmjAdmBindPort);
input = readLine();
if (input): mlmmjAdmBindPort = input;

prompt("Please enter the IP to bind to", mlmmjAdmBindAddress);
input = readLine();
if (input): mlmmjAdmBindAddress = input;

prompt("Please enter the directory containing mlmmj binaries", mlmmjBinPrefix);
input = readLine();
if (input): mlmmjBinPrefix = input;

prompt("Please enter the complete path to the users file", mlmmjAdmUsersFile);
input = readLine();
if (input): mlmmjAdmUsersFile = input;

prompt("Please enter the complete path to the configuration file", mlmmjAdmConfigFile);
input = readLine();
if (input): mlmmjAdmConfigFile = input;

prompt("Please enter the complete path to mlmmj base dir", mlmmjListBase);
input = readLine();
if (input): mlmmjListBase = input;

prompt("Please enter the complete path to the log file", mlmmjAdmLogFile);
input = readLine();
if (input): mlmmjAdmLogFile = input;

prompt("Please enter the complete path to the PID file", mlmmjAdmPidFile);
input = readLine();
if (input): mlmmjAdmPidFile = input;

prompt("Please enter the user name that you would like mlmmjadmd to run as", mlmmjAdmUser);
input = readLine();
if (input): mlmmjAdmUser = input;

prompt("Please enter the group name that you would like mlmmjadmd to run as", mlmmjAdmGroup);
input = readLine();
if (input): mlmmjAdmGroup = input;

prompt("Please enter the path to the dir containing list texts", mlmmjListTextsDir);
input = readLine();
if (input): mlmmjListTextsDir = input;

print "Writing configuration to "+mlmmjAdmConfigFile;

setConfigValue("BindPort", mlmmjAdmBindPort);
setConfigValue("BindAddress", mlmmjAdmBindAddress);
setConfigValue("BinPrefix", mlmmjBinPrefix);
setConfigValue("ListBase", mlmmjListBase);
setConfigValue("UsersFile", mlmmjAdmUsersFile);
setConfigValue("LogFile", mlmmjAdmLogFile);
setConfigValue("PidFile", mlmmjAdmPidFile);
setConfigValue("User", mlmmjAdmUser);
setConfigValue("Group", mlmmjAdmGroup);
setConfigValue("ListTextsDir", mlmmjListTextsDir);

try: 
    configFh = open(mlmmjAdmConfigFile, "w");
    parser.write(configFh);
    configFh.close();
except IOError, e:
    print "Unable to open config file for writing: "+str(e);