# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: Dialog to set crop parameters.

# load libs
import wx

# load modules
from nucleus import mwx


class dlgCropParams(wx.Dialog):
    """ Set crop parameters. """

    # ----
    def __init__(self, parent, minX=None, maxX=None):
        wx.Dialog.__init__(self, parent, -1, "Set Crop Range", style=wx.DEFAULT_DIALOG_STYLE)

        self.data = [minX, maxX]

        # pack main frame
        mainBox = wx.BoxSizer(wx.VERTICAL)
        if wx.Platform == '__WXMAC__':
            mainBox.Add(self.makeParamsBox(), 0, wx.TOP|wx.LEFT|wx.RIGHT, 20)
            mainBox.Add(self.makeButtonBox(), 0, wx.ALIGN_CENTER|wx.ALL, 10)
        else:
            mainBox.Add(self.makeParamsBox(), 0, wx.ALL, 5)
            mainBox.Add(self.makeButtonBox(), 0, wx.ALIGN_CENTER|wx.ALL, 5)

        # fit layout
        mainBox.Fit(self)
        self.SetSizer(mainBox)
        self.Centre()
    # ----


    # ----
    def makeParamsBox(self):
        """ Make box for crop parameters. """

        # make items
        minX_label = wx.StaticText(self, -1, "Minimum mass:")
        self.minX_value = wx.TextCtrl(self, -1, str(self.data[0]), size=(100, -1), validator=mwx.txtValidator('digits'))
        maxX_label = wx.StaticText(self, -1, "Maximum mass:")
        self.maxX_value = wx.TextCtrl(self, -1, str(self.data[1]), size=(100, -1), validator=mwx.txtValidator('digits'))

        # pack items
        grid = mwx.GridBagSizer()
        grid.Add(minX_label, (0, 0), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.minX_value, (0, 1))
        grid.Add(maxX_label, (1, 0), flag=wx.ALIGN_CENTER_VERTICAL)
        grid.Add(self.maxX_value, (1, 1))

        return grid
    # ----


    # ----
    def makeButtonBox(self):
        """ Make box for main buttons. """

        # make items
        OK_button = wx.Button(self, wx.ID_OK, "OK")
        Cancel_button = wx.Button(self, wx.ID_CANCEL, "Cancel")

        # pack items
        buttonBox = wx.BoxSizer(wx.HORIZONTAL)
        buttonBox.Add(OK_button, 0, wx.ALL, 5)
        buttonBox.Add(Cancel_button, 0, wx.ALL, 5)

        # set events
        wx.EVT_BUTTON(self, wx.ID_OK, self.onDlgOK)

        # set defaults
        OK_button.SetDefault()

        return buttonBox
    # ----


    # ----
    def onDlgOK(self, evt):
        """ Get parameters. """

        # get params
        minX = self.minX_value.GetValue()
        maxX = self.maxX_value.GetValue()

        # test params
        try:
            minX = float(minX)
            maxX = float(maxX)
        except ValueError:
            return
        if minX >= maxX:
            return

        # end dialog
        self.data[0] = minX
        self.data[1] = maxX
        self.EndModal(wx.ID_OK)
    # ----
