# -------------------------------------------------------------------------
#     This file is part of mMass - the spectrum analysis tool for MS.
#     Copyright (C) 2005-07 Martin Strohalm <mmass@biographics.cz>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 2 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE in the
#     main directory of the program
# -------------------------------------------------------------------------

# Function: About application dialog.

# load libs
import wx

# load modules
import images


class dlgAbout(wx.Dialog):
    """About application"""

    # ----
    def __init__(self, parent):
        wx.Dialog.__init__(self, parent, -1, "About mMass", style=wx.DEFAULT_DIALOG_STYLE)

        # make items
        splash_bitmap = wx.StaticBitmap(self, -1, images.getSplashBitmap())
        WEB_button = wx.Button(self, wx.ID_OK, "Homepage")
        CANCEL_button = wx.Button(self, wx.ID_CANCEL, "Close")
        CANCEL_button.SetDefault()

        # pack items
        buttonSizer = wx.BoxSizer(wx.HORIZONTAL)
        buttonSizer.Add(WEB_button, 0, wx.ALL, 5)
        buttonSizer.Add(CANCEL_button, 0, wx.ALL, 5)

        mainSizer = wx.BoxSizer(wx.VERTICAL)
        mainSizer.Add(splash_bitmap, 0)
        mainSizer.Add(buttonSizer, 0, wx.ALL|wx.ALIGN_CENTER_HORIZONTAL, 5)

        # fit layout
        mainSizer.Fit(self)
        self.SetSizer(mainSizer)
        self.SetMinSize(self.GetSize())
        self.Centre()
    # ----
