      PROGRAM HISTMKE
*
      implicit none
C
#include "mnlun.inc"
C
      real hlim
      integer ilim
      COMMON //HLIM(300000)
      COMMON /PAWC/ILIM(300000)
C
      REAL XDAT(1000),YDAT(1000),DXDAT(1000),DYDAT(1000)
C
      real gaus1,gaus2,flat
      common /m8cwn1/ gaus1,gaus2,flat
      integer mvalmx
      parameter (mvalmx = 10)
      integer nval2
      real rval1,rval2,rval3,rval4,rtest1,rtest2
      double precision zval1,zval2
      logical qval1,qtest2
      common /m8cwn2/ rval1,qval1,rtest1(8),qtest2,rtest2(8,3)
     + ,nval2,rval2(mvalmx)
     + ,rval3(3,mvalmx),rval4(4,3,mvalmx)
      character cval1*20,cval2*12
      common /m8cwn3/ zval1,zval2(mvalmx)
      common /m8cwn4/ cval1,cval2(mvalmx)
      real GaussianDistribution1,GaussianDistribution2
     + ,Flattish_Distribution1,Flattish_Distribution2
     + ,Flat3
      common /m8cwn5/ GaussianDistribution1,GaussianDistribution2
     + ,Flattish_Distribution1,Flattish_Distribution2
     + ,Flat3
C
      INTEGER IDBIN(10)
      REAL ADLO(10),ADHI(10),ADAT(10)
      CHARACTER*32 TNAME(10),tnamen(10)
     + ,TAGS(10),TAG2(25),TAG3(4),TAG4(2)
C
C     List of histograms that are stored in the example file used in
C     the Mn_Fit tutorial and demos
C
      integer midlist,midntpl
      parameter (midlist = 7, midntpl = 1)
      integer idlist(midlist),idntpl(midntpl)
C
      CHARACTER*80 TITLE,tmp1
      CHARACTER*255 TMPDIR
      integer i,j,ii,jj,k,lunhb4,lunhbe,lunhb5,lun_dt,ierr,idn,nidn
     + ,idum,jdum,kdum
     + ,nbinx,nbiny,nwt,iad,icycle,nh,npnt,ndim
     + ,nchar,ind,nevt,tmplen,lent
      real pi,rdeg,x,y,z,wt,weight,sx,sy,dx,dy,xx,dxl,dxh,dyl,dyh
     + ,xlo,xhi,ylo,yhi
C
      real     rndm,gaus_ib,hij
      integer  lnblnk
      external rndm,gaus_ib,hij,lnblnk
C
      DATA TNAME/'X','Y','Z',7*' '/
      DATA TAGS/'Gaus1','Gaus2','Flat',2*' '
     + ,'GaussianDistribution1'
     + ,'GaussianDistribution2'
     + ,'Flattish_Distribution1'
     + ,'Flattish_Distribution2'
     + ,'Flattish_Distribution3'/
      DATA TAG2/
     + 'N1', 'N2', 'N3', 'N4', 'N5', 'N6', 'N7', 'N8', 'N9','N10'
     + ,'N11','N12','N13','N14','N15','N16','N17','N18','N19','N20'
     + ,'N21','N22','N23','N24','N25'/
      DATA TAG3/'VAR1','VAR2','WEIGHT','DWEIGHT'/
      DATA TAG4/'X','Y'/
C
      DATA IDUM/1234567/
C
      data idlist/1,2,5,6,7,9,10/
      data idntpl/31/
C
      pi   = 2.0*asin(1.0)
      rdeg = 180.0 / pi
C
      CALL CTINUN
      CALL CLEO_GETLUN(LUNHB4,'HISTMKE')
      CALL TYPINI
C
C     INITIALIZE MNBOOK
C
      CALL M_INIT(0)
C
C     Open the log file
C
#if ( defined(VMS) )
      OPEN(UNIT=LUNLPT,FILE='mn_tem:hist_make.dat',STATUS='UNKNOWN'
     1 ,FORM='FORMATTED',ERR=100)
      GOTO 150
 100  CONTINUE
      OPEN(UNIT=LUNLPT,FILE='hist_make.dat',STATUS='UNKNOWN'
     1 ,FORM='FORMATTED')
 150  CONTINUE
#endif
#if ( defined(UNIX) )
C     Modified to respect $TMPDIR on Unix
C     -- Kevin B. McCarty, 7 Jan 2005
      CALL GETENVF('TMPDIR', TMPDIR)
      TMPLEN = LNBLNK(TMPDIR)
      IF(TMPLEN.EQ.0) THEN
          TMPDIR = '/tmp'
          TMPLEN = 4
      ENDIF
      OPEN(UNIT=LUNLPT,FILE=TMPDIR(1:TMPLEN) // '/hist_make.dat',
     1STATUS='UNKNOWN',FORM='FORMATTED')
#endif

C
C     INITIALIZE HBOOK
C
      CALL HLIMIT(300000)
      CALL HOUTPU(LUNLPT)
C     CALL HERMES(LUNLPT)
C
C     Open the output file for the Ntuple
C
      CALL HROPEN(LUNHB4,'MNHB4','hbook4_test.his','N',1024,IERR)
      IF(IERR.NE.0) GOTO 9000
      CALL HCDIR('//MNHB4',' ')
      CALL HMDIR('NTUPLE','S')
      CALL HCDIR('//PAWC',' ')
      CALL HMDIR('NTUPLE','S')
      CALL HCDIR('//PAWC',' ')
C
C     BOOK THE HBOOK HISTOGRAMS
C
      CALL HBOOK1(1,'HBOOK: Simple Gaussian Histogram$',40,-2.0,2.0,0.0)
      CALL HBOOK1(2,'HBOOK: Simple Gaussian Histogram$',40,-2.5,2.5,0.0)
      CALL HBOOK1(3,'HBOOK: Weighted Histogram$',40,-2.0,2.0,0.0)
      CALL HBOOK1(4,'HBOOK: 2 Gaussians + Exponential Background$'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOK1(5,'HBOOK: Gaussian Signal$'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOK1(6,'HBOOK: Exponential Background$'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOK1(7,'HBOOK: Gaussian Signal + Exponential Background$'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOK1(8,'HBOOK: Straight Line Background$'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOK1(9,'HBOOK: High Statistics Gaussian for Fitting$'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOK2(10,'HBOOK: 2 Gaussians$',20,-2.0,2.0,15,-3.0,3.0,0.0)
      CALL HBOOK2(11,'HBOOK: High statistics 2 Gaussians$'
     1 ,20,-2.0,2.0,15,-3.0,3.0,0.0)
      CALL HBOOK2(13,'HBOOK: Surface for 2-D Plots'
     + ,15,-15.0,15.0,20,-5.0,15.0,0.0)
      CALL HBOOK1(14,'HBOOK: sin(x)/x to smooth'
     + ,20,-5.0,15.0,0.0)
      CALL HBOOK1(15,'HBOOK: Random weights around zero'
     + ,20,0.0,20.0,0.0)
      CALL HBOOK2(16,'HBOOK: Random weights around zero'
     + ,20,0.0,20.0,20,0.0,20.0,0.0)
      CALL HBOOK1(17,'HBOOK: sine wave in radians'
     1 ,16,0.0,pi,0.0)
      CALL HBOOK1(18,'HBOOK: sine wave in degrees'
     1 ,16,0.0,360.0,0.0)
      CALL HBOOK1(19,'HBOOK: Gaussian Signal + Exponential Background'
     1 ,25,0.0,5.0,0.0)
      CALL HBOOKN(20,'HBOOK: 2 Gaussians',2,' ',1000,TNAME)
      CALL HBOOKN(21,'HBOOK: 2 Gaussians',2,' ',1000,TNAME)
      CALL HBOOK2(22,'HBOOK: Exponential vs Flat Background$'
     1 ,40,0.0,4.0,60,0.0,3.0,0.0)
C
C     Make an Exponetial convoluted with a Gaussian
C
      call hbook1(26,'HBOOK: Exponential convoluted with Gaussian'
     + ,30,-1.0,5.0,0.0)
C
C     Book some slices for the Gaussian
C
      CALL HBPROX(10,0.0)
      CALL HBPROY(10,0.0)
      CALL HBSLIX(10,4,0.0)
      CALL HBSLIY(10,3,0.0)
C
      CALL HBPROF(61,'HBOOK: Profile plot (RMS)'
     + ,20,0.0,10.0,-100.0,100.0,'S')
      CALL HBPROF(62,'HBOOK: Profile plot (Error)'
     + ,20,0.0,10.0,-100.0,100.0,' ')
      CALL HBPROF(63,'HBOOK: Profile plot (Error) - First 1/3'
     + ,20,0.0,10.0,-100.0,100.0,' ')
      CALL HBPROF(64,'HBOOK: Profile plot (Error) - Last 2/3'
     + ,20,0.0,10.0,-100.0,100.0,' ')
      IDN = 32
      CALL HCDIR('NTUPLE',' ')
      CALL HBOOKN(31,'HBOOK: Ntuple - 2 Gaussians + flat',3
     1 ,'//MNHB4/NTUPLE',500,TAGS)
      CALL HBOOKN(32,'HBOOK: Ntuple - 2 Gaussians + flat',3
     1 ,'//MNHB4/NTUPLE',500,TAGS)
      CALL HBOOKN(35,'HBOOK: Ntuple - 2 Gaussians + 3 flat - Long',5
     1 ,'//MNHB4/NTUPLE',500,TAGS(6))
      call hprntu(31)
      call hprntu(32)
      call hprntu(35)
*
*     CWN's
*
      call hcdir('//PAWC/NTUPLE',' ')
      call hcdir('//MNHB4/NTUPLE',' ')
      call hbnt(33,'HBOOK: CWN - 2 Gaussians + flat',' ')
      call hbname(33,'GAUSS',gaus1,'gaus1, gaus2')
      call hbname(33,'FLAT',FLAT,'FLAT')
      call hprnt(33)
      call hbnt(36,'HBOOK: CWN - 2 Gaussians + 3 flat - Long',' ')
      call hbname(36,'GAUSS',GaussianDistribution1
     + ,'GaussianDistribution1, GaussianDistribution2')
      call hbname(36,'FLAT',Flattish_Distribution1
     + ,'Flattish_Distribution1, Flattish_Distribution2, FLAT')
      call hprnt(36)
*
      call hbnt(34,'HBOOK: CWN - Full test',' ')
      call hbname(34,'SINGLE',rval1,'rval1:r*4:20:[-10,10],qval1:l')
      call hbname(34,'DOUBLE',zval1,'zval1:r*8')
      call hbnamc(34,'CHAR1',cval1,'cval1:c*20')
      call hbname(34,'TEST',rtest1,'rtest1(8),qtest2:l,rtest2(8,3)')
      call hbname(34,'ARRAY',nval2,'nval2[0,10]'//
     + ',rval2(nval2)::24:[-5.0,10.0]')
      call hbname(34,'ARRAY',zval2,'zval2(nval2):r*8')
      call hbnamc(34,'ARRAY',cval2,'cval2(nval2):c*12')
      call hbname(34,'ARRAY',rval4,'rval4(4,3,nval2)')
      call hbname(34,'ARRAY',rval3,'rval3(3,nval2)')
      call hprnt(34)
*
*     Book the projections
*
      call hbook1(34410,'HBOOK: rval2',75,-5.0,10.0,0.0)
      call hbook2(34420,'HBOOK: abs(rval4(1,2,1:nval2)) vs rval3(1)'
     + ,75,-5.0,10.0,75,-5.0,10.0,0.0)
*
      CALL HBOOKN(41,'HBOOK: Ntuple - 1st 20 random numbers',20
     + ,'//MNHB4/NTUPLE',500,TAG2(1))
      CALL HBOOKN(42,'HBOOK: Ntuple - 2nd 20 random numbers',20
     + ,'//MNHB4/NTUPLE',500,TAG2(6))
      CALL HBOOKN(51,'HBOOK: 2-D Gaussian stored as an Ntuple',4
     + ,'//MNHB4/NTUPLE',500,TAG3)
      CALL HBOOK2(52,'HBOOK: Y vs. X stored as a 2-D histogram'
     + ,50,-10.0,10.0,60,0.0,60.0,0.0)
      CALL HBOOKN(53,'HBOOK: Y vs. X stored as an Ntuple',2
     + ,'//MNHB4/NTUPLE',500,TAG4)
      CALL HBOOKN(54,'HBOOK: X only stored as an Ntuple',1
     + ,'//MNHB4/NTUPLE',500,TAG4)
C
C     BOOK THE MNBOOK HISTOGRAMS
C
      IDBIN(1) = 40
      ADLO(1)  = -2.0
      ADHI(1)  =  2.0
      CALL M_BOOK(1,'MNBOOK: Simple Gaussian Histogram',1
     1    ,IDBIN,ADLO,ADHI,0)
      ADLO(1)  = -2.5
      ADHI(1)  =  2.5
      CALL M_BOOK(2,'MNBOOK: Simple Gaussian Histogram',1
     1    ,IDBIN,ADLO,ADHI,0)
      IDBIN(1) = 25
      ADLO(1)  =  0.0
      ADHI(1)  =  5.0
      CALL M_BOOK(4,'MNBOOK: 2 Gaussians + Exponential Background',1
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(5,'MNBOOK: Gaussian Signal',1
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(6,'MNBOOK: Exponential Background',1
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(7,'MNBOOK: Gaussian Signal + Exponential Background',1
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(8,'MNBOOK: Straight Line Background',1
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(9,'MNBOOK: High Statistics Gaussian for Fitting',1
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(19,'MNBOOK: Gaussian Signal + Exponential Background'
     1    ,1,IDBIN,ADLO,ADHI,0)
C     2-DIMENSIONAL HISTOGRAM
      IDBIN(1) = 20
      ADLO(1)  = -2.0
      ADHI(1)  =  2.0
      IDBIN(2) = 15
      ADLO(2)  = -3.0
      ADHI(2)  =  3.0
      CALL M_BOOK(10,'MNBOOK: 2 Gaussians',2
     1    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(11,'MNBOOK: High statistics 2 Gaussians',2
     1    ,IDBIN,ADLO,ADHI,0)
      IDBIN(1) = 15
      ADLO(1)  = -15.0
      ADHI(1)  =  15.0
      IDBIN(2) = 20
      ADLO(2)  =  -5.0
      ADHI(2)  =  15.0
      CALL M_BOOK(13,'MNBOOK: Surface for 2-D Plots',2
     +    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(14,'MNBOOK: sin(x)/x to smooth',1
     + ,IDBIN(2),ADLO(2),ADHI(2),0)
      IDBIN(1) = 20
      ADLO(1)  = 0.0
      ADHI(1)  = 20.0
      IDBIN(2) = 20
      ADLO(2)  = 0.0
      ADHI(2)  = 20.0
      CALL M_BOOK(15,'MNBOOK: Random weights around zero',1
     +    ,IDBIN,ADLO,ADHI,0)
      CALL M_BOOK(16,'MNBOOK: Random weights around zero',2
     +    ,IDBIN,ADLO,ADHI,0)
      IDBIN(1) = 16
      ADLO(1)  = 0.0
      ADHI(1)  = pi
      CALL M_BOOK(17,'MNBOOK: sine wave in radians',1
     +    ,IDBIN,ADLO,ADHI,0)
      ADHI(1)  = 360.0
      CALL M_BOOK(18,'MNBOOK: sine wave in degrees',1
     +    ,IDBIN,ADLO,ADHI,0)
C     SCATTER PLOTS
      IDBIN(1) = 0
      IDBIN(2) = 0
      IDBIN(3) = 0
      CALL M_BOOK(20,'MNBOOK: 2 Gaussians',2
     1    ,IDBIN,ADLO,ADHI,1000)
      CALL M_BOOK(21,'MNBOOK: 2 Gaussians',2
     1    ,IDBIN,ADLO,ADHI,1000)
      CALL M_BOOK(22,'MNBOOK: Exponential vs Flat Background',2
     1    ,IDBIN,ADLO,ADHI,1000)
      CALL M_BOOK(31,'MNBOOK: Ntuple - 2 Gaussians + flat',3
     1    ,IDBIN,ADLO,ADHI,950)
C
      DO 1000 I=1,1000
          CALL HCDIR('//PAWC',' ')
          CALL HCDIR('//MNHB4',' ')
C
C         HIST 1 A GAUSSIAN
C
          X = GAUS_IB(IDUM)
          CALL HFILL(1,X,1.0,1.0)
          CALL M_FIL1(1,X,1.0)
C
C         HIST 1 A GAUSSIAN
C
          X = GAUS_IB(IDUM)
          CALL HFILL(2,X,1.0,1.0)
          CALL M_FIL1(2,X,1.0)
C
C         HIST 3 A WEIGHTED HISTOGRAM
C
          WT = 4.0*(RNDM(IDUM)-0.5)
          WEIGHT = EXP(-WT**2/2.0)
          CALL HFILL(3,X,1.0,WEIGHT)
C
C         HISTS 5 AND 7, SIGNAL AND SIGNAL + BACKGROUND
C
          X = 2.0 + 0.25*GAUS_IB(IDUM)
          CALL HFILL(5,X,1.0,1.0)
          CALL HFILL(7,X,1.0,1.0)
          CALL M_FIL1(5,X,1.0)
          CALL M_FIL1(7,X,1.0)
C
C         Hist 19 is the same again, but with half the statistics and
C         a new random number
C
          if(mod(i,2).eq.1) then
              x = 2.0 + 0.25*gaus_ib(idum)
              call hfill(19,x,1.0,1.0)
              CALL M_FIL1(19,X,1.0)
          endif
C
C         HIST 4 CONTAINS 2 GAUSSIANS
C
          X = 1.5 + 0.25*GAUS_IB(IDUM)
          CALL HFILL(4,X,1.0,1.0)
          CALL M_FIL1(4,X,1.0)
C
          X = 2.5 + 0.50*GAUS_IB(IDUM)
          CALL HFILL(4,X,1.0,1.0)
          CALL M_FIL1(4,X,1.0)
C
C         HISTS 10 AND 12, 2 DIMENSIONAL HISTS OF 2 GAUSSIANS
C
          X = 1.0*GAUS_IB(IDUM)
          Y = 1.5*GAUS_IB(IDUM)
          CALL HFILL(10,X,Y,1.0)
          CALL M_FIL2(10,X,Y,1.0)
C
C         HIST 20, A REAL SCATTER PLOT OF THE 2 GAUSSIANS
C
          ADAT(1) = X
          ADAT(2) = Y
          CALL M_FILN(20,ADAT)
C
          CALL HFN(20,ADAT)
C
C         HIST 21, A REAL SCATTER PLOT OF 2 OTHER GAUSSIANS
C
          X = 1.0 + 2.0*GAUS_IB(IDUM)
          Y = 5.0 + GAUS_IB(IDUM)
          ADAT(1) = X
          ADAT(2) = Y
          CALL M_FILN(21,ADAT)
C
          CALL HFN(21,ADAT)
C
C         HIST 22, EXPONENTIAL DECAY VS A FLAT BACKGROUND
C
          X = 4.0*RNDM(IDUM)
900       CONTINUE
          Y = RNDM(IDUM)
          Z = EXP(-3.0*Y)
          IF(RNDM(IDUM).GT.Z) GOTO 900
          Y = 2.0*Y + 1.0
          CALL HFILL(22,X,Y,1.0)
          ADAT(1) = X
          ADAT(2) = Y
          CALL M_FILN(22,ADAT)
C
C         Histograms 61 to 64 are Profile plots - HBOOK4 only
C
          X = 8.0 * RNDM(IDUM)
          Y = X + 5.0*GAUS_IB(IDUM)
          CALL HFILL(61,X,Y,1.0)
          CALL HFILL(62,X,Y,1.0)
          IF(I.LE.333) THEN
              CALL HFILL(63,X,Y,1.0)
          ELSE
              CALL HFILL(64,X,Y,1.0)
          ENDIF
C
C         HIST 31, A REAL SCATTER PLOT OF 2 OTHER GAUSSIANS
C
          X = 1.0 + 2.0*GAUS_IB(IDUM)
          Y = 5.0 + GAUS_IB(IDUM)
          Z = 4.0*RNDM(IDUM)
          YDAT(1) = X
          YDAT(2) = Y
          YDAT(3) = Z
          ydat(4) = 5.0*rndm(idum)
          ydat(5) = 6.0*rndm(idum)
          CALL HCDIR('//PAWC/NTUPLE',' ')
          CALL HCDIR('//MNHB4/NTUPLE',' ')
          CALL HFN(31,YDAT)
          CALL HFN(32,YDAT)
          call hfn(35,ydat)
          CALL M_FILN(31,YDAT)
C
          gaus1 = x
          gaus2 = y
          flat  = z
          call hfnt(33)
C
          GaussianDistribution1 = x
          GaussianDistribution2 = y
          Flattish_Distribution1 = ydat(3)
          Flattish_Distribution2 = ydat(4)
          Flat3 = ydat(5)
          call hfnt(36)
C
1000  CONTINUE
*
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR('//MNHB4',' ')
C
C     HISTS 4, 6 AND 7 ARE AN EXPONENTIALLY FALLING BACKGROUND
C     AND 7 HAS A GAUSSIAN SIGNAL ON IT
C
      DO 2000 I=1,2000
1200      CONTINUE
          X = 4.0*RNDM(IDUM)
          Y = EXP(-0.5*X)
          IF(RNDM(IDUM).GT.Y) GOTO 1200
C
          CALL HFILL(4,X,1.0,1.0)
          CALL HFILL(6,X,1.0,1.0)
          CALL HFILL(7,X,1.0,1.0)
          CALL M_FIL1(4,X,1.0)
          CALL M_FIL1(6,X,1.0)
          CALL M_FIL1(7,X,1.0)
C
C         Smear the exponential with a Gaussian of width 0.5
C
          x = x + 0.5*gaus_ib(i)
          call hfill(26,x,1.0,1.0)
C
C         Hist 19 is the same again, but with 1/3 the statistics and
C         a new random number
C
          if(mod(i,3).eq.1) then
 1300         continue
              x = 4.0*rndm(idum)
              y = exp(-0.5*x)
              if(rndm(idum).gt.y) goto 1300
              call hfill(19,x,1.0,1.0)
              CALL M_FIL1(19,X,1.0)
          endif
C
C         HIST 8 IS A STRAIGHT LINE BACKGROUND
C
 1400     CONTINUE
          X = 5.0*RNDM(IDUM)
          Y = 0.1 * (10.0 - 2.0*X)
          IF(RNDM(IDUM).GT.Y) GOTO 1400
C
          CALL HFILL(8,X,1.0,1.0)
          CALL M_FIL1(8,X,1.0)
2000  CONTINUE
C
      DO 3000 I=1,5000
C
C         HIST 9 A HIGH STATISTICS GAUSSIAN
C
          X = 2.0 + 0.25*GAUS_IB(IDUM)
          CALL HFILL(9,X,1.0,1.0)
          CALL M_FIL1(9,X,1.0)
C
C         HIST 11 A HIGH STATISTICS DOUBLE GAUSSIAN
C
          X = 1.0*GAUS_IB(IDUM)
          Y = 1.5*GAUS_IB(IDUM)
          CALL HFILL(11,X,Y,1.0)
          CALL M_FILL(11,X,Y,1.0)
3000  CONTINUE
C
C     HIST 13, A surface for IGTABL
C
      sx = 30.0/15.0
      sy = 20.0/20.0
      x = -15.0 + 0.5*sx
      y =  -5.0 + 0.5*sy
      do i=1,20
          do j=1,15
              if(x.ne.0.0 .and. y.ne.0.0) then
                  weight = 100.0*sin(x)/x*sin(y)/y
              elseif(x.ne.0.0) then
                  weight = 100.0*sin(x)/x
              elseif(y.ne.0.0) then
                  weight = 100.0*sin(y)/y
              else
                  weight = 100.0
              endif
              call hfill(13,x,y,weight)
              call m_fill(13,x,y,weight)
              x = x + sx
          enddo
          y = y + sy
          x = -15.0 + 0.5*sx
      enddo
C
C     Fill 14 as a histogram to smooth
C
      do i=1,5000
          idum = 10*j + i
          jdum = nint(rndm(idum))
          kdum = nint(rndm(jdum))
          x = -5.0 + 20.0*rndm(idum)
          y = 100.0*rndm(jdum)
          if(x.ne.0.0) then
              weight = 100.0*sin(x)/x + 1.0*(x+5.0)*rndm(kdum)
          else
              weight = 100.0
          endif
          if(y.lt.weight) then
              call hfill(14,x,1.0,1.0)
              call m_fil1(14,x,1.0)
          endif
      enddo
C
C     HIST 15, Random weights around zero
C
      DO 3200 I=1,20
          X = FLOAT(I) - 0.5
          WEIGHT = 10.0 * (RNDM(IDUM) - 0.5)
          IF(MOD(I,6).EQ.0) WEIGHT = 0.0
          CALL HFILL(15,X,1.0,WEIGHT)
          CALL M_FIL1(15,X,WEIGHT)
          DO 3190 J=1,20
              Y = FLOAT(J) - 0.5
              WEIGHT = 10.0 * (RNDM(IDUM) - 0.5)
              IF(MOD(I+J,6).EQ.0) WEIGHT = 0.0
              CALL HFILL(16,X,Y,WEIGHT)
              CALL M_FIL2(16,X,Y,WEIGHT)
 3190     CONTINUE
 3200 CONTINUE
C
C     HISTS 17, 18 are sine waves in radians and degrees
C
      DO 3300 I=1,2000
 3250     continue
          X = 2.0 * pi * RNDM(IDUM)
          Y = sin(x)
          IF(RNDM(IDUM).GT.abs(Y)) GOTO 3250
C
          CALL HFILL(17,X,1.0,1.0)
          CALL HFILL(18,X*rdeg,1.0,1.0)
          CALL M_FIL1(17,X,1.0)
          CALL M_FIL1(18,X*rdeg,1.0)
 3300 CONTINUE

C
C     HIST 41, A BIGGISH Ntuple
C
      CALL HCDIR('//PAWC/NTUPLE',' ')
      CALL HCDIR('//MNHB4/NTUPLE',' ')
      DO 4000 I=1,3000
          DO 3500 J=1,25
              IF(J.EQ.1) THEN
                  X = FLOAT(I)
              ELSEIF(J.LE.5) THEN
                  X = FLOAT(I/J)
              ELSEIF(J.LE.10) THEN
                  X = (FLOAT(J)-0.5)*RNDM(IDUM) + FLOAT(10*(J-1))
              ELSE
                  X = FLOAT(J-11) + FLOAT(J-10)*GAUS_IB(IDUM)
              ENDIF
              YDAT(J) = X
 3500     CONTINUE
          CALL HFN(41,YDAT(1))
          CALL HFN(42,YDAT(6))
 4000 CONTINUE
C
C     Make a y vs. x plot and put a smear on y.
C     x runs from -10 to 10, y from 0 to 50
C
      DO 4100 I=1,2000
          X = -10.0 + 20.0*RNDM(IDUM)
          Y = 0.5*X**2 + ABS(X)*(RNDM(IDUM)-1.0)
          CALL HFILL(52,X,Y,1.0)
          YDAT(1) = X
          YDAT(2) = Y
          CALL HFN(53,YDAT)
          YDAT(1) = 10.0*GAUS_IB(IDUM)
          CALL HFN(54,YDAT)
 4100 CONTINUE
C
C     CWN
C
      do i=1,200
          do j=1,7
            rtest1(j)   = float(i) + float(1000*j)
            rtest2(j,1) = -rtest1(j)
            rtest2(j,2) = rtest1(j)
            rtest2(j,3) = float(j)
          enddo
          qtest2      = j.gt.4
          rtest1(8)   = 1.0/rtest1(1)
          rtest2(8,1) = 1.0/rtest2(1,1)
          rtest2(8,2) = 2.0/rtest2(3,2)
          rtest2(8,3) = 3.0/rtest2(5,3)
*
          rval1 = gaus_ib(idum)
          zval1 = dble(2.0*gaus_ib(i))
          qval1 = rval1.gt.0.0
          nval2 = nint(10.0*rndm(i))
          cval1 = ' '
          nchar = 20 - nint(10.0*rndm(i))
          do j=1,nchar
              cval1(j:j) = char(ichar('A')+nval2+j)
          enddo
          call vzero(rval2,mvalmx)
          call vzero(rval3,3*mvalmx)
          call vzero(rval4,4*3*mvalmx)
          rval2(1) = rval1
          rval3(1,1) = rval1
          rval3(2,1) = sngl(zval1)
          rval3(3,1) = float(nval2)
          do j=2,nval2
              rval2(j) = float(j-2) + 0.1*float(j)*gaus_ib(j)
              rval3(1,j) = rval2(j) - 1.0
              rval3(2,j) = rval2(j)
              rval3(3,j) = 2.0 * rval2(j)
              do k=1,4
                  rval4(k,1,j) = float(k + (i-1)/10)
                  if(k.le.3) then
                      rval4(k,2,j) = rval3(k,j)
                  else
                      rval4(k,2,j) = float(nval2)
                  endif
                  if(mod(k,2).eq.1) then
                      rval4(k,3,j) = float(j) + 0.5*gaus_ib(k)
                  else
                      rval4(k,3,j) = -rval4(k-1,3,j)
                  endif
              enddo
          enddo
          if(nval2.gt.0) then
              zval2(nval2) = zval1
              cval2(nval2) = cval1
          endif
          do j=1,nval2-1
              zval2(j) = dble(rval2(nval2-j+1))
              cval2(j) = ' '
              do k=1,nval2,2
                  cval2(j)(k:k+1) = char(ichar('A')+nval2+j) //
     +                              char(ichar('a')+nval2+k)
              enddo
          enddo
          call hfnt(34)
*
*         Fill the projections
*
          do j=1,nval2
              call hfill(34410,rval2(j),1.0,1.0)
              if(j.gt.1) then
                  call hfill(34420,rval3(1,j),abs(rval4(1,2,j)),1.0)
              endif
          enddo
      enddo
C
C     Fill an Ntuple with the contents on 2-d Gaussian
C
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR('//MNHB4',' ')
      CALL HGIVE(10,TITLE,NBINX,XLO,XHI,NBINY,YLO,YHI
     1 ,NWT,IAD)
      DX = (XHI - XLO) / FLOAT(NBINX)
      DY = (YHI - YLO) / FLOAT(NBINY)
      DO 4200 I=1,20
          DO 4190 J=1,15
              CALL HIJXY(10,I,J,YDAT(1),YDAT(2))
              YDAT(1) = YDAT(1) + 0.5*DX
              YDAT(2) = YDAT(2) + 0.5*DY
              YDAT(3) = HIJ(10,I,J)
              YDAT(4) = 0.5*SQRT(YDAT(3))
              CALL HCDIR('//PAWC/NTUPLE',' ')
              CALL HCDIR('//MNHB4/NTUPLE',' ')
              CALL HFN(51,YDAT)
              CALL HCDIR('//PAWC',' ')
              CALL HCDIR('//MNHB4',' ')
 4190     CONTINUE
 4200 CONTINUE
C
C     PRINT AND STORE HBOOK HISTOGRAMS
C
      CALL HISTDO
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR('//MNHB4',' ')
      CALL HROUT(0,ICYCLE,'NT')
c
c     Wait for 2 minutes to get another time
c
*icb      WRITE(LUNTTO,'('' +++ Waiting for 2 minutes !! +++'')')
      WRITE(LUNTTO,'('' +++ Waiting for 2 seconds !! +++'')')
*icb      call sleepf(120)
      call sleepf(2)
      CALL HCDIR('//PAWC',' ')
      CALL HCDIR('//MNHB4',' ')
      CALL HROUT(1,ICYCLE,' ')
      CALL HROUT(9,ICYCLE,' ')
C
C     Also write a selection of the histograms into the example file
C
      call hrput(idlist(1),'hbook_example.his','N')
      do i=2,midlist
          call hrput(idlist(i),'hbook_example.his','U')
      enddo
C
C     Also write a selection of the histograms into a file with different
C     record length
C
      call cleo_getlun(lunhb5,'HISTMKE')
      call hropen(lunhb5,'MNHB5','hbook5_test.his','N',4096,ierr)
      if(ierr.ne.0) goto 9000
      do i=1,midlist
          call hrout(idlist(i),icycle,' ')
      enddo
      call hrendc('MNHB5')
*ICB      close(unit=lunhb5)
*ICB      call cleo_frelun(lunhb5,'HISTMKE')
C
C     Write Ntuple(s) to the example file
C
      icycle = 999999
      call cleo_getlun(lunhbe,'test')
      call hropen(lunhbe,'MNHBE','hbook_example.his','U',1024,ierr)
      do i=1,midntpl
          call hcdir('//PAWC',' ')
          call hcdir('//MNHB4/NTUPLE',' ')
          call hrin(idntpl(i),icycle,1000)
          call hcdir('//MNHBE',' ')
          call hntdup(1000+idntpl(i),idntpl(i),-1,' ',' ')
          call hgnpar(1000+idntpl(i),'test')
          nevt = 0
 4300     continue
          nevt = nevt + 1
          call hcdir('//PAWC',' ')
          call hcdir('//MNHB4/NTUPLE',' ')
          call hgnf(1000+idntpl(i),nevt,ydat,ierr)
          if(ierr.ne.0) then
              nevt = nevt - 1
              goto 4350
          endif
          call hcdir('//MNHBE',' ')
          call hfn(idntpl(i),ydat)
          if(nevt.ge.1000) goto 4350
          goto 4300
 4350     continue
          write(6,'('' Ntuple'',I6,'': Read in'',I5,'' events'')')
     +     idntpl(i),nevt
          call hrout(idntpl(i),icycle,' ')
      enddo
      call hrendc('MNHBE')
*ICB      close(unit=lunhbe)
*ICB      call cleo_frelun(lunhbe,'test')
      call hcdir('//PAWC',' ')
C
C     OPEN THE FILE FOR DATA CARDS
C
      CALL CLEO_GETLUN(LUN_DT,'TEST')
      OPEN(UNIT=LUN_DT,FILE='dat_test.mnd',STATUS='UNKNOWN'
     1    ,FORM='FORMATTED')
C
      DO 5500 NH=1,3
C
C       GET THE HBOOK HISTOGRAM TO USE FOR DATA CARDS
C
        IF(NH.EQ.1 .OR. NH.EQ.2) THEN
          CALL HGIVE(1,TITLE,NBINX,XLO,XHI,NBINY,YLO,YHI
     1     ,NWT,IAD)
          CALL HUNPAK(1,YDAT,'HIST',1)
          IF(NBINX.GT.0) DX = (XHI - XLO) / FLOAT(NBINX)
          DO 5100 II=1,NBINX
            XDAT(II) = XLO + FLOAT(II-1)*DX + 0.5*DX
            DXDAT(II) = 0.5*DX
            DYDAT(II) = SQRT(YDAT(II))
 5100     CONTINUE
          NPNT = NBINX
        ELSE
          write(6,'('' Reading in Ntuple'',I4)') idn
          icycle = 999999
          CALL HCDIR('//PAWC/NTUPLE',' ')
          CALL HCDIR('//MNHB4/NTUPLE',' ')
          call hdelet(idn)
          call hrin(idn,icycle,0)
          ndim = 10
          CALL HGIVEN(IDN,TITLE,NDIM,TNAMEn,ADLO,ADHI)
          CALL HNOENT(IDN,NPNT)
          NIDN = 0
        END IF
        WRITE(LUN_DT,'(''ID '',I8)') NH
        IF(NH.EQ.1) THEN
          WRITE(LUN_DT,*) 'TITLE A Gaussian without errors'
        ELSE IF(NH.EQ.2) THEN
          WRITE(LUN_DT,*)
     1     'TIT A Gaussian with asymmetric errors junk and order'
          WRITE(LUN_DT,*) 'LIMIT -2 2'
          WRITE(LUN_DT,*) 'ORDER DUMMY X DXN DXP Y DYN DYP'
        ELSE IF(NH.EQ.3) THEN
          IND   = INDEX(TITLE,':')
          Tmp1  = TITLE(IND+1:)
          title = tmp1
          lent = lnblnk(title)
          WRITE(LUN_DT,'(''TIT '',A)') TITLE(:lent)
          WRITE(LUN_DT,'(''NTUPLE '',I4,10(1X,A))') NDIM
     1     ,(TNAMEn(JJ),JJ=1,NDIM)
        END IF
        WRITE(LUN_DT,'(''DATA'')')
C
        DO 5200 II=1,NBINX
          IF(NH.EQ.1) THEN
            WRITE(LUN_DT,'(1X,F8.4,F10.4)') XDAT(II),YDAT(II)
          ELSE IF(NH.EQ.2) THEN
            XX = XDAT(II) - 0.5*DXDAT(II)
            DXL = 0.5*DXDAT(II)
            DXH = 1.5*DXDAT(II)
            DYL = 0.8*DYDAT(II)
            DYH = 1.2*DYDAT(II)
            WRITE(LUN_DT,'(1X,I6,3F8.4,3F10.4)') II,XX,DXL,DXH
     1       ,YDAT(II),DYL,DYH
          ELSE
c           CALL HGNf(IDN,II,ADAT,IERR)
            CALL HGN(IDN,NIDN,II,ADAT,IERR)
            IF(IERR.NE.0) THEN
              WRITE(LUNTTO,'('' Error getting Ntuple '',I8
     +         ,''  Event'',I6)') idn,II
              WRITE(LUNTTO,'('' Data: '',5(1PG12.5)
     +         ,/,(7X,5(1PG12.5)))') (ADAT(JJ),JJ=1,NDIM)
            ENDIF
            WRITE(LUN_DT,'(1X,10G13.5)') (ADAT(JJ),JJ=1,NDIM)
          END IF
 5200   CONTINUE
        IF(NH.NE.2) WRITE(LUN_DT,*) 'END'
 5500 CONTINUE
C
C     Dump a CWN
C
      call hcdir('//PAWC/NTUPLE',' ')
      call hcdir('//MNHB4/NTUPLE',' ')
      call hrin(33,99999,0)
      call hrin(34,99999,0)
*
      call hprnt(33)
      do i=1,10
          call hgnt(33,i,ierr)
          if(ierr.ne.0) then
              write(6,'('' Error'',I6,'' reading CWN 33'')') ierr
          endif
          write(6,'('' Event'',I4,''  Gaus1,Gaus2,Flat'',3f8.4)')
     +     i,gaus1,gaus2,flat
      enddo
      call hprnt(34)
      do i=1,10
          call hgnt(34,i,ierr)
          if(ierr.ne.0) then
              write(6,'('' Error'',I6,'' reading CWN 34'')') ierr
          endif
          write(6,'('' Event'',I4
     +     ,''  rval1,zval1,qval1,cval1'',2f9.4,l4,1x,a
     +     ,'' nval2'',i3)')
     +     i,rval1,zval1,qval1,cval1
     +     ,nval2
          write(6,'('' rval2:'',10f7.3)') (rval2(jj),jj=1,nval2)
          write(6,'('' zval2:'',10f7.3)') (zval2(jj),jj=1,nval2)
          write(6,'('' cval2:'',5(2x,a),/,7x,5(2x,a))')
     +     (cval2(jj),jj=1,nval2)
          do j=1,nval2
              write(6,'('' rval3:'',3f9.4)') (rval3(ii,j),ii=1,3)
          enddo
      enddo
C
      CALL HCDIR('//PAWC',' ')
      CLOSE(UNIT=LUN_DT)
      CALL CLEO_FRELUN(LUN_DT,'TEST')
C
C
C     PRINT AND STORE MNBOOK HISTOGRAMS
C
      CALL M_INDX
      CALL M_PRNT(0)
      CALL M_STOR(0,'mnbook_test.mnh')
C
      CALL HRENDc('MNHB4')
*ICB      CLOSE(UNIT=LUNHB4)
C
 9000 CONTINUE
      CLOSE(UNIT=LUNLPT)
C
 9900 CONTINUE
      STOP
      END
C
      FUNCTION GAUS_IB(IDUM)
C
      VAL = 0.0
      DO II=1,12
          VAL = VAL + RNDM(IDUM)
      ENDDO
      GAUS_IB = VAL - 6.0
C
      RETURN
      END
C
      SUBROUTINE CTINUN
C-----
C     INITIALIZE LUN MANAGER WITH STANDARD CLEO LOGICAL UNITS
C
C                                ROHIT NAMJOSHI 18-AUG-86
C
C 28-Aug-88  : Modifications for new version of LUN manager
C-----
C
C      INCLUDE 'CLINC:CLUNS.INC'
C     NBM:1/19/83:ADDED /CLUNS/STAFLG FOR PRINTOUT OF STATUS
C
C       27-AUG-86 RMN  ADDED LUNMTI, LUNMTO FOR MTIN, MTOUT
C
      LOGICAL   DRFLG , IZFLG , ESFLG , OZFLG , TRFLG , DXFLG , TFFLG ,
     1          RSFLG , CSFLG , LMFLG , MUFLG , ONLF1 , WTFLG , MTAFLG,
     2          AUTOUT, DETFLG, MAFLG , STAFLG
C
      INTEGER   LUNIN , LUNOUT, LUNLPT, LUNTTY, LUNTMP, LUNTTI, LUNTTO,
     1          LUNMTI, LUNMTO
C
      COMMON /CLUNS/ LUNIN , LUNOUT, LUNLPT, LUNTTY, LUNTMP, DRFLG ,
     1               IZFLG , ESFLG , OZFLG , TRFLG , DXFLG , TFFLG ,
     2               RSFLG , CSFLG , LMFLG , MUFLG , ONLF1 , WTFLG ,
     3               MTAFLG, AUTOUT, DETFLG, MAFLG , STAFLG,
     4               LUNTTI, LUNTTO, LUNMTI, LUNMTO
*
      CHARACTER*(*) CRNAME
      PARAMETER(    CRNAME = 'CTINUN' )
*
C
C== HARDWIRED UNITS
C
      LUNMTI = 1
      LUNMTO = 2
      LUNTTI = 5
      LUNTTO = 6
      LUNTTY = 6
      LUNPUN = 7
      LUNLPT = 20
      LUNTMP = 61
C
C== INITIALIZE LUN MANAGER
C
      CALL CLEO_INILUN
C
C== LOCK ALL THE RESERVED LUNS
C
      CALL CLEO_LOKLUN( LUNMTI, CRNAME )
      CALL CLEO_LOKLUN( LUNMTO, CRNAME )
      CALL CLEO_LOKLUN( LUNTTI, CRNAME )
      CALL CLEO_LOKLUN( LUNTTO, CRNAME )
      CALL CLEO_LOKLUN( LUNPUN, CRNAME )
      CALL CLEO_LOKLUN( LUNLPT, CRNAME )
      CALL CLEO_LOKLUN( LUNTMP, CRNAME )
C
      RETURN
      END
