      SUBROUTINE MN_FUP(NMODE)
C
C     SUBROUTINE TO COPY THE PARAMETER VALUES FROM MINUIT COMMONS
C     TO MN_FIT COMMONS
C     NMODE = -1 MEANS FIT ABORTED SO DONT COPY RESULTS
C     NMODE = 0  MEANS FIT FINISHED COPY RESULTS
C     NMODE = 1  MEANS COPY RESULTS FOR STORING A FUNCTION
C
      IMPLICIT NONE
C
      EXTERNAL FCN,FUTIL
C
#include "mnpar.inc"
#include "mnfun.inc"
#include "mnfit.inc"
#include "mnlun.inc"
C
      INTEGER NMODE
C
      CHARACTER*20 TCMD
      CHARACTER*10 TPNAME
      DOUBLE PRECISION VAL,ERROR,BND1,BND2,ERP,ERN,EPARAB,GCC
      DOUBLE PRECISION PVAL0(MINMAX),PVAL(MINMAX)
      DOUBLE PRECISION RNUMB(2),WSUM
      integer i,ivarbl,ierflg,np1
C
      INTEGER II,NF,NPART,NPARF,NPAR,NH1
C
C     IF WE ARE NOT FITTING RETURN
C
      IF(NHFIT.LE.0) GOTO 9000
C
C     Copy from MINUIT to Mn_Fit commons
C
      IF(NMODE.EQ.0 .OR. NMODE.EQ.1) THEN
C
C
          DO 1000 I=1,NPAR_MN
              CALL MNPOUT(I,TPNAME,PVAL(I),ERROR,BND1,BND2,IVARBL)
              PVAL0(I) = PVAL(I)
1000      CONTINUE
C
C         Apply the constraints if there are any
C         Update the MINUIT parameter values with the new constraint
C
          IF(NCNSTR.GT.0) THEN
              CALL M_CST0(NPAR_MN,PVAL)
C
              IF(NMODE.EQ.0) THEN
                  DO 1100 I=1,NCNSTR
                      IF(PVAL0(ICNPAR(I)).NE.PVAL(ICNPAR(I))) THEN
                          TCMD = 'SET PARAMETER'
                          RNUMB(1) = DBLE(ICNPAR(I))
                          RNUMB(2) = PVAL(ICNPAR(I))
                          CALL MNEXCM(FCN,TCMD,RNUMB,2,IERFLG,FUTIL)
                      ENDIF
1100              CONTINUE
              ENDIF
          ENDIF
C
C         Update the fixed parameter if parameter types are 1
C
          IF(NPARTP.EQ.1) THEN
              WSUM = 0.0D0
              NP1 = 1
              IF(QSNORM) NP1 = 2
              DO 2100 NF=1,NFUN_MN
                  IF(IUSEF(NF).EQ.0) GOTO 2100
cicb                  IF(IASSF(NF,NH).EQ.0) GOTO 2090
                  IF(NF.LT.NFUSEL) THEN
                      WSUM = WSUM + PVAL(NP1)
                  ENDIF
 2090             CONTINUE
                  IF(NF.LT.NFUSEL) NP1 = NP1 + IPARF(NF)
 2100         CONTINUE
              PVAL(NP1) = 1.0D0 - WSUM
              FPAR(1,NFUSEL) = SNGL(PVAL(NP1))
C
              IF(NMODE.EQ.0) THEN
                  TCMD = 'SET PARAMETER'
                  RNUMB(1) = DFLOAT(NP1)
                  RNUMB(2) = PVAL(NP1)
                  CALL MNEXCM(FCN,TCMD,RNUMB,2,IERFLG,FUTIL)
              ENDIF
          ENDIF
C
          NPART = 0
          IF(QSNORM) THEN
              NPART = NPART + 1
C
C             Use the parabolic error if the global correlation coefficient
C             has been calculated
C
              CALL MNPOUT(NPART,TPNAME,VAL,ERROR,BND1,BND2,IVARBL)
              CALL MNERRS(NPART,ERP,ERN,EPARAB,GCC)
              IF(GCC.NE.0.0D0) ERROR = EPARAB
              F00   = SNGL(PVAL(NPART))
              DF00  = SNGL(ERROR)
              DPF00 = SNGL(ERP)
              DNF00 = SNGL(ERN)
              F00LO = SNGL(BND1)
              F00HI = SNGL(BND2)
              ISF00 = NPART
              IF(IVARBL.LE.0) ISF00 = -NPART
          ENDIF
C
          DO 4300 NF=1,NFUN_MN
              IF(IUSEF(NF).EQ.0) GOTO 4300
              NPARF = IPARF(NF)
              DO 4200 II=1,NPARF
                  NPART = NPART + 1
C
C                 Use the parabolic error if the global correlation coefficient
C                 has been calculated
C
                  CALL MNPOUT(NPART,TPNAME,VAL,ERROR,BND1,BND2,IVARBL)
                  CALL MNERRS(NPART,ERP,ERN,EPARAB,GCC)
                  IF(GCC.NE.0.0D0) ERROR = EPARAB
                  FPAR(II,NF)   = SNGL(PVAL(NPART))
                  DFPAR(II,NF)  = SNGL(ERROR)
                  DPFPAR(II,NF) = SNGL(ERP)
                  DNFPAR(II,NF) = SNGL(ERN)
                  FPARLO(II,NF) = SNGL(BND1)
                  FPARHI(II,NF) = SNGL(BND2)
                  ISFPAR(II,NF) = NPART
                  IF(IVARBL.LE.0) ISFPAR(II,NF) = -NPART
4200          CONTINUE
4300      CONTINUE
      ENDIF
C
C     If fitting more than one histogram set functions back to normal
C     Clear out the association between Mn_Fit and MINUIT parameters.
C
      IF(NMODE.LE.0) THEN
          ISF00 = 0
          CALL VZERO_i(ISFPAR(1,1),20*NFUN_MN)
          IF(NHFIT.GT.1) THEN
              DO 4800 NF=1,NFUN_MN
                  IF(IUSEF(NF).EQ.0) GOTO 4800
                  NPAR = IPARF(NF)
                  IPARF(NF) = NPAR - NHFIT + 1
                  IF(TPARF(1,NF)(1:2).EQ.'AR') THEN
                      TPARF(1,NF) = 'AREA'
                  ELSE
                      TPARF(1,NF) = 'NORM'
                  ENDIF
C
C                 If we are fitting more than one histogram and not using
C                 ratios and the first parameter is 0.0, copy the second
C                 parameter to the first.
C
                  IF(NHFIT.GT.1 .AND. .NOT.QRATIO .AND.
     +               FPAR(1,NF).EQ.0.0 .AND. DFPAR(1,NF).EQ.0.0) THEN
                      FPAR(1,NF)   = FPAR(2,NF)
                      DFPAR(1,NF)  = DFPAR(2,NF)
                      DPFPAR(1,NF) = DPFPAR(2,NF)
                      DNFPAR(1,NF) = DNFPAR(2,NF)
                      FPARLO(1,NF) = FPARLO(2,NF)
                      FPARHI(1,NF) = FPARHI(2,NF)
                      NH1 = 3
                  ELSE
                      NH1 = 2
                  ENDIF
C
                  DO 4700 II=2,NHFIT
                      WRITE(TXTMES,'('' WARNING. Value of parameter '',A
     1                 ,''  Function'',I4,'' will be lost'')')
     2                 TPARF(II,NF),NF
                      CALL MN_MES(LUNTTO,'ME',TXTMES)
4700              CONTINUE
C
                  DO 4750 II=NHFIT+1,NPAR
                      TPARF(II-NHFIT+1,NF)  = TPARF(II,NF)
                      FPAR(II-NHFIT+1,NF)   = FPAR(II,NF)
                      DFPAR(II-NHFIT+1,NF)  = DFPAR(II,NF)
                      DPFPAR(II-NHFIT+1,NF) = DPFPAR(II,NF)
                      DNFPAR(II-NHFIT+1,NF) = DNFPAR(II,NF)
                      FPARLO(II-NHFIT+1,NF) = FPARLO(II,NF)
                      FPARHI(II-NHFIT+1,NF) = FPARHI(II,NF)
4750              CONTINUE
4800          CONTINUE
          ENDIF
C
C         If parameter types are 1 set them back to AREA and multiply
C         the fraction by the overall normalization
C         and reset the parameter limits
C
          IF(NPARTP.EQ.1) THEN
              DO 5800 NF=1,NFUN_MN
                  IF(IUSEF(NF).EQ.0) GOTO 5800
                  NPAR = IPARF(NF)
                  IF(TPARF(1,NF)(1:3).EQ.'FRC') THEN
                      TPARF(1,NF)  = 'AREA'
                      FPAR(1,NF)   = FPAR(1,NF) * F00
                      DFPAR(1,NF)  = DFPAR(1,NF) * F00
                      DPFPAR(1,NF) = DPFPAR(1,NF) * F00
                      DNFPAR(1,NF) = DNFPAR(1,NF) * F00
                      FPARLO(1,NF) = 0.0
                      FPARHI(1,NF) = 0.0
                  ENDIF
 5800         CONTINUE
          ENDIF
      ENDIF
C
9000  CONTINUE
      RETURN
      END
