      SUBROUTINE MN_OPR
C
C     Subroutine for doing histogram operations, adding, subtracting,
C     multiplying, dividing scaling and normalizing
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncmd.inc"
#include "mnflg.inc"
#include "mnlun.inc"
C
      INTEGER IDBIN1(MDIMMX),IDBIN2(MDIMMX)
      REAL ADLO1(MDIMMX),ADHI1(MDIMMX),ADLO2(MDIMMX),ADHI2(MDIMMX)
      real acont1(3**3),acont2(3**3),acont3(3**3)
C
      REAL RNUM(10)
C
      CHARACTER*10 THNAM(2)
      CHARACTER*80 TDFIL3
      LOGICAL QERRL1,QERRH1,QERRL2,QERRH2,QERRL3,QERRH3
      LOGICAL QRNGE,QENULU
C
      DATA THNAM/'HIST',' '/
C
      CALL WAITYQ('Give input, output histogram numbers: ')
      CALL MN_HRN(IDA11,IDA12,IDB11,IDB12,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 9000
      IF(COMND1.EQ.'ADD'       .OR. COMND1.EQ.'SUBTRACT' .OR.
     1   COMND1.EQ.'MULTIPLY'  .OR. COMND1.EQ.'DIVIDE'   .OR.
     1   COMND1.EQ.'EFFICIENCY'.OR. COMND1.EQ.'AVERAGE') THEN
          CALL MN_HRN(IDA21,IDA22,IDB21,IDB22,IDELIM,NNID)
          IF(NNID.LE.0) GOTO 9000
      ELSE
          IDA21 = IDA11
          IDA22 = IDA12
          IDB21 = IDB11
          IDB22 = IDB12
      ENDIF
      CALL WAITYQ('Give output histogram numbers: ')
      CALL MN_HRN(IDA31,IDA32,IDB31,IDB32,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 9000
      IF(IDA11.LT.0) THEN
          WRITE(LUNTTO,'('' Error specifying the histogram numbers'')')
          IF(COMND1.EQ.'ADD'       .OR. COMND1.EQ.'SUBTRACT' .OR.
     1       COMND1.EQ.'MULTIPLY'  .OR. COMND1.EQ.'DIVIDE'   .OR.
     1       COMND1.EQ.'EFFICIENCY'.OR. COMND1.EQ.'AVERAGE') THEN
             WRITE(LUNTTO,'('' Input histogram numbers''
     1        ,2(I7,'':'',I7,'' &'',I4,'';''))')
     1        IDA11,IDA12,IDB11,IDA21,IDA22,IDB21
          ELSE
             WRITE(LUNTTO,'('' Input histogram number''
     1        ,I7,'':'',I7,'' &'',I4,'';'')')
     1        IDA11,IDA12,IDB11
          ENDIF
          WRITE(LUNTTO,'('' Output histogram number''
     1     ,I7,'':'',I7,'' &'',I4,'';'')')
     1     IDA31,IDA32,IDB31
          GOTO 9000
      ENDIF
      IF(IDB11.NE.IDB12 .OR. IDB21.NE.IDB22 .OR. IDB31.NE.IDB32) THEN
          WRITE(LUNTTO,'('' *** MN_OPR: You can only specify a range''
     1     ,'' of primary identifiers'')')
          GOTO 9000
      ENDIF
C
C     NOW SORT OUT WHAT I HAVE SPECIFIED
C
      QRNGE = IDA11.EQ.0 .OR. IDA11.NE.IDA12
      IF(QRNGE) THEN
          IF(IDA11.NE.IDA21 .OR. IDA11.NE.IDA31 .OR.
     1       IDA12.NE.IDA22 .OR. IDA12.NE.IDA32) THEN
              WRITE(LUNTTO,'('' *** MN_OPR: You must give the same''
     1         ,'' range for all primary identifiers'')')
              GOTO 9000
          ENDIF
      ENDIF
C
C     CHECK THAT THE HISTOGRAMS EXIST
C
      NNH1  = 0
      NLOOP = 0
      NDHIS0 = NDHIS
2000  CONTINUE
      IF(QRNGE) THEN
          NNH1 = NNH1 + 1
          IF(NNH1.GT.NDHIS0) GOTO 9000
          IDA1 = IDIDA(NNH1)
          IDB1 = IDIDB(NNH1)
          IF(IDPTRH(NNH1).LE.0 .OR. IDPTRD(NNH1).LE.0) GOTO 2000
          IF(IDA11.NE.0 .AND.
     1       (IDA1.LT.IDA11 .OR. IDA1.GT.IDA12)) GOTO 2000
          IF(IDB1.NE.IDB11) GOTO 2000
          IDA2 = IDA1
          IDA3 = IDA1
          IDB2 = IDB21
          IDB3 = IDB31
      ELSE
          IDA1 = IDA11
          IDA2 = IDA21
          IDA3 = IDA31
          IDB1 = IDB11
          IDB2 = IDB21
          IDB3 = IDB31
      ENDIF
C
      CALL MN_HGT(IDA1,IDB1,NH1)
      NPTRH1 = NPTRH
      NPTRD1 = NPTRD
      NDIM1  = NDIM
      NWPPT1 = NWPPT
      NPNT1  = NPNT
      NBPPT1 = NBPPT
      NSDAT1 = NSDATE
      NSTIM1 = NSTIME
      NTMOD1 = NTMODE
      EDENT1 = EDENT
      EDLO1  = EDLO
      EDHI1  = EDHI
      CALL UCOPY_i(IDBIN,IDBIN1,IABS(NDIM))
      CALL UCOPY_r(ADLO,ADLO1,IABS(NDIM))
      CALL UCOPY_r(ADHI,ADHI1,IABS(NDIM))
      call mn_uof(rdat(nptrh1),acont1)
      IF(NH1.LE.0) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' does not exist'')') IDA1,IDB1
          CALL MN_ERR('MN_OPR',TXTERR)
          GOTO 9000
      ENDIF
      IF(NPNT1.LE.0 .OR. (EDENT1.EQ.0.0 .AND.
     +    COMND1.NE.'ADD'      .AND. COMND1.NE.'SUBTRACT' .AND.
     +    COMND1.NE.'MULTIPLY' .AND. COMND1.NE.'DIVIDE'   .AND.
     +    COMND1.NE.'SCALE'    .AND.
     +    COMND1.NE.'XSHIFT'   .AND. COMND1.NE.'XSCALE'   .AND.
     +    COMND1.NE.'YSHIFT'   .AND. COMND1.NE.'YSCALE'   .AND.
     +    COMND1.NE.'ZSHIFT'   .AND. COMND1.NE.'ZSCALE'   )) THEN
          WRITE(TXTERR,'(''Histogram'',I7,I4
     1     ,'' has no entries'')') IDA1,IDB1
          IF(QRNGE) THEN
              CALL M_EMSG('MN_OPR',TXTERR)
              GOTO 2000
          ELSE
              CALL MN_ERR('MN_OPR',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
      IF(NDIM1.LT.-1) THEN
          WRITE(TXTERR,'(''Plot'',I7,I4
     1     ,'' is an Ntuple'')') IDA1,IDB1
          CALL MN_ERR('MN_OPR',TXTERR)
          IF(QRNGE) THEN
              CALL M_EMSG('MN_OPR',TXTERR)
              GOTO 2000
          ELSE
              CALL MN_ERR('MN_OPR',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
C
      IF((COMND1.EQ.'ZSHIFT' .OR. COMND1.EQ.'ZSCALE') .AND.
     +   NDIM1.LT.2) THEN
          WRITE(TXTERR,'(''Plot'',I7,I4,'' is less than 2-D'')')
     +     IDA1,IDA2
          IF(QRNGE) THEN
              CALL M_EMSG('MN_OPR',TXTERR)
              GOTO 2000
          ELSE
              CALL MN_ERR('MN_OPR',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
C
      IF(COMND1.EQ.'ADD'       .OR. COMND1.EQ.'SUBTRACT' .OR.
     1   COMND1.EQ.'MULTIPLY'  .OR. COMND1.EQ.'DIVIDE'   .OR.
     1   COMND1.EQ.'EFFICIENCY'.OR. COMND1.EQ.'AVERAGE') THEN
          CALL MN_HGT(IDA2,IDB2,NH2)
          NPTRH2 = NPTRH
          NPTRD2 = NPTRD
          NDIM2  = NDIM
          NWPPT2 = NWPPT
          NPNT2  = NPNT
          NBPPT2 = NBPPT
          NSDAT2 = NSDATE
          NSTIM2 = NSTIME
          NTMOD2 = NTMODE
          EDENT2 = EDENT
          EDLO2  = EDLO
          EDHI2  = EDHI
          CALL UCOPY_i(IDBIN,IDBIN2,IABS(NDIM))
          CALL UCOPY_r(ADLO,ADLO2,IABS(NDIM))
          CALL UCOPY_r(ADHI,ADHI2,IABS(NDIM))
          call mn_uof(rdat(nptrh2),acont2)
          IF(NH2.LE.0) THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     1         ,'' does not exist'')') IDA2,IDB2
              CALL MN_ERR('MN_OPR',TXTERR)
              GOTO 9000
          ENDIF
*
*         Remove this check as it is not necessary
*
*ICB          IF(NPNT2.LE.0 .OR. (EDENT2.EQ.0.0 .AND.
*ICB     +        COMND1.NE.'ADD'      .AND. COMND1.NE.'SUBTRACT' .AND.
*ICB     +        COMND1.NE.'MULTIPLY' .AND. COMND1.NE.'EFFICIENCY')) THEN
*ICB              WRITE(TXTERR,'(''Histogram'',I7,I4
*ICB     1         ,'' has no entries'')')
*ICB     1         IDA2,IDB2
*ICB              CALL MN_ERR('MN_OPR',TXTERR)
*ICB              IF(QRNGE) GOTO 2000
*ICB              GOTO 9000
*ICB          ENDIF
          IF(NDIM2.LT.-1) THEN
              WRITE(TXTERR,'(''Plot'',I7,I4
     1         ,'' is an Ntuple'')') IDA2,IDB2
              CALL MN_ERR('MN_OPR',TXTERR)
              IF(QRNGE) GOTO 2000
              GOTO 9000
          ENDIF
      ENDIF
C
C     CHECK THAT THE HISTOGRAMS ARE DEFINED THE SAME
C
      IF(COMND1.EQ.'ADD'       .OR. COMND1.EQ.'SUBTRACT' .OR.
     1   COMND1.EQ.'MULTIPLY'  .OR. COMND1.EQ.'DIVIDE'   .OR.
     1   COMND1.EQ.'EFFICIENCY'.OR. COMND1.EQ.'AVERAGE') THEN
          CALL M_HCMP(0,IDA1,IDB1,IDA2,IDB2,IERR)
          IF(IERR.NE.0) GOTO 9000
      ENDIF
C
      NLOOP = NLOOP + 1
      IF(.NOT.QRNGE .OR. (QRNGE .AND. NLOOP.EQ.1)) THEN
          NNUM = 0
          RNUM(1) = 1.0
          RNUM(2) = 1.0
 4000     CONTINUE
          IF(COMND1.EQ.'ADD'      .OR. COMND1.EQ.'SUBTRACT' .OR.
     1       COMND1.EQ.'MULTIPLY' .OR. COMND1.EQ.'DIVIDE') THEN
              CALL WAITYQ('Give scale factor(s) for histograms' //
     1         '(<CR>=1.0): ')
          ELSEIF(COMND1.EQ.'EFFICIENCY') THEN
              GOTO 4500
          ELSEIF(COMND1.EQ.'NORMALIZE') THEN
              IF(.NOT.QRFILE .AND. IDELIM.LT.0)
     +         CALL MN_MES(LUNTTO,'ME'
     +         ,' To normalize to the area of another' //
     +          ' histogram give the command HIST')
              CALL WAITYQ('Give normalization (<CR>=1.0) or' //
     1         ' HIST: ')
          ELSEIF(COMND1.EQ.'SCALE') THEN
              CALL WAITYQ(
     1         'Give scale factor to multiply contents by (<CR>=1.0): ')
          ELSEIF(COMND1.EQ.'AVERAGE') THEN
              GOTO 4500
          ELSEIF(COMND1.EQ.'XSHIFT') THEN
              CALL WAITYQ('Give amount to shift the x-axis: ')
          ELSEIF(COMND1.EQ.'XSCALE') THEN
              CALL WAITYQ('Give amount to scale the x-axis: ')
          ELSEIF(COMND1.EQ.'YSHIFT') THEN
              CALL WAITYQ('Give amount to shift the y-axis: ')
          ELSEIF(COMND1.EQ.'YSCALE') THEN
              CALL WAITYQ('Give amount to scale the y-axis: ')
          ELSEIF(COMND1.EQ.'ZSHIFT') THEN
              CALL WAITYQ('Give amount to shift the z-axis: ')
          ELSEIF(COMND1.EQ.'ZSCALE') THEN
              CALL WAITYQ('Give amount to scale the z-axis: ')
          ENDIF
C
          RVAL = VALTYQ(.TRUE.,IDELIM)
C
          IF(COMND1.EQ.'NORMALIZE' .AND. IDELIM.GT.0) THEN
              CALL RESTYQ
              KCMD = ICMTYQ(.TRUE.,JDELIM,THNAM)
              IF(KCMD.EQ.1) THEN
                  CALL WAITYQ('Give histogram number to normalize to: ')
                  CALL MN_HNO(IDA2,IDB2,KDELIM,NNID)
                  IF(NNID.LE.0) GOTO 9000
                  IF(IDA2.LE.0) GOTO 9000
                  CALL MN_HGT(IDA2,IDB2,NH2)
                  NPTRH2 = NPTRH
                  NPTRD2 = NPTRD
                  NDIM2  = NDIM
                  NWPPT2 = NWPPT
                  NPNT2  = NPNT
                  NBPPT2 = NBPPT
                  NSDAT2 = NSDATE
                  NSTIM2 = NSTIME
                  NTMOD2 = NTMODE
                  EDENT2 = EDENT
                  EDLO2  = EDLO
                  EDHI2  = EDHI
                  CALL UCOPY_i(IDBIN,IDBIN2,IABS(NDIM))
                  CALL UCOPY_r(ADLO,ADLO2,IABS(NDIM))
                  CALL UCOPY_r(ADHI,ADHI2,IABS(NDIM))
                  IF(NH2.LE.0) THEN
                      WRITE(TXTERR,'(''Histogram'',I7,I4
     1                 ,'' does not exist'')') IDA2,IDB2
                      CALL MN_ERR('MN_OPR',TXTERR)
                      GOTO 9000
                  ENDIF
                  IF(IABS(NDIM1).NE.IABS(NDIM2)) THEN
                      WRITE(TXTERR,'(''Histograms'',I7,I4,'';'',I7,I4
     1                 ,'' do not have the same dimensions'',2I4)')
     2                 IDA1,IDB1,IDA2,IDB2,NDIM1,NDIM2
                      CALL MN_ERR('MN_OPR',TXTERR)
                      GOTO 9000
                  ENDIF
                  RVAL = EDENT2
                  GOTO 4100
              ENDIF
          ENDIF
C
          CALL MN_RCK(RVAL,IDELIM,IERR)
          IF(IERR.GT.0) THEN
              IF(QRFILE) THEN
                  GOTO 4500
              ELSE
                  NNUM = 0
                  IF(IERR.EQ.2) GOTO 4500
                  GOTO 4000
              ENDIF
          ENDIF
C
 4100     CONTINUE
          NNUM = NNUM + 1
          RNUM(NNUM) = RVAL
          IF(COMND1.EQ.'ADD'      .OR. COMND1.EQ.'SUBTRACT' .OR.
     1       COMND1.EQ.'MULTIPLY' .OR. COMND1.EQ.'DIVIDE') THEN
              IF(IDELIM.EQ.0 .AND. NNUM.LT.2) GOTO 4000
          ENDIF
C
 4500     CONTINUE
          IF(COMND1.EQ.'ADD'      .OR. COMND1.EQ.'SUBTRACT' .OR.
     1       COMND1.EQ.'MULTIPLY' .OR. COMND1.EQ.'DIVIDE') THEN
              SCAL1 = 1.0
              SCAL2 = 1.0
              IF(NNUM.GE.1) SCAL1 = RNUM(1)
              IF(NNUM.GE.2) SCAL2 = RNUM(2)
          ELSEIF(COMND1.EQ.'NORMALIZE') THEN
              ANORM = 1.0
              IF(NNUM.GE.1) ANORM = RNUM(1)
          ELSEIF(COMND1.EQ.'SCALE') THEN
              SCAL = 1.0
              IF(NNUM.GE.1) SCAL = RNUM(1)
          ELSEIF(COMND1.EQ.'EFFICIENCY') THEN
              SCAL1 = 1.0
              SCAL2 = 1.0
          ELSEIF(COMND1.EQ.'AVERAGE') THEN
              SCAL1 = 1.0
              SCAL2 = 1.0
          ELSEIF(COMND1.EQ.'XSHIFT') THEN
              SHIFT = 0.0
              IF(NNUM.GE.1) SHIFT = RNUM(1)
          ELSEIF(COMND1.EQ.'XSCALE') THEN
              SCALE = 1.0
              IF(NNUM.GE.1) SCALE = RNUM(1)
          ELSEIF(COMND1.EQ.'YSHIFT') THEN
              SHIFT = 0.0
              IF(NNUM.GE.1) SHIFT = RNUM(1)
          ELSEIF(COMND1.EQ.'YSCALE') THEN
              SCALE = 1.0
              IF(NNUM.GE.1) SCALE = RNUM(1)
          ELSEIF(COMND1.EQ.'ZSHIFT') THEN
              SHIFT = 0.0
              IF(NNUM.GE.1) SHIFT = RNUM(1)
          ELSEIF(COMND1.EQ.'ZSCALE') THEN
              SCALE = 1.0
              IF(NNUM.GE.1) SCALE = RNUM(1)
          ENDIF
      ENDIF
C
C     NOW DO THE OPERATION
C
 5000 CONTINUE
C
C     BOOK THE OUTPUT HISTOGRAM
C
      NWRD = NINT(RDAT(NPTRH1+2))
      NBPPT3 = 0
      NTMOD3 = NTMOD1
      CALL MN_HNW(IDA3,IDB3,NDIM1,NWRD,NH3,NPTRH3,NPTRD3,NWH3
     + ,NBPPT3,NTMOD3)
      IF(NH3.LE.0) GOTO 9000
C
      NDIM3  = NDIM1
      NWPPT3 = NWPPT1
      NPNT3  = NPNT1
      NSDAT3 = NSDAT1
      NSTIM3 = NSTIM1
C
C     SORT OUT THE OFFSETS AND WHETHER ERRORS ARE BOOKED FOR EACH
C     HISTOGRAM
C
      CALL AMNOFF(NDIM1,NWPPT1,NOFF1,NOFFL1,NOFFH1,QERRL1,QERRH1)
      CALL AMNOFF(NDIM2,NWPPT2,NOFF2,NOFFL2,NOFFH2,QERRL2,QERRH2)
      CALL AMNOFF(NDIM3,NWPPT3,NOFF3,NOFFL3,NOFFH3,QERRL3,QERRH3)
C
C     Do not allow asymmetric errors for averaging
C
      IF(COMND1.EQ.'AVERAGE' .AND.
     +   (QERRH1 .OR. QERRH2)) THEN
          WRITE(TXTERR,'(
     +     ''You cannot average histograms with asymmetric errors'')')
          CALL MN_ERR('MN_OPR',TXTERR)
          GOTO 9000
      ENDIF
C
C     Set the number of entries starting values
C
      EDENT3 = 0.0
      EDLO3 = 1.0E+30
      EDHI3 = -1.0E+30
C
C     If the plot is a histogram and we are scaling or shifting the x-axis
C     then there is no need to loop over all the points
C
      IF(COMND1.EQ.'XSHIFT' .OR. COMND1.EQ.'XSCALE') THEN
          IF(COMND1.EQ.'XSHIFT') THEN
              ADLO1(1) = ADLO1(1) + SHIFT
              ADHI1(1) = ADHI1(1) + SHIFT
          ELSEIF(COMND1.EQ.'XSCALE') THEN
              ADLO1(1) = ADLO1(1) * SCALE
              ADHI1(1) = ADHI1(1) * SCALE
          ENDIF
          EDENT3 = EDENT1
          EDLO3  = EDLO1
          EDHI3  = EDHI1
          call ucopy_r(acont1,acont3,3**min0(3,iabs(ndim)))
          IF(NDIM1.GT.0) THEN
              NWDAT  = NPNT3 * NWPPT3
              CALL UCOPY_r(RDAT(NPTRD1),RDAT(NPTRD3),NWDAT)
              GOTO 6000
          ENDIF
      ENDIF
C
      IF((COMND1.EQ.'YSHIFT' .OR. COMND1.EQ.'YSCALE') .AND.
     +   NDIM.GT.1) THEN
          IF(COMND1.EQ.'YSHIFT') THEN
              ADLO1(2) = ADLO1(2) + SHIFT
              ADHI1(2) = ADHI1(2) + SHIFT
          ELSEIF(COMND1.EQ.'YSCALE') THEN
              ADLO1(2) = ADLO1(2) * SCALE
              ADHI1(2) = ADHI1(2) * SCALE
          ENDIF
          EDENT3 = EDENT1
          EDLO3  = EDLO1
          EDHI3  = EDHI1
          call ucopy_r(acont1,acont3,3**min0(3,iabs(ndim)))
          NWDAT  = NPNT3 * NWPPT3
          CALL UCOPY_r(RDAT(NPTRD1),RDAT(NPTRD3),NWDAT)
          GOTO 6000
      ENDIF
C
      IF((COMND1.EQ.'ZSHIFT' .OR. COMND1.EQ.'ZSCALE') .AND.
     +   NDIM.GT.2) THEN
          IF(COMND1.EQ.'ZSHIFT') THEN
              ADLO1(3) = ADLO1(3) + SHIFT
              ADHI1(3) = ADHI1(3) + SHIFT
          ELSEIF(COMND1.EQ.'ZSCALE') THEN
              ADLO1(3) = ADLO1(3) * SCALE
              ADHI1(2) = ADHI1(3) * SCALE
          ENDIF
          EDENT3 = EDENT1
          EDLO3  = EDLO1
          EDHI3  = EDHI1
          call ucopy_r(acont1,acont3,3**min0(3,iabs(ndim)))
          NWDAT  = NPNT3 * NWPPT3
          CALL UCOPY_r(RDAT(NPTRD1),RDAT(NPTRD3),NWDAT)
          GOTO 6000
      ENDIF
C
      DEEL1 = 0.0
      DEEH1 = 0.0
      DEEL2 = 0.0
      DEEH2 = 0.0
      DEEL3 = 0.0
      DEEH3 = 0.0
      NERR  = 0
C
C     If 0 points are supposed to have errors of one, then only add these
C     on operations between histogtams and not when scaling or normalizing
C
      IF(QENULL .AND.
     +   (COMND1.EQ.'ADD'       .OR. COMND1.EQ.'SUBTRACT' .OR.
     +    COMND1.EQ.'MULTIPLY'  .OR. COMND1.EQ.'DIVIDE'   .OR.
     +    COMND1.EQ.'EFFICIENCY'.OR. COMND1.EQ.'AVERAGE')) THEN
          QENULU = .TRUE.
      ELSE
          QENULU = .FALSE.
      ENDIF
C
      DO 5500 II=1,NPNT3
          NPTR1 = NPTRD1 + NWPPT1*(II-1) - 1
          NPTR3 = NPTRD3 + NWPPT3*(II-1) - 1
C
          EE1 = AMNE(II,NH1,NERR)
          IF(QERRL1) THEN
              DEEL1 = AMNDEN(II,NH1,NERR)
              IF(QENULU .AND. EE1.EQ.0.0 .AND. DEEL1.EQ.0.0) DEEL1=1.0
          ENDIF
          IF(QERRH1) THEN
              DEEH1 = AMNDEP(II,NH1,NERR)
              IF(QENULU .AND. EE1.EQ.0.0 .AND. DEEH1.EQ.0.0) DEEH1=1.0
          ENDIF
C
          IF(COMND1.EQ.'ADD'       .OR. COMND1.EQ.'SUBTRACT' .OR.
     1       COMND1.EQ.'MULTIPLY'  .OR. COMND1.EQ.'DIVIDE'   .OR.
     1       COMND1.EQ.'EFFICIENCY'.OR. COMND1.EQ.'AVERAGE') THEN
C
              EE2 = AMNE(II,NH2,NERR)
              IF(QERRL2) THEN
                  DEEL2 = AMNDEN(II,NH2,NERR)
                  IF(QENULU .AND. EE2.EQ.0.0 .AND. DEEL2.EQ.0.0)
     1             DEEL2 = 1.0
              ENDIF
              IF(QERRH2) THEN
                  DEEH2 = AMNDEP(II,NH2,NERR)
                  IF(QENULU .AND. EE2.EQ.0.0 .AND. DEEH2.EQ.0.0)
     1             DEEH2 = 1.0
              ELSEIF(QERRH1) THEN
                  DEEH2 = DEEL2
              ENDIF
          ENDIF
C
          IF(COMND1.EQ.'ADD') THEN
              EE3 = SCAL1*EE1 + SCAL2*EE2
              IF(QERRL3) DEEL3 =
     1         SQRT((SCAL1*DEEL1)**2 + (SCAL2*DEEL2)**2)
              IF(QERRH3) DEEH3 =
     1         SQRT((SCAL1*DEEH1)**2 + (SCAL2*DEEH2)**2)
          ELSEIF(COMND1.EQ.'SUBTRACT') THEN
              EE3 = SCAL1*EE1 - SCAL2*EE2
              IF(QERRL3) DEEL3 =
     1         SQRT((SCAL1*DEEL1)**2 + (SCAL2*DEEL2)**2)
              IF(QERRH3) DEEH3 =
     1         SQRT((SCAL1*DEEH1)**2 + (SCAL2*DEEH2)**2)
          ELSEIF(COMND1.EQ.'MULTIPLY') THEN
              EE3 = SCAL1*EE1 * SCAL2*EE2
              IF(QERRL3) DEEL3 = SCAL1 * SCAL2 *
     1         SQRT((DEEL1*EE2)**2 + (DEEL2*EE1)**2)
              IF(QERRH3) DEEH3 = SCAL1 * SCAL2 *
     1         SQRT((DEEH1*EE2)**2 + (DEEH2*EE1)**2)
          ELSEIF(COMND1.EQ.'DIVIDE') THEN
              IF(EE2.NE.0.0 .AND. SCAL2.NE.0.0) THEN
                  EE3 = (SCAL1*EE1) / (SCAL2*EE2)
                  IF(QERRL3) DEEL3 = SCAL1 / SCAL2 *
     1             SQRT((DEEL1/EE2)**2 + (DEEL2*EE1/EE2**2)**2)
                  IF(QERRH3) DEEL3 = SCAL1 / SCAL2 *
     1             SQRT((DEEL1/EE2)**2 + (DEEH2*EE1/EE2**2)**2)
                  IF(QERRH3) DEEH3 = SCAL1 / SCAL2 *
     1             SQRT((DEEH1/EE2)**2 + (DEEL2*EE1/EE2**2)**2)
              ELSE
                  EE3 = 0.0
                  DEEL3 = 0.0
                  DEEH3 = 0.0
              ENDIF
          ELSEIF(COMND1.EQ.'EFFICIENCY') THEN
              EE3   = 0.0
              DEEL3 = 0.0
C
C             Use error formula from Frank Linde
C
C              EE3F = (EE1+1.0) / (EE2+2.0)
C              DISC = (EE1+1.0) * (EE2-EE1+1.0) /
C     +         ((EE2+3.0) * (EE2+2.0)**2)
C              IF(DISC.GE.0.0) DEEL3F = SQRT(DISC)
C
C             Use the MULFIT formula from Paul Avery for the error on
C             the efficiency which is more correct for low statistics
C
              IF(EE2.GT.0.0) THEN
                  EE3 = EE1 / EE2
                  DISC = (1.0/EE2 * (EE3 + 1.0/EE2) *
     1             (1.0-EE3 + 1.0/EE2) /
     1             ((1+2.0/EE2)**2 * (1.0+3.0/EE2)))
                  IF(DISC.GE.0.0) THEN
                      DEEL3 = SQRT(DISC)
C
C                     For EFF = 0 or 1 add to error the value of the
C                     unbiased estimate of Y1/Y2. This will give a better
C                     estimate of the confidence interval
C
                      IF(EE3.EQ.0.0 .OR. EE3.EQ.1.0) DEEL3 =
     1                 (1.0/EE2) / (1.0+2.0/EE2) + DEEL3
                  ENDIF
              ENDIF
              DEEH3 = DEEL3
          ELSEIF(COMND1.EQ.'NORMALIZE') THEN
              EE3 = ANORM / EDENT1 * EE1
              IF(QERRL3) DEEL3 = ANORM / EDENT1 * DEEL1
              IF(QERRH3) DEEH3 = ANORM / EDENT1 * DEEH1
          ELSEIF(COMND1.EQ.'SCALE') THEN
              EE3 = SCAL * EE1
              IF(QERRL3) DEEL3 = SCAL * DEEL1
              IF(QERRH3) DEEH3 = SCAL * DEEH1
          ELSEIF(COMND1.EQ.'AVERAGE') THEN
              IF(DEEL1.NE.0.0 .AND. DEEL2.NE.0.0) THEN
                  DEEL3I = 1.0 / DEEL1**2 + 1.0 / DEEL2**2
                  EE3 = (EE1 / DEEL1**2 + EE2 / DEEL2**2) / DEEL3I
                  DEEL3 = 1.0 / SQRT(DEEL3I)
              ELSEIF(DEEL1.NE.0.0) THEN
                  DEEL3I = 1.0 / DEEL1**2
                  EE3    = EE1
                  DEEL3  = DEEL1
              ELSEIF(DEEL2.NE.0.0) THEN
                  DEEL3I = 1.0 / DEEL2**2
                  EE3    = EE2
                  DEEL3  = DEEL2
              ELSE
                  DEEL3 = 0.0
                  EE3   = 0.0
              ENDIF
          ELSEIF(COMND1.EQ.'YSHIFT' .OR. COMND1.EQ.'ZSHIFT') THEN
              EE3 = EE1 + SHIFT
              IF(QERRL3) DEEL3 = DEEL1
              IF(QERRH3) DEEH3 = DEEH1
          ELSEIF(COMND1.EQ.'YSCALE' .OR. COMND1.EQ.'ZSCALE') THEN
              EE3 = EE1 * SCALE
              IF(QERRL3) DEEL3 = DEEL1 * SCALE
              IF(QERRH3) DEEH3 = DEEH1 * SCALE
          ENDIF
C
          IF(COMND1.EQ.'XSHIFT') THEN
              RDAT(NPTR3+1) = RDAT(NPTR1+1) + SHIFT
              CALL UCOPY_r(RDAT(NPTR1+2),RDAT(NPTR3+2),NWPPT3-1)
          ELSEIF(COMND1.EQ.'XSCALE') THEN
              RDAT(NPTR3+1) = RDAT(NPTR1+1) * SCALE
              CALL UCOPY_r(RDAT(NPTR1+2),RDAT(NPTR3+2),NWPPT3-1)
          ELSE
              IF(.NOT.QERRH3) DEEH3 = DEEL3
              EDLO3 = AMIN1(EDLO3,EE3-DEEL3)
              EDHI3 = AMAX1(EDHI3,EE3+DEEH3)
              EDENT3 = EDENT3 + EE3
              IF(NDIM3.LT.0)
     1         CALL UCOPY_r(RDAT(NPTR1+1),RDAT(NPTR3+1),NWPPT3)
              CALL UMNE(II,NH3,NPTRD3,NDIM3,NWPPT3,NBPPT3,EE3,NERR)
              IF(QERRL3)
     1         CALL UMNDEL(II,NH3,NPTRD3,NDIM3,NWPPT3,NBPPT3,DEEL3,NERR)
              IF(QERRH3)
     1         CALL UMNDEH(II,NH3,NPTRD3,NDIM3,NWPPT3,NBPPT3,DEEH3,NERR)
          ENDIF
 5500 CONTINUE
*
*     Now update the contents also
*
      do i=1,3**min0(3,iabs(ndim))
          if(comnd1.eq.'ADD') then
              acont3(i) = scal1*acont1(i) + scal2*acont2(i)
          elseif(comnd1.eq.'SUBTRACT') then
              acont3(i) = scal1*acont1(i) - scal2*acont2(i)
          elseif(comnd1.eq.'MULTIPLY') then
              acont3(i) = scal1*acont1(i) * scal2*acont2(i)
          elseif(comnd1.eq.'DIVIDE' .or. comnd1.eq.'EFFICIENCY') then
              if(acont2(i).ne.0.0 .and. scal2.ne.0.0) then
                  acont3(i) = (scal1 * acont1(i)) / (scal2 * acont2(i))
              else
                  acont3(i) = 0.0
              endif
          elseif(comnd1.eq.'NORMALIZE') then
              acont3(i) = anorm / edent1 * acont1(i)
          elseif(comnd1.eq.'SCALE') then
              acont3(i) = scal * acont1(i)
          elseif(comnd1.eq.'YSHIFT' .or. comnd1.eq.'ZSHIFT') then
              if(iabs(ndim).eq.1 .and. i.eq.2) then
                  acont3(i) = acont1(i) + shift * float(npnt3)
              elseif(ndim.eq.2 .and. i.eq.5) then
                  acont3(i) = acont1(i) + shift * float(npnt3)
              elseif(ndim.eq.3 .and. i.eq.14) then
                  acont3(i) = acont1(i) + shift * float(npnt3)
              elseif(acont1(i).ne.0.0) then
                  acont3(i) = shift + acont1(i)
              else
                  acont3(i) = acont1(i)
              endif
          elseif(comnd1.eq.'YSCALE' .or. comnd1.eq.'ZSCALE') then
              acont3(i) = scale * acont1(i)
          elseif(comnd1.eq.'AVERAGE') then
              if(iabs(ndim).eq.1 .and. i.eq.2) then
                  acont3(i) = edent3
              elseif(ndim.eq.2 .and. i.eq.5) then
                  acont3(i) = edent3
              elseif(ndim.eq.3 .and. i.eq.14) then
                  acont3(i) = edent3
              else
                  acont3(i) = 0.0
              endif
          endif
      enddo
C
 6000 CONTINUE
C
C     NOW UPDATE THE HEADER
C
      NWDAT = NPNT3 * NWPPT3
      NWTOT = NWH3 + NWDAT
      CALL M_RTIM(NHDAT3,NHTIM3)
      CALL MN_HDU(RDAT(NPTRH3),NWTOT,NWH3,NWDAT,IDA3,IDB3
     + ,NDIM3,NWPPT3,NPNT3,NHDAT3,NHTIM3,NSDAT3,NSTIM3,NTMOD3
     + ,EDENT3,EDLO3,EDHI3,IDBIN1,ADLO1,ADHI1,NBPPT3,ACONT3)
C
      IF((COMND1.EQ.'ADD'      .OR. COMND1.EQ.'SUBTRACT' .OR.
     +    COMND1.EQ.'MULTIPLY' .OR. COMND1.EQ.'DIVIDE'   .OR.
     +    COMND1.EQ.'EFFICIENCY')) then
        if(TDFIL(NH1).NE.TDFIL(NH2)) THEN
          TDFIL3 = 'Generated internally'
        ELSE
          TDFIL3 = TDFIL(NH1)
        ENDIF
      else
        TDFIL3 = TDFIL(NH1)
      endif
      CALL MN_PTU(NH3,NWTOT,IDA3,IDB3,NPTRH3,NPTRD3,TDTIT(NH1)
     1 ,TDFIL3,' ',TDNAM(1,NH1))
      CALL MN_MSU(IDA3,IDB3,NDIM3,NWH3,NH3)
C
      IF(QRNGE) GOTO 2000
C
9000  CONTINUE
      RETURN
      END
