      subroutine mn_rooto(idelim,ierr)
*-----------------------------------------------------------------------
*     Open a root file
*
*     $Id: mn_rooto.fpp,v 1.3 2005/05/13 20:59:21 brock Exp $
*-----------------------------------------------------------------------
*
      implicit none
*
      integer idelim, ierr
*
#include "mnlun.inc"
#if ( defined(ROOT) )
#include "mnpar.inc"
#include "mndir.inc"
#include "mnflg.inc"
*
      character*255 txt1,txt2
      integer lenf,lent1,lent2,istat
*
      integer isltyq,lnblnk
      integer m_root_open, m_root_close
#endif
*
*-----------------------------------------------------------------------
*
#if ( !defined(ROOT) )
        txterr = 'Root not in this Mn_Fit version'
        call mn_err('MN_ROOTO',txterr)
        goto 9000
#else
*
*     Open the root file
*
      call waityq('Give filename with root histograms: ')
      lent1 = isltyq(.true.,idelim,txt1)
*
      if(lent1.le.0 .or. txt1.eq.' ') then
        goto 9000
      endif
*
*     Close any open root file
*
      if(fil_root.ne.' ') then
        lenf = lnblnk(fil_root)
        istat = m_root_close(lenf,fil_root(:lenf))
        if(istat.ne.0) then
          txterr = 'Failed to close root file: ' // fil_root(:lenf)
          call m_emsg('MN_ROOTO',txterr)
        endif
      endif
*
*     Fixup the working directory, environment variables and ~
*     For output files just add the working directory
*     For input files search the path
*
      txt2 = txt1
      call m_pfil(2,txt2,ierr)
      if(ierr.ne.0) goto 9000
      txt1 = txt2
      lent1 = lnblnk(txt1)
*     
      istat =  m_root_open(lent1,txt1(1:lent1),lent2,txt2)
      if(istat.ne.0 .or. lent2.le.0) then
        ierr = 1
        goto 9000
      else
        dir_hc = '//root'
      endif
      lunrin   = 1
      fil_root = txt2(:lent2)
*
      write(luntto,12100) txt2(:lent2)
12100 format(' Reading root histograms from file: ',A)
#endif
*
9000  continue
      end
