      SUBROUTINE MN_HID(NMODE,XPT,YPT,NPT,NSYM,XUNIT,NCOL,THICK)
C
C
C     ******************************************************************
C     *                                                                *
C     *                                                                *
C     *       ALGORITHM TO NOT DRAW HIDDEN LINES                       *
C     *       WHEN DRAWING A LINE WITH ANY ANGLE                       *
C     *       AUXILIARY FOR HPLEGO CALLED FROM HPLEG1                  *
C     *       NMODE = 0 means update the WORK array
C     *       NMODE = 1 means don't update it
C     *                                                                *
C     *                                                                *
C     ******************************************************************
C
      REAL XPT(NPT),YPT(NPT)
C
      PARAMETER (MPNTMX=5000)
C
#include "mnscr.inc"
      REAL XXLOW,XXHIG,YYLOW,YYHIG,RES,DRES,WRK1(MPNTMX),WRK2(MPNTMX)
      EQUIVALENCE(SCRATCH(1),XXLOW)
      EQUIVALENCE(SCRATCH(2),XXHIG)
      EQUIVALENCE(SCRATCH(3),YYLOW)
      EQUIVALENCE(SCRATCH(4),YYHIG)
      EQUIVALENCE(SCRATCH(5),RES)
      EQUIVALENCE(SCRATCH(6),DRES)
      EQUIVALENCE(SCRATCH(7),WRK1(1))
      EQUIVALENCE(SCRATCH(MPNTMX+7),WRK2(1))
C
      REAL X(2),Y(2)
C
C     ------------------------------------------------------------------
C
C
      IF(NPT.LT.2) RETURN
      DO 1000 I=1,NPT-1
          U1 = XPT(I)
          V1 = YPT(I)
          U2 = XPT(I+1)
          V2 = YPT(I+1)
C
          IC1=MAX0(1,IFIX((U1-XXLOW)*DRES+0.5))
          IC2=MAX0(1,IFIX((U2-XXLOW)*DRES+0.5))
C
C         Vertical line - make sure V2 is the highest point
C
          IF(IC1.EQ.IC2) THEN
              VMAX=WRK1(IC1)
              X(1)=U1
              X(2)=U1
              IF(V1.GT.V2) THEN
                  VT = V1
                  V1 = V2
                  V2 = VT
              ENDIF
              IF(V1.GE.VMAX) THEN
                  Y(1)=V1
                  Y(2)=V2
              ELSEIF(V2.LT.VMAX) THEN
                  GO TO 1000
              ELSE
                  Y(1)=VMAX
                  Y(2)=V2
              ENDIF
              IF(NMODE.EQ.0) WRK1(IC1)=V2
              IF(NINT(DRES*(Y(1)-Y(2))).NE.0)
     +         CALL MN_LIN(X,Y,2,NSYM,XUNIT,NCOL,THICK)
C
C         INCLINED LINE
C
          ELSE
              ALFA=(V1-V2)/(U1-U2)
              BETA=V1-ALFA*U1
              IDRAW=0
              X(1)=U1
              Y(1)=V1
C
              IF(IC2.GT.IC1) THEN
                  NSTEP = 1
              ELSE
                  NSTEP = -1
              ENDIF
              DO 30 IC=IC1,IC2,NSTEP
                  VMAX=WRK1(IC)
                  U=FLOAT(IC)*RES+XXLOW
                  IF(IC.EQ.IC1 .AND.
     +               (NSTEP.GT.0 .AND. U.LT.U1) .OR.
     +               (NSTEP.LT.0 .AND. U.GT.U1)) U = U1
                  IF(IC.EQ.IC2 .AND.
     +               (NSTEP.GT.0 .AND. U.GT.U2) .OR.
     +               (NSTEP.LT.0 .AND. U.LT.U2)) U = U2
                  V=ALFA*U+BETA
                  IF(V.GT.VMAX) THEN
                      X(2)=U
                      Y(2)=V
                      IDRAW=1
                      IF(NMODE.EQ.0) WRK1(IC)=V
                  ELSEIF(IDRAW.NE.0) THEN
                      CALL MN_LIN(X,Y,2,NSYM,XUNIT,NCOL,THICK)
                      IDRAW=0
                  ELSE
                      X(1)=U
                      Y(1)=V
                  ENDIF
  30          CONTINUE
              IF(IDRAW.NE.0) CALL MN_LIN(X,Y,2,NSYM,XUNIT,NCOL,THICK)
          ENDIF
1000  CONTINUE
C
 9000 CONTINUE
      RETURN
      END
