      SUBROUTINE M_NTPPNT(IDA,IDB,NP,IERR,RVAL)
C
C     Gets the point NP of Ntuple IDA,IDB
C     If NP= 0 the Ntuple is initialized
C        NP=-1 the Ntuple is initialized, but is not read in again
C              as m_intp has already been called - this is the case in MN_PRJ
C
C     Successive entries are no longer assumed, because you cannot
C     then access a random entry of an Ntuple.
C
      implicit none
*
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mncwn.inc"
#include "mnlst.inc"
#include "mnflg.inc"
#include "mnlun.inc"
#include "quest.inc"
C
      INTEGER IDA,IDB,NP,IERR
      REAL RVAL(*)
C
      CHARACTER*80 TXT1
      INTEGER ioerr,i,nloop,nvar,nelem,lent,lnblnk
      logical qsame
C
      INTEGER NPTR,IDH,NPL
      logical qcwntp
      SAVE NPTR,IDH,NPL,qcwntp
C
      logical  hntnew
      external hntnew
C
      IERR = 0
C
C     Initialize anything needed for reading the Ntuple
C
      IF(NP.LE.0) THEN
          IDAL = IDA
          IDBL = IDB
          CALL MN_HGT(IDAL,IDBL,NHALST)
          NPTRHL = NPTRH
          NPTRDL = NPTRD
          NWDATL = NWDAT
          NDIML  = NDIM
          NWPPTL = NWPPT
          NBPPTL = NBPPT
          NPNTL  = NPNT
          EDENTL = EDENT
          EDLOL  = EDLO
          EDHIL  = EDHI
          CALL UCOPY_i(IDBIN,IDBINL,IABS(NDIM))
          CALL UCOPY_r(ADLO,ADLOL,IABS(NDIM))
          CALL UCOPY_r(ADHI,ADHIL,IABS(NDIM))
C
C         Check that the input fle is correct
C
          qcwntp = .false.
          if(nwdat.gt.0) then
              nptr = nptrd - nwppt
          else
              if(np.eq.0) then
                  call m_intp(idal,idbl,nhalst,ierr)
                  if(ierr.ne.0) goto 9000
              endif
              idh = ida
              qcwntp = hntnew(idh)
*
*             Initialize Ntuple for all variables or those I want
*
              if(qcwntp) then
                  call m_intv(idh,ierr)
              else
                  CALL HGNPAR(IDH,'M_NTPPNT')
              endif
          ENDIF
          qcwntpl = qcwntp
C
          NPL = 0
C
C     Get the contents of point NP
C
      ELSE
          qsame = .false.
          IF(IDA.NE.IDAL .OR. IDB.NE.IDBL) THEN
              WRITE(TXTERR,'(''Wrong Ntuple number'',I7,I4
     +         ,''  Should be'',I7,I4)',IOSTAT=IOERR)
     +         IDA,IDB,IDAL,IDBL
              CALL MN_ERR('M_NTPPNT',TXTERR)
              IERR = 2
              GOTO 9000
          elseif(qcwntp .and. npl.gt.0 .and. (np-npl).eq.0) then
              qsame = .true.
*ICB          ELSEIF(NPL.GT.0 .AND. (NP-NPL).NE.1) THEN
*ICB              NPE = NPL + 1
*ICB              WRITE(TXTERR,'(''Ntuple'',I7,I4
*ICB     +         ,'' Expect to get event'',I4,'', asked for'',I4)'
*ICB     +         ,IOSTAT=IOERR) IDA,IDB,NPE,NP
*ICB              CALL MN_ERR('M_NTPPNT',TXTERR)
*ICB              IERR = 3
*ICB              GOTO 9000
          ELSEIF(.not.qcwntp .and. NPL.EQ.0) THEN
              NPTR = NPTR + (NP-1)*NWPPTL
          ENDIF
C
          IF(NWDATL.GT.0) THEN
              NPTR = NPTR + NWPPTL
              CALL UCOPY_r(RDAT(NPTR),RVAL,NWPPTL)
          ELSE
              if(qcwntp) then
*
*                 Don't read in the data again, if asked for same point
*
                  if(.not.qsame) then
                      if(npl.eq.0) then
                          if(nvcwn.eq.0) then
                              call hgnt(idh,np,ierr)
                          else
                              call hgntv(idh,chcwnv,nvcwn,np,ierr)
                          endif
                      else
                          call hgntf(idh,np,ierr)
                      endif
                  endif
*
*                 Copy the data into rval
*
                  if(nvcwn.eq.0) then
                      nloop = iabs(ndim)
                  else
                      nloop = nvcwn
                  endif
                  do i=1,nloop
                      if(nvcwn.eq.0) then
                          nvar  = i
                          nelem = 1
                      else
                          nvar  = ivcwn(i)
                          nelem = iecwn(1,i)
                      endif
                      if(ivtype(nvar).eq.1 .and. ivsize(nvar).eq.4) then
                          rval(i) = ar4(ivposn(nvar)+nelem-1)
                      elseif(ivtype(nvar).eq.1 .and.
     +                     ivsize(nvar).eq.8) then
                          rval(i) = sngl(zr8(ivposn(nvar)+nelem-1))
                      elseif(ivtype(nvar).eq.2 .or.
     +                     ivtype(nvar).eq.3) then
                          rval(i)= float(ir4(ivposn(nvar)+nelem-1))
                      elseif(ivtype(nvar).eq.4) then
                          if(qr4(ivposn(nvar)+nelem-1)) then
                              rval(i) = 1.0
                          else
                              rval(i) = 0.0
                          endif
                      else
                          rval(i) = 0.0
                      endif
                  enddo
              else
                  call hgnf(idh,np,rval,ierr)
              endif
              IF(IERR.NE.0) THEN
                  WRITE(TXTERR
     +             ,'(''Error unpacking Ntuple'',I7)') IDH
                  IF(NP.EQ.1) THEN
                      CALL M_EMSG('M_NTPPNT',TXTERR)
                      CALL M_EMSG('M_NTPPNT'
     +                 ,'Maybe you have not set the HBOOK directory' //
     +                 ' correctly (use CDIR)')
                      CALL HCDIR(TXT1,'R')
                      LENT = MAX0(lnblnk(TXT1),1)
                      TXTERR = 'The current directory is: ' //
     +                 TXT1(1:LENT)
                  ENDIF
                  CALL MN_ERR('M_NTPPNT',TXTERR)
                  IERR = 4
                  GOTO 9000
              ENDIF
          ENDIF
          NPL = NP
      ENDIF
C
9000  CONTINUE
      END
