      SUBROUTINE MN_SYM(MSYMB,XX,YY,DXXL,DYYL,DXXH,DYYH
     1 ,SSYMX,SSYMY,NCOL,ncole,THICK,XUNIT,NMODE)
C
C     Draws a symbol at the point given, with its error bars if requested
C     NMODE = 1 means without error bars - check if point is inside plot
C     NMODE = 0 means with error bars - check if point is inside plot
C     NMODE = -1 means without error bars. Point can be outside plot
C
#include "mnpar.inc"
#include "mnhpj.inc"
#include "mngrn.inc"
C
      PARAMETER (MAXPT=200)
      REAL XPT(MAXPT),YPT(MAXPT)
      LOGICAL QXERR,QYERR,QXERRB,QYERRB,QFILL,QINS,QXINS,QYINS
      DATA COS60/0.5/,SIN60/0.866/
C
C     Check if LPDEV <= 1 then no or null device selected so should not
C     draw a point
C
      IF(LPDEV.LE.1) RETURN
C
      NSYM  = IABS(MSYMB)
      NNSYM = MOD(NSYM,10)
      QFILL = MSYMB.LT.0
      NPFILL = 0
      SISYMX = 0.5*SSYMX
      SISYMY = 0.5*SSYMY
C
      if(nsym.ge.10) then
        qxerr  = (nsym/10.eq.2 .or. nsym/10.eq.4 .or.
     +            nsym/10.eq.6 .or. nsym/10.eq.8)
        qyerr  = (nsym/10.eq.3 .or. nsym/10.eq.4 .or.
     +            nsym/10.eq.7 .or. nsym/10.eq.8)
        qxerrb = (nsym/10.eq.6 .or. nsym/10.eq.8)
        qyerrb = (nsym/10.eq.7 .or. nsym/10.eq.8)
      endif
      if(iabs(nmode).eq.1) then
        qxerr = .false.
        qyerr = .false.
        qxerrb = .false.
        qyerrb = .false.
      endif
C
C     Key for a histogram or line
C
      IF(NSYM.LT.10) THEN
          IF(QFILL) THEN
              NPT = 2
              XPT(1) = XX - 3.0*SISYMX
              YPT(1) = YY
              XPT(2) = XX + 3.0*SISYMX
              YPT(2) = YY
          ELSE
              NPT = 4
              XPT(1) = XX - 3.0*SISYMX
              YPT(1) = YY - SISYMY
              XPT(2) = XX - 3.0*SISYMX
              YPT(2) = YY
              XPT(3) = XX + 3.0*SISYMX
              YPT(3) = YY
              XPT(4) = XX + 3.0*SISYMX
              YPT(4) = YY - SISYMY
          ENDIF
C
          CALL MN_LIN(XPT,YPT,NPT,NSYM,XUNIT,NCOL,THICK)
C
C     Key for hollow, solid, hatched or pattern
C
      ELSE IF(NSYM.GE.1000 .AND. NSYM.LT.9000) THEN
          if((nsym.ge.1000 .and. nsym.lt.3000) .or.
     +       (nsym.ge.5000 .and. nsym.lt.7000)) then
              NPT = 5
              XPT(1) = XX - SISYMX
              YPT(1) = YY - SISYMY
              XPT(2) = XX + SISYMX
              YPT(2) = YY - SISYMY
              XPT(3) = XX + SISYMX
              YPT(3) = YY + SISYMY
              XPT(4) = XX - SISYMX
              YPT(4) = YY + SISYMY
              XPT(5) = XX - SISYMX
              YPT(5) = YY - SISYMY
          else
              NPT = 4
              XPT(1) = XX - 3.0*SISYMX
              YPT(1) = YY - SISYMY
              XPT(2) = XX - 3.0*SISYMX
              YPT(2) = YY
              XPT(3) = XX + 3.0*SISYMX
              YPT(3) = YY
              XPT(4) = XX + 3.0*SISYMX
              YPT(4) = YY - SISYMY
          endif
C
C         SYMBOL IS HOLLOW OR SOLID
C
          IF(mod(nsym,1000).eq.0) then
              NSMOD = 2
              if(mod(nsym/1000,2).eq.1) then
                  NSHAD = 100
              else
                  nshad = 200
              endif
C
C         SYMBOL IS HATCHED
C
          ELSEIF(mod(nsym/1000,2).eq.1) then
              NSMOD = 1
              NSHAD = MOD(MSYMB,1000)
C
C         SYMBOL IS A PATTERN
C
          ELSEIF(mod(nsym/1000,2).eq.0) then
              NSMOD = 2
              NSHAD = MOD(MSYMB,1000)
          ENDIF
C
          CALL TVSHAD(NSMOD,XPT,YPT,NPT,NSHAD,NCOL)
          if(nsym.ge.5000 .and. nsym.lt.9000) then
              CALL MN_LIN(XPT,YPT,NPT,1,SISYMX,NCOLe,THICK)
          else
              CALL MN_LIN(XPT,YPT,NPT,1,SISYMX,NCOL,THICK)
          endif
C
C     Standard symbol
C
      ELSE
C
C         Check if the symbol is inside the plot
C
          QINS  = XX.GE.XPLO .AND. XX.LE.XPHI .AND.
     +            YY.GE.YPLO .AND. YY.LE.YPHI
          QXINS = XX.GE.XPLO .AND. XX.LE.XPHI
          QYINS = YY.GE.YPLO .AND. YY.LE.YPHI
          IF(NMODE.GE.0 .AND. .NOT.QINS) GOTO 3000
C
C         DRAW A DOT
C
          IF(NNSYM.EQ.0) THEN
              CALL TVDOT(XX,YY)
C
C         CIRCLE
C
          ELSEIF(NNSYM.EQ.1) THEN
              NPT    = 1
              XPT(1) = XX
              YPT(1) = YY
              CALL TVCIRC(XPT(1),YPT(1),SISYMX,NCOL,THICK,QFILL)
C
C         SQUARE
C
          ELSEIF(NNSYM.EQ.2) THEN
              NPT = 5
              NPFILL = NPT
              XPT(1) = XX - SISYMX
              YPT(1) = YY - SISYMY
              XPT(2) = XX - SISYMX
              YPT(2) = YY + SISYMY
              XPT(3) = XX + SISYMX
              YPT(3) = YY + SISYMY
              XPT(4) = XX + SISYMX
              YPT(4) = YY - SISYMY
              XPT(5) = XX - SISYMX
              YPT(5) = YY - SISYMY
C
C         TRIANGLE
C
          ELSEIF(NNSYM.EQ.3) THEN
              NPT = 4
              NPFILL = NPT
              XPT(1) = XX - SISYMX
              YPT(1) = YY - SISYMY
              XPT(2) = XX
              YPT(2) = YY + SISYMY
              XPT(3) = XX + SISYMX
              YPT(3) = YY - SISYMY
              XPT(4) = XX - SISYMX
              YPT(4) = YY - SISYMY
C
C         INVERTED TRIANGLE
C
          ELSEIF(NNSYM.EQ.4) THEN
              NPT = 4
              NPFILL = NPT
              XPT(1) = XX
              YPT(1) = YY - SISYMY
              XPT(2) = XX - SISYMX
              YPT(2) = YY + SISYMY
              XPT(3) = XX + SISYMX
              YPT(3) = YY + SISYMY
              XPT(4) = XX
              YPT(4) = YY - SISYMY
C
C         DIAMOND
C
          ELSEIF(NNSYM.EQ.5) THEN
              NPT = 5
              NPFILL = NPT
              XPT(1) = XX - SISYMX
              YPT(1) = YY
              XPT(2) = XX
              YPT(2) = YY - SISYMY
              XPT(3) = XX + SISYMX
              YPT(3) = YY
              XPT(4) = XX
              YPT(4) = YY + SISYMY
              XPT(5) = XX - SISYMX
              YPT(5) = YY
C
C         PLUS
C
          ELSEIF(NNSYM.EQ.6) THEN
              NPT = 4
              NPFILL = NPT
              XPT(1) = XX - SISYMX
              YPT(1) = YY
              XPT(2) = XX + SISYMX
              YPT(2) = YY
              XPT(3) = XX
              YPT(3) = YY - SISYMY
              XPT(4) = XX
              YPT(4) = YY + SISYMY
C
C         CROSS
C
          ELSEIF(NNSYM.EQ.7) THEN
              XPT(1) = XX - SISYMX
              YPT(1) = YY - SISYMY
              XPT(2) = XX + SISYMX
              YPT(2) = YY + SISYMY
              XPT(3) = XX - SISYMX
              YPT(3) = YY + SISYMY
              XPT(4) = XX + SISYMX
              YPT(4) = YY - SISYMY
C
C         ASTERISK
C
          ELSEIF(NNSYM.EQ.8) THEN
              XPT(1) = XX
              YPT(1) = YY - SISYMY
              XPT(2) = XX
              YPT(2) = YY + SISYMY
              XPT(3) = XX - SISYMX*SIN60
              YPT(3) = YY + SISYMY*COS60
              XPT(4) = XX + SISYMX*SIN60
              YPT(4) = YY - SISYMY*COS60
              XPT(5) = XX - SISYMX*SIN60
              YPT(5) = YY - SISYMY*COS60
              XPT(6) = XX + SISYMX*SIN60
              YPT(6) = YY + SISYMY*COS60
C
C         Octogon (used to be the circle)
C
          ELSEIF(NNSYM.EQ.9) THEN
              NPT = 9
              NPFILL = NPT
              XPT(1) = XX - SISYMX
              YPT(1) = YY + 0.5*SISYMY
              XPT(2) = XX - 0.5*SISYMX
              YPT(2) = YY + SISYMY
              XPT(3) = XX + 0.5*SISYMX
              YPT(3) = YY + SISYMY
              XPT(4) = XX + SISYMX
              YPT(4) = YY + 0.5*SISYMY
              XPT(5) = XX + SISYMX
              YPT(5) = YY - 0.5*SISYMY
              XPT(6) = XX + 0.5*SISYMX
              YPT(6) = YY - SISYMY
              XPT(7) = XX - 0.5*SISYMX
              YPT(7) = YY - SISYMY
              XPT(8) = XX - SISYMX
              YPT(8) = YY - 0.5*SISYMY
              XPT(9) = XX - SISYMX
              YPT(9) = YY + 0.5*SISYMY
          ENDIF
C
          IF((NNSYM.GE.2 .AND. NNSYM.LE.5) .OR. NNSYM.EQ.9) THEN
              CALL MN_LIN(XPT,YPT,NPT,1,SISYMX,NCOL,THICK)
          ELSEIF(NNSYM.EQ.6 .OR. NNSYM.EQ.7) THEN
              CALL MN_LIN(XPT(1),YPT(1),2,1,SISYMX,NCOL,THICK)
              CALL MN_LIN(XPT(3),YPT(3),2,1,SISYMX,NCOL,THICK)
          ELSEIF(NNSYM.EQ.8) THEN
              CALL MN_LIN(XPT(1),YPT(1),2,1,SISYMX,NCOL,THICK)
              CALL MN_LIN(XPT(3),YPT(3),2,1,SISYMX,NCOL,THICK)
              CALL MN_LIN(XPT(5),YPT(5),2,1,SISYMX,NCOL,THICK)
          ENDIF
C
C         FILL IN SYMBOLS IF REQUESTED
C
          IF(QFILL .AND.
     +       ((NNSYM.GE.2 .AND. NNSYM.LE.5) .OR. NNSYM.EQ.9)) THEN
              CALL TVSFIL(NPFILL,XPT,YPT,NNSYM,XX,YY,SISYMX,SISYMY
     1         ,NCOL)
          ENDIF
C
C         DRAW X ERROR
C
3000      CONTINUE
          IF(QXERR .AND. QYINS) THEN
              NPT = 2
              IF(NNSYM.EQ.3 .OR. NNSYM.EQ.4) THEN
                  SJSYM = 0.5*SISYMX
              ELSEIF(NNSYM.EQ.0 .OR.
     +               (NNSYM.GE.6 .AND. NNSYM.LE.8)) THEN
                  SJSYM = 0.0
              ELSE
                  SJSYM  = SISYMX
              ENDIF
              IF(DXXL.GE.0.0) THEN
                  XPT(1) = AMIN1(AMAX1(XX - DXXL,XPLO),XPHI)
                  YPT(1) = YY
                  XPT(2) = AMIN1(AMAX1(XX - SJSYM,XPLO),XPHI)
                  YPT(2) = YY
                  xpt(3) = xpt(1)
                  ypt(3) = ypt(1) - sisymy
                  xpt(4) = xpt(1)
                  ypt(4) = ypt(1) + sisymy
                  IF(XPT(1).NE.XPT(2))
     +             CALL MN_LIN(XPT,YPT,NPT,1,SISYMX,NCOL,THICK)
                  IF(qxerrb .and. YPT(3).NE.YPT(4))
     +             CALL MN_LIN(XPT(3),YPT(3),2,1,SISYMX,NCOL,THICK)
              ENDIF
              IF(DXXH.GE.0.0) THEN
                  XPT(1) = AMIN1(AMAX1(XX + DXXH,XPLO),XPHI)
                  YPT(1) = YY
                  XPT(2) = AMIN1(AMAX1(XX + SJSYM,XPLO),XPHI)
                  YPT(2) = YY
                  xpt(3) = xpt(1)
                  ypt(3) = ypt(1) - sisymy
                  xpt(4) = xpt(1)
                  ypt(4) = ypt(1) + sisymy
                  IF(XPT(1).NE.XPT(2))
     +             CALL MN_LIN(XPT,YPT,NPT,1,SISYMX,NCOL,THICK)
                  IF(qxerrb .and. YPT(3).NE.YPT(4))
     +             CALL MN_LIN(XPT(3),YPT(3),2,1,SISYMX,NCOL,THICK)
              ENDIF
          ENDIF
C
C         DRAW Y ERROR
C
          IF(QYERR .AND. QXINS) THEN
              NPT = 2
              SJSYM = SISYMY
              IF(NNSYM.EQ.0 .OR.
     +           (NNSYM.GE.6 .AND. NNSYM.LE.8)) SJSYM = 0.0
              IF(DYYL.GE.0.0) THEN
                  XPT(1) = XX
                  YPT(1) = AMIN1(AMAX1(YY - DYYL,YPLO),YPHI)
                  XPT(2) = XX
                  YPT(2) = AMIN1(AMAX1(YY - SJSYM,YPLO),YPHI)
                  xpt(3) = xpt(1) - sisymx
                  ypt(3) = ypt(1)
                  xpt(4) = xpt(1) + sisymx
                  ypt(4) = ypt(1)
                  IF(YPT(1).NE.YPT(2))
     +             CALL MN_LIN(XPT,YPT,NPT,1,SISYMY,NCOL,THICK)
                  IF(qyerrb .and. XPT(3).NE.XPT(4))
     +             CALL MN_LIN(XPT(3),YPT(3),2,1,SISYMX,NCOL,THICK)
              ENDIF
              IF(DYYH.GE.0.0) THEN
                  XPT(1) = XX
                  YPT(1) = AMIN1(AMAX1(YY + DYYH,YPLO),YPHI)
                  XPT(2) = XX
                  YPT(2) = AMIN1(AMAX1(YY + SJSYM,YPLO),YPHI)
                  xpt(3) = xpt(1) - sisymx
                  ypt(3) = ypt(1)
                  xpt(4) = xpt(1) + sisymx
                  ypt(4) = ypt(1)
                  IF(YPT(1).NE.YPT(2))
     +             CALL MN_LIN(XPT,YPT,NPT,1,SISYMY,NCOL,THICK)
                  IF(qyerrb .and. XPT(3).NE.XPT(4))
     +             CALL MN_LIN(XPT(3),YPT(3),2,1,SISYMX,NCOL,THICK)
              ENDIF
          ENDIF
      ENDIF
C
      RETURN
      END

