      SUBROUTINE M_SFUN(IDELIM,IERR)
C
C     Sets up options on using functions
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mnplt.inc"
#include "mnflg.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER MFUN,MFLIM
      PARAMETER (MFUN = 6)
      parameter (mflim = 3)
      CHARACTER*10 FUNNAM(MFUN),limnam(mflim)
C
      INTEGER IDELIM,IERR
C
      INTEGER KCMD,LCMD,ICMTYQ,IVLTYQ,IOERR,NVAL
      REAL RVAL,VALTYQ
C
      DATA FUNNAM/'AREA', 'BIN_WIDTH', 'POINTS', 'INTEGRATE', 'STEP'
     + , ' '/
      DATA LIMNAM/'LIMIT', 'FULL', ' '/
C
      IERR = 0
C
      IF(COMND1.EQ.'SHOW') THEN
        WRITE(TXTMES,'(1X,A,T55,L1)',IOSTAT=IOERR)
     +   'Use plot limits for area of Gauss etc (AREA):',QFPLIM
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(1X,A,T55,L1)',IOSTAT=IOERR)
     +   'Use bin width in function value (BIN_WIDTH):',QFBINW
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(1X,A,T55,I5)',IOSTAT=IOERR)
     +   'Number of points drawn (POINTS):',NFPNT
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(1X,A,T55,I5)',IOSTAT=IOERR)
     +   'Number of intervals for integration (INTEGRATE):',NINTFT
        CALL MN_MES(LUNTTO,'I',TXTMES)
        WRITE(TXTMES,'(1X,A,T55,1PG12.4)',IOSTAT=IOERR)
     +   'Step size for differentiation (STEP):',FNSTEP
        CALL MN_MES(LUNTTO,'IE',TXTMES)
        GOTO 9000
      ENDIF
C
1000  CONTINUE
      CALL WAITYQ('Give option or ?: ')
      KCMD = ICMTYQ(.TRUE.,IDELIM,FUNNAM)
      IF(KCMD.GT.0) COMND3 = FUNNAM(KCMD)
      IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('SET FUNCTION')
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 1000
      ELSEIF(KCMD.LT.0) THEN
          GOTO 9000
      ELSEIF(KCMD.EQ.0) THEN
          CALL MN_DCK(IDELIM,KCMD,MFUN,FUNNAM,IERR)
          IF(IERR.EQ.2) CALL MN_UNK('M_SFUN')
          GOTO 9000
      ELSEIF(COMND3.EQ.'AREA') THEN
          CALL WAITYQ('Limit or Full: ')
          LCMD = ICMTYQ(.TRUE.,IDELIM,LIMNAM)
          IF(LCMD.LT.0) THEN
              GOTO 9000
          ELSEIF(LCMD.EQ.0) THEN
              CALL MN_DCK(IDELIM,LCMD,MLOG,LIMNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('M_SFUN')
              GOTO 9000
          ELSEIF(MOD(LCMD,2).EQ.1) THEN
              QFPLIM = .TRUE.
          ELSE
              QFPLIM = .FALSE.
          ENDIF
      ELSEIF(COMND3.EQ.'BIN_WIDTH') THEN
          CALL WAITYQ('On or Off: ')
          LCMD = ICMTYQ(.TRUE.,IDELIM,LOGNAM)
          IF(LCMD.LT.0) THEN
              GOTO 9000
          ELSEIF(LCMD.EQ.0) THEN
              CALL MN_DCK(IDELIM,LCMD,MLOG,LOGNAM,IERR)
              IF(IERR.EQ.2) CALL MN_UNK('M_SFUN')
              GOTO 9000
          ELSEIF(MOD(LCMD,2).EQ.1) THEN
              QFBINW = .TRUE.
          ELSE
              QFBINW = .FALSE.
          ENDIF
      ELSEIF(COMND3.EQ.'POINTS') THEN
          CALL WAITYQ('Give number of points to draw: ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          IF(NVAL.LE.0) THEN
              GOTO 9000
          ENDIF
          NFPNT = MAX0(1,MIN0(NVAL,1000))
      ELSEIF(COMND3.EQ.'INTEGRATE') THEN
          CALL WAITYQ('Give number of intervals for integration: ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          IF(NVAL.LE.0) THEN
              GOTO 9000
          ELSEIF(MOD(NVAL,2).NE.0) THEN
            NVAL = MAX0(2,(NVAL / 2) * 2)
            WRITE(TXTMES
     +       ,'('' The number of intervals must be even.''
     +       ,'' It will be set to'',I4)',IOSTAT=IOERR) NVAL
            CALL MN_MES(LUNTTO,'ME',TXTMES)
          endif
          NINTFT = MAX0(1,MIN0(NVAL,1000))
      ELSEIF(COMND3.EQ.'STEP') THEN
          CALL WAITYQ('Give step size for differentiation: ')
          RVAL = VALTYQ(.TRUE.,IDELIM)
          IF(RVAL.LE.0.0) THEN
              GOTO 9000
          ENDIF
          FNSTEP = RVAL
      ENDIF
C
9000  CONTINUE
      END
